/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.hoster;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.UIManager;
import jd.PluginWrapper;
import jd.controlling.HTACCESSController;
import jd.controlling.JDLogger;
import jd.http.Browser;
import jd.http.Cookies;
import jd.http.URLConnectionAdapter;
import jd.nutils.encoding.Encoding;
import jd.parser.Regex;
import jd.parser.html.Form;
import jd.plugins.BrowserAdapter;
import jd.plugins.DownloadLink;
import jd.plugins.HostPlugin;
import jd.plugins.Plugin;
import jd.plugins.PluginException;
import jd.plugins.PluginForHost;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;
import org.appwork.utils.net.httpconnection.HTTPConnection;

@HostPlugin(revision="$Revision: 16133 $", interfaceVersion=2, names={"DirectHTTP", "http links"}, urls={"directhttp://.+", "https?viajd://[\\d\\w\\.:\\-@]*/.*\\.(3gp|7zip|7z|abr|ac3|aiff|aifc|aif|ai|au|avi|bin|bat|bz2|cbr|cbz|ccf|chm|cso|cue|cvd|dta|deb|divx|djvu|dlc|dmg|doc|docx|dot|eps|exe|ff|flv|flac|f4v|gsd|gif|gz|iwd|idx|iso|ipa|ipsw|java|jar|jpg|jpeg|jdeatme|load|m2ts|mws|mv|m4v|m4a|mkv|mp2|mp3|mp4|mov|movie|mpeg|mpe|mpg|msi|msu|msp|nfo|npk|oga|ogg|ogv|otrkey|par2|pkg|png|pdf|pptx|ppt|pps|ppz|pot|psd|qt|rmvb|rm|rar|ram|ra|rev|rnd|r\\d+|rpm|run|rsdf|reg|rtf|shnf|sh(?!tml)|ssa|smi|sub|srt|snd|sfv|swf|tar|tiff|tif|ts|txt|viv|vivo|vob|webm|wav|wmv|wma|xla|xls|xpi|zeno|zip|z\\d+|_[_a-z]{2}|\\d+(?=$|\"|\r|\n))"}, flags={2, 0})
public class DirectHTTP
extends PluginForHost {
    private static final String JDL_PREFIX = "jd.plugins.hoster.DirectHTTP.";
    public static final String ENDINGS = "\\.(3gp|7zip|7z|abr|ac3|aiff|aifc|aif|ai|au|avi|bin|bz2|bat|cbr|cbz|ccf|chm|cso|cue|cvd|dta|deb|divx|djvu|dlc|dmg|doc|docx|dot|eps|exe|ff|flv|flac|f4v|gsd|gif|gz|iwd|idx|iso|ipa|ipsw|java|jar|jpg|jpeg|jdeatme|load|m2ts|mws|mw|m4v|m4a|mkv|mp2|mp3|mp4|mov|movie|mpeg|mpe|mpg|msi|msu|msp|nfo|npk|oga|ogg|ogv|otrkey|par2|pkg|png|pdf|pptx|ppt|pps|ppz|pot|psd|qt|rmvb|rm|rar|ram|ra|rev|rnd|r\\d+|rpm|run|rsdf|reg|rtf|shnf|sh(!?tml)|ssa|smi|sub|srt|snd|sfv|tar|tif|tiff|ts|txt|viv|vivo|vob|webm|wav|wmv|wma|xla|xls|xpi|zeno|zip|z\\d+|_[_a-z]{2}|\\d+$)";
    public static final String NORESUME = "nochunkload";
    public static final String NOCHUNKS = "nochunk";
    public static final String FORCE_NORESUME = "forcenochunkload";
    public static final String FORCE_NOCHUNKS = "forcenochunk";
    public static final String TRY_ALL = "tryall";
    private String contentType = "";
    private String customFavIconHost = null;
    private static boolean hotFixSynthethica = true;

    public static ArrayList<String> findUrls(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            for (String string2 : new Regex(string, "((https?|ftp):((//)|(\\\\\\\\))+[\\w\\d:#@%/;$()~_?\\+-=\\\\\\.&]*)(\n|\r|$|<|\")").getColumn(0)) {
                try {
                    new URL(string2);
                    if (arrayList.contains(string2)) continue;
                    arrayList.add(string2);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            JDLogger.exception(exception);
        }
        return DirectHTTP.removeDuplicates(arrayList);
    }

    public static ArrayList<String> removeDuplicates(ArrayList<String> arrayList) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (arrayList == null || arrayList.size() == 0) {
            return arrayList2;
        }
        for (String string : arrayList) {
            if (string.contains("...")) {
                String string2 = string.substring(0, string.indexOf("..."));
                String string3 = string;
                for (String string4 : arrayList) {
                    if (!string4.startsWith(string2) || string4.contains("...")) continue;
                    string3 = string4;
                    break;
                }
                if (arrayList2.contains(string3)) continue;
                arrayList2.add(string3);
                continue;
            }
            arrayList2.add(string);
        }
        return arrayList2;
    }

    public DirectHTTP(PluginWrapper pluginWrapper) {
        super(pluginWrapper);
        if (hotFixSynthethica) {
            try {
                String[] stringArray = new String[]{"Licensee=AppWork UG", "LicenseRegistrationNumber=289416475", "Product=Synthetica", "LicenseType=Small Business License", "ExpireDate=--.--.----", "MaxVersion=2.999.999"};
                UIManager.put("Synthetica.license.info", stringArray);
                UIManager.put("Synthetica.license.key", "C1410294-61B64AAC-4B7D3039-834A82A1-37E5D695");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            hotFixSynthethica = false;
        }
    }

    @Override
    public void correctDownloadLink(DownloadLink downloadLink) {
        if (downloadLink.getDownloadURL().startsWith("directhttp")) {
            downloadLink.setUrlDownload(downloadLink.getDownloadURL().replaceAll("^directhttp://", ""));
        } else {
            downloadLink.setUrlDownload(downloadLink.getDownloadURL().replaceAll("httpviajd://", "http://").replaceAll("httpsviajd://", "https://"));
            downloadLink.setUrlDownload(downloadLink.getDownloadURL().replaceAll("\\.jdeatme$", ""));
        }
    }

    @Override
    public String getAGBLink() {
        return "";
    }

    private String getBasicAuth(DownloadLink downloadLink) {
        String string = downloadLink.getLinkType() == 1 ? downloadLink.getHost() : downloadLink.getBrowserUrl();
        String string2 = null;
        String string3 = null;
        try {
            string2 = Plugin.getUserInput(JDL.LF("jd.plugins.hoster.DirectHTTP.username", "Username (BasicAuth) for %s", string), downloadLink);
            string3 = Plugin.getUserInput(JDL.LF("jd.plugins.hoster.DirectHTTP.password", "Password (BasicAuth) for %s", string), downloadLink);
        }
        catch (Exception exception) {
            return null;
        }
        return "Basic " + Encoding.Base64Encode(string2 + ":" + string3);
    }

    @Override
    public String getCustomFavIconURL() {
        if (this.customFavIconHost != null) {
            return this.customFavIconHost;
        }
        return null;
    }

    @Override
    public String getFileInformationString(DownloadLink downloadLink) {
        return "(" + this.contentType + ")" + downloadLink.getName();
    }

    @Override
    public int getMaxSimultanFreeDownloadNum() {
        return -1;
    }

    public Recaptcha getReCaptcha(Browser browser) {
        return new Recaptcha(browser);
    }

    @Override
    public String getSessionInfo() {
        if (this.customFavIconHost != null) {
            return this.customFavIconHost;
        }
        return "";
    }

    @Override
    public void handleFree(DownloadLink downloadLink) throws Exception {
        this.requestFileInformation(downloadLink);
        String string = this.br.getHeaders().get("Authorization");
        this.br = new Browser();
        if (string != null) {
            this.br.getHeaders().put("Authorization", string);
        }
        this.br.setFollowRedirects(true);
        this.br.setDebug(true);
        boolean bl = true;
        int n = 0;
        if (downloadLink.getBooleanProperty(NORESUME, false).booleanValue() || downloadLink.getBooleanProperty(FORCE_NORESUME, false).booleanValue()) {
            bl = false;
        }
        if (downloadLink.getBooleanProperty(NOCHUNKS, false).booleanValue() || downloadLink.getBooleanProperty(FORCE_NOCHUNKS, false).booleanValue() || !bl) {
            n = 1;
        }
        this.setCustomHeaders(this.br, downloadLink);
        this.dl = downloadLink.getStringProperty("post", null) != null ? BrowserAdapter.openDownload(this.br, downloadLink, downloadLink.getDownloadURL(), downloadLink.getStringProperty("post", null), bl, n) : BrowserAdapter.openDownload(this.br, downloadLink, downloadLink.getDownloadURL(), bl, n);
        if (!this.dl.startDownload()) {
            try {
                if (this.dl.externalDownloadStop()) {
                    return;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (downloadLink.getLinkStatus().getErrorMessage() != null && downloadLink.getLinkStatus().getErrorMessage().startsWith(JDL.L("download.error.message.rangeheaders", "Server does not support chunkload"))) {
                if (!downloadLink.getBooleanProperty(NORESUME, false).booleanValue()) {
                    downloadLink.setChunksProgress(null);
                    downloadLink.setProperty(NORESUME, true);
                    throw new PluginException(4);
                }
            } else if (!downloadLink.getBooleanProperty(NOCHUNKS, false).booleanValue()) {
                downloadLink.setProperty(NOCHUNKS, true);
                throw new PluginException(4);
            }
        }
    }

    private URLConnectionAdapter prepareConnection(Browser browser, DownloadLink downloadLink) throws IOException {
        URLConnectionAdapter uRLConnectionAdapter = null;
        this.setCustomHeaders(browser, downloadLink);
        uRLConnectionAdapter = downloadLink.getStringProperty("post", null) != null ? browser.openPostConnection(downloadLink.getDownloadURL(), downloadLink.getStringProperty("post", null)) : browser.openGetConnection(downloadLink.getDownloadURL());
        return uRLConnectionAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DownloadLink.AvailableStatus requestFileInformation(DownloadLink downloadLink) throws PluginException {
        block35: {
            Object object;
            this.setBrowserExclusive();
            this.br.getHeaders().put("Accept-Encoding", "");
            String string = new Regex(downloadLink.getDownloadURL(), "http.*?/([^/]{1}.*?)@").getMatch(0);
            String string2 = null;
            String string3 = null;
            ArrayList<String> arrayList = new ArrayList<String>();
            String string4 = downloadLink.getStringProperty("auth", null);
            if (string4 != null) {
                arrayList.add(string4);
            }
            arrayList.add("");
            if (string != null) {
                arrayList.add("Basic " + Encoding.Base64Encode(string));
            }
            if ((string3 = downloadLink.getStringProperty("pass", null)) != null) {
                arrayList.add("Basic " + Encoding.Base64Encode(string3));
            }
            if ((string2 = HTACCESSController.getInstance().get(downloadLink.getDownloadURL())) != null) {
                arrayList.add("Basic " + Encoding.Base64Encode(string2));
            }
            this.br.setFollowRedirects(true);
            HTTPConnection hTTPConnection = null;
            try {
                String string5 = null;
                for (Object object2 : arrayList) {
                    if (object2 != null && object2.length() > 0) {
                        string5 = object2;
                        this.br.getHeaders().put("Authorization", (String)object2);
                    } else {
                        string5 = null;
                        this.br.getHeaders().remove("Authorization");
                    }
                    hTTPConnection = this.prepareConnection(this.br, downloadLink);
                    if (hTTPConnection.getResponseCode() != 401) break;
                    hTTPConnection.disconnect();
                }
                if (hTTPConnection.getResponseCode() == 401) {
                    string5 = this.getBasicAuth(downloadLink);
                    if (string5 == null) {
                        throw new PluginException(32, JDL.L("plugins.hoster.httplinks.errors.basicauthneeded", "BasicAuth needed"));
                    }
                    this.br.getHeaders().put("Authorization", string5);
                    hTTPConnection = this.prepareConnection(this.br, downloadLink);
                    if (hTTPConnection.getResponseCode() == 401) {
                        throw new PluginException(32, JDL.L("plugins.hoster.httplinks.errors.basicauthneeded", "BasicAuth needed"));
                    }
                }
                if (hTTPConnection.getResponseCode() == 404 || !hTTPConnection.isOK()) {
                    throw new PluginException(32);
                }
                downloadLink.setProperty("auth", string5);
                this.contentType = hTTPConnection.getContentType();
                if (this.contentType.startsWith("text/html") && !downloadLink.getBooleanProperty(TRY_ALL, false).booleanValue()) {
                    Object object2;
                    this.br.followConnection();
                    object = DirectHTTP.findUrls(this.br.toString());
                    if (((ArrayList)object).size() != 1 || downloadLink.getBooleanProperty("htmlRedirect", false).booleanValue()) {
                        throw new PluginException(32);
                    }
                    downloadLink.setUrlDownload(((String)((ArrayList)object).get(0)).trim());
                    downloadLink.setProperty("htmlRedirect", true);
                    object2 = downloadLink.getAvailableStatus();
                    return object2;
                }
                hTTPConnection.disconnect();
                if (downloadLink.getFinalFileName() == null) {
                    if (downloadLink.getStringProperty("fixName", null) != null) {
                        downloadLink.setFinalFileName(downloadLink.getStringProperty("fixName", null));
                    } else {
                        downloadLink.setFinalFileName(Plugin.getFileNameFromHeader((URLConnectionAdapter)hTTPConnection));
                    }
                }
                downloadLink.setProperty("fixName", downloadLink.getFinalFileName());
                downloadLink.setDownloadSize(hTTPConnection.getLongContentLength());
                object = DownloadLink.AvailableStatus.TRUE;
            }
            catch (PluginException pluginException) {
                if (!downloadLink.getBooleanProperty("tryoldref", false).booleanValue() && downloadLink.getStringProperty("referer", null) != null) {
                    downloadLink.setProperty("tryoldref", true);
                    object = this.requestFileInformation(downloadLink);
                    return object;
                }
                throw pluginException;
            }
            catch (Exception exception) {
                JDLogger.exception(exception);
                break block35;
            }
            finally {
                try {
                    hTTPConnection.disconnect();
                }
                catch (Throwable throwable) {}
            }
            return object;
        }
        throw new PluginException(32);
    }

    @Override
    public void reset() {
    }

    @Override
    public void resetDownloadlink(DownloadLink downloadLink) {
        downloadLink.setProperty(NORESUME, false);
        downloadLink.setProperty(NOCHUNKS, false);
        if (downloadLink.getStringProperty("fixName", null) != null) {
            downloadLink.setFinalFileName(downloadLink.getStringProperty("fixName", null));
        }
    }

    @Override
    public void resetPluginGlobals() {
    }

    private void setCustomHeaders(Browser browser, DownloadLink downloadLink) {
        ArrayList arrayList = downloadLink.getGenericProperty("customHeader", new ArrayList());
        if (arrayList != null && arrayList.size() > 0) {
            for (Object e : arrayList) {
                if (e instanceof ArrayList) {
                    browser.getHeaders().put((String)((ArrayList)e).get(0), (String)((ArrayList)e).get(1));
                    continue;
                }
                if (!e.getClass().isArray()) continue;
                browser.getHeaders().put(((String[])e)[0], ((String[])e)[1]);
            }
        }
        if (downloadLink.getStringProperty("refURL", null) != null) {
            browser.getHeaders().put("Referer", downloadLink.getStringProperty("refURL", null));
        }
        if (downloadLink.getBooleanProperty("tryoldref", false).booleanValue() && downloadLink.getStringProperty("referer", null) != null) {
            browser.getHeaders().put("Referer", downloadLink.getStringProperty("referer", null));
        }
        if (downloadLink.getStringProperty("cookies", null) != null) {
            browser.getCookies(downloadLink.getDownloadURL()).add(Cookies.parseCookies(downloadLink.getStringProperty("cookies", null), Browser.getHost(downloadLink.getDownloadURL()), null));
        }
    }

    @Override
    public void setDownloadLink(DownloadLink downloadLink) {
        try {
            super.setDownloadLink(downloadLink);
            this.customFavIconHost = Browser.getHost(new URL(downloadLink.getDownloadURL()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static class Recaptcha {
        private static final int MAX_TRIES = 10;
        private final Browser br;
        private String challenge;
        private String server;
        private String captchaAddress;
        private String id;
        private Browser rcBr;
        private Form form;
        private int tries = 0;

        public Recaptcha(Browser browser) {
            this.br = browser;
        }

        public File downloadCaptcha(File file) throws IOException, PluginException {
            if (this.getTries() > 0) {
                this.reload();
            }
            this.rcBr.setFollowRedirects(true);
            try {
                Browser.download(file, this.rcBr.openGetConnection(this.captchaAddress));
            }
            catch (IOException iOException) {
                file.delete();
                throw iOException;
            }
            return file;
        }

        public void findID() throws PluginException {
            this.id = this.br.getRegex("\\?k=([A-Za-z0-9%_\\+\\- ]+)\"").getMatch(0);
            if (this.id == null) {
                this.id = this.br.getRegex("Recaptcha\\.create\\(\"([A-Za-z0-9%_\\+\\- ]+)\"").getMatch(0);
            }
            if (this.id == null) {
                throw new PluginException(0x400000);
            }
        }

        public String getCaptchaAddress() {
            return this.captchaAddress;
        }

        public String getChallenge() {
            return this.challenge;
        }

        public Form getForm() {
            return this.form;
        }

        public String getId() {
            return this.id;
        }

        public String getServer() {
            return this.server;
        }

        public int getTries() {
            return this.tries;
        }

        public synchronized void handleAuto(Plugin plugin, DownloadLink downloadLink) throws Exception {
            this.parse();
            this.load();
            while (!this.isSolved()) {
                int n = 1;
                File file = null;
                while (file == null || file.exists()) {
                    file = JDUtilities.getResourceFile("captchas/recaptcha_" + plugin.getHost() + "_" + n + ".jpg", true);
                    file.deleteOnExit();
                    ++n;
                }
                file.deleteOnExit();
                this.downloadCaptcha(file);
                String string = new DirectHTTP(PluginWrapper.getWrapper(plugin.getClass().getName())).getCaptchaCode(plugin.getHost(), file, 0, downloadLink, "", "Please enter both words");
                if (string == null || string.length() == 0) {
                    throw new PluginException(2048, "Recaptcha failed", 10000L);
                }
                this.setCode(string);
            }
        }

        public boolean isSolved() throws PluginException {
            if (this.tries > 10) {
                throw new PluginException(8);
            }
            try {
                this.parse();
                return false;
            }
            catch (Exception exception) {
                JDLogger.getLogger().severe(exception.toString());
                return true;
            }
        }

        public void load() throws IOException, PluginException {
            this.rcBr = this.br.cloneBrowser();
            this.rcBr.setFollowRedirects(true);
            this.rcBr.getPage("http://api.recaptcha.net/challenge?k=" + this.id);
            this.challenge = this.rcBr.getRegex("challenge.*?:.*?'(.*?)',").getMatch(0);
            this.server = this.rcBr.getRegex("server.*?:.*?'(.*?)',").getMatch(0);
            if (this.challenge == null || this.server == null) {
                JDLogger.getLogger().severe("Recaptcha Module fails: " + this.rcBr.getHttpConnection());
                throw new PluginException(0x400000);
            }
            this.captchaAddress = this.server + "image?c=" + this.challenge;
        }

        public void parse() throws IOException, PluginException {
            this.form = null;
            this.id = null;
            if (this.br.containsHTML("Recaptcha\\.create\\(\".*?\"\\,\\s*\".*?\"\\,.*?\\)")) {
                this.id = this.br.getRegex("Recaptcha\\.create\\(\"(.*?)\"").getMatch(0);
                String string = this.br.getRegex("Recaptcha\\.create\\(\"(.*?)\"\\,\\s*\"(.*?)\"").getMatch(1);
                if (string == null || this.id == null) {
                    JDLogger.getLogger().warning("reCaptcha ID or div couldn't be found...");
                    throw new PluginException(0x400000);
                }
                for (Form form : this.br.getForms()) {
                    if (!form.containsHTML("id\\s*?=\\s*?\"" + string + "\"")) continue;
                    this.form = form;
                    break;
                }
            } else {
                Form[] formArray = this.br.getForms();
                this.form = null;
                for (Form form : formArray) {
                    if (form.getInputField("recaptcha_challenge_field") == null) continue;
                    this.form = form;
                    break;
                }
                if (this.form == null) {
                    throw new PluginException(0x400000);
                }
                this.id = this.form.getRegex("k=(.*?)\"").getMatch(0);
                if (this.id == null || this.id.equals("") || this.id.contains("\\")) {
                    this.findID();
                }
                if (this.id == null || this.id.equals("")) {
                    JDLogger.getLogger().warning("reCaptcha ID couldn't be found...");
                    throw new PluginException(0x400000);
                }
                this.id = this.id.replace("&amp;error=1", "");
            }
            if (this.id == null || this.id.equals("")) {
                JDLogger.getLogger().warning("reCaptcha ID couldn't be found...");
                throw new PluginException(0x400000);
            }
            if (this.form == null) {
                JDLogger.getLogger().warning("reCaptcha form couldn't be found...");
                throw new PluginException(0x400000);
            }
        }

        private void prepareForm(String string) throws PluginException {
            if (this.challenge == null || string == null) {
                JDLogger.getLogger().severe("Recaptcha Module fail: challenge or code equals null!");
                throw new PluginException(0x400000);
            }
            this.form.put("recaptcha_challenge_field", this.challenge);
            this.form.put("recaptcha_response_field", Encoding.urlEncode(string));
        }

        public void reload() throws IOException, PluginException {
            this.rcBr.getPage("http://www.google.com/recaptcha/api/reload?c=" + this.challenge + "&k=" + this.id + "&reason=r&type=image&lang=en");
            this.challenge = this.rcBr.getRegex("Recaptcha\\.finish\\_reload\\(\\'(.*?)\\'\\, \\'image\\'\\)\\;").getMatch(0);
            if (this.challenge == null) {
                JDLogger.getLogger().severe("Recaptcha Module fails: " + this.rcBr.getHttpConnection());
                throw new PluginException(0x400000);
            }
            this.captchaAddress = this.server + "image?c=" + this.challenge;
        }

        public void setCaptchaAddress(String string) {
            this.captchaAddress = string;
        }

        public void setChallenge(String string) {
            this.challenge = string;
        }

        public Browser setCode(String string) throws Exception {
            this.prepareForm(string);
            this.br.submitForm(this.form);
            ++this.tries;
            return this.br;
        }

        public void setForm(Form form) {
            this.form = form;
        }

        public void setId(String string) {
            this.id = string;
        }

        public void setServer(String string) {
            this.server = string;
        }
    }
}

