/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import jd.config.Property;
import jd.controlling.JDLogger;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.controlling.linkcrawler.CheckableLink;
import jd.controlling.packagecontroller.AbstractNodeNotifier;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.http.Browser;
import jd.nutils.io.JDIO;
import jd.plugins.FilePackage;
import jd.plugins.LinkStatus;
import jd.plugins.Plugin;
import jd.plugins.PluginForHost;
import jd.plugins.PluginProgress;
import jd.plugins.download.DownloadInterface;
import jd.utils.JDUtilities;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging.Log;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.DomainInfo;
import org.jdownloader.controlling.UniqueSessionID;
import org.jdownloader.settings.GeneralSettings;

public class DownloadLink
extends Property
implements Serializable,
AbstractPackageChildrenNode<FilePackage>,
CheckableLink {
    private static final String PROPERTY_MD5 = "MD5";
    private static final String PROPERTY_SHA1 = "SHA1";
    private static final String PROPERTY_PASS = "pass";
    private static final String PROPERTY_FINALFILENAME = "FINAL_FILENAME";
    private static final String PROPERTY_FORCEDFILENAME = "FORCED_FILENAME";
    private static final String PROPERTY_COMMENT = "COMMENT";
    private static final String PROPERTY_PRIORITY = "PRIORITY";
    private static final String PROPERTY_FINISHTIME = "FINISHTIME";
    private static final String PROPERTY_ENABLED = "ENABLED";
    private static final String PROPERTY_PWLIST = "PWLIST";
    private static final String PROPERTY_LINKDUPEID = "LINKDUPEID";
    private static final String PROPERTY_SPEEDLIMIT = "SPEEDLIMIT";
    public static final int LINKTYPE_CONTAINER = 1;
    public static final int LINKTYPE_NORMAL = 0;
    private static transient Logger logger = JDLogger.getLogger();
    private static final long serialVersionUID = 1981079856214268373L;
    public static final String UNKNOWN_FILE_NAME = "unknownFileName.file";
    private static final String PROPERTY_CHUNKS = "CHUNKS";
    private transient AvailableStatus availableStatus = AvailableStatus.UNCHECKED;
    private long[] chunksProgress = null;
    private long downloadCurrent = 0L;
    private transient DownloadInterface downloadInstance;
    private transient SingleDownloadController downloadLinkController;
    private long downloadMax = 0L;
    private String browserurl = null;
    private FilePackage filePackage;
    private String host;
    private boolean isEnabled;
    private LinkStatus linkStatus;
    private int linkType = 0;
    private String name;
    private transient PluginForHost defaultplugin;
    private transient PluginForHost liveplugin;
    private String finalFileName;
    private String urlDownload;
    private transient PluginProgress pluginProgress;
    private transient ImageIcon icon = null;
    private long created = -1L;
    private transient UniqueSessionID uniqueID = new UniqueSessionID();
    private transient AbstractNodeNotifier<DownloadLink> propertyListener;
    transient DomainInfo domainInfo = null;

    public DownloadLink(PluginForHost pluginForHost, String string, String string2, String string3, boolean bl) {
        this.defaultplugin = pluginForHost;
        this.setName(string);
        this.downloadMax = 0L;
        this.host = string2 == null ? null : string2.toLowerCase(Locale.ENGLISH);
        this.isEnabled = bl;
        this.created = System.currentTimeMillis();
        this.setUrlDownload(string3);
        if (pluginForHost != null && this.getDownloadURL() != null) {
            try {
                pluginForHost.correctDownloadLink(this);
            }
            catch (Throwable throwable) {
                Log.exception(throwable);
            }
        }
        if (string == null && string3 != null) {
            this.setName(Plugin.extractFileNameFromURL(this.getDownloadURL()));
        }
    }

    @Override
    public long getFinishedDate() {
        return this.getLongProperty(PROPERTY_FINISHTIME, -1L);
    }

    public void setFinishedDate(long l) {
        if (l <= 0L) {
            this.setProperty(PROPERTY_FINISHTIME, Property.NULL);
        } else {
            this.setProperty(PROPERTY_FINISHTIME, l);
        }
    }

    @Override
    public long getCreated() {
        return this.created;
    }

    public void setCreated(long l) {
        this.created = l;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.uniqueID = new UniqueSessionID();
    }

    public UniqueSessionID getUniqueID() {
        return this.uniqueID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadLink addSourcePluginPassword(String string) {
        if (string == null || string.length() == 0) {
            return this;
        }
        DownloadLink downloadLink = this;
        synchronized (downloadLink) {
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSourcePluginPasswords(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        DownloadLink downloadLink = this;
        synchronized (downloadLink) {
            for (String string : stringArray) {
                this.addSourcePluginPassword(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSourcePluginPasswordList(ArrayList<String> arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        DownloadLink downloadLink = this;
        synchronized (downloadLink) {
            for (String string : arrayList) {
                this.addSourcePluginPassword(string);
            }
        }
    }

    public int getPriority() {
        return this.getIntegerProperty(PROPERTY_PRIORITY, 0);
    }

    public int getChunks() {
        return this.getIntegerProperty(PROPERTY_CHUNKS, -1);
    }

    public void setChunks(int n) {
        if (n <= 0) {
            this.setProperty(PROPERTY_CHUNKS, Property.NULL);
        } else {
            this.setProperty(PROPERTY_CHUNKS, n);
        }
    }

    public void setCustomSpeedLimit(int n) {
        if (n == 0) {
            this.setProperty(PROPERTY_SPEEDLIMIT, Property.NULL);
        } else {
            if (n < 0) {
                n = 1;
            }
            this.setProperty(PROPERTY_SPEEDLIMIT, n);
        }
    }

    public int getCustomSpeedLimit() {
        return this.getIntegerProperty(PROPERTY_SPEEDLIMIT, 0);
    }

    public void setPriority(int n) {
        int n2 = 0;
        if (n >= -1 && n < 4) {
            n2 = n;
        }
        if (n2 == 0) {
            this.setProperty(PROPERTY_PRIORITY, Property.NULL);
        } else {
            this.setProperty(PROPERTY_PRIORITY, n2);
        }
    }

    public long[] getChunksProgress() {
        return this.chunksProgress;
    }

    public long getDownloadCurrent() {
        DownloadInterface downloadInterface = this.downloadInstance;
        if (downloadInterface != null) {
            return downloadInterface.getTotaleLinkBytesLoaded();
        }
        return this.downloadCurrent;
    }

    public long getRemainingKB() {
        return this.getDownloadSize() - this.getDownloadCurrent();
    }

    public DownloadInterface getDownloadInstance() {
        return this.downloadInstance;
    }

    public SingleDownloadController getDownloadLinkController() {
        return this.downloadLinkController;
    }

    public long getDownloadSize() {
        return Math.max(this.getDownloadCurrent(), this.downloadMax);
    }

    public long getDownloadSpeed() {
        DownloadInterface downloadInterface = this.getDownloadInstance();
        if (downloadInterface == null || !this.getLinkStatus().hasStatus(1024)) {
            return 0L;
        }
        return downloadInterface.getSpeed();
    }

    public String getDownloadURL() {
        return this.urlDownload;
    }

    public String getBrowserUrl() {
        if (this.browserurl != null) {
            return this.browserurl;
        }
        return this.getDownloadURL();
    }

    public void setBrowserUrl(String string) {
        this.browserurl = string;
    }

    public boolean gotBrowserUrl() {
        return this.browserurl != null;
    }

    public String getFileOutput() {
        if (this.getFilePackage().getDownloadDirectory() != null && this.getFilePackage().getDownloadDirectory().length() > 0) {
            return new File(new File(this.getFilePackage().getDownloadDirectory()), this.getName()).getAbsolutePath();
        }
        return null;
    }

    public FilePackage getFilePackage() {
        if (this.filePackage == null) {
            return FilePackage.getDefaultFilePackage();
        }
        return this.filePackage;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public LinkStatus getLinkStatus() {
        if (this.linkStatus == null) {
            this.linkStatus = new LinkStatus(this);
        }
        return this.linkStatus;
    }

    public int getLinkType() {
        return this.linkType;
    }

    @Override
    public String getName() {
        String string = this.getForcedFileName();
        if (string != null) {
            return string;
        }
        string = this.getFinalFileName();
        if (string != null) {
            return string;
        }
        try {
            String string2;
            return this.name == null ? ((string2 = new File(new URL(this.getDownloadURL()).toURI()).getName()) != null ? string2 : UNKNOWN_FILE_NAME) : this.name;
        }
        catch (Exception exception) {
            return UNKNOWN_FILE_NAME;
        }
    }

    public PluginForHost getDefaultPlugin() {
        return this.defaultplugin;
    }

    public PluginForHost getLivePlugin() {
        return this.liveplugin;
    }

    public String getComment() {
        return this.getStringProperty(PROPERTY_COMMENT, null);
    }

    public ArrayList<String> getSourcePluginPasswordList() {
        return this.getGenericProperty(PROPERTY_PWLIST, null);
    }

    public String getFinalFileName() {
        if (this.finalFileName != null) {
            this.setFinalFileName(this.finalFileName);
        }
        return this.getStringProperty(PROPERTY_FINALFILENAME, null);
    }

    public String getForcedFileName() {
        return this.getStringProperty(PROPERTY_FORCEDFILENAME, null);
    }

    public String getLinkID() {
        String string = this.getStringProperty(PROPERTY_LINKDUPEID, null);
        if (string == null) {
            return this.getDownloadURL();
        }
        return string;
    }

    public void setLinkID(String string) {
        if (StringUtils.isEmpty(string)) {
            this.setProperty(PROPERTY_LINKDUPEID, Property.NULL);
        } else {
            this.setProperty(PROPERTY_LINKDUPEID, string);
        }
    }

    public boolean isAborted() {
        SingleDownloadController singleDownloadController = this.getDownloadLinkController();
        if (singleDownloadController != null) {
            return singleDownloadController.isAborted();
        }
        DownloadInterface downloadInterface = this.getDownloadInstance();
        if (downloadInterface != null) {
            return downloadInterface.externalDownloadStop();
        }
        return false;
    }

    public void abort() {
        SingleDownloadController singleDownloadController = this.getDownloadLinkController();
        if (singleDownloadController != null) {
            singleDownloadController.abortDownload();
        }
    }

    public boolean isAvailabilityStatusChecked() {
        return this.availableStatus != AvailableStatus.UNCHECKED;
    }

    public boolean isAvailable() {
        return this.availableStatus != AvailableStatus.FALSE;
    }

    public AvailableStatus getAvailableStatus() {
        return this.availableStatus;
    }

    public void setAvailableStatus(AvailableStatus availableStatus) {
        this.availableStatus = availableStatus;
        this.notifyChanges();
    }

    private void notifyChanges() {
        FilePackage filePackage = this.propertyListener;
        if (filePackage == null) {
            filePackage = this.filePackage;
        }
        if (filePackage != null) {
            filePackage.nodeUpdated(this);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void reset() {
        this.chunksProgress = null;
        this.downloadLinkController = null;
        this.downloadCurrent = 0L;
        this.setFinishedDate(-1L);
        this.linkStatus.reset();
        this.availableStatus = AvailableStatus.UNCHECKED;
        this.setEnabled(true);
        this.deleteFile(true, true);
        this.setFinalFileName(null);
        PluginForHost pluginForHost = this.liveplugin;
        if (pluginForHost == null) {
            pluginForHost = this.defaultplugin.getNewInstance();
        }
        if (pluginForHost.getBrowser() == null) {
            pluginForHost.setBrowser(new Browser());
        }
        pluginForHost.init();
        pluginForHost.resetDownloadlink(this);
    }

    public void deleteFile(boolean bl, boolean bl2) {
        File file;
        int n = 5;
        while (this.getLinkStatus().isPluginActive()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                JDLogger.exception(interruptedException);
            }
            if (--n != 0) continue;
        }
        if (bl2 && new File(this.getFileOutput()).exists() && !new File(this.getFileOutput()).delete()) {
            logger.severe("Could not delete file " + this.getFileOutput());
        }
        if (bl && new File(this.getFileOutput() + ".part").exists() && !new File(this.getFileOutput() + ".part").delete()) {
            logger.severe("Could not delete file " + this.getFileOutput());
        }
        if ((file = new File(this.getFileOutput()).getParentFile()) != null && file.exists() && file.isDirectory() && file.listFiles() != null && file.listFiles().length == 0 && !new File(JsonConfig.create(GeneralSettings.class).getDefaultDownloadFolder()).equals(file)) {
            file.delete();
        }
    }

    public boolean existsFile() {
        return new File(this.getFileOutput()).exists() || new File(this.getFileOutput() + ".part").exists();
    }

    public void setAvailable(boolean bl) {
        this.availableStatus = bl ? AvailableStatus.TRUE : AvailableStatus.FALSE;
        this.notifyChanges();
    }

    public void setChunksProgress(long[] lArray) {
        this.chunksProgress = lArray;
    }

    public void setDownloadCurrent(long l) {
        this.downloadCurrent = l;
        if (this.getDownloadInstance() == null) {
            this.notifyChanges();
        }
    }

    public void setDownloadInstance(DownloadInterface downloadInterface) {
        this.downloadInstance = downloadInterface;
    }

    public void setDownloadLinkController(SingleDownloadController singleDownloadController) {
        this.downloadLinkController = singleDownloadController;
    }

    public void setDownloadSize(long l) {
        this.downloadMax = l;
        if (this.getDownloadInstance() == null) {
            this.notifyChanges();
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        this.getLinkStatus().removeStatus(2048);
        this.isEnabled = bl;
        if (!bl) {
            this.abort();
        }
        if (bl) {
            this.setProperty(PROPERTY_ENABLED, Property.NULL);
        } else {
            this.setProperty(PROPERTY_ENABLED, bl);
        }
        this.notifyChanges();
    }

    public synchronized void _setFilePackage(FilePackage filePackage) {
        if (filePackage == this.filePackage) {
            return;
        }
        if (this.filePackage != null && filePackage != null) {
            this.filePackage.remove(this);
        }
        this.filePackage = filePackage;
    }

    public void setLinkType(int n) {
        if (n == this.linkType) {
            return;
        }
        if (this.linkType == 1) {
            logger.severe("You are not allowd to Change the Linktype of " + this);
            return;
        }
        this.linkType = n;
    }

    public void setDefaultPlugin(PluginForHost pluginForHost) {
        this.defaultplugin = pluginForHost;
    }

    public void setLivePlugin(PluginForHost pluginForHost) {
        this.liveplugin = pluginForHost;
        if (this.liveplugin != null) {
            this.liveplugin.setDownloadLink(this);
        }
    }

    public void setName(String string) {
        if (string != null && string.length() > 0) {
            this.name = JDUtilities.removeEndingPoints(JDIO.validateFileandPathName(string));
        }
        this.setIcon(null);
        this.notifyChanges();
    }

    public void forceFileName(String string) {
        if (string == null) {
            this.setProperty(PROPERTY_FORCEDFILENAME, Property.NULL);
        } else {
            this.setProperty(PROPERTY_FORCEDFILENAME, string);
        }
        this.setIcon(null);
        this.notifyChanges();
    }

    private void setIcon(ImageIcon imageIcon) {
        this.icon = imageIcon;
    }

    @Deprecated
    public DownloadLink setSourcePluginComment(String string) {
        this.setComment(string);
        return this;
    }

    public void setComment(String string) {
        if (string == null || string.length() == 0) {
            this.setProperty(PROPERTY_COMMENT, Property.NULL);
        } else {
            this.setProperty(PROPERTY_COMMENT, string);
        }
    }

    public DownloadLink setSourcePluginPasswordList(ArrayList<String> arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            this.setProperty(PROPERTY_PWLIST, Property.NULL);
        } else {
            this.setProperty(PROPERTY_PWLIST, arrayList);
        }
        return this;
    }

    public void setFinalFileName(String string) {
        this.setName(string);
        if (string != null && string.length() > 0) {
            if (new Regex(string, Pattern.compile("r..\\.htm.?$", 2)).matches()) {
                logger.info("Use Workaround for stupid >>rar.html<< uploaders!");
                string = string.substring(0, string.length() - new Regex(string, Pattern.compile("r..(\\.htm.?)$", 2)).getMatch(0).length());
            }
            this.setProperty(PROPERTY_FINALFILENAME, JDUtilities.removeEndingPoints(JDIO.validateFileandPathName(string)));
        } else {
            this.setProperty(PROPERTY_FINALFILENAME, Property.NULL);
        }
        this.finalFileName = null;
        this.setIcon(null);
        this.notifyChanges();
    }

    public void setUrlDownload(String string) {
        this.urlDownload = string != null ? new String(string.trim()) : null;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public long getDownloadMax() {
        return this.downloadMax;
    }

    public String getDownloadPassword() {
        return this.getStringProperty(PROPERTY_PASS, null);
    }

    public void setDownloadPassword(String string) {
        if (StringUtils.isEmpty(string)) {
            this.setProperty(PROPERTY_PASS, Property.NULL);
        } else {
            this.setProperty(PROPERTY_PASS, string);
        }
    }

    @Deprecated
    public void setDecrypterPassword(String string) {
        this.setDownloadPassword(string);
    }

    public void setMD5Hash(String string) {
        if (StringUtils.isEmpty(string)) {
            this.setProperty(PROPERTY_MD5, Property.NULL);
        } else {
            this.setProperty(PROPERTY_MD5, string);
        }
    }

    public String getMD5Hash() {
        return this.getStringProperty(PROPERTY_MD5, null);
    }

    public void setPluginProgress(PluginProgress pluginProgress) {
        this.pluginProgress = pluginProgress;
    }

    public PluginProgress getPluginProgress() {
        return this.pluginProgress;
    }

    public void setSha1Hash(String string) {
        if (StringUtils.isEmpty(string)) {
            this.setProperty(PROPERTY_SHA1, Property.NULL);
        } else {
            this.setProperty(PROPERTY_SHA1, string);
        }
    }

    public String getSha1Hash() {
        return this.getStringProperty(PROPERTY_SHA1, null);
    }

    public ImageIcon getIcon() {
        if (this.icon == null) {
            String string = JDIO.getFileExtension(this.getFileOutput());
            if (string != null) {
                try {
                    this.icon = CrossSystem.getMime().getFileIcon(string, 16, 16);
                }
                catch (Throwable throwable) {
                    Log.exception(throwable);
                }
            }
            if (this.icon == null) {
                this.icon = null;
            }
        }
        return this.icon;
    }

    @Override
    public DomainInfo getDomainInfo() {
        PluginForHost pluginForHost = this.liveplugin;
        if (pluginForHost != null) {
            return pluginForHost.getDomainInfo();
        }
        if (this.domainInfo == null) {
            if ("ftp".equalsIgnoreCase(this.getHost()) || "DirectHTTP".equalsIgnoreCase(this.getHost()) || "http links".equalsIgnoreCase(this.getHost())) {
                try {
                    String string = Browser.getHost(new URL(this.getDownloadURL()));
                    this.domainInfo = DomainInfo.getInstance(string);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            if (this.domainInfo == null) {
                this.domainInfo = DomainInfo.getInstance(this.getHost());
            }
        }
        return this.domainInfo;
    }

    @Override
    public FilePackage getParentNode() {
        return this.getFilePackage();
    }

    @Override
    public void setParentNode(FilePackage filePackage) {
        if (filePackage == this.filePackage) {
            return;
        }
        if (this.filePackage != null && filePackage != null) {
            this.filePackage.remove(this);
        }
        this.filePackage = filePackage;
    }

    @Override
    public DownloadLink getDownloadLink() {
        return this;
    }

    public void setNodeChangeListener(AbstractNodeNotifier<DownloadLink> abstractNodeNotifier) {
        this.propertyListener = abstractNodeNotifier;
    }

    @Deprecated
    public PluginForHost getPlugin() {
        return this.liveplugin;
    }

    public static enum AvailableStatus {
        UNCHECKED,
        FALSE,
        UNCHECKABLE,
        TRUE;

    }
}

