/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;
import jd.nutils.encoding.Encoding;
import jd.parser.Regex;
import org.appwork.utils.formatter.StringFormatter;

public class Formatter {
    private static SimpleDateFormat DATE_FORMAT = null;

    public static String formatSeconds(long l) {
        return Formatter.formatSeconds(l, true);
    }

    public static String formatSeconds(long l, boolean bl) {
        if (l < 0L) {
            return "~";
        }
        long l2 = l / 86400L;
        long l3 = (l -= l2 * 24L * 60L * 60L) / 3600L;
        long l4 = (l -= l3 * 60L * 60L) / 60L;
        long l5 = l - l4 * 60L;
        StringBuilder stringBuilder = new StringBuilder();
        if (l2 != 0L) {
            stringBuilder.append(l2).append('d');
        }
        if (l3 != 0L || stringBuilder.length() != 0) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(':');
            }
            stringBuilder.append(l3).append('h');
        }
        if (l4 != 0L || stringBuilder.length() != 0) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(':');
            }
            stringBuilder.append(Formatter.fillInteger(l4, 2, "0")).append('m');
        }
        if (bl) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(':');
            }
            stringBuilder.append(Formatter.fillInteger(l5, 2, "0")).append('s');
        }
        return stringBuilder.toString();
    }

    public static String formatMilliseconds(long l) {
        return Formatter.formatSeconds(l / 1000L) + "." + Formatter.fillInteger(l % 1000L, 3, "0");
    }

    public static String formatFilesize(double d, int n) {
        if (d > 1024.0 && n < 5) {
            return Formatter.formatFilesize(d / 1024.0, ++n);
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        switch (n) {
            case 0: {
                return decimalFormat.format(d) + " B";
            }
            case 1: {
                return decimalFormat.format(d) + " KiB";
            }
            case 2: {
                return decimalFormat.format(d) + " MiB";
            }
            case 3: {
                return decimalFormat.format(d) + " GiB";
            }
            case 4: {
                return decimalFormat.format(d) + " TiB";
            }
        }
        return null;
    }

    public static String formatReadable(long l) {
        if (l < 0L) {
            l = 0L;
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        if (l >= 0x10000000000L) {
            return decimalFormat.format((double)l / 1.099511627776E12) + " TiB";
        }
        if (l >= 0x40000000L) {
            return decimalFormat.format((double)l / 1.073741824E9) + " GiB";
        }
        if (l >= 0x100000L) {
            return decimalFormat.format((double)l / 1048576.0) + " MiB";
        }
        if (l >= 1024L) {
            return decimalFormat.format((double)l / 1024.0) + " KiB";
        }
        return l + " B";
    }

    public static String fillString(String string, String string2, String string3, int n) {
        return StringFormatter.fillString(string, string2, string3, n);
    }

    public static String fillInteger(long l, int n, String string) {
        String string2 = "" + l;
        while (string2.length() < n) {
            string2 = string + string2;
        }
        return string2;
    }

    public static int filterInt(String string) {
        try {
            return Integer.parseInt(Encoding.filterString(string, "1234567890"));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static long filterLong(String string) {
        try {
            return Long.parseLong(Encoding.filterString(string, "1234567890"));
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public static String formatTime(long l) {
        if (DATE_FORMAT == null) {
            DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
            DATE_FORMAT.setTimeZone(new SimpleTimeZone(0, "GMT"));
            DATE_FORMAT.setLenient(true);
        }
        return DATE_FORMAT.format(new Date(l)).substring(0, 29);
    }

    public static long getRevision(String string) {
        if (string == null) {
            return -1L;
        }
        try {
            String string2 = new Regex(string, "Revision:.*?(\\d+)").getMatch(0);
            if (string2 != null) {
                return Long.parseLong(string2);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return -1L;
    }
}

