/*
 * Decompiled with CFR 0.152.
 */
package jd.http;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.CharacterCodingException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import jd.http.Browser;
import jd.http.Cookie;
import jd.http.Cookies;
import jd.http.HTTPConnectionFactory;
import jd.http.RequestHeader;
import jd.http.URLConnectionAdapter;
import jd.nutils.encoding.Encoding;
import jd.parser.Regex;
import org.appwork.utils.Application;
import org.appwork.utils.ReusableByteArrayOutputStreamPool;
import org.appwork.utils.logging.Log;
import org.appwork.utils.net.httpconnection.HTTPProxy;

public abstract class Request {
    private int connectTimeout = 30000;
    private int readTimeout = 60000;
    private Cookies cookies = null;
    private RequestHeader headers;
    private String htmlCode;
    protected URLConnectionAdapter httpConnection;
    private long readTime = -1L;
    private boolean requested = false;
    private HTTPProxy proxy;
    private URL orgURL;
    private String customCharset = null;
    private byte[] byteArray = null;
    private BufferedImage image;
    private boolean contentDecoded = true;

    public static String getCookieString(Cookies cookies) {
        if (cookies == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        LinkedList<Cookie> linkedList = new LinkedList<Cookie>(cookies.getCookies());
        for (Cookie cookie : linkedList) {
            if (cookie.isExpired()) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append("; ");
            }
            stringBuilder.append(cookie.getKey());
            stringBuilder.append("=");
            stringBuilder.append(cookie.getValue());
        }
        return stringBuilder.toString();
    }

    public static LinkedHashMap<String, String> parseQuery(String string) throws MalformedURLException {
        if (string == null) {
            return null;
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        if (string.toLowerCase().trim().startsWith("http")) {
            string = new URL(string).getQuery();
        }
        if (string == null) {
            return linkedHashMap;
        }
        String[][] stringArray = new Regex(string.trim(), "&?(.*?)=(.*?)($|&(?=.*?=.+))").getMatches();
        if (stringArray != null) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                linkedHashMap.put(stringArray[i][0], stringArray[i][1]);
            }
        }
        return linkedHashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] read(URLConnectionAdapter uRLConnectionAdapter) throws IOException {
        byte[] byArray;
        block29: {
            ReusableByteArrayOutputStreamPool.ReusableByteArrayOutputStream reusableByteArrayOutputStream;
            int n;
            InputStream inputStream = uRLConnectionAdapter.getInputStream();
            byArray = null;
            if (inputStream == null) {
                return null;
            }
            ReusableByteArrayOutputStreamPool.ReusableByteArrayOutputStream reusableByteArrayOutputStream2 = ReusableByteArrayOutputStreamPool.getReusableByteArrayOutputStream(1048);
            long l = uRLConnectionAdapter.getContentLength();
            if (l != -1L) {
                n = l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
                reusableByteArrayOutputStream = ReusableByteArrayOutputStreamPool.getReusableByteArrayOutputStream(n);
            } else {
                reusableByteArrayOutputStream = ReusableByteArrayOutputStreamPool.getReusableByteArrayOutputStream(16384);
            }
            n = 0;
            try {
                int n2;
                while ((n2 = inputStream.read(reusableByteArrayOutputStream2.getInternalBuffer())) != -1) {
                    if (n2 <= 0) continue;
                    reusableByteArrayOutputStream.write(reusableByteArrayOutputStream2.getInternalBuffer(), 0, n2);
                }
                n = 1;
            }
            catch (EOFException eOFException) {
                Log.L.log(Level.SEVERE, "Try workaround for ", eOFException);
                n = 1;
            }
            catch (IOException iOException) {
                if (iOException.toString().contains("end of ZLIB") || iOException.toString().contains("Premature") || iOException.toString().contains("Corrupt GZIP trailer")) {
                    Log.L.log(Level.SEVERE, "Try workaround for ", iOException);
                    n = 1;
                    break block29;
                }
                throw iOException;
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
                try {
                    uRLConnectionAdapter.disconnect();
                }
                catch (Exception exception) {}
                ReusableByteArrayOutputStreamPool.reuseReusableByteArrayOutputStream(reusableByteArrayOutputStream2);
                if (n != 0) {
                    byArray = reusableByteArrayOutputStream.toByteArray();
                }
                ReusableByteArrayOutputStreamPool.reuseReusableByteArrayOutputStream(reusableByteArrayOutputStream);
                reusableByteArrayOutputStream = null;
                reusableByteArrayOutputStream2 = null;
            }
        }
        return byArray;
    }

    public Request(String string) throws MalformedURLException {
        this.orgURL = new URL(Browser.correctURL(string));
        this.initDefaultHeader();
        String string2 = Browser.getBasicAuthfromURL(string);
        if (string2 != null) {
            this.getHeaders().put("Authorization", "Basic " + string2);
        }
    }

    public Request(URLConnectionAdapter uRLConnectionAdapter) {
        this.httpConnection = uRLConnectionAdapter;
        this.collectCookiesFromConnection();
    }

    public Request cloneRequest() {
        return null;
    }

    private void collectCookiesFromConnection() {
        List<String> list = this.httpConnection.getHeaderFields("Set-Cookie");
        String string = this.httpConnection.getHeaderField("Date");
        if (list == null) {
            return;
        }
        if (this.cookies == null) {
            this.cookies = new Cookies();
        }
        String string2 = Browser.getHost(this.httpConnection.getURL());
        for (int i = 0; i < list.size(); ++i) {
            String string3 = list.get(i);
            this.cookies.add(Cookies.parseCookies(string3, string2, string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Request connect() throws IOException {
        try {
            this.openConnection();
            this.postRequest();
            this.httpConnection.finalizeConnect();
            try {
                this.collectCookiesFromConnection();
            }
            catch (NullPointerException nullPointerException) {
                throw new IOException("Malformed url?", nullPointerException);
            }
        }
        finally {
            this.requested = true;
        }
        return this;
    }

    public boolean containsHTML(String string) throws CharacterCodingException {
        return this.getHtmlCode() == null ? false : this.getHtmlCode().contains(string);
    }

    public void disconnect() {
        try {
            this.httpConnection.disconnect();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public long getContentLength() {
        return this.httpConnection == null ? -1L : this.httpConnection.getLongContentLength();
    }

    public Cookies getCookies() {
        if (this.cookies == null) {
            this.cookies = new Cookies();
        }
        return this.cookies;
    }

    public String getCookieString() {
        return Request.getCookieString(this.cookies);
    }

    public RequestHeader getHeaders() {
        return this.headers;
    }

    public String getHtmlCode() throws CharacterCodingException {
        String string = this.httpConnection.getContentType();
        if (string != null && Pattern.compile("images?/\\w*", 34).matcher(string).matches()) {
            throw new IllegalStateException("Content-Type: " + string);
        }
        if (this.htmlCode == null && this.byteArray != null) {
            String string2 = this.customCharset == null ? this.httpConnection.getCharset() : this.customCharset;
            try {
                try {
                    if (string2 != null) {
                        this.htmlCode = new String(this.byteArray, string2.toUpperCase());
                        return this.htmlCode;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.htmlCode = new String(this.byteArray, "ISO-8859-1");
                return this.htmlCode;
            }
            catch (Exception exception) {
                try {
                    Log.getLogger().severe("could neither charset: " + string2 + " nor default charset");
                    this.htmlCode = new String(this.byteArray);
                    return this.htmlCode;
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        return this.htmlCode;
    }

    public URLConnectionAdapter getHttpConnection() {
        return this.httpConnection;
    }

    public String getLocation() {
        if (this.httpConnection == null) {
            return null;
        }
        String string = this.httpConnection.getHeaderField("Location");
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = this.httpConnection.getHeaderField("Content-Type");
        if (string2 != null && string2.contains("UTF-8")) {
            string = Encoding.UTF8Decode(string, "ISO-8859-1");
        }
        try {
            new URL(string);
        }
        catch (Exception exception) {
            String string3 = this.getHttpConnection().getURL().getFile();
            if (!string3.endsWith("/")) {
                String string4 = new Regex(string3, "(/.*?/.*?)(\\?|$)").getMatch(0);
                string3 = string4 != null && string4.length() > 0 ? string4 : "";
            }
            int n = this.getHttpConnection().getURL().getPort();
            int n2 = this.getHttpConnection().getURL().getDefaultPort();
            String string5 = "http://";
            if (this.getHttpConnection().getURL().toString().startsWith("https")) {
                string5 = "https://";
            }
            String string6 = "";
            if (n2 > 0 && n > 0 && n2 != n) {
                string6 = ":" + n;
            }
            string = string5 + this.getHttpConnection().getURL().getHost() + string6 + (string.charAt(0) == '/' ? string : string3 + "/" + string);
        }
        return Browser.correctURL(Encoding.urlEncode_light(string));
    }

    public HTTPProxy getProxy() {
        return this.proxy;
    }

    public long getReadTime() {
        return this.readTime;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public long getRequestTime() {
        return this.httpConnection == null ? -1L : this.httpConnection.getRequestTime();
    }

    public byte[] getResponseBytes() {
        return this.byteArray;
    }

    public String getResponseHeader(String string) {
        return this.httpConnection == null ? null : this.httpConnection.getHeaderField(string);
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.httpConnection == null ? null : this.httpConnection.getHeaderFields();
    }

    public Image getResponseImage() {
        String string = this.httpConnection.getContentType();
        if (string != null && !Pattern.compile("images?/\\w*", 34).matcher(string).matches()) {
            throw new IllegalStateException("Content-Type: " + string);
        }
        if (this.image == null && this.byteArray != null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.byteArray);
            try {
                this.image = ImageIO.read(byteArrayInputStream);
            }
            catch (Exception exception) {
                Log.exception(exception);
            }
        }
        return this.image;
    }

    public String getResponseText() throws CharacterCodingException {
        return this.getHtmlCode();
    }

    public URL getUrl() {
        return this.orgURL;
    }

    private boolean hasCookies() {
        return this.cookies != null && !this.cookies.isEmpty();
    }

    protected void initDefaultHeader() {
        this.headers = new RequestHeader();
        this.headers.put("User-Agent", "Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.9.0.10) Gecko/2009042523 Ubuntu/9.04 (jaunty) Firefox/3.0.10");
        this.headers.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        this.headers.put("Accept-Language", "de, en-gb;q=0.9, en;q=0.8");
        if ((double)Application.getJavaVersion() >= 1.6) {
            this.headers.put("Accept-Encoding", "gzip,deflate");
        } else {
            this.headers.put("Accept-Encoding", "gzip");
        }
        this.headers.put("Accept-Charset", "ISO-8859-1,utf-8;q=0.7,*;q=0.3");
        this.headers.put("Cache-Control", "no-cache");
        this.headers.put("Pragma", "no-cache");
        this.headers.put("Connection", "close");
    }

    public boolean isContentDecoded() {
        return this.httpConnection == null ? this.contentDecoded : this.httpConnection.isContentDecoded();
    }

    public boolean isRequested() {
        return this.requested;
    }

    public String load() throws IOException {
        this.requestConnection();
        return this.getHtmlCode();
    }

    private void openConnection() throws IOException {
        this.httpConnection = HTTPConnectionFactory.createHTTPConnection(this.orgURL, this.proxy);
        this.httpConnection.setRequest(this);
        this.httpConnection.setReadTimeout(this.readTimeout);
        this.httpConnection.setConnectTimeout(this.connectTimeout);
        this.httpConnection.setContentDecoded(this.contentDecoded);
        if (this.headers != null) {
            int n = this.headers.size();
            for (int i = 0; i < n; ++i) {
                this.httpConnection.setRequestProperty(this.headers.getKey(i), this.headers.getValue(i));
            }
        }
        this.preRequest();
        if (this.hasCookies()) {
            this.httpConnection.setRequestProperty("Cookie", this.getCookieString());
        }
    }

    public abstract long postRequest() throws IOException;

    public abstract void preRequest() throws IOException;

    public String printHeaders() {
        return this.httpConnection.toString();
    }

    public Request read() throws IOException {
        long l = System.currentTimeMillis();
        this.httpConnection.setCharset(this.customCharset);
        this.byteArray = Request.read(this.httpConnection);
        this.readTime = System.currentTimeMillis() - l;
        return this;
    }

    private void requestConnection() throws IOException {
        this.connect();
        this.read();
    }

    public void setConnectTimeout(int n) {
        this.connectTimeout = n;
    }

    public void setContentDecoded(boolean bl) {
        this.contentDecoded = bl;
    }

    public void setCookies(Cookies cookies) {
        this.cookies = cookies;
    }

    public void setCustomCharset(String string) {
        this.customCharset = string;
    }

    public void setHeaders(RequestHeader requestHeader) {
        this.headers = requestHeader;
    }

    public void setHtmlCode(String string) {
        this.byteArray = null;
        this.htmlCode = string;
    }

    public void setProxy(HTTPProxy hTTPProxy) {
        this.proxy = hTTPProxy;
    }

    public void setReadTimeout(int n) {
        this.readTimeout = n;
        URLConnectionAdapter uRLConnectionAdapter = this.httpConnection;
        if (uRLConnectionAdapter != null) {
            uRLConnectionAdapter.setReadTimeout(n);
        }
    }

    public String toString() {
        if (!this.requested) {
            return "Request not sent yet";
        }
        try {
            this.getHtmlCode();
            if (this.htmlCode == null || this.htmlCode.length() == 0) {
                if (this.getLocation() != null) {
                    return "Not HTML Code. Redirect to: " + this.getLocation();
                }
                return "No htmlCode read";
            }
        }
        catch (Exception exception) {
            return "NOTEXT: " + exception.getMessage();
        }
        return this.htmlCode;
    }
}

