/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.proxy;

import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import jd.controlling.IOEQ;
import jd.controlling.proxy.ProxyBlock;
import jd.controlling.proxy.ProxyData;
import jd.controlling.proxy.ProxyEvent;
import jd.controlling.proxy.ProxyInfo;
import jd.plugins.Account;
import jd.plugins.DownloadLink;
import jd.plugins.PluginForHost;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownEvent;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.DefaultEventListener;
import org.appwork.utils.event.DefaultEventSender;
import org.appwork.utils.logging.Log;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.net.httpconnection.HTTPProxyStorable;
import org.appwork.utils.net.httpconnection.HTTPProxyUtils;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.settings.GeneralSettings;
import org.jdownloader.settings.InternetConnectionSettings;

public class ProxyController {
    private static final ProxyController INSTANCE = new ProxyController();
    private ArrayList<ProxyInfo> proxies = new ArrayList();
    private ArrayList<ProxyInfo> directs = new ArrayList();
    private ProxyInfo defaultproxy = null;
    private ProxyInfo none = null;
    private DefaultEventSender<ProxyEvent<ProxyInfo>> eventSender = null;
    private InternetConnectionSettings config;
    private GeneralSettings generalConfig = null;
    private final Object LOCK = new Object();

    public static final ProxyController getInstance() {
        return INSTANCE;
    }

    public DefaultEventSender<ProxyEvent<ProxyInfo>> getEventSender() {
        return this.eventSender;
    }

    private ProxyController() {
        this.eventSender = new DefaultEventSender();
        this.config = JsonConfig.create(InternetConnectionSettings.class);
        this.generalConfig = JsonConfig.create(GeneralSettings.class);
        this.none = new ProxyInfo(HTTPProxy.NONE);
        this.loadProxySettings();
        ShutdownController.getInstance().addShutdownEvent(new ShutdownEvent(){

            @Override
            public void run() {
                ProxyController.this.saveProxySettings();
            }

            @Override
            public String toString() {
                return "ProxyController: save config";
            }
        });
        ShutdownController.getInstance().addShutdownEvent(new ShutdownEvent(){

            @Override
            public void run() {
                ProxyController.this.exportUpdaterConfig();
            }

            @Override
            public String toString() {
                return "ProxyController: export important settings to updaterConfig";
            }
        });
        this.eventSender.addListener(new DefaultEventListener<ProxyEvent<ProxyInfo>>(){
            DelayedRunnable asyncSaving = new DelayedRunnable(IOEQ.TIMINGQUEUE, 5000L, 60000L){

                @Override
                public void delayedrun() {
                    ProxyController.this.saveProxySettings();
                }
            };

            @Override
            public void onEvent(ProxyEvent<ProxyInfo> proxyEvent) {
                this.asyncSaving.resetAndStart();
            }
        });
    }

    private void exportUpdaterConfig() {
        this.exportUpdaterProxy();
    }

    private void exportUpdaterProxy() {
        ProxyInfo proxyInfo = this.defaultproxy;
        if (proxyInfo != null && !proxyInfo.isNone()) {
            HTTPProxyStorable hTTPProxyStorable = HTTPProxy.getStorable(proxyInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HTTPProxy> autoConfig() {
        ArrayList<HTTPProxy> arrayList = new ArrayList<HTTPProxy>();
        try {
            if (CrossSystem.isWindows()) {
                return ProxyController.checkReg();
            }
            System.setProperty("java.net.useSystemProxies", "true");
            List<Proxy> list = null;
            try {
                list = ProxySelector.getDefault().select(new URI("http://www.appwork.org"));
            }
            finally {
                System.setProperty("java.net.useSystemProxies", "false");
            }
            for (Proxy proxy : list) {
                InetSocketAddress inetSocketAddress;
                SocketAddress socketAddress = proxy.address();
                if (socketAddress == null || !(socketAddress instanceof InetSocketAddress) || StringUtils.isEmpty((inetSocketAddress = (InetSocketAddress)socketAddress).getHostName())) continue;
                switch (proxy.type()) {
                    case HTTP: {
                        HTTPProxy hTTPProxy = new HTTPProxy(HTTPProxy.TYPE.HTTP);
                        hTTPProxy.setHost(inetSocketAddress.getHostName());
                        hTTPProxy.setPort(inetSocketAddress.getPort());
                        arrayList.add(hTTPProxy);
                        break;
                    }
                    case SOCKS: {
                        HTTPProxy hTTPProxy = new HTTPProxy(HTTPProxy.TYPE.SOCKS5);
                        hTTPProxy.setHost(inetSocketAddress.getHostName());
                        hTTPProxy.setPort(inetSocketAddress.getPort());
                        arrayList.add(hTTPProxy);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Log.exception(throwable);
        }
        return arrayList;
    }

    private static byte[] toCstr(String string) {
        byte[] byArray = new byte[string.length() + 1];
        for (int i = 0; i < string.length(); ++i) {
            byArray[i] = (byte)string.charAt(i);
        }
        byArray[string.length()] = 0;
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<HTTPProxy> checkReg() {
        ArrayList<HTTPProxy> arrayList = new ArrayList<HTTPProxy>();
        try {
            Preferences preferences = Preferences.userRoot();
            Class<?> clazz = preferences.getClass();
            Method method = clazz.getDeclaredMethod("openKey", byte[].class, Integer.TYPE, Integer.TYPE);
            method.setAccessible(true);
            Method method2 = clazz.getDeclaredMethod("closeKey", Integer.TYPE);
            method2.setAccessible(true);
            Method method3 = clazz.getDeclaredMethod("WindowsRegQueryValueEx", Integer.TYPE, byte[].class);
            method3.setAccessible(true);
            byte[] byArray = null;
            String string = null;
            String string2 = null;
            Integer n = -1;
            string2 = "Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings";
            try {
                n = (Integer)method.invoke((Object)preferences, ProxyController.toCstr(string2), 131097, 131097);
                byArray = (byte[])method3.invoke((Object)preferences, (int)n, ProxyController.toCstr("ProxyServer"));
                string = byArray != null ? new String(byArray).trim() : null;
            }
            catch (Throwable throwable) {
                method2.invoke((Object)Preferences.userRoot(), n);
                throw throwable;
            }
            method2.invoke((Object)Preferences.userRoot(), n);
            if (string != null) {
                for (String string3 : string.split(";")) {
                    HTTPProxy hTTPProxy;
                    int n2;
                    String string4 = new Regex(string3, "(\\d+\\.\\d+\\.\\d+\\.\\d+)").getMatch(0);
                    if (string4 == null) {
                        string4 = new Regex(string3, "=(.*?)($|:)").getMatch(0);
                    }
                    String string5 = new Regex(string3, ":(\\d+)").getMatch(0);
                    if (string4 == null) continue;
                    if (string3.trim().contains("socks")) {
                        n2 = string5 != null ? Integer.parseInt(string5) : 1080;
                        hTTPProxy = new HTTPProxy(HTTPProxy.TYPE.SOCKS5);
                        hTTPProxy.setHost(string4);
                        hTTPProxy.setPort(n2);
                        arrayList.add(hTTPProxy);
                        continue;
                    }
                    n2 = string5 != null ? Integer.parseInt(string5) : 8080;
                    hTTPProxy = new HTTPProxy(HTTPProxy.TYPE.HTTP);
                    hTTPProxy.setHost(string4);
                    hTTPProxy.setPort(n2);
                    arrayList.add(hTTPProxy);
                }
            }
        }
        catch (Throwable throwable) {
            Log.exception(throwable);
        }
        return arrayList;
    }

    private List<HTTPProxy> getAvailableDirects() {
        List<InetAddress> list = HTTPProxyUtils.getLocalIPs();
        ArrayList<HTTPProxy> arrayList = new ArrayList<HTTPProxy>(list.size());
        if (list.size() > 1) {
            for (InetAddress inetAddress : list) {
                arrayList.add(new HTTPProxy(inetAddress));
            }
        }
        return arrayList;
    }

    private void saveProxySettings() {
        ProxyData proxyData;
        ProxyInfo proxyInfo = this.defaultproxy;
        ArrayList<ProxyData> arrayList = new ArrayList<ProxyData>(this.proxies.size());
        ArrayList<ProxyInfo> arrayList2 = this.proxies;
        for (ProxyInfo proxyInfo2 : arrayList2) {
            proxyData = proxyInfo2.toProxyData();
            proxyData.setDefaultProxy(proxyInfo2 == proxyInfo);
            arrayList.add(proxyData);
        }
        this.config.setCustomProxyList(arrayList);
        arrayList = new ArrayList();
        arrayList2 = this.directs;
        for (ProxyInfo proxyInfo2 : arrayList2) {
            proxyData = proxyInfo2.toProxyData();
            proxyData.setDefaultProxy(proxyInfo2 == proxyInfo);
            arrayList.add(proxyData);
        }
        this.config.setDirectGatewayList(arrayList);
        this.config.setNoneDefault(this.none == proxyInfo);
        this.config.setNoneRotationEnabled(this.none.isProxyRotationEnabled());
    }

    private List<HTTPProxy> restoreFromOldConfig() {
        ArrayList<HTTPProxy> arrayList = new ArrayList<HTTPProxy>();
        return arrayList;
    }

    private void loadProxySettings() {
        List<HTTPProxy> list;
        ProxyInfo proxyInfo = null;
        boolean bl = false;
        ArrayList<ProxyInfo> arrayList = new ArrayList<ProxyInfo>();
        ArrayList<ProxyInfo> arrayList2 = new ArrayList<ProxyInfo>();
        ArrayList<ProxyInfo> arrayList3 = new ArrayList<ProxyInfo>();
        ProxyInfo proxyInfo2 = null;
        List<Object> list2 = this.config.getCustomProxyList();
        if (list2 != null) {
            block8: for (ProxyData iterator : list2) {
                try {
                    proxyInfo2 = new ProxyInfo(iterator);
                    for (HTTPProxy hTTPProxy : arrayList3) {
                        if (!hTTPProxy.sameProxy(proxyInfo2)) continue;
                        continue block8;
                    }
                    arrayList3.add(proxyInfo2);
                    arrayList.add(proxyInfo2);
                    if (iterator.isDefaultProxy()) {
                        proxyInfo = proxyInfo2;
                    }
                    if (!proxyInfo2.isProxyRotationEnabled()) continue;
                    bl = true;
                }
                catch (Throwable throwable) {
                    Log.exception(throwable);
                }
            }
        } else {
            list = this.restoreFromOldConfig();
            block10: for (HTTPProxy hTTPProxy : list) {
                try {
                    proxyInfo2 = new ProxyInfo(hTTPProxy);
                    for (HTTPProxy hTTPProxy2 : arrayList3) {
                        if (!hTTPProxy2.sameProxy(proxyInfo2)) continue;
                        continue block10;
                    }
                    arrayList3.add(proxyInfo2);
                    arrayList.add(proxyInfo2);
                    proxyInfo = proxyInfo2;
                    if (!proxyInfo2.isProxyRotationEnabled()) continue;
                    bl = true;
                }
                catch (Throwable throwable) {
                    Log.exception(throwable);
                }
            }
        }
        list = HTTPProxy.getFromSystemProperties();
        block12: for (HTTPProxy hTTPProxy : list) {
            try {
                proxyInfo2 = new ProxyInfo(hTTPProxy);
                for (HTTPProxy hTTPProxy3 : arrayList3) {
                    if (!hTTPProxy3.sameProxy(proxyInfo2)) continue;
                    continue block12;
                }
                arrayList3.add(proxyInfo2);
                arrayList.add(proxyInfo2);
                proxyInfo = proxyInfo2;
                if (!proxyInfo2.isProxyRotationEnabled()) continue;
                bl = true;
            }
            catch (Throwable throwable) {
                Log.exception(throwable);
            }
        }
        list2 = this.getAvailableDirects();
        list = this.config.getDirectGatewayList();
        if (list != null) {
            block14: for (ProxyData proxyData : list) {
                try {
                    boolean bl2;
                    proxyInfo2 = new ProxyInfo(proxyData);
                    for (HTTPProxy hTTPProxy : arrayList3) {
                        if (!hTTPProxy.sameProxy(proxyInfo2)) continue;
                        continue block14;
                    }
                    boolean bl3 = false;
                    for (HTTPProxy hTTPProxy : list2) {
                        if (!hTTPProxy.sameProxy(proxyInfo2)) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2) continue;
                    arrayList3.add(proxyInfo2);
                    arrayList2.add(proxyInfo2);
                    if (proxyData.isDefaultProxy()) {
                        proxyInfo = proxyInfo2;
                    }
                    if (!proxyInfo2.isProxyRotationEnabled()) continue;
                    bl = true;
                }
                catch (Throwable throwable) {
                    Log.exception(throwable);
                }
            }
        }
        if (this.config.isNoneDefault()) {
            if (proxyInfo != null) {
                Log.L.severe("NONE default but already got different default?!");
            }
            proxyInfo = this.none;
        }
        this.none.setProxyRotationEnabled(this.config.isNoneRotationEnabled());
        if (this.none.isProxyRotationEnabled()) {
            bl = true;
        }
        if (!bl) {
            this.none.setProxyRotationEnabled(true);
            this.config.setNoneRotationEnabled(true);
        }
        if (proxyInfo == null || proxyInfo == this.none) {
            this.config.setNoneDefault(true);
        }
        this.setDefaultProxy(proxyInfo);
        this.directs = arrayList2;
        this.proxies = arrayList;
        this.eventSender.fireEvent(new ProxyEvent(this, ProxyEvent.Types.REFRESH, null));
    }

    public ArrayList<ProxyInfo> getList() {
        ArrayList<ProxyInfo> arrayList = new ArrayList<ProxyInfo>(this.directs.size() + this.proxies.size() + 1);
        arrayList.add(this.none);
        arrayList.addAll(this.directs);
        arrayList.addAll(this.proxies);
        return arrayList;
    }

    public ProxyInfo getDefaultProxy() {
        return this.defaultproxy;
    }

    public void setDefaultProxy(ProxyInfo proxyInfo) {
        if (proxyInfo != null && this.defaultproxy == proxyInfo) {
            return;
        }
        this.defaultproxy = proxyInfo == null ? this.none : proxyInfo;
        this.eventSender.fireEvent(new ProxyEvent(this, ProxyEvent.Types.REFRESH, null));
        this.exportUpdaterProxy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProxy(HTTPProxy hTTPProxy) {
        if (hTTPProxy == null) {
            return;
        }
        ProxyInfo proxyInfo = null;
        Object object = this.LOCK;
        synchronized (object) {
            ArrayList<ProxyInfo> arrayList = new ArrayList<ProxyInfo>(this.proxies);
            for (ProxyInfo proxyInfo2 : arrayList) {
                if (!proxyInfo2.sameProxy(hTTPProxy)) continue;
                return;
            }
            proxyInfo = new ProxyInfo(hTTPProxy);
            arrayList.add(proxyInfo);
            this.proxies = arrayList;
        }
        this.eventSender.fireEvent(new ProxyEvent(this, ProxyEvent.Types.ADDED, proxyInfo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProxy(List<HTTPProxy> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        int n = 0;
        Object object = this.LOCK;
        synchronized (object) {
            ArrayList<ProxyInfo> arrayList = new ArrayList<ProxyInfo>(this.proxies);
            n = arrayList.size();
            block3: for (HTTPProxy hTTPProxy : list) {
                for (ProxyInfo proxyInfo : arrayList) {
                    if (!proxyInfo.sameProxy(hTTPProxy)) continue;
                    continue block3;
                }
                arrayList.add(new ProxyInfo(hTTPProxy));
            }
            this.proxies = arrayList;
            if (n != arrayList.size()) {
                n = -1;
            }
        }
        if (n == -1) {
            this.eventSender.fireEvent(new ProxyEvent(this, ProxyEvent.Types.REFRESH, null));
        }
    }

    public void setproxyRotationEnabled(ProxyInfo proxyInfo, boolean bl) {
        if (proxyInfo == null) {
            return;
        }
        if (proxyInfo.isProxyRotationEnabled() == bl) {
            return;
        }
        proxyInfo.setProxyRotationEnabled(bl);
        this.eventSender.fireEvent(new ProxyEvent(this, ProxyEvent.Types.REFRESH, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ProxyInfo proxyInfo) {
        if (proxyInfo == null) {
            return;
        }
        boolean bl = false;
        Object object = this.LOCK;
        synchronized (object) {
            ArrayList<ProxyInfo> arrayList = new ArrayList<ProxyInfo>(this.proxies);
            if (arrayList.remove(proxyInfo)) {
                bl = true;
                if (proxyInfo == this.defaultproxy) {
                    this.setDefaultProxy(this.none);
                }
            }
            this.proxies = arrayList;
        }
        if (bl) {
            this.eventSender.fireEvent(new ProxyEvent(this, ProxyEvent.Types.REMOVED, proxyInfo));
        }
    }

    public ProxyInfo getProxyForDownload(DownloadLink downloadLink, Account account, boolean bl) {
        PluginForHost pluginForHost = downloadLink.getDefaultPlugin();
        String string = pluginForHost.getHost();
        int n = pluginForHost.getMaxSimultanDownload(account);
        if (account != null) {
            ProxyInfo proxyInfo = this.defaultproxy;
            int n2 = proxyInfo.activeDownloadsbyHosts(string);
            if (bl || n2 < n) {
                return proxyInfo;
            }
            return null;
        }
        if (this.none.isProxyRotationEnabled() && this.none.getHostBlockedTimeout(string) == null && this.none.getHostIPBlockTimeout(string) == null) {
            int n3 = this.none.activeDownloadsbyHosts(string);
            if (bl || n3 < n) {
                return this.none;
            }
        }
        ArrayList<ProxyInfo> arrayList = this.directs;
        for (ProxyInfo object2 : arrayList) {
            if (!object2.isProxyRotationEnabled() || object2.getHostBlockedTimeout(string) != null || object2.getHostIPBlockTimeout(string) != null) continue;
            int proxyInfo = object2.activeDownloadsbyHosts(string);
            if (!bl && proxyInfo >= n) continue;
            return object2;
        }
        ArrayList<ProxyInfo> arrayList2 = this.proxies;
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            ProxyInfo proxyInfo = (ProxyInfo)iterator.next();
            if (!proxyInfo.isProxyRotationEnabled() || proxyInfo.getHostBlockedTimeout(string) != null || proxyInfo.getHostIPBlockTimeout(string) != null) continue;
            int n2 = proxyInfo.activeDownloadsbyHosts(string);
            if (!bl && n2 >= n) continue;
            return proxyInfo;
        }
        return null;
    }

    public ProxyBlock getHostIPBlockTimeout(String string) {
        Object object;
        Object object3 = null;
        if (this.none.isProxyRotationEnabled()) {
            object3 = this.none.getHostIPBlockTimeout(string);
        }
        if (object3 == null) {
            return null;
        }
        ArrayList<ProxyInfo> arrayList = this.proxies;
        for (ProxyInfo object22 : arrayList) {
            if (!object22.isProxyRotationEnabled()) continue;
            object = object22.getHostIPBlockTimeout(string);
            if (object == null) {
                return null;
            }
            if (object3 != null && ((ProxyBlock)object).getBlockedUntil() >= ((ProxyBlock)object3).getBlockedUntil()) continue;
            object3 = object;
        }
        ArrayList<ProxyInfo> arrayList2 = this.directs;
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            object = (ProxyInfo)iterator.next();
            if (!((ProxyInfo)object).isProxyRotationEnabled()) continue;
            ProxyBlock proxyBlock = ((ProxyInfo)object).getHostIPBlockTimeout(string);
            if (proxyBlock == null) {
                return null;
            }
            if (object3 != null && proxyBlock.getBlockedUntil() >= ((ProxyBlock)object3).getBlockedUntil()) continue;
            object3 = proxyBlock;
        }
        return object3;
    }

    public ProxyBlock getHostBlockedTimeout(String string) {
        Object object;
        Object object3 = null;
        if (this.none.isProxyRotationEnabled()) {
            object3 = this.none.getHostBlockedTimeout(string);
        }
        if (object3 == null) {
            return null;
        }
        ArrayList<ProxyInfo> arrayList = this.proxies;
        for (ProxyInfo object22 : arrayList) {
            if (!object22.isProxyRotationEnabled()) continue;
            object = object22.getHostBlockedTimeout(string);
            if (object == null) {
                return null;
            }
            if (object3 != null && ((ProxyBlock)object).getBlockedUntil() >= ((ProxyBlock)object3).getBlockedUntil()) continue;
            object3 = object;
        }
        ArrayList<ProxyInfo> arrayList2 = this.directs;
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            object = (ProxyInfo)iterator.next();
            if (!((ProxyInfo)object).isProxyRotationEnabled()) continue;
            ProxyBlock proxyBlock = ((ProxyInfo)object).getHostBlockedTimeout(string);
            if (proxyBlock == null) {
                return null;
            }
            if (object3 != null && proxyBlock.getBlockedUntil() >= ((ProxyBlock)object3).getBlockedUntil()) continue;
            object3 = proxyBlock;
        }
        return object3;
    }

    public boolean hasIPBlock(String string) {
        if (this.none.isProxyRotationEnabled() && this.none.getHostIPBlockTimeout(string) != null) {
            return true;
        }
        ArrayList<ProxyInfo> arrayList = this.proxies;
        for (ProxyInfo object2 : arrayList) {
            if (!object2.isProxyRotationEnabled() || object2.getHostIPBlockTimeout(string) == null) continue;
            return true;
        }
        ArrayList<ProxyInfo> arrayList2 = this.directs;
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            ProxyInfo proxyInfo = (ProxyInfo)iterator.next();
            if (!proxyInfo.isProxyRotationEnabled() || proxyInfo.getHostIPBlockTimeout(string) == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasHostBlocked(String string) {
        if (this.none.isProxyRotationEnabled() && this.none.getHostBlockedTimeout(string) != null) {
            return true;
        }
        ArrayList<ProxyInfo> arrayList = this.proxies;
        for (ProxyInfo object2 : arrayList) {
            if (!object2.isProxyRotationEnabled() || object2.getHostBlockedTimeout(string) == null) continue;
            return true;
        }
        ArrayList<ProxyInfo> arrayList2 = this.directs;
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            ProxyInfo proxyInfo = (ProxyInfo)iterator.next();
            if (!proxyInfo.isProxyRotationEnabled() || proxyInfo.getHostBlockedTimeout(string) == null) continue;
            return true;
        }
        return false;
    }

    public void removeHostBlockedTimeout(String string, boolean bl) {
        this.none.removeHostBlockedWaittime(string);
        ArrayList<ProxyInfo> arrayList = this.directs;
        for (ProxyInfo object : arrayList) {
            object.removeHostBlockedWaittime(string);
        }
        if (!bl) {
            ArrayList<ProxyInfo> arrayList2 = this.proxies;
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                ProxyInfo proxyInfo = (ProxyInfo)iterator.next();
                proxyInfo.removeHostBlockedWaittime(string);
            }
        }
    }

    public void removeIPBlockTimeout(String string, boolean bl) {
        this.none.removeHostIPBlockTimeout(string);
        ArrayList<ProxyInfo> arrayList = this.directs;
        for (ProxyInfo object : arrayList) {
            object.removeHostIPBlockTimeout(string);
        }
        if (!bl) {
            ArrayList<ProxyInfo> arrayList2 = this.proxies;
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                ProxyInfo proxyInfo = (ProxyInfo)iterator.next();
                proxyInfo.removeHostIPBlockTimeout(string);
            }
        }
    }

    public boolean hasRotation() {
        if (this.none.isProxyRotationEnabled()) {
            return true;
        }
        ArrayList<ProxyInfo> arrayList = this.directs;
        for (ProxyInfo object2 : arrayList) {
            if (!object2.isProxyRotationEnabled()) continue;
            return true;
        }
        ArrayList<ProxyInfo> arrayList2 = this.proxies;
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            ProxyInfo proxyInfo = (ProxyInfo)iterator.next();
            if (!proxyInfo.isProxyRotationEnabled()) continue;
            return true;
        }
        return false;
    }

    public ProxyInfo getNone() {
        return this.none;
    }
}

