/*
 * Decompiled with CFR 0.152.
 */
package jd.config;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import jd.controlling.JDController;
import jd.controlling.JDLogger;
import jd.utils.JDUtilities;

public class Property
implements Serializable {
    private static final long serialVersionUID = -6093927038856757256L;
    public static final Object NULL = new Object();
    private HashMap<String, Object> properties = null;
    private HashMap<String, Integer> propertiesHashes = null;
    protected transient boolean changes = false;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.properties != null && this.properties.isEmpty()) {
            this.properties = null;
            this.propertiesHashes = null;
        }
    }

    @Deprecated
    public <E> E getGenericProperty(String string, E e) {
        Object object = this.getProperty(string, e);
        try {
            Object object2 = object;
            return (E)object2;
        }
        catch (Exception exception) {
            JDLogger.getLogger().finer("Could not cast " + object.getClass().getSimpleName() + " to " + e.getClass().getSimpleName() + " for key " + string);
            return e;
        }
    }

    public Boolean getBooleanProperty(String string) {
        return this.getBooleanProperty(string, false);
    }

    public Boolean getBooleanProperty(String string, boolean bl) {
        try {
            Object object = this.getProperty(string, bl);
            if (!(object instanceof Boolean)) {
                object = ((String)(object = object + "")).equals("false") ? Boolean.valueOf(false) : Boolean.valueOf(((String)object).length() > 0);
            }
            Boolean bl2 = (Boolean)object;
            return bl2;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Double getDoubleProperty(String string) {
        return this.getDoubleProperty(string, -1.0);
    }

    public Double getDoubleProperty(String string, Double d) {
        try {
            Object object = this.getProperty(string, d);
            if (object instanceof String) {
                object = Double.parseDouble((String)object);
            }
            Double d2 = (Double)object;
            return d2;
        }
        catch (Exception exception) {
            return d;
        }
    }

    public int getIntegerProperty(String string) {
        return this.getIntegerProperty(string, -1);
    }

    public int getIntegerProperty(String string, int n) {
        try {
            Object object = this.getProperty(string, n);
            if (object instanceof String) {
                object = Integer.parseInt((String)object);
            }
            Integer n2 = (Integer)object;
            return n2;
        }
        catch (Exception exception) {
            return n;
        }
    }

    public long getLongProperty(String string, long l) {
        try {
            Object object = this.getProperty(string, l);
            if (object instanceof String) {
                object = Long.parseLong((String)object);
            } else if (object instanceof Integer) {
                object = ((Integer)object).longValue();
            }
            Long l2 = (Long)object;
            return l2;
        }
        catch (Exception exception) {
            return l;
        }
    }

    public HashMap<String, Object> getProperties() {
        return this.properties;
    }

    public void copyTo(Property property) {
        if (property != null && property != this) {
            if (this.properties != null) {
                if (property.properties == null) {
                    property.properties = new HashMap();
                }
                property.properties.putAll(this.properties);
            }
            if (this.propertiesHashes != null) {
                if (property.propertiesHashes == null) {
                    property.propertiesHashes = new HashMap();
                }
                property.propertiesHashes.putAll(this.propertiesHashes);
            }
        }
    }

    @Deprecated
    public Object getProperty(String string) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(string);
    }

    public Object getProperty(String string, Object object) {
        Object object2 = this.getProperty(string);
        if (object instanceof Long && object2 instanceof Integer) {
            object2 = ((Integer)object2).longValue();
        }
        if (object2 == null) {
            return object;
        }
        return object2;
    }

    public String getStringProperty(String string) {
        return this.getStringProperty(string, null);
    }

    public String getStringProperty(String string, String string2) {
        try {
            Object object = this.getProperty(string, string2);
            String string3 = object == null ? null : object.toString();
            return string3;
        }
        catch (Exception exception) {
            return string2;
        }
    }

    public boolean hasProperty(String string) {
        if (this.properties == null) {
            return false;
        }
        return this.properties.containsKey(string);
    }

    public void setProperties(HashMap<String, Object> hashMap) {
        if (hashMap != null && hashMap.isEmpty()) {
            this.properties = null;
            this.propertiesHashes = null;
        } else {
            this.properties = hashMap;
            this.propertiesHashes = new HashMap();
        }
    }

    public void setProperty(String string, Object object) {
        Object object2;
        JDController jDController = JDUtilities.getController();
        if (object == NULL) {
            if (this.properties != null && this.properties.containsKey(string)) {
                this.properties.remove(string);
                this.propertiesHashes.remove(string);
                this.changes = true;
            }
            return;
        }
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        if (this.propertiesHashes == null) {
            this.propertiesHashes = new HashMap();
        }
        if ((object2 = this.getProperty(string)) == null && object == null) {
            return;
        }
        this.properties.put(string, object);
        Integer n = this.propertiesHashes.get(string);
        this.propertiesHashes.put(string, object == null ? null : Integer.valueOf(object.toString().hashCode()));
        if (jDController != null) {
            try {
                if (object2 == null && object != null) {
                    this.changes = true;
                } else if (object instanceof Comparable) {
                    if (((Comparable)object).compareTo((Comparable)object2) != 0) {
                        this.changes = true;
                    }
                } else if (!object.equals(object2) || n.intValue() != object.hashCode()) {
                    this.changes = true;
                }
            }
            catch (Exception exception) {
                this.changes = true;
            }
        }
    }

    public boolean hasChanges() {
        return this.changes;
    }

    public String toString() {
        if (this.properties != null) {
            return this.properties.size() == 0 ? "" : "Property: " + this.properties;
        }
        return "no properties set";
    }
}

