/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.remote.ipfilter;

import java.io.File;
import org.gudy.azureus2.plugins.ipfilter.IPBanned;
import org.gudy.azureus2.plugins.ipfilter.IPBlocked;
import org.gudy.azureus2.plugins.ipfilter.IPFilter;
import org.gudy.azureus2.plugins.ipfilter.IPFilterException;
import org.gudy.azureus2.plugins.ipfilter.IPRange;
import org.gudy.azureus2.pluginsimpl.remote.RPException;
import org.gudy.azureus2.pluginsimpl.remote.RPObject;
import org.gudy.azureus2.pluginsimpl.remote.RPReply;
import org.gudy.azureus2.pluginsimpl.remote.RPRequest;
import org.gudy.azureus2.pluginsimpl.remote.ipfilter.RPIPRange;

public class RPIPFilter
extends RPObject
implements IPFilter {
    protected transient IPFilter delegate;
    public long last_update_time;
    public int number_of_ranges;
    public int number_of_blocked_ips;

    public static IPFilter create(IPFilter iPFilter) {
        RPIPFilter rPIPFilter = (RPIPFilter)RPIPFilter._lookupLocal(iPFilter);
        if (rPIPFilter == null) {
            rPIPFilter = new RPIPFilter(iPFilter);
        }
        return rPIPFilter;
    }

    protected RPIPFilter(IPFilter iPFilter) {
        super(iPFilter);
    }

    @Override
    protected void _setDelegate(Object object) {
        this.delegate = (IPFilter)object;
        this.last_update_time = this.delegate.getLastUpdateTime();
        this.number_of_ranges = this.delegate.getNumberOfRanges();
        this.number_of_blocked_ips = this.delegate.getNumberOfBlockedIPs();
    }

    @Override
    public Object _setLocal() throws RPException {
        return this._fixupLocal();
    }

    @Override
    public RPReply _process(RPRequest rPRequest) {
        String string = rPRequest.getMethod();
        Object[] objectArray = rPRequest.getParams();
        if (string.equals("createAndAddRange[String,String,String,boolean]")) {
            IPRange iPRange = this.delegate.createAndAddRange((String)objectArray[0], (String)objectArray[1], (String)objectArray[2], (Boolean)objectArray[3]);
            if (iPRange == null) {
                return new RPReply(null);
            }
            RPIPRange rPIPRange = RPIPRange.create(iPRange);
            return new RPReply(rPIPRange);
        }
        if (string.equals("getRanges")) {
            IPRange[] iPRangeArray = this.delegate.getRanges();
            RPIPRange[] rPIPRangeArray = new RPIPRange[iPRangeArray.length];
            for (int i = 0; i < iPRangeArray.length; ++i) {
                rPIPRangeArray[i] = RPIPRange.create(iPRangeArray[i]);
            }
            return new RPReply(rPIPRangeArray);
        }
        if (string.equals("save")) {
            try {
                this.delegate.save();
                return null;
            }
            catch (IPFilterException iPFilterException) {
                return new RPReply(iPFilterException);
            }
        }
        if (string.equals("getInRangeAddressesAreAllowed")) {
            return new RPReply(new Boolean(this.delegate.getInRangeAddressesAreAllowed()));
        }
        if (string.equals("setInRangeAddressesAreAllowed[boolean]")) {
            this.delegate.setInRangeAddressesAreAllowed((Boolean)objectArray[0]);
            return null;
        }
        if (string.equals("isEnabled")) {
            return new RPReply(new Boolean(this.delegate.isEnabled()));
        }
        if (string.equals("setEnabled[boolean]")) {
            this.delegate.setEnabled((Boolean)objectArray[0]);
            return null;
        }
        if (string.equals("isInRange[String]")) {
            return new RPReply(new Boolean(this.delegate.isInRange((String)objectArray[0])));
        }
        throw new RPException("Unknown method: " + string);
    }

    @Override
    public File getFile() {
        this.notSupported();
        return null;
    }

    @Override
    public IPRange createRange(boolean bl) {
        this.notSupported();
        return null;
    }

    @Override
    public void addRange(IPRange iPRange) {
        this.notSupported();
    }

    @Override
    public IPRange createAndAddRange(String string, String string2, String string3, boolean bl) {
        RPIPRange rPIPRange = (RPIPRange)this._dispatcher.dispatch(new RPRequest(this, "createAndAddRange[String,String,String,boolean]", new Object[]{string, string2, string3, new Boolean(bl)})).getResponse();
        rPIPRange._setRemote(this._dispatcher);
        return rPIPRange;
    }

    @Override
    public void removeRange(IPRange iPRange) {
        this.notSupported();
    }

    @Override
    public void reload() throws IPFilterException {
        this.notSupported();
    }

    @Override
    public IPRange[] getRanges() {
        IPRange[] iPRangeArray = (RPIPRange[])this._dispatcher.dispatch(new RPRequest(this, "getRanges", null)).getResponse();
        for (int i = 0; i < iPRangeArray.length; ++i) {
            ((RPObject)((Object)iPRangeArray[i]))._setRemote(this._dispatcher);
        }
        return iPRangeArray;
    }

    @Override
    public boolean isInRange(String string) {
        Boolean bl = (Boolean)this._dispatcher.dispatch(new RPRequest(this, "isInRange[String]", new Object[]{string})).getResponse();
        return bl;
    }

    @Override
    public IPBlocked[] getBlockedIPs() {
        this.notSupported();
        return null;
    }

    @Override
    public void block(String string) {
        this.notSupported();
    }

    @Override
    public IPBanned[] getBannedIPs() {
        this.notSupported();
        return null;
    }

    @Override
    public void ban(String string, String string2) {
        this.notSupported();
    }

    @Override
    public void unban(String string) {
        this.notSupported();
    }

    @Override
    public boolean getInRangeAddressesAreAllowed() {
        Boolean bl = (Boolean)this._dispatcher.dispatch(new RPRequest(this, "getInRangeAddressesAreAllowed", null)).getResponse();
        return bl;
    }

    @Override
    public void setInRangeAddressesAreAllowed(boolean bl) {
        this._dispatcher.dispatch(new RPRequest(this, "setInRangeAddressesAreAllowed[boolean]", new Object[]{new Boolean(bl)})).getResponse();
    }

    @Override
    public boolean isEnabled() {
        Boolean bl = (Boolean)this._dispatcher.dispatch(new RPRequest(this, "isEnabled", null)).getResponse();
        return bl;
    }

    @Override
    public void setEnabled(boolean bl) {
        this._dispatcher.dispatch(new RPRequest(this, "setEnabled[boolean]", new Object[]{new Boolean(bl)})).getResponse();
    }

    @Override
    public void save() throws IPFilterException {
        try {
            this._dispatcher.dispatch(new RPRequest(this, "save", null)).getResponse();
        }
        catch (RPException rPException) {
            if (rPException.getCause() instanceof IPFilterException) {
                throw (IPFilterException)rPException.getCause();
            }
            throw rPException;
        }
    }

    @Override
    public void markAsUpToDate() {
        this.notSupported();
    }

    @Override
    public long getLastUpdateTime() {
        return this.last_update_time;
    }

    @Override
    public int getNumberOfRanges() {
        return this.number_of_ranges;
    }

    @Override
    public int getNumberOfBlockedIPs() {
        return this.number_of_blocked_ips;
    }

    @Override
    public int getNumberOfBannedIPs() {
        this.notSupported();
        return -1;
    }
}

