/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.update;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.update.UpdatableComponent;
import org.gudy.azureus2.plugins.update.Update;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateCheckInstanceListener;
import org.gudy.azureus2.plugins.update.UpdateChecker;
import org.gudy.azureus2.plugins.update.UpdateException;
import org.gudy.azureus2.plugins.update.UpdateInstaller;
import org.gudy.azureus2.plugins.update.UpdateManager;
import org.gudy.azureus2.plugins.update.UpdateManagerDecisionListener;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.pluginsimpl.local.update.UpdatableComponentImpl;
import org.gudy.azureus2.pluginsimpl.local.update.UpdateCheckerImpl;
import org.gudy.azureus2.pluginsimpl.local.update.UpdateImpl;

public class UpdateCheckInstanceImpl
implements UpdateCheckInstance {
    private static final LogIDs LOGID = LogIDs.CORE;
    private static UpdateCheckInstanceImpl active_checker;
    private List<UpdateCheckInstanceListener> listeners = new ArrayList<UpdateCheckInstanceListener>();
    private List<UpdateImpl> updates = new ArrayList<UpdateImpl>();
    private List<UpdateManagerDecisionListener> decision_listeners = new ArrayList<UpdateManagerDecisionListener>();
    private AESemaphore sem = new AESemaphore("UpdateCheckInstance");
    private UpdateManager manager;
    private int check_type;
    private String name;
    private UpdatableComponentImpl[] components;
    private UpdateCheckerImpl[] checkers;
    private boolean completed;
    private boolean cancelled;
    private boolean automatic = true;
    private boolean low_noise = false;
    protected AEMonitor this_mon = new AEMonitor("UpdateCheckInstance");
    private Map<Integer, Object> properties = new HashMap<Integer, Object>();

    protected UpdateCheckInstanceImpl(UpdateManager updateManager, int n, String string, UpdatableComponentImpl[] updatableComponentImplArray) {
        this.properties.put(1, 1);
        this.manager = updateManager;
        this.check_type = n;
        this.name = string;
        this.components = updatableComponentImplArray;
        this.checkers = new UpdateCheckerImpl[this.components.length];
        for (int i = 0; i < this.components.length; ++i) {
            UpdatableComponentImpl updatableComponentImpl = this.components[i];
            this.checkers[i] = new UpdateCheckerImpl(this, updatableComponentImpl, this.sem);
        }
    }

    @Override
    public int getType() {
        return this.check_type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addUpdatableComponent(UpdatableComponent updatableComponent, boolean bl) {
        UpdatableComponentImpl updatableComponentImpl = new UpdatableComponentImpl(updatableComponent, bl);
        UpdatableComponentImpl[] updatableComponentImplArray = new UpdatableComponentImpl[this.components.length + 1];
        System.arraycopy(this.components, 0, updatableComponentImplArray, 0, this.components.length);
        updatableComponentImplArray[this.components.length] = updatableComponentImpl;
        this.components = updatableComponentImplArray;
        UpdateCheckerImpl updateCheckerImpl = new UpdateCheckerImpl(this, updatableComponentImpl, this.sem);
        UpdateCheckerImpl[] updateCheckerImplArray = new UpdateCheckerImpl[this.checkers.length + 1];
        System.arraycopy(this.checkers, 0, updateCheckerImplArray, 0, this.checkers.length);
        updateCheckerImplArray[this.checkers.length] = updateCheckerImpl;
        this.checkers = updateCheckerImplArray;
    }

    @Override
    public void setAutomatic(boolean bl) {
        this.automatic = bl;
    }

    @Override
    public boolean isAutomatic() {
        return this.automatic;
    }

    @Override
    public void setLowNoise(boolean bl) {
        this.low_noise = bl;
    }

    @Override
    public boolean isLowNoise() {
        return this.low_noise;
    }

    @Override
    public Object getProperty(int n) {
        return this.properties.get(n);
    }

    @Override
    public void setProperty(int n, Object object) {
        this.properties.put(n, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Class<UpdateCheckInstanceImpl> clazz = UpdateCheckInstanceImpl.class;
        synchronized (UpdateCheckInstanceImpl.class) {
            boolean bl;
            if (active_checker == null) {
                active_checker = this;
                bl = true;
                new AEThread2("UCI:clearer"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object;
                        while (true) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            if (!UpdateCheckInstanceImpl.this.isCompleteOrCancelled()) continue;
                            boolean bl = true;
                            if (UpdateCheckInstanceImpl.this.completed) {
                                for (Update update : object = UpdateCheckInstanceImpl.this.getUpdates()) {
                                    if (update.isCancelled() || update.isComplete()) continue;
                                    bl = false;
                                    break;
                                }
                            }
                            if (bl) break;
                        }
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        object = UpdateCheckInstanceImpl.class;
                        synchronized (UpdateCheckInstanceImpl.class) {
                            active_checker = null;
                            // ** MonitorExit[var2_3 /* !! */ ] (shouldn't be in output)
                            return;
                        }
                    }
                }.start();
            } else {
                bl = false;
                new AEThread2("UCI:waiter"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     * Converted monitor instructions to comments
                     * Lifted jumps to return sites
                     */
                    @Override
                    public void run() {
                        boolean bl;
                        do {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            bl = false;
                            Class<UpdateCheckInstanceImpl> clazz = UpdateCheckInstanceImpl.class;
                            // MONITORENTER : org.gudy.azureus2.pluginsimpl.local.update.UpdateCheckInstanceImpl.class
                            if (active_checker == null) {
                                bl = true;
                            }
                            // MONITOREXIT : clazz
                        } while (!bl);
                        UpdateCheckInstanceImpl.this.start();
                    }
                }.start();
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (bl) {
                this.startSupport();
            }
            return;
        }
    }

    private void startSupport() {
        for (int i = 0; i < this.components.length; ++i) {
            final UpdateCheckerImpl updateCheckerImpl = this.checkers[i];
            new AEThread2("UpdatableComponent Checker:" + i, true){

                @Override
                public void run() {
                    try {
                        updateCheckerImpl.getComponent().checkForUpdate(updateCheckerImpl);
                    }
                    catch (Throwable throwable) {
                        updateCheckerImpl.reportProgress("Update check failed: " + Debug.getNestedExceptionMessage(throwable));
                        throwable.printStackTrace();
                        updateCheckerImpl.failed();
                    }
                }
            }.start();
        }
        new AEThread2("UpdatableComponent Completion Waiter", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int n;
                for (n = 0; n < UpdateCheckInstanceImpl.this.components.length; ++n) {
                    UpdateCheckInstanceImpl.this.sem.reserve();
                }
                try {
                    n = 0;
                    for (int i = 0; i < UpdateCheckInstanceImpl.this.checkers.length; ++i) {
                        if (!UpdateCheckInstanceImpl.this.components[i].isMandatory() || !UpdateCheckInstanceImpl.this.checkers[i].getFailed()) continue;
                        n = 1;
                        break;
                    }
                    ArrayList<UpdateImpl> arrayList = new ArrayList<UpdateImpl>();
                    if (n != 0) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, 3, "Dropping all updates as a mandatory update check failed"));
                        }
                    } else {
                        UpdateImpl updateImpl;
                        int n2;
                        boolean bl = false;
                        for (n2 = 0; n2 < UpdateCheckInstanceImpl.this.updates.size(); ++n2) {
                            updateImpl = (UpdateImpl)UpdateCheckInstanceImpl.this.updates.get(n2);
                            if (!updateImpl.isMandatory()) continue;
                            bl = true;
                            break;
                        }
                        for (n2 = 0; n2 < UpdateCheckInstanceImpl.this.updates.size(); ++n2) {
                            updateImpl = (UpdateImpl)UpdateCheckInstanceImpl.this.updates.get(n2);
                            if (updateImpl.isMandatory() || !bl) {
                                arrayList.add(updateImpl);
                                continue;
                            }
                            if (!Logger.isEnabled()) continue;
                            Logger.log(new LogEvent(LOGID, 3, "Dropping update '" + updateImpl.getName() + "' as non-mandatory and " + "mandatory updates found"));
                        }
                    }
                    Collections.sort(arrayList, new Comparator<UpdateImpl>(){

                        @Override
                        public int compare(UpdateImpl updateImpl, UpdateImpl updateImpl2) {
                            int n = this.getIndex(updateImpl);
                            int n2 = this.getIndex(updateImpl2);
                            return n - n2;
                        }

                        private int getIndex(UpdateImpl updateImpl) {
                            UpdatableComponentImpl updatableComponentImpl = updateImpl.getComponent();
                            for (int i = 0; i < UpdateCheckInstanceImpl.this.components.length; ++i) {
                                if (UpdateCheckInstanceImpl.this.components[i] != updatableComponentImpl) continue;
                                return i;
                            }
                            Debug.out("Missing component!");
                            return 0;
                        }
                    });
                    UpdateCheckInstanceImpl.this.updates = arrayList;
                }
                finally {
                    try {
                        UpdateCheckInstanceImpl.this.this_mon.enter();
                        if (UpdateCheckInstanceImpl.this.cancelled) {
                            return;
                        }
                        UpdateCheckInstanceImpl.this.completed = true;
                    }
                    finally {
                        UpdateCheckInstanceImpl.this.this_mon.exit();
                    }
                }
                for (n = 0; n < UpdateCheckInstanceImpl.this.listeners.size(); ++n) {
                    try {
                        ((UpdateCheckInstanceListener)UpdateCheckInstanceImpl.this.listeners.get(n)).complete(UpdateCheckInstanceImpl.this);
                        continue;
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UpdateImpl addUpdate(UpdatableComponentImpl updatableComponentImpl, String string, String[] stringArray, String string2, ResourceDownloader[] resourceDownloaderArray, int n) {
        try {
            this.this_mon.enter();
            UpdateImpl updateImpl = new UpdateImpl(this, updatableComponentImpl, string, stringArray, string2, resourceDownloaderArray, updatableComponentImpl.isMandatory(), n);
            this.updates.add(updateImpl);
            if (this.cancelled) {
                updateImpl.cancel();
            }
            UpdateImpl updateImpl2 = updateImpl;
            return updateImpl2;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Update[] getUpdates() {
        try {
            this.this_mon.enter();
            Update[] updateArray = new Update[this.updates.size()];
            this.updates.toArray(updateArray);
            Update[] updateArray2 = updateArray;
            return updateArray2;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public UpdateChecker[] getCheckers() {
        return this.checkers;
    }

    @Override
    public UpdateInstaller createInstaller() throws UpdateException {
        return this.manager.createInstaller();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCompleteOrCancelled() {
        try {
            this.this_mon.enter();
            boolean bl = this.completed || this.cancelled;
            return bl;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        int n;
        boolean bl = false;
        try {
            this.this_mon.enter();
            if (this.completed) {
                bl = true;
            }
            this.cancelled = true;
        }
        finally {
            this.this_mon.exit();
        }
        for (n = 0; n < this.updates.size(); ++n) {
            this.updates.get(n).cancel();
        }
        if (!bl) {
            for (n = 0; n < this.checkers.length; ++n) {
                if (this.checkers[n] == null) continue;
                this.checkers[n].cancel();
            }
            for (n = 0; n < this.listeners.size(); ++n) {
                try {
                    this.listeners.get(n).cancelled(this);
                    continue;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public UpdateManager getManager() {
        return this.manager;
    }

    protected Object getDecision(Update update, int n, String string, String string2, Object object) {
        for (int i = 0; i < this.decision_listeners.size(); ++i) {
            Object object2 = this.decision_listeners.get(i).decide(update, n, string, string2, object);
            if (object2 == null) continue;
            return object2;
        }
        return null;
    }

    @Override
    public void addDecisionListener(UpdateManagerDecisionListener updateManagerDecisionListener) {
        this.decision_listeners.add(updateManagerDecisionListener);
    }

    @Override
    public void removeDecisionListener(UpdateManagerDecisionListener updateManagerDecisionListener) {
        this.decision_listeners.remove(updateManagerDecisionListener);
    }

    @Override
    public void addListener(UpdateCheckInstanceListener updateCheckInstanceListener) {
        this.listeners.add(updateCheckInstanceListener);
        if (this.completed) {
            updateCheckInstanceListener.complete(this);
        } else if (this.cancelled) {
            updateCheckInstanceListener.cancelled(this);
        }
    }

    @Override
    public void removeListener(UpdateCheckInstanceListener updateCheckInstanceListener) {
        this.listeners.remove(updateCheckInstanceListener);
    }
}

