/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.torrent;

import java.net.URL;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLGroup;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.torrent.TorrentAnnounceURLList;
import org.gudy.azureus2.plugins.torrent.TorrentAnnounceURLListSet;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentAnnounceURLListSetImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;

public class TorrentAnnounceURLListImpl
implements TorrentAnnounceURLList {
    protected TorrentImpl torrent;

    protected TorrentAnnounceURLListImpl(TorrentImpl torrentImpl) {
        this.torrent = torrentImpl;
    }

    @Override
    public TorrentAnnounceURLListSet[] getSets() {
        TOTorrentAnnounceURLGroup tOTorrentAnnounceURLGroup = this.torrent.getTorrent().getAnnounceURLGroup();
        TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray = tOTorrentAnnounceURLGroup.getAnnounceURLSets();
        TorrentAnnounceURLListSet[] torrentAnnounceURLListSetArray = new TorrentAnnounceURLListSet[tOTorrentAnnounceURLSetArray.length];
        for (int i = 0; i < torrentAnnounceURLListSetArray.length; ++i) {
            torrentAnnounceURLListSetArray[i] = new TorrentAnnounceURLListSetImpl(this, tOTorrentAnnounceURLSetArray[i]);
        }
        return torrentAnnounceURLListSetArray;
    }

    @Override
    public void setSets(TorrentAnnounceURLListSet[] torrentAnnounceURLListSetArray) {
        TOTorrentAnnounceURLGroup tOTorrentAnnounceURLGroup = this.torrent.getTorrent().getAnnounceURLGroup();
        TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray = new TOTorrentAnnounceURLSet[torrentAnnounceURLListSetArray.length];
        for (int i = 0; i < tOTorrentAnnounceURLSetArray.length; ++i) {
            tOTorrentAnnounceURLSetArray[i] = ((TorrentAnnounceURLListSetImpl)torrentAnnounceURLListSetArray[i]).getSet();
        }
        tOTorrentAnnounceURLGroup.setAnnounceURLSets(tOTorrentAnnounceURLSetArray);
        this.updated();
    }

    @Override
    public TorrentAnnounceURLListSet create(URL[] uRLArray) {
        return new TorrentAnnounceURLListSetImpl(this, this.torrent.getTorrent().getAnnounceURLGroup().createAnnounceURLSet(uRLArray));
    }

    @Override
    public void addSet(URL[] uRLArray) {
        if (this.setAlreadyExists(uRLArray)) {
            return;
        }
        TorrentUtils.announceGroupsInsertLast(this.torrent.getTorrent(), uRLArray);
        this.updated();
    }

    @Override
    public void insertSetAtFront(URL[] uRLArray) {
        if (this.setAlreadyExists(uRLArray)) {
            return;
        }
        TorrentUtils.announceGroupsInsertFirst(this.torrent.getTorrent(), uRLArray);
        this.updated();
    }

    protected boolean setAlreadyExists(URL[] uRLArray) {
        TOTorrentAnnounceURLGroup tOTorrentAnnounceURLGroup = this.torrent.getTorrent().getAnnounceURLGroup();
        TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray = tOTorrentAnnounceURLGroup.getAnnounceURLSets();
        for (int i = 0; i < tOTorrentAnnounceURLSetArray.length; ++i) {
            URL[] uRLArray2 = tOTorrentAnnounceURLSetArray[i].getAnnounceURLs();
            if (uRLArray2.length != uRLArray.length) continue;
            boolean bl = true;
            for (int j = 0; j < uRLArray.length; ++j) {
                URL uRL = uRLArray[j];
                boolean bl2 = false;
                for (int k = 0; k < uRLArray2.length; ++k) {
                    URL uRL2 = uRLArray2[k];
                    if (!uRL.toString().equals(uRL2.toString())) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    protected void updated() {
        this.torrent.updated();
    }
}

