/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ipfilter;

import java.io.File;
import org.gudy.azureus2.core3.ipfilter.BannedIp;
import org.gudy.azureus2.core3.ipfilter.BlockedIp;
import org.gudy.azureus2.core3.ipfilter.IpFilter;
import org.gudy.azureus2.core3.ipfilter.IpFilterManagerFactory;
import org.gudy.azureus2.core3.ipfilter.IpRange;
import org.gudy.azureus2.plugins.ipfilter.IPBanned;
import org.gudy.azureus2.plugins.ipfilter.IPBlocked;
import org.gudy.azureus2.plugins.ipfilter.IPFilter;
import org.gudy.azureus2.plugins.ipfilter.IPFilterException;
import org.gudy.azureus2.plugins.ipfilter.IPRange;
import org.gudy.azureus2.pluginsimpl.local.ipfilter.IPBannedImpl;
import org.gudy.azureus2.pluginsimpl.local.ipfilter.IPBlockedImpl;
import org.gudy.azureus2.pluginsimpl.local.ipfilter.IPRangeImpl;

public class IPFilterImpl
implements IPFilter {
    protected IpFilter filter = IpFilterManagerFactory.getSingleton().getIPFilter();

    @Override
    public File getFile() {
        return this.filter.getFile();
    }

    @Override
    public void reload() throws IPFilterException {
        try {
            this.filter.reload();
        }
        catch (Throwable throwable) {
            throw new IPFilterException("IPFilter::reload fails", throwable);
        }
    }

    @Override
    public void save() throws IPFilterException {
        try {
            this.filter.save();
        }
        catch (Throwable throwable) {
            throw new IPFilterException("IPFilter::reload fails", throwable);
        }
    }

    @Override
    public IPRange[] getRanges() {
        IpRange[] ipRangeArray = this.filter.getRanges();
        IPRange[] iPRangeArray = new IPRange[ipRangeArray.length];
        for (int i = 0; i < ipRangeArray.length; ++i) {
            iPRangeArray[i] = new IPRangeImpl(this, ipRangeArray[i]);
        }
        return iPRangeArray;
    }

    @Override
    public int getNumberOfRanges() {
        return this.filter.getNbRanges();
    }

    @Override
    public int getNumberOfBlockedIPs() {
        return this.filter.getNbIpsBlocked();
    }

    @Override
    public int getNumberOfBannedIPs() {
        return this.filter.getNbBannedIps();
    }

    @Override
    public boolean isInRange(String string) {
        return this.filter.isInRange(string);
    }

    @Override
    public IPRange createRange(boolean bl) {
        return new IPRangeImpl(this, this.filter.createRange(bl));
    }

    @Override
    public void addRange(IPRange iPRange) {
        if (!(iPRange instanceof IPRangeImpl)) {
            throw new RuntimeException("range must be created by createRange");
        }
        this.filter.addRange(((IPRangeImpl)iPRange).getRange());
    }

    @Override
    public IPRange createAndAddRange(String string, String string2, String string3, boolean bl) {
        IPRange iPRange = this.createRange(bl);
        iPRange.setDescription(string);
        iPRange.setStartIP(string2);
        iPRange.setEndIP(string3);
        iPRange.checkValid();
        if (iPRange.isValid()) {
            this.addRange(iPRange);
            return iPRange;
        }
        return null;
    }

    @Override
    public void removeRange(IPRange iPRange) {
        if (!(iPRange instanceof IPRangeImpl)) {
            throw new RuntimeException("range must be created by createRange");
        }
        this.filter.removeRange(((IPRangeImpl)iPRange).getRange());
    }

    @Override
    public IPBlocked[] getBlockedIPs() {
        BlockedIp[] blockedIpArray = this.filter.getBlockedIps();
        IPBlocked[] iPBlockedArray = new IPBlocked[blockedIpArray.length];
        for (int i = 0; i < blockedIpArray.length; ++i) {
            iPBlockedArray[i] = new IPBlockedImpl(this, blockedIpArray[i]);
        }
        return iPBlockedArray;
    }

    @Override
    public void block(String string) {
        this.filter.ban(string, "<plugin>", false);
    }

    @Override
    public IPBanned[] getBannedIPs() {
        BannedIp[] bannedIpArray = this.filter.getBannedIps();
        IPBanned[] iPBannedArray = new IPBanned[bannedIpArray.length];
        for (int i = 0; i < bannedIpArray.length; ++i) {
            iPBannedArray[i] = new IPBannedImpl(bannedIpArray[i]);
        }
        return iPBannedArray;
    }

    @Override
    public void ban(String string, String string2) {
        this.filter.ban(string, string2, false);
    }

    @Override
    public void unban(String string) {
        this.filter.unban(string);
    }

    @Override
    public boolean isEnabled() {
        return this.filter.isEnabled();
    }

    @Override
    public void setEnabled(boolean bl) {
        this.filter.setEnabled(bl);
    }

    @Override
    public boolean getInRangeAddressesAreAllowed() {
        return this.filter.getInRangeAddressesAreAllowed();
    }

    @Override
    public void setInRangeAddressesAreAllowed(boolean bl) {
        this.filter.setInRangeAddressesAreAllowed(bl);
    }

    @Override
    public void markAsUpToDate() {
        this.filter.markAsUpToDate();
    }

    @Override
    public long getLastUpdateTime() {
        return this.filter.getLastUpdateTime();
    }
}

