/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ipc;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ipc.IPCException;
import org.gudy.azureus2.plugins.ipc.IPCInterface;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;

public class IPCInterfaceImpl
implements IPCInterface {
    private Object target_use_accessor;
    private String plugin_class;
    private PluginInitializer plugin_initializer;

    public IPCInterfaceImpl(PluginInitializer pluginInitializer, Plugin plugin) {
        this.plugin_initializer = pluginInitializer;
        this.target_use_accessor = plugin;
        this.plugin_class = plugin.getClass().getName();
    }

    public IPCInterfaceImpl(Object object) {
        this.target_use_accessor = object;
        this.plugin_class = object.getClass().getName();
    }

    @Override
    public boolean canInvoke(String string, Object[] objectArray) {
        try {
            Object object = this.getTarget();
            Method method = this.getMethod(object, string, objectArray);
            method.setAccessible(true);
            if (method != null) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Override
    public Object invoke(String string, Object[] objectArray) throws IPCException {
        Object object = this.getTarget();
        try {
            Method method = this.getMethod(object, string, objectArray);
            method.setAccessible(true);
            return method.invoke(object, objectArray);
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            if (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
                throwable2 = throwable.getCause();
            }
            throw new IPCException(throwable2);
        }
    }

    protected Method getMethod(Object object, String string, Object[] objectArray) throws Throwable {
        Method method;
        block6: {
            if (objectArray == null) {
                objectArray = new Object[]{};
            }
            Class[] classArray = new Class[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                classArray[i] = objectArray[i] instanceof Boolean ? Boolean.TYPE : (objectArray[i] instanceof Integer ? Integer.TYPE : (objectArray[i] instanceof Long ? Long.TYPE : (objectArray[i] instanceof Float ? Float.TYPE : (objectArray[i] instanceof Double ? Double.TYPE : (objectArray[i] instanceof Byte ? Byte.TYPE : (objectArray[i] instanceof Character ? Character.TYPE : (objectArray[i] instanceof Short ? Short.TYPE : objectArray[i].getClass())))))));
            }
            method = null;
            try {
                method = object.getClass().getDeclaredMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Method[] methodArray = object.getClass().getMethods();
                for (int i = 0; i < methodArray.length; ++i) {
                    Method method2 = methodArray[i];
                    Class<?>[] classArray2 = method2.getParameterTypes();
                    if (!method2.getName().equals(string) || classArray2.length != classArray.length) continue;
                    boolean bl = true;
                    for (int j = 0; j < classArray2.length; ++j) {
                        Class<?> clazz = classArray2[j];
                        Class clazz2 = classArray[j];
                        if (clazz.isAssignableFrom(clazz2)) continue;
                        bl = false;
                        break;
                    }
                    if (!bl) continue;
                    method = method2;
                    break;
                }
                if (method != null) break block6;
                throw noSuchMethodException;
            }
        }
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getTarget() throws IPCException {
        IPCInterfaceImpl iPCInterfaceImpl = this;
        synchronized (iPCInterfaceImpl) {
            if (this.target_use_accessor == null) {
                PluginInterface[] pluginInterfaceArray = this.plugin_initializer.getPlugins();
                for (int i = 0; i < pluginInterfaceArray.length; ++i) {
                    PluginInterface pluginInterface = pluginInterfaceArray[i];
                    if (!pluginInterface.getPlugin().getClass().getName().equals(this.plugin_class)) continue;
                    this.target_use_accessor = pluginInterface.getPlugin();
                    break;
                }
            }
            if (this.target_use_accessor == null) {
                throw new IPCException("Plugin has been unloaded");
            }
            return this.target_use_accessor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload() {
        IPCInterfaceImpl iPCInterfaceImpl = this;
        synchronized (iPCInterfaceImpl) {
            this.target_use_accessor = null;
        }
    }
}

