/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.download;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadActivationEvent;
import org.gudy.azureus2.plugins.download.DownloadActivationListener;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadAttributeListener;
import org.gudy.azureus2.plugins.download.DownloadCompletionListener;
import org.gudy.azureus2.plugins.download.DownloadEventNotifier;
import org.gudy.azureus2.plugins.download.DownloadListener;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadPeerListener;
import org.gudy.azureus2.plugins.download.DownloadPropertyEvent;
import org.gudy.azureus2.plugins.download.DownloadPropertyListener;
import org.gudy.azureus2.plugins.download.DownloadRemovalVetoException;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.plugins.download.DownloadTrackerListener;
import org.gudy.azureus2.plugins.download.DownloadWillBeRemovedListener;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;

public class DownloadEventNotifierImpl
implements DownloadEventNotifier {
    private DownloadActivationNotifier download_activation_notifier;
    private DownloadNotifier download_notifier;
    private DownloadPeerNotifier download_peer_notifier;
    private DownloadPropertyNotifier download_property_notifier;
    private DownloadTrackerNotifier download_tracker_notifier;
    private DownloadTrackerNotifier download_tracker_notifier_instant;
    private DownloadWillBeRemovedNotifier download_will_be_removed_notifier;
    private DownloadCompletionNotifier download_completion_notifier;
    private DownloadManager dm;
    private HashMap read_attribute_listeners;
    private HashMap write_attribute_listeners;

    public DownloadEventNotifierImpl(DownloadManager downloadManager) {
        this.dm = downloadManager;
        this.download_activation_notifier = new DownloadActivationNotifier();
        this.download_notifier = new DownloadNotifier();
        this.download_peer_notifier = new DownloadPeerNotifier();
        this.download_property_notifier = new DownloadPropertyNotifier();
        this.download_tracker_notifier = new DownloadTrackerNotifier(false);
        this.download_tracker_notifier_instant = new DownloadTrackerNotifier(true);
        this.download_will_be_removed_notifier = new DownloadWillBeRemovedNotifier();
        this.download_completion_notifier = new DownloadCompletionNotifier();
        this.read_attribute_listeners = new HashMap();
        this.write_attribute_listeners = new HashMap();
    }

    @Override
    public void addActivationListener(DownloadActivationListener downloadActivationListener) {
        this.download_activation_notifier.addListener(downloadActivationListener);
    }

    @Override
    public void addCompletionListener(DownloadCompletionListener downloadCompletionListener) {
        this.download_completion_notifier.addListener(downloadCompletionListener);
    }

    @Override
    public void addDownloadWillBeRemovedListener(DownloadWillBeRemovedListener downloadWillBeRemovedListener) {
        this.download_will_be_removed_notifier.addListener(downloadWillBeRemovedListener);
    }

    @Override
    public void addListener(DownloadListener downloadListener2) {
        this.download_notifier.addListener(downloadListener2);
    }

    @Override
    public void addPeerListener(DownloadPeerListener downloadPeerListener) {
        this.download_peer_notifier.addListener(downloadPeerListener);
    }

    @Override
    public void addPropertyListener(DownloadPropertyListener downloadPropertyListener) {
        this.download_property_notifier.addListener(downloadPropertyListener);
    }

    @Override
    public void addTrackerListener(DownloadTrackerListener downloadTrackerListener) {
        this.download_tracker_notifier.addListener(downloadTrackerListener);
    }

    @Override
    public void addTrackerListener(DownloadTrackerListener downloadTrackerListener, boolean bl) {
        (bl ? this.download_tracker_notifier_instant : this.download_tracker_notifier).addListener(downloadTrackerListener);
    }

    @Override
    public void removeActivationListener(DownloadActivationListener downloadActivationListener) {
        this.download_activation_notifier.removeListener(downloadActivationListener);
    }

    @Override
    public void removeCompletionListener(DownloadCompletionListener downloadCompletionListener) {
        this.download_completion_notifier.removeListener(downloadCompletionListener);
    }

    @Override
    public void removeDownloadWillBeRemovedListener(DownloadWillBeRemovedListener downloadWillBeRemovedListener) {
        this.download_will_be_removed_notifier.removeListener(downloadWillBeRemovedListener);
    }

    @Override
    public void removeListener(DownloadListener downloadListener2) {
        this.download_notifier.removeListener(downloadListener2);
    }

    @Override
    public void removePeerListener(DownloadPeerListener downloadPeerListener) {
        this.download_peer_notifier.removeListener(downloadPeerListener);
    }

    @Override
    public void removePropertyListener(DownloadPropertyListener downloadPropertyListener) {
        this.download_property_notifier.removeListener(downloadPropertyListener);
    }

    @Override
    public void removeTrackerListener(DownloadTrackerListener downloadTrackerListener) {
        this.download_tracker_notifier.removeListener(downloadTrackerListener);
        this.download_tracker_notifier_instant.removeListener(downloadTrackerListener);
    }

    @Override
    public void addAttributeListener(DownloadAttributeListener downloadAttributeListener, TorrentAttribute torrentAttribute, int n) {
        Map map = this.getAttributeListenerMap(n);
        DownloadAttributeNotifier downloadAttributeNotifier = (DownloadAttributeNotifier)map.get(torrentAttribute);
        if (downloadAttributeNotifier == null) {
            downloadAttributeNotifier = new DownloadAttributeNotifier(torrentAttribute, n);
            map.put(torrentAttribute, downloadAttributeNotifier);
        }
        downloadAttributeNotifier.addListener(downloadAttributeListener);
    }

    @Override
    public void removeAttributeListener(DownloadAttributeListener downloadAttributeListener, TorrentAttribute torrentAttribute, int n) {
        Map map = this.getAttributeListenerMap(n);
        DownloadAttributeNotifier downloadAttributeNotifier = (DownloadAttributeNotifier)map.get(torrentAttribute);
        if (downloadAttributeNotifier == null) {
            return;
        }
        downloadAttributeNotifier.removeListener(downloadAttributeListener);
    }

    private Map getAttributeListenerMap(int n) {
        if (n == 1) {
            return this.write_attribute_listeners;
        }
        if (n == 2) {
            return this.read_attribute_listeners;
        }
        throw new IllegalArgumentException("invalid event type " + n);
    }

    public class DownloadTrackerNotifier
    extends BaseDownloadListener
    implements DownloadTrackerListener {
        private boolean instant_notify;

        public DownloadTrackerNotifier(boolean bl) {
            this.instant_notify = bl;
        }

        @Override
        public void downloadAdded(Download download) {
            download.addTrackerListener(this, this.instant_notify);
        }

        @Override
        public void downloadRemoved(Download download) {
            download.removeTrackerListener(this);
        }

        @Override
        public void scrapeResult(DownloadScrapeResult downloadScrapeResult) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                try {
                    ((DownloadTrackerListener)iterator.next()).scrapeResult(downloadScrapeResult);
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }

        @Override
        public void announceResult(DownloadAnnounceResult downloadAnnounceResult) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                try {
                    ((DownloadTrackerListener)iterator.next()).announceResult(downloadAnnounceResult);
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
    }

    public class DownloadAttributeNotifier
    extends BaseDownloadListener
    implements DownloadAttributeListener {
        private TorrentAttribute ta;
        private int event_type;

        public DownloadAttributeNotifier(TorrentAttribute torrentAttribute, int n) {
            this.ta = torrentAttribute;
            this.event_type = n;
        }

        @Override
        public void downloadAdded(Download download) {
            download.addAttributeListener(this, this.ta, this.event_type);
        }

        @Override
        public void downloadRemoved(Download download) {
            download.removeAttributeListener(this, this.ta, this.event_type);
        }

        @Override
        public void attributeEventOccurred(Download download, TorrentAttribute torrentAttribute, int n) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                try {
                    ((DownloadAttributeListener)iterator.next()).attributeEventOccurred(download, torrentAttribute, n);
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
    }

    public class DownloadWillBeRemovedNotifier
    extends BaseDownloadListener
    implements DownloadWillBeRemovedListener {
        @Override
        public void downloadAdded(Download download) {
            download.addDownloadWillBeRemovedListener(this);
        }

        @Override
        public void downloadRemoved(Download download) {
            download.removeDownloadWillBeRemovedListener(this);
        }

        @Override
        public void downloadWillBeRemoved(Download download) throws DownloadRemovalVetoException {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                try {
                    ((DownloadWillBeRemovedListener)iterator.next()).downloadWillBeRemoved(download);
                }
                catch (DownloadRemovalVetoException downloadRemovalVetoException) {
                    throw downloadRemovalVetoException;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
    }

    public class DownloadPropertyNotifier
    extends BaseDownloadListener
    implements DownloadPropertyListener {
        @Override
        public void downloadAdded(Download download) {
            download.addPropertyListener(this);
        }

        @Override
        public void downloadRemoved(Download download) {
            download.removePropertyListener(this);
        }

        @Override
        public void propertyChanged(Download download, DownloadPropertyEvent downloadPropertyEvent) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                try {
                    ((DownloadPropertyListener)iterator.next()).propertyChanged(download, downloadPropertyEvent);
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
    }

    public class DownloadPeerNotifier
    extends BaseDownloadListener
    implements DownloadPeerListener {
        @Override
        public void downloadAdded(Download download) {
            download.addPeerListener(this);
        }

        @Override
        public void downloadRemoved(Download download) {
            download.removePeerListener(this);
        }

        @Override
        public void peerManagerAdded(Download download, PeerManager peerManager) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                try {
                    ((DownloadPeerListener)iterator.next()).peerManagerAdded(download, peerManager);
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }

        @Override
        public void peerManagerRemoved(Download download, PeerManager peerManager) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                try {
                    ((DownloadPeerListener)iterator.next()).peerManagerRemoved(download, peerManager);
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
    }

    public class DownloadNotifier
    extends BaseDownloadListener
    implements DownloadListener {
        @Override
        public void downloadAdded(Download download) {
            download.addListener(this);
        }

        @Override
        public void downloadRemoved(Download download) {
            download.removeListener(this);
        }

        @Override
        public void stateChanged(Download download, int n, int n2) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                try {
                    ((DownloadListener)iterator.next()).stateChanged(download, n, n2);
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }

        @Override
        public void positionChanged(Download download, int n, int n2) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                try {
                    ((DownloadListener)iterator.next()).positionChanged(download, n, n2);
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
    }

    public class DownloadCompletionNotifier
    extends BaseDownloadListener
    implements DownloadCompletionListener {
        @Override
        public void downloadAdded(Download download) {
            download.addCompletionListener(this);
        }

        @Override
        public void downloadRemoved(Download download) {
            download.removeCompletionListener(this);
        }

        @Override
        public void onCompletion(Download download) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                try {
                    ((DownloadCompletionListener)iterator.next()).onCompletion(download);
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
    }

    public class DownloadActivationNotifier
    extends BaseDownloadListener
    implements DownloadActivationListener {
        @Override
        public void downloadAdded(Download download) {
            download.addActivationListener(this);
        }

        @Override
        public void downloadRemoved(Download download) {
            download.removeActivationListener(this);
        }

        @Override
        public boolean activationRequested(DownloadActivationEvent downloadActivationEvent) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                try {
                    if (!((DownloadActivationListener)iterator.next()).activationRequested(downloadActivationEvent)) continue;
                    return true;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
            return false;
        }
    }

    private abstract class BaseDownloadListener
    implements DownloadManagerListener {
        protected ArrayList listeners = new ArrayList();
        private AEMonitor this_mon = new AEMonitor(this.getClass().getName());

        private BaseDownloadListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addListener(Object object) {
            boolean bl = false;
            try {
                this.this_mon.enter();
                bl = this.listeners.isEmpty();
                ArrayList<Object> arrayList = new ArrayList<Object>(this.listeners);
                arrayList.add(object);
                this.listeners = arrayList;
            }
            finally {
                this.this_mon.exit();
            }
            if (bl) {
                DownloadEventNotifierImpl.this.dm.addListener(this, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeListener(Object object) {
            boolean bl = false;
            try {
                this.this_mon.enter();
                ArrayList arrayList = new ArrayList(this.listeners);
                arrayList.remove(object);
                this.listeners = arrayList;
                bl = this.listeners.isEmpty();
            }
            finally {
                this.this_mon.exit();
            }
            if (bl) {
                DownloadEventNotifierImpl.this.dm.removeListener(this, true);
            }
        }
    }
}

