/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local;

import com.aelitis.azureus.core.AzureusCoreComponent;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.PluginEvent;
import org.gudy.azureus2.plugins.PluginEventListener;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.PluginState;
import org.gudy.azureus2.plugins.PluginView;
import org.gudy.azureus2.plugins.clientid.ClientIDManager;
import org.gudy.azureus2.plugins.ddb.DistributedDatabase;
import org.gudy.azureus2.plugins.dht.mainline.MainlineDHTManager;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.ipc.IPCInterface;
import org.gudy.azureus2.plugins.ipfilter.IPFilter;
import org.gudy.azureus2.plugins.logging.Logger;
import org.gudy.azureus2.plugins.messaging.MessageManager;
import org.gudy.azureus2.plugins.network.ConnectionManager;
import org.gudy.azureus2.plugins.platform.PlatformManager;
import org.gudy.azureus2.plugins.sharing.ShareException;
import org.gudy.azureus2.plugins.sharing.ShareManager;
import org.gudy.azureus2.plugins.torrent.TorrentManager;
import org.gudy.azureus2.plugins.tracker.Tracker;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.config.ConfigSection;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.PluginConfigUIFactory;
import org.gudy.azureus2.plugins.update.UpdateManager;
import org.gudy.azureus2.plugins.utils.ShortCuts;
import org.gudy.azureus2.plugins.utils.Utilities;
import org.gudy.azureus2.pluginsimpl.local.FailedPlugin;
import org.gudy.azureus2.pluginsimpl.local.PluginConfigImpl;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.PluginStateImpl;
import org.gudy.azureus2.pluginsimpl.local.clientid.ClientIDManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.ddb.DDBaseImpl;
import org.gudy.azureus2.pluginsimpl.local.deprecate.PluginDeprecation;
import org.gudy.azureus2.pluginsimpl.local.dht.mainline.MainlineDHTManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.ipc.IPCInterfaceImpl;
import org.gudy.azureus2.pluginsimpl.local.ipfilter.IPFilterImpl;
import org.gudy.azureus2.pluginsimpl.local.logging.LoggerImpl;
import org.gudy.azureus2.pluginsimpl.local.messaging.MessageManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.network.ConnectionManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.UIManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ConfigSectionRepository;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ParameterRepository;
import org.gudy.azureus2.pluginsimpl.local.ui.config.PluginConfigUIFactoryImpl;
import org.gudy.azureus2.pluginsimpl.local.update.UpdateManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.ShortCutsImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.UtilitiesImpl;

public final class PluginInterfaceImpl
implements PluginInterface,
AzureusCoreComponent {
    private static final LogIDs LOGID = LogIDs.PLUGIN;
    private Plugin plugin;
    private PluginInitializer initialiser;
    private Object initialiser_key;
    protected ClassLoader class_loader;
    private CopyOnWriteList<PluginListener> listeners = new CopyOnWriteList();
    private Set<PluginListener> init_complete_fired_set = new HashSet<PluginListener>();
    private CopyOnWriteList<PluginEventListener> event_listeners = new CopyOnWriteList();
    private String key;
    private String pluginConfigKey;
    private Properties props;
    private String pluginDir;
    private PluginConfigImpl config;
    private String plugin_version;
    private Logger logger;
    private IPCInterfaceImpl ipc_interface;
    protected List children = new ArrayList();
    private List configSections = new ArrayList();
    private PluginStateImpl state;
    private String given_plugin_id;
    private String plugin_id_to_use;

    protected PluginInterfaceImpl(Plugin plugin, PluginInitializer pluginInitializer, Object object, ClassLoader classLoader, List<File> list, String string, Properties properties, String string2, String string3, String string4) throws PluginException {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        int n = 0;
        while (!stackTraceElementArray[n].getClassName().equals(PluginInterfaceImpl.class.getName())) {
            ++n;
        }
        String string5 = stackTraceElementArray[n + 1].getClassName();
        if (!string5.equals("org.gudy.azureus2.pluginsimpl.local.PluginInitializer") && !string5.equals("org.gudy.azureus2.pluginsimpl.local.PluginInterfaceImpl")) {
            throw new PluginException("Invalid caller");
        }
        String string6 = this.getClass().getCanonicalName();
        if (!string6.equals("org.gudy.azureus2.pluginsimpl.local.PluginInterfaceImpl")) {
            throw new PluginException("Subclassing not permitted");
        }
        this.plugin = plugin;
        this.initialiser = pluginInitializer;
        this.initialiser_key = object;
        this.class_loader = classLoader;
        this.key = string;
        this.pluginConfigKey = "Plugin." + string;
        this.props = new propertyWrapper(properties);
        this.pluginDir = string2;
        this.config = new PluginConfigImpl(this, this.pluginConfigKey);
        this.given_plugin_id = string3;
        this.plugin_version = string4;
        this.ipc_interface = new IPCInterfaceImpl(this.initialiser, this.plugin);
        this.state = new PluginStateImpl(this, this.initialiser);
        boolean bl = false;
        boolean bl2 = false;
        if (string3.endsWith("_v")) {
            File file;
            if (this.plugin.getClass() == FailedPlugin.class) {
                bl = true;
            } else if (list != null && (file = FileUtil.getJarFileFromClass(this.plugin.getClass())) != null) {
                for (File file2 : list) {
                    if (!file2.equals(file)) continue;
                    bl = true;
                }
            }
            if (!bl) {
                bl2 = true;
            }
        }
        PluginInitializer.setVerified(this, this.plugin, bl, bl2);
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public boolean isOperational() {
        PluginDeprecation.call("isOperational", this.given_plugin_id);
        return this.getPluginState().isOperational();
    }

    public Object getInitializerKey() {
        return this.initialiser_key;
    }

    @Override
    public PluginManager getPluginManager() {
        return this.initialiser.getPluginManager();
    }

    @Override
    public String getApplicationName() {
        return Constants.APP_NAME;
    }

    @Override
    public String getAzureusName() {
        return "Azureus";
    }

    @Override
    public String getAzureusVersion() {
        return "4.5.0.4";
    }

    @Override
    public void addView(PluginView pluginView) {
    }

    @Override
    public void addConfigSection(ConfigSection configSection) {
        ConfigSectionRepository.getInstance().addConfigSection(configSection);
        this.configSections.add(configSection);
    }

    @Override
    public void removeConfigSection(ConfigSection configSection) {
        ConfigSectionRepository.getInstance().removeConfigSection(configSection);
        this.configSections.remove(configSection);
    }

    @Override
    public ConfigSection[] getConfigSections() {
        return this.configSections.toArray(new ConfigSection[0]);
    }

    @Override
    public void openTorrentFile(String string) {
        PluginDeprecation.call("openTorrentFile", this.getPluginID());
        try {
            this.getDownloadManager().addDownload(new File(string));
        }
        catch (DownloadException downloadException) {
            throw new RuntimeException(downloadException);
        }
    }

    @Override
    public void openTorrentURL(String string) {
        PluginDeprecation.call("openTorrentURL", this.getPluginID());
        try {
            this.getDownloadManager().addDownload(new URL(string));
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public void setPluginName(String string) {
        this.props.put("plugin.name", string);
    }

    @Override
    public String getPluginName() {
        String string = null;
        if (this.props != null) {
            string = (String)this.props.get("plugin.name");
        }
        if (string == null) {
            try {
                string = new File(this.pluginDir).getName();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (string == null || string.length() == 0) {
            string = this.plugin.getClass().getName();
        }
        return string;
    }

    public void setPluginVersion(String string) {
        this.props.put("plugin.version", string);
    }

    @Override
    public String getPluginVersion() {
        String string = (String)this.props.get("plugin.version");
        if (string == null) {
            string = this.plugin_version;
        }
        return string;
    }

    @Override
    public String getPluginID() {
        String string = (String)this.props.get("plugin.id");
        if (string != null && string.equals("azupdater")) {
            this.plugin_id_to_use = string;
        }
        if (this.plugin_id_to_use != null) {
            return this.plugin_id_to_use;
        }
        if (string == null) {
            string = this.given_plugin_id;
        }
        if (string == null) {
            string = "<none>";
        }
        this.plugin_id_to_use = string;
        return this.plugin_id_to_use;
    }

    @Override
    public boolean isMandatory() {
        PluginDeprecation.call("isMandatory", this.given_plugin_id);
        return this.getPluginState().isMandatory();
    }

    @Override
    public boolean isBuiltIn() {
        PluginDeprecation.call("isBuiltIn", this.given_plugin_id);
        return this.getPluginState().isBuiltIn();
    }

    @Override
    public Properties getPluginProperties() {
        return this.props;
    }

    @Override
    public String getPluginDirectoryName() {
        return this.pluginDir;
    }

    @Override
    public String getPerUserPluginDirectoryName() {
        String string = this.pluginDir == null ? this.getPluginID() : new File(this.pluginDir).getName();
        String string2 = new File(new File(SystemProperties.getUserPath(), "plugins"), string).getAbsolutePath();
        if (this.pluginDir == null) {
            return string2;
        }
        try {
            if (new File(this.pluginDir).getCanonicalPath().equals(new File(string2).getCanonicalPath())) {
                return this.pluginDir;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string2;
    }

    public void setPluginDirectoryName(String string) {
        this.initialiser_key = new File(string);
        this.pluginDir = string;
    }

    @Override
    public void addConfigUIParameters(Parameter[] parameterArray, String string) {
        ParameterRepository.getInstance().addPlugin(parameterArray, string);
    }

    @Override
    public PluginConfig getPluginconfig() {
        return this.config;
    }

    @Override
    public PluginConfigUIFactory getPluginConfigUIFactory() {
        return new PluginConfigUIFactoryImpl(this.config, this.pluginConfigKey);
    }

    public String getPluginConfigKey() {
        return this.pluginConfigKey;
    }

    @Override
    public Tracker getTracker() {
        return TrackerImpl.getSingleton();
    }

    @Override
    public ShareManager getShareManager() throws ShareException {
        return ShareManagerImpl.getSingleton();
    }

    @Override
    public DownloadManager getDownloadManager() {
        return DownloadManagerImpl.getSingleton(this.initialiser.getAzureusCore());
    }

    @Override
    public MainlineDHTManager getMainlineDHTManager() {
        return new MainlineDHTManagerImpl(this.initialiser.getAzureusCore());
    }

    @Override
    public TorrentManager getTorrentManager() {
        return TorrentManagerImpl.getSingleton().specialise(this);
    }

    @Override
    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = new LoggerImpl(this);
        }
        return this.logger;
    }

    @Override
    public IPFilter getIPFilter() {
        return new IPFilterImpl();
    }

    @Override
    public Utilities getUtilities() {
        return new UtilitiesImpl(this.initialiser.getAzureusCore(), this);
    }

    @Override
    public ShortCuts getShortCuts() {
        return new ShortCutsImpl(this);
    }

    @Override
    public UIManager getUIManager() {
        return new UIManagerImpl(this);
    }

    @Override
    public UpdateManager getUpdateManager() {
        return UpdateManagerImpl.getSingleton(this.initialiser.getAzureusCore());
    }

    protected void unloadSupport() {
        this.ipc_interface.unload();
        UIManagerImpl.unload(this);
    }

    @Override
    public boolean isUnloadable() {
        PluginDeprecation.call("unloadable", this.given_plugin_id);
        return this.getPluginState().isUnloadable();
    }

    @Override
    public void reload() throws PluginException {
        PluginDeprecation.call("reload", this.given_plugin_id);
        this.getPluginState().reload();
    }

    @Override
    public void unload() throws PluginException {
        PluginDeprecation.call("unload", this.given_plugin_id);
        this.getPluginState().unload();
    }

    @Override
    public void uninstall() throws PluginException {
        PluginDeprecation.call("uninstall", this.given_plugin_id);
        this.getPluginState().uninstall();
    }

    @Override
    public boolean isInitialisationThread() {
        return this.initialiser.isInitialisationThread();
    }

    @Override
    public ClientIDManager getClientIDManager() {
        return ClientIDManagerImpl.getSingleton();
    }

    @Override
    public ConnectionManager getConnectionManager() {
        return ConnectionManagerImpl.getSingleton(this.initialiser.getAzureusCore());
    }

    @Override
    public MessageManager getMessageManager() {
        return MessageManagerImpl.getSingleton(this.initialiser.getAzureusCore());
    }

    @Override
    public DistributedDatabase getDistributedDatabase() {
        return DDBaseImpl.getSingleton(this.initialiser.getAzureusCore());
    }

    @Override
    public PlatformManager getPlatformManager() {
        return PlatformManagerFactory.getPlatformManager();
    }

    protected void initialisationComplete() {
        Iterator<PluginListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            try {
                this.fireInitComplete(iterator.next());
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        for (int i = 0; i < this.children.size(); ++i) {
            ((PluginInterfaceImpl)this.children.get(i)).initialisationComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireInitComplete(PluginListener pluginListener) {
        Set<PluginListener> set = this.init_complete_fired_set;
        synchronized (set) {
            if (this.init_complete_fired_set.contains(pluginListener)) {
                return;
            }
            this.init_complete_fired_set.add(pluginListener);
        }
        try {
            pluginListener.initializationComplete();
        }
        catch (Exception exception) {
            Debug.out(exception);
        }
    }

    protected void closedownInitiated() {
        Iterator<PluginListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            try {
                iterator.next().closedownInitiated();
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        for (int i = 0; i < this.children.size(); ++i) {
            ((PluginInterfaceImpl)this.children.get(i)).closedownInitiated();
        }
    }

    protected void closedownComplete() {
        Iterator<PluginListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            try {
                iterator.next().closedownComplete();
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        for (int i = 0; i < this.children.size(); ++i) {
            ((PluginInterfaceImpl)this.children.get(i)).closedownComplete();
        }
    }

    @Override
    public ClassLoader getPluginClassLoader() {
        return this.class_loader;
    }

    @Override
    public PluginInterface getLocalPluginInterface(Class clazz, String string) throws PluginException {
        try {
            Plugin plugin = (Plugin)clazz.newInstance();
            Properties properties = new Properties(this.props);
            properties.remove("plugin.id");
            if (string.endsWith("_v")) {
                throw new Exception("Verified plugins must be loaded from a jar");
            }
            PluginInterfaceImpl pluginInterfaceImpl = new PluginInterfaceImpl(plugin, this.initialiser, this.initialiser_key, this.class_loader, null, this.key + "." + string, properties, this.pluginDir, this.getPluginID() + "." + string, this.plugin_version);
            this.initialiser.fireCreated(pluginInterfaceImpl);
            plugin.initialize(pluginInterfaceImpl);
            this.children.add(pluginInterfaceImpl);
            return pluginInterfaceImpl;
        }
        catch (Throwable throwable) {
            if (throwable instanceof PluginException) {
                throw (PluginException)throwable;
            }
            throw new PluginException("Local initialisation fails", throwable);
        }
    }

    @Override
    public IPCInterface getIPC() {
        return this.ipc_interface;
    }

    @Override
    public boolean isShared() {
        PluginDeprecation.call("isShared", this.given_plugin_id);
        return this.getPluginState().isShared();
    }

    void setAsFailed() {
        this.getPluginState().setDisabled(true);
        this.state.failed = true;
    }

    protected void destroy() {
        this.class_loader = null;
        this.plugin = new FailedPlugin("Plugin '" + this.getPluginID() + "' has been unloaded!", null);
    }

    @Override
    public void addListener(PluginListener pluginListener) {
        this.listeners.add(pluginListener);
        if (this.initialiser.isInitialisationComplete()) {
            this.fireInitComplete(pluginListener);
        }
    }

    @Override
    public void removeListener(final PluginListener pluginListener) {
        this.listeners.remove(pluginListener);
        new DelayedEvent("PIL:clear", 10000L, new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runSupport() {
                Set set = PluginInterfaceImpl.this.init_complete_fired_set;
                synchronized (set) {
                    PluginInterfaceImpl.this.init_complete_fired_set.remove(pluginListener);
                }
            }
        });
    }

    @Override
    public void addEventListener(final PluginEventListener pluginEventListener) {
        this.initialiser.runPEVTask(new AERunnable(){

            @Override
            public void runSupport() {
                List<PluginEvent> list = PluginInterfaceImpl.this.initialiser.getPEVHistory();
                for (PluginEvent pluginEvent : list) {
                    try {
                        pluginEventListener.handleEvent(pluginEvent);
                    }
                    catch (Throwable throwable) {
                        Debug.out(throwable);
                    }
                }
                PluginInterfaceImpl.this.event_listeners.add(pluginEventListener);
            }
        });
    }

    @Override
    public void removeEventListener(final PluginEventListener pluginEventListener) {
        this.initialiser.runPEVTask(new AERunnable(){

            @Override
            public void runSupport() {
                PluginInterfaceImpl.this.event_listeners.remove(pluginEventListener);
            }
        });
    }

    @Override
    public void firePluginEvent(final PluginEvent pluginEvent) {
        this.initialiser.runPEVTask(new AERunnable(){

            @Override
            public void runSupport() {
                PluginInterfaceImpl.this.firePluginEventSupport(pluginEvent);
            }
        });
    }

    protected void firePluginEventSupport(PluginEvent pluginEvent) {
        Iterator<PluginEventListener> iterator = this.event_listeners.iterator();
        while (iterator.hasNext()) {
            try {
                PluginEventListener pluginEventListener = iterator.next();
                pluginEventListener.handleEvent(pluginEvent);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        for (int i = 0; i < this.children.size(); ++i) {
            ((PluginInterfaceImpl)this.children.get(i)).firePluginEvent(pluginEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateEvidence(IndentWriter indentWriter) {
        indentWriter.println(this.getPluginName());
        try {
            indentWriter.indent();
            indentWriter.println("id:" + this.getPluginID() + ",version:" + this.getPluginVersion());
            String string = FileUtil.getUserFile("plugins").toString();
            String string2 = FileUtil.getApplicationFile("plugins").toString();
            String string3 = this.getPluginDirectoryName();
            String string4 = string3.startsWith(string2) ? "shared" : (string3.startsWith(string) ? "per-user" : "built-in");
            indentWriter.println("type:" + string4 + ",enabled:" + !this.getPluginState().isDisabled() + ",operational:" + this.getPluginState().isOperational());
        }
        finally {
            indentWriter.exdent();
        }
    }

    @Override
    public boolean isDisabled() {
        PluginDeprecation.call("isDisabled", this.given_plugin_id);
        return this.getPluginState().isDisabled();
    }

    @Override
    public void setDisabled(boolean bl) {
        PluginDeprecation.call("setDisabled", this.given_plugin_id);
        this.getPluginState().setDisabled(bl);
    }

    @Override
    public PluginState getPluginState() {
        return this.state;
    }

    PluginStateImpl getPluginStateImpl() {
        return this.state;
    }

    protected class propertyWrapper
    extends Properties {
        protected boolean initialising = true;

        protected propertyWrapper(Properties properties) {
            for (Object object : properties.keySet()) {
                this.put(object, properties.get(object));
            }
            this.initialising = false;
        }

        @Override
        public Object setProperty(String string, String string2) {
            if (!PluginInterfaceImpl.this.plugin.getClass().getName().startsWith("org.gudy") && !PluginInterfaceImpl.this.plugin.getClass().getName().startsWith("com.aelitis.") && (string.equalsIgnoreCase("plugin.id") || string.equalsIgnoreCase("plugin.version"))) {
                if (org.gudy.azureus2.core3.logging.Logger.isEnabled()) {
                    org.gudy.azureus2.core3.logging.Logger.log(new LogEvent(LOGID, 1, "Plugin '" + PluginInterfaceImpl.this.getPluginName() + "' tried to set property '" + string + "' - action ignored"));
                }
                return null;
            }
            return super.setProperty(string, string2);
        }

        @Override
        public Object put(Object object, Object object2) {
            String string;
            if (!PluginInterfaceImpl.this.plugin.getClass().getName().startsWith("org.gudy") && !PluginInterfaceImpl.this.plugin.getClass().getName().startsWith("com.aelitis.") && !this.initialising && object instanceof String && ((string = (String)object).equalsIgnoreCase("plugin.id") || string.equalsIgnoreCase("plugin.version"))) {
                if (org.gudy.azureus2.core3.logging.Logger.isEnabled()) {
                    org.gudy.azureus2.core3.logging.Logger.log(new LogEvent(LOGID, 1, "Plugin '" + PluginInterfaceImpl.this.getPluginName() + "' tried to set property '" + string + "' - action ignored"));
                }
                return null;
            }
            return super.put(object, object2);
        }

        @Override
        public Object get(Object object) {
            return super.get(object);
        }
    }
}

