/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.plugins.download.savelocation;

import java.io.File;

public class SaveLocationChange {
    public File download_location = null;
    public String download_name = null;
    public File torrent_location = null;
    public String torrent_name = null;

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer("SaveLocationChange: ");
        stringBuffer.append("DL-LOC=");
        stringBuffer.append(this.download_location);
        stringBuffer.append(", DL-NAME=");
        stringBuffer.append(this.download_name);
        stringBuffer.append(", TOR-LOC=");
        stringBuffer.append(this.torrent_location);
        stringBuffer.append(", TOR-NAME=");
        stringBuffer.append(this.torrent_name);
        return stringBuffer.toString();
    }

    public final File normaliseTorrentLocation(File file) {
        return this.normaliseTorrentLocation(file.getParentFile(), file.getName());
    }

    public final File normaliseTorrentLocation(File file, String string) {
        return new File(this.torrent_location != null ? this.torrent_location : file, this.torrent_name != null ? this.torrent_name : string);
    }

    public final File normaliseDownloadLocation(File file) {
        return this.normaliseDownloadLocation(file.getParentFile(), file.getName());
    }

    public final File normaliseDownloadLocation(File file, String string) {
        return new File(this.download_location != null ? this.download_location : file, this.download_name != null ? this.download_name : string);
    }

    public final boolean hasDownloadChange() {
        return this.download_location != null || this.download_name != null;
    }

    public final boolean hasTorrentChange() {
        return this.torrent_location != null || this.torrent_name != null;
    }

    public final boolean isDifferentDownloadLocation(File file) {
        if (!this.hasDownloadChange()) {
            return false;
        }
        return !file.equals(this.normaliseDownloadLocation(file));
    }

    public final boolean isDifferentTorrentLocation(File file) {
        if (!this.hasTorrentChange()) {
            return false;
        }
        return !file.equals(this.normaliseTorrentLocation(file));
    }
}

