/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util.jar;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.security.SEKeyDetails;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.jar.AEJarSigner2;

public class AEJarBuilder {
    public static long buildFromPackages(OutputStream outputStream, ClassLoader classLoader, String[] stringArray, Map map, String string) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            List list = (List)map.get(stringArray[i]);
            if (list == null) {
                Debug.out("package '" + stringArray[i] + "' missing");
                continue;
            }
            for (int j = 0; j < list.size(); ++j) {
                arrayList.add(stringArray[i] + "/" + list.get(j));
            }
        }
        String[] stringArray2 = new String[arrayList.size()];
        arrayList.toArray(stringArray2);
        return AEJarBuilder.buildFromResources2(outputStream, classLoader, null, stringArray2, string);
    }

    public static void buildFromResources(OutputStream outputStream, ClassLoader classLoader, String string, String[] stringArray, String string2) throws IOException {
        AEJarBuilder.buildFromResources2(outputStream, classLoader, string, stringArray, string2);
    }

    private static long buildFromResources2(OutputStream outputStream, ClassLoader classLoader, String string, String[] stringArray, String string2) throws IOException {
        if (string2 != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(65536);
            long l = AEJarBuilder.buildFromResourcesSupport(new JarOutputStream(byteArrayOutputStream), classLoader, string, stringArray);
            try {
                SEKeyDetails sEKeyDetails = SESecurityManager.getKeyDetails(string2);
                if (sEKeyDetails == null) {
                    Logger.log(new LogAlert(false, 3, "Certificate alias '" + string2 + "' not found, jar signing fails"));
                    throw new Exception("Certificate alias '" + string2 + "' not found ");
                }
                AEJarSigner2 aEJarSigner2 = new AEJarSigner2(string2, SESecurityManager.getKeystoreName(), SESecurityManager.getKeystorePassword());
                aEJarSigner2.signJarStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), outputStream);
                return l;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
                throw new IOException(throwable.getMessage());
            }
        }
        JarOutputStream jarOutputStream = outputStream instanceof JarOutputStream ? (JarOutputStream)outputStream : new JarOutputStream(outputStream);
        return AEJarBuilder.buildFromResourcesSupport(jarOutputStream, classLoader, string, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long buildFromResourcesSupport(JarOutputStream jarOutputStream, ClassLoader classLoader, String string, String[] stringArray) throws IOException {
        Object object;
        long l = 0L;
        long l2 = SystemTime.getCurrentTime();
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            if (string != null) {
                object = string + "/" + (String)object;
            }
            try (InputStream inputStream = null;){
                Object object2;
                inputStream = classLoader.getResourceAsStream((String)object);
                if (inputStream == null) {
                    Debug.out("WUJarBuilder: failed to find resource '" + (String)object + "'");
                    continue;
                }
                URL uRL = classLoader.getResource((String)object);
                try {
                    object2 = null;
                    if (uRL != null) {
                        String string2 = uRL.toString();
                        if (string2.startsWith("jar:file:")) {
                            object2 = FileUtil.getJarFileFromURL(string2);
                        } else if (string2.startsWith("file:")) {
                            object2 = new File(URI.create(string2));
                        }
                    }
                    if (object2 == null) {
                        l = l2;
                    } else {
                        long l3 = ((File)object2).lastModified();
                        if (l3 > l) {
                            l = l3;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
                object2 = new JarEntry((String)object);
                AEJarBuilder.writeEntry(jarOutputStream, (JarEntry)object2, inputStream);
                continue;
            }
        }
        JarEntry jarEntry = new JarEntry("META-INF/MANIFEST.MF");
        object = new ByteArrayInputStream("Manifest-Version: 1.0\r\n\r\n".getBytes());
        AEJarBuilder.writeEntry(jarOutputStream, jarEntry, (InputStream)object);
        jarOutputStream.flush();
        jarOutputStream.finish();
        return l;
    }

    private static void writeEntry(JarOutputStream jarOutputStream, JarEntry jarEntry, InputStream inputStream) throws IOException {
        jarOutputStream.putNextEntry(jarEntry);
        byte[] byArray = new byte[4096];
        int n = inputStream.read(byArray);
        while (n != -1) {
            jarOutputStream.write(byArray, 0, n);
            n = inputStream.read(byArray);
        }
    }
}

