/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import org.gudy.azureus2.core3.util.DebugLight;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.Timer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class TimerEventPeriodic
implements TimerEventPerformer {
    private Timer timer;
    private long frequency;
    private boolean absolute;
    private TimerEventPerformer performer;
    private String name;
    private TimerEvent current_event;
    private boolean cancelled;

    protected TimerEventPeriodic(Timer timer, long l, boolean bl, TimerEventPerformer timerEventPerformer) {
        this.timer = timer;
        this.frequency = l;
        this.absolute = bl;
        this.performer = timerEventPerformer;
        long l2 = SystemTime.getCurrentTime();
        this.current_event = this.timer.addEvent(this.name, l2, l2 + this.frequency, this.absolute, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String string) {
        this.name = string;
        TimerEventPeriodic timerEventPeriodic = this;
        synchronized (timerEventPeriodic) {
            if (this.current_event != null) {
                this.current_event.setName(this.name);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    protected TimerEventPerformer getPerformer() {
        return this.performer;
    }

    public long getFrequency() {
        return this.frequency;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform(TimerEvent timerEvent2) {
        if (!this.cancelled) {
            try {
                this.performer.perform(timerEvent2);
            }
            catch (Throwable throwable) {
                DebugLight.printStackTrace(throwable);
            }
            TimerEventPeriodic timerEventPeriodic = this;
            synchronized (timerEventPeriodic) {
                if (!this.cancelled) {
                    long l = SystemTime.getCurrentTime();
                    this.current_event = this.timer.addEvent(this.name, l, l + this.frequency, this.absolute, this);
                }
            }
        }
    }

    public synchronized void cancel() {
        if (this.current_event != null) {
            this.current_event.cancel();
            this.cancelled = true;
        }
    }

    protected String getString() {
        TimerEvent timerEvent2 = this.current_event;
        String string = timerEvent2 == null ? "?" : "when=" + timerEvent2.getWhen() + ",run=" + timerEvent2.hasRun() + ", can=" + timerEvent2.isCancelled();
        return string + ",freq=" + this.getFrequency() + ",target=" + this.getPerformer() + (this.name == null ? "" : ",name=" + this.name);
    }
}

