/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import com.aelitis.azureus.core.util.Java15Utils;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DebugLight;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.ThreadPoolTask;
import org.gudy.azureus2.core3.util.TimeFormatter;

public class ThreadPool {
    private static final boolean LOG_WARNINGS = false;
    private static final int WARN_TIME = 10000;
    private static List busy_pools = new ArrayList();
    private static boolean busy_pool_timer_set = false;
    private static boolean debug_thread_pool;
    private static boolean debug_thread_pool_log_on;
    private static ThreadLocal tls;
    private String name;
    private int max_size;
    private int thread_name_index = 1;
    private long execution_limit;
    private List busy;
    private boolean queue_when_full;
    private List task_queue = new ArrayList();
    AESemaphore thread_sem;
    private int thread_priority = 5;
    private boolean warn_when_full;
    private long task_total;
    private long task_total_last;
    private Average task_average = Average.getInstance(10000, 120);
    private boolean log_cpu = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void checkAllTimeouts() {
        ArrayList arrayList;
        List list = busy_pools;
        synchronized (list) {
            arrayList = new ArrayList(busy_pools);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            ((ThreadPool)arrayList.get(i)).checkTimeouts();
        }
    }

    public ThreadPool(String string, int n) {
        this(string, n, false);
    }

    public ThreadPool(String string, int n, boolean bl) {
        this.name = string;
        this.max_size = n;
        this.queue_when_full = bl;
        this.thread_sem = new AESemaphore("ThreadPool::" + this.name, n);
        this.busy = new ArrayList(n);
    }

    private void generateEvidence(IndentWriter indentWriter) {
        indentWriter.println(this.name + ": max=" + this.max_size + ",qwf=" + this.queue_when_full + ",queue=" + this.task_queue.size() + ",busy=" + this.busy.size() + ",total=" + this.task_total + ":" + DisplayFormatters.formatDecimal(this.task_average.getDoubleAverage(), 2) + "/sec");
    }

    public void setWarnWhenFull() {
        this.warn_when_full = true;
    }

    public void setLogCPU() {
        this.log_cpu = true;
    }

    public int getMaxThreads() {
        return this.max_size;
    }

    public void setThreadPriority(int n) {
        this.thread_priority = n;
    }

    public void setExecutionLimit(long l) {
        this.execution_limit = l;
    }

    public threadPoolWorker run(AERunnable aERunnable) {
        return this.run(aERunnable, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public threadPoolWorker run(AERunnable aERunnable, boolean bl, boolean bl2) {
        threadPoolWorker threadPoolWorker2;
        if (bl2 && !(aERunnable instanceof ThreadPoolTask)) {
            throw new IllegalArgumentException("manual release only allowed for ThreadPoolTasks");
        }
        if (bl2) {
            ((ThreadPoolTask)aERunnable).manualRelease = 1;
        }
        if (!this.queue_when_full && !this.thread_sem.reserveIfAvailable()) {
            threadPoolWorker2 = (threadPoolWorker)tls.get();
            if (threadPoolWorker2 == null || threadPoolWorker2.getOwner() != this) {
                this.checkWarning();
                this.thread_sem.reserve();
            } else {
                if (aERunnable instanceof ThreadPoolTask) {
                    ThreadPoolTask threadPoolTask = (ThreadPoolTask)aERunnable;
                    threadPoolTask.worker = threadPoolWorker2;
                    try {
                        threadPoolTask.taskStarted();
                        this.runIt(aERunnable);
                        threadPoolTask.join();
                    }
                    finally {
                        threadPoolTask.taskCompleted();
                    }
                } else {
                    this.runIt(aERunnable);
                }
                return threadPoolWorker2;
            }
        }
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            if (bl) {
                this.task_queue.add(0, aERunnable);
            } else {
                this.task_queue.add(aERunnable);
            }
            if (this.queue_when_full && !this.thread_sem.reserveIfAvailable()) {
                threadPoolWorker2 = null;
                this.checkWarning();
            } else {
                threadPoolWorker2 = new threadPoolWorker();
            }
        }
        return threadPoolWorker2;
    }

    protected void runIt(AERunnable aERunnable) {
        if (this.log_cpu) {
            long l = this.log_cpu ? Java15Utils.getThreadCPUTime() : 0L;
            long l2 = SystemTime.getHighPrecisionCounter();
            aERunnable.run();
            if (l > 0L) {
                long l3 = this.log_cpu ? Java15Utils.getThreadCPUTime() : 0L;
                long l4 = (l3 - l) / 1000000L;
                long l5 = SystemTime.getHighPrecisionCounter();
                long l6 = (l5 - l2) / 1000000L;
                if (l4 > 10L || l6 > 10L) {
                    System.out.println(TimeFormatter.milliStamp() + ": Thread: " + Thread.currentThread().getName() + ": " + aERunnable + " -> " + l4 + "/" + l6);
                }
            }
        } else {
            aERunnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkWarning() {
        if (this.warn_when_full) {
            String string = "";
            try {
                ThreadPool threadPool = this;
                synchronized (threadPool) {
                    for (int i = 0; i < this.busy.size(); ++i) {
                        threadPoolWorker threadPoolWorker2 = (threadPoolWorker)this.busy.get(i);
                        AERunnable aERunnable = threadPoolWorker2.runnable;
                        if (threadPoolWorker2 == null) continue;
                        String string2 = aERunnable instanceof ThreadPoolTask ? ((ThreadPoolTask)aERunnable).getName() : threadPoolWorker2.getClass().getName();
                        string = string + (string.length() == 0 ? "" : ",") + string2;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Debug.out("Thread pool '" + this.getName() + "' is full (busy=" + string + ")");
            this.warn_when_full = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AERunnable[] getQueuedTasks() {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            AERunnable[] aERunnableArray = new AERunnable[this.task_queue.size()];
            this.task_queue.toArray(aERunnableArray);
            return aERunnableArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueueSize() {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            return this.task_queue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isQueued(AERunnable aERunnable) {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            return this.task_queue.contains(aERunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AERunnable[] getRunningTasks() {
        ArrayList<AERunnable> arrayList = new ArrayList<AERunnable>();
        AERunnable[] aERunnableArray = this;
        synchronized (this) {
            for (threadPoolWorker threadPoolWorker2 : this.busy) {
                AERunnable aERunnable = threadPoolWorker2.getRunnable();
                if (aERunnable == null) continue;
                arrayList.add(aERunnable);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            aERunnableArray = new AERunnable[arrayList.size()];
            arrayList.toArray(aERunnableArray);
            return aERunnableArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRunningCount() {
        int n = 0;
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            for (threadPoolWorker threadPoolWorker2 : this.busy) {
                AERunnable aERunnable = threadPoolWorker2.getRunnable();
                if (aERunnable == null) continue;
                ++n;
            }
        }
        return n;
    }

    public boolean isFull() {
        return this.thread_sem.getValue() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkTimeouts() {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            long l = this.task_total - this.task_total_last;
            this.task_average.addValue(l);
            this.task_total_last = this.task_total;
            if (debug_thread_pool_log_on) {
                System.out.println("ThreadPool '" + this.getName() + "'/" + this.thread_name_index + ": max=" + this.max_size + ",sem=[" + this.thread_sem.getString() + "],busy=" + this.busy.size() + ",queue=" + this.task_queue.size());
            }
            long l2 = SystemTime.getCurrentTime();
            for (int i = 0; i < this.busy.size(); ++i) {
                AERunnable aERunnable;
                threadPoolWorker threadPoolWorker2 = (threadPoolWorker)this.busy.get(i);
                long l3 = l2 - threadPoolWorker2.run_start_time;
                if (l3 <= (long)(10000 * (threadPoolWorker2.warn_count + 1))) continue;
                threadPoolWorker2.warn_count++;
                if (this.execution_limit <= 0L || l3 <= this.execution_limit || (aERunnable = threadPoolWorker2.runnable) == null) continue;
                try {
                    if (aERunnable instanceof ThreadPoolTask) {
                        ((ThreadPoolTask)aERunnable).interruptTask();
                        continue;
                    }
                    threadPoolWorker2.interrupt();
                    continue;
                }
                catch (Throwable throwable) {
                    DebugLight.printStackTrace(throwable);
                }
            }
        }
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseManual(ThreadPoolTask threadPoolTask) {
        if (!this.busy.contains(threadPoolTask.worker) || threadPoolTask.manualRelease != 2) {
            throw new IllegalStateException("task already released or not manually releasable");
        }
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            long l = SystemTime.getCurrentTime() - threadPoolTask.worker.run_start_time;
            if (l > 10000L) {
                // empty if block
            }
            this.busy.remove(threadPoolTask.worker);
            if (this.busy.size() == 0 && !debug_thread_pool) {
                List list = busy_pools;
                synchronized (list) {
                    busy_pools.remove(this);
                }
            }
            if (this.busy.size() == 0) {
                this.thread_sem.release();
            } else {
                new threadPoolWorker();
            }
        }
    }

    public void registerThreadAsChild(threadPoolWorker threadPoolWorker2) {
        if (tls.get() != null && tls.get() != threadPoolWorker2) {
            throw new IllegalStateException("another parent is already set for this thread");
        }
        tls.set(threadPoolWorker2);
    }

    public void deregisterThreadAsChild(threadPoolWorker threadPoolWorker2) {
        if (tls.get() != threadPoolWorker2) {
            throw new IllegalStateException("tls is not set to parent");
        }
        tls.set(null);
    }

    static /* synthetic */ ThreadLocal access$900() {
        return tls;
    }

    static /* synthetic */ List access$1000(ThreadPool threadPool) {
        return threadPool.task_queue;
    }

    static /* synthetic */ List access$1100(ThreadPool threadPool) {
        return threadPool.busy;
    }

    static /* synthetic */ long access$1208(ThreadPool threadPool) {
        return threadPool.task_total++;
    }

    static /* synthetic */ boolean access$1300() {
        return busy_pool_timer_set;
    }

    static /* synthetic */ boolean access$1302(boolean bl) {
        busy_pool_timer_set = bl;
        return busy_pool_timer_set;
    }

    static /* synthetic */ boolean access$1400() {
        return debug_thread_pool;
    }

    static {
        if (System.getProperty("transitory.startup", "0").equals("0")) {
            AEDiagnostics.addEvidenceGenerator(new AEDiagnosticsEvidenceGenerator(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void generate(IndentWriter indentWriter) {
                    indentWriter.println("Thread Pools");
                    try {
                        ArrayList arrayList;
                        indentWriter.indent();
                        List list = busy_pools;
                        synchronized (list) {
                            arrayList = new ArrayList(busy_pools);
                        }
                        for (int i = 0; i < arrayList.size(); ++i) {
                            ((ThreadPool)arrayList.get(i)).generateEvidence(indentWriter);
                        }
                    }
                    finally {
                        indentWriter.exdent();
                    }
                }
            });
        }
        tls = new ThreadLocal(){

            public Object initialValue() {
                return null;
            }
        };
    }

    class threadPoolWorker
    extends AEThread2 {
        private final String worker_name;
        private volatile AERunnable runnable;
        private long run_start_time;
        private int warn_count;
        private String state;

        protected threadPoolWorker() {
            super(ThreadPool.this.name + "[" + ThreadPool.this.thread_name_index++ + "]", true);
            this.state = "<none>";
            this.setPriority(ThreadPool.this.thread_priority);
            this.worker_name = ThreadPool.this.name + "[" + ThreadPool.this.thread_name_index++ + "]";
            this.start();
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void setState(String string) {
            this.state = string;
        }

        public String getState() {
            return this.state;
        }

        protected String getWorkerName() {
            return this.worker_name;
        }

        protected ThreadPool getOwner() {
            return ThreadPool.this;
        }

        protected AERunnable getRunnable() {
            return this.runnable;
        }

        static /* synthetic */ String access$500(threadPoolWorker threadPoolWorker2) {
            return threadPoolWorker2.state;
        }
    }
}

