/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.io.PrintWriter;

public class IndentWriter {
    private static final String INDENT_STRING = "    ";
    private static final String INDENT_STRING_HTML = "&nbsp;&nbsp;&nbsp;&nbsp;";
    private PrintWriter pw;
    private String indent = "";
    private boolean html;
    private boolean force;

    public IndentWriter(PrintWriter printWriter) {
        this.pw = printWriter;
    }

    public void setHTML(boolean bl) {
        this.html = bl;
    }

    public void println(String string) {
        if (this.html) {
            this.pw.print(this.indent + string + "<br>");
        } else {
            this.pw.println(this.indent + string);
        }
        if (this.force) {
            this.pw.flush();
        }
    }

    public void indent() {
        this.indent = this.indent + (this.html ? INDENT_STRING_HTML : INDENT_STRING);
    }

    public void exdent() {
        if (this.indent.length() > 0) {
            this.indent = this.indent.substring((this.html ? INDENT_STRING_HTML : INDENT_STRING).length());
        }
    }

    public String getTab() {
        return this.html ? INDENT_STRING_HTML : INDENT_STRING;
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }

    public void close() {
        this.pw.close();
    }
}

