/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class BrokenMd5Hasher {
    private ByteBuffer buffer = ByteBuffer.allocate(64).order(ByteOrder.LITTLE_ENDIAN);
    private int stateA = 1732584193;
    private int stateB = -271733879;
    private int stateC = -1732584194;
    private int stateD = 271733878;
    private long count = 0L;

    public byte[] calculateHash(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        this.reset();
        this.update(byteBuffer);
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(16);
        this.finalDigest(byteBuffer2);
        byte[] byArray2 = new byte[16];
        byteBuffer2.position(0);
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = byteBuffer2.get();
        }
        return byArray2;
    }

    public void reset() {
        this.stateA = 1732584193;
        this.stateB = -271733879;
        this.stateC = -1732584194;
        this.stateD = 271733878;
        this.count = 0L;
        this.buffer.rewind();
        for (int i = 0; i < 64; ++i) {
            this.buffer.put((byte)0);
        }
        this.buffer.rewind();
    }

    public void update(ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining();
        int n2 = (int)this.count & 0x3F;
        this.count += (long)n;
        int n3 = 64 - n2;
        int n4 = 0;
        if (n >= n3) {
            if (n2 > 0) {
                int n5 = byteBuffer.limit();
                byteBuffer.limit(byteBuffer.position() + n3);
                this.buffer.put(byteBuffer);
                this.buffer.rewind();
                byteBuffer.limit(n5);
                this.transform(this.buffer);
                this.buffer.rewind();
                n4 = n3;
                n2 = n3;
            }
            while (n4 + 63 < n) {
                this.transform(byteBuffer);
                n4 += 64;
            }
        }
        if (n4 < n) {
            this.buffer.put(byteBuffer);
        }
    }

    public void update(byte[] byArray) {
        this.update(ByteBuffer.wrap(byArray));
    }

    public byte[] getDigest() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(16);
        this.finalDigest(byteBuffer);
        byte[] byArray = new byte[16];
        byteBuffer.position(0);
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = byteBuffer.get();
        }
        return byArray;
    }

    public void finalDigest(ByteBuffer byteBuffer) {
        int n = (int)this.count & 0x3F;
        if (n < 56) {
            this.buffer.put((byte)-128);
            for (int i = n; i < 55; ++i) {
                this.buffer.put((byte)0);
            }
            this.buffer.putLong(this.count << 3);
            this.buffer.rewind();
            this.transform(this.buffer);
            this.buffer.rewind();
        } else {
            int n2;
            this.buffer.put((byte)-128);
            for (n2 = n; n2 < 63; ++n2) {
                this.buffer.put((byte)0);
            }
            this.buffer.rewind();
            this.transform(this.buffer);
            this.buffer.rewind();
            for (n2 = 0; n2 < 56; ++n2) {
                this.buffer.put((byte)0);
            }
            this.buffer.putLong(this.count << 3);
            this.buffer.rewind();
            this.transform(this.buffer);
            this.buffer.rewind();
        }
        byteBuffer.putInt(this.stateA);
        byteBuffer.putInt(this.stateB);
        byteBuffer.putInt(this.stateC);
        byteBuffer.putInt(this.stateD);
        this.reset();
    }

    private void transform(ByteBuffer byteBuffer) {
        int n = this.stateA;
        int n2 = this.stateB;
        int n3 = this.stateC;
        int n4 = this.stateD;
        long l = byteBuffer.getLong();
        long l2 = byteBuffer.getLong();
        long l3 = byteBuffer.getLong();
        long l4 = byteBuffer.getLong();
        long l5 = byteBuffer.getLong();
        long l6 = byteBuffer.getLong();
        long l7 = byteBuffer.getLong();
        long l8 = byteBuffer.getLong();
        n = BrokenMd5Hasher.FF(n, n2, n3, n4, (int)l, 7, -680876936);
        n4 = BrokenMd5Hasher.FF(n4, n, n2, n3, (int)(l >>> 32), 12, -389564586);
        n3 = BrokenMd5Hasher.FF(n3, n4, n, n2, (int)l2, 17, 606105819);
        n2 = BrokenMd5Hasher.FF(n2, n3, n4, n, (int)(l2 >>> 32), 22, -1044525330);
        n = BrokenMd5Hasher.FF(n, n2, n3, n4, (int)l3, 7, -176418897);
        n4 = BrokenMd5Hasher.FF(n4, n, n2, n3, (int)(l3 >>> 32), 12, 1200080426);
        n3 = BrokenMd5Hasher.FF(n3, n4, n, n2, (int)l4, 17, -1473231341);
        n2 = BrokenMd5Hasher.FF(n2, n3, n4, n, (int)(l4 >>> 32), 22, -45705983);
        n = BrokenMd5Hasher.FF(n, n2, n3, n4, (int)l5, 7, 1770035416);
        n4 = BrokenMd5Hasher.FF(n4, n, n2, n3, (int)(l5 >>> 32), 12, -1958414417);
        n3 = BrokenMd5Hasher.FF(n3, n4, n, n2, (int)l6, 17, -42063);
        n2 = BrokenMd5Hasher.FF(n2, n3, n4, n, (int)(l6 >>> 32), 22, -1990404162);
        n = BrokenMd5Hasher.FF(n, n2, n3, n4, (int)l7, 7, 1804603682);
        n4 = BrokenMd5Hasher.FF(n4, n, n2, n3, (int)(l7 >>> 32), 12, -40341101);
        n3 = BrokenMd5Hasher.FF(n3, n4, n, n2, (int)l8, 17, -1502002290);
        n2 = BrokenMd5Hasher.FF(n2, n3, n4, n, (int)(l8 >>> 32), 22, 1236535329);
        n = BrokenMd5Hasher.GG(n, n2, n3, n4, (int)(l >>> 32), 5, -165796510);
        n4 = BrokenMd5Hasher.GG(n4, n, n2, n3, (int)l4, 9, -1069501632);
        n3 = BrokenMd5Hasher.GG(n3, n4, n, n2, (int)(l6 >>> 32), 14, 643717713);
        n2 = BrokenMd5Hasher.GG(n2, n3, n4, n, (int)l, 20, -373897302);
        n = BrokenMd5Hasher.GG(n, n2, n3, n4, (int)(l3 >>> 32), 5, -701558691);
        n4 = BrokenMd5Hasher.GG(n4, n, n2, n3, (int)l6, 9, 38016083);
        n3 = BrokenMd5Hasher.GG(n3, n4, n, n2, (int)(l8 >>> 32), 14, -660478335);
        n2 = BrokenMd5Hasher.GG(n2, n3, n4, n, (int)l3, 20, -405537848);
        n = BrokenMd5Hasher.GG(n, n2, n3, n4, (int)(l5 >>> 32), 5, 568446438);
        n4 = BrokenMd5Hasher.GG(n4, n, n2, n3, (int)l8, 9, -1019803690);
        n3 = BrokenMd5Hasher.GG(n3, n4, n, n2, (int)(l2 >>> 32), 14, -187363961);
        n2 = BrokenMd5Hasher.GG(n2, n3, n4, n, (int)l5, 20, 1163531501);
        n = BrokenMd5Hasher.GG(n, n2, n3, n4, (int)(l7 >>> 32), 5, -1444681467);
        n4 = BrokenMd5Hasher.GG(n4, n, n2, n3, (int)l2, 9, -51403784);
        n3 = BrokenMd5Hasher.GG(n3, n4, n, n2, (int)(l4 >>> 32), 14, 1735328473);
        n2 = BrokenMd5Hasher.GG(n2, n3, n4, n, (int)l7, 20, -1926607734);
        n = BrokenMd5Hasher.HH(n, n2, n3, n4, (int)(l3 >>> 32), 4, -378558);
        n4 = BrokenMd5Hasher.HH(n4, n, n2, n3, (int)l5, 11, -2022574463);
        n3 = BrokenMd5Hasher.HH(n3, n4, n, n2, (int)(l6 >>> 32), 16, 1839030562);
        n2 = BrokenMd5Hasher.HH(n2, n3, n4, n, (int)l8, 23, -35309556);
        n = BrokenMd5Hasher.HH(n, n2, n3, n4, (int)(l >>> 32), 4, -1530992060);
        n4 = BrokenMd5Hasher.HH(n4, n, n2, n3, (int)l3, 11, 1272893353);
        n3 = BrokenMd5Hasher.HH(n3, n4, n, n2, (int)(l4 >>> 32), 16, -155497632);
        n2 = BrokenMd5Hasher.HH(n2, n3, n4, n, (int)l6, 23, -1094730640);
        n = BrokenMd5Hasher.HH(n, n2, n3, n4, (int)(l7 >>> 32), 4, 681279174);
        n4 = BrokenMd5Hasher.HH(n4, n, n2, n3, (int)l, 11, -358537222);
        n3 = BrokenMd5Hasher.HH(n3, n4, n, n2, (int)(l2 >>> 32), 16, -722521979);
        n2 = BrokenMd5Hasher.HH(n2, n3, n4, n, (int)l4, 23, 76029189);
        n = BrokenMd5Hasher.HH(n, n2, n3, n4, (int)(l5 >>> 32), 4, -640364487);
        n4 = BrokenMd5Hasher.HH(n4, n, n2, n3, (int)l7, 11, -421815835);
        n3 = BrokenMd5Hasher.HH(n3, n4, n, n2, (int)(l8 >>> 32), 16, 530742520);
        n2 = BrokenMd5Hasher.HH(n2, n3, n4, n, (int)l2, 23, -995338651);
        n = BrokenMd5Hasher.II(n, n2, n3, n4, (int)l, 6, -198630844);
        n4 = BrokenMd5Hasher.II(n4, n, n2, n3, (int)(l4 >>> 32), 10, 1126891415);
        n3 = BrokenMd5Hasher.II(n3, n4, n, n2, (int)l8, 15, -1416354905);
        n2 = BrokenMd5Hasher.II(n2, n3, n4, n, (int)(l3 >>> 32), 21, -57434055);
        n = BrokenMd5Hasher.II(n, n2, n3, n4, (int)l7, 6, 1700485571);
        n4 = BrokenMd5Hasher.II(n4, n, n2, n3, (int)(l2 >>> 32), 10, -1894986606);
        n3 = BrokenMd5Hasher.II(n3, n4, n, n2, (int)l6, 15, -1051523);
        n2 = BrokenMd5Hasher.II(n2, n3, n4, n, (int)(l >>> 32), 21, -2054922799);
        n = BrokenMd5Hasher.II(n, n2, n3, n4, (int)l5, 6, 1873313359);
        n4 = BrokenMd5Hasher.II(n4, n, n2, n3, (int)(l8 >>> 32), 10, -30611744);
        n3 = BrokenMd5Hasher.II(n3, n4, n, n2, (int)l4, 15, -1560198380);
        n2 = BrokenMd5Hasher.II(n2, n3, n4, n, (int)(l7 >>> 32), 21, 1309151649);
        n = BrokenMd5Hasher.II(n, n2, n3, n4, (int)l3, 6, -145523070);
        n4 = BrokenMd5Hasher.II(n4, n, n2, n3, (int)(l6 >>> 32), 10, -1120210379);
        n3 = BrokenMd5Hasher.II(n3, n4, n, n2, (int)l2, 15, 718787259);
        n2 = BrokenMd5Hasher.II(n2, n3, n4, n, (int)(l5 >>> 32), 21, -343485551);
        this.stateA += n;
        this.stateB += n2;
        this.stateC += n3;
        this.stateD += n4;
    }

    private static int FF(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n + n5 + n7 + (n4 ^ n2 & (n3 ^ n4));
        return (n8 << n6 | n8 >>> 32 - n6) + n2;
    }

    private static int GG(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n + n5 + n7 + (n3 ^ n4 & (n2 ^ n3));
        return (n8 << n6 | n8 >>> 32 - n6) + n2;
    }

    private static int HH(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n + n5 + n7 + (n2 ^ n3 ^ n4);
        return (n8 << n6 | n8 >>> 32 - n6) + n2;
    }

    private static int II(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n + n5 + n7 + (n3 ^ (n2 | ~n4));
        return (n8 << n6 | n8 >>> 32 - n6) + n2;
    }
}

