/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl.tcp.blocking;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.TRTrackerServerTCP;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.blocking.TRBlockingServerProcessor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;

public class TRBlockingServer
extends TRTrackerServerTCP {
    private static final LogIDs LOGID = LogIDs.TRACKER;
    private InetAddress current_bind_ip;
    private ServerSocket server_socket;
    private volatile boolean closed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TRBlockingServer(String string, int n, InetAddress inetAddress, boolean bl, boolean bl2, boolean bl3) throws TRTrackerServerException {
        block24: {
            super(string, n, bl, bl2, bl3);
            boolean bl4 = false;
            try {
                InetAddress inetAddress2 = NetworkAdmin.getSingleton().getSingleHomedServiceBindAddress();
                String string2 = COConfigurationManager.getStringParameter("Bind IP for Tracker", "");
                if (string2.length() >= 7) {
                    try {
                        inetAddress2 = InetAddress.getByName(string2);
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
                if (bl) {
                    if (n == 0) {
                        throw new TRTrackerServerException("port of 0 not currently supported for SSL");
                    }
                    try {
                        SSLServerSocket sSLServerSocket;
                        SSLServerSocketFactory sSLServerSocketFactory = SESecurityManager.getSSLServerSocketFactory();
                        if (sSLServerSocketFactory == null) {
                            throw new TRTrackerServerException("TRTrackerServer: failed to get SSL factory");
                        }
                        if (inetAddress != null) {
                            this.current_bind_ip = inetAddress;
                            sSLServerSocket = (SSLServerSocket)sSLServerSocketFactory.createServerSocket(this.getPort(), 128, inetAddress);
                        } else if (inetAddress2 == null) {
                            sSLServerSocket = (SSLServerSocket)sSLServerSocketFactory.createServerSocket(this.getPort(), 128);
                        } else {
                            this.current_bind_ip = inetAddress2;
                            sSLServerSocket = (SSLServerSocket)sSLServerSocketFactory.createServerSocket(this.getPort(), 128, inetAddress2);
                        }
                        String[] stringArray = sSLServerSocket.getSupportedCipherSuites();
                        sSLServerSocket.setEnabledCipherSuites(stringArray);
                        sSLServerSocket.setNeedClientAuth(false);
                        sSLServerSocket.setReuseAddress(true);
                        this.server_socket = sSLServerSocket;
                        AEThread aEThread = new AEThread("TRTrackerServer:accept.loop(ssl)"){

                            @Override
                            public void runSupport() {
                                TRBlockingServer.this.acceptLoop(TRBlockingServer.this.server_socket);
                            }
                        };
                        aEThread.setDaemon(true);
                        aEThread.start();
                        Logger.log(new LogEvent(LOGID, "TRTrackerServer: SSL listener established on port " + this.getPort()));
                        bl4 = true;
                        break block24;
                    }
                    catch (Throwable throwable) {
                        Logger.logTextResource(new LogAlert(false, 3, "Tracker.alert.listenfail"), new String[]{"" + this.getPort()});
                        Logger.log(new LogEvent(LOGID, "TRTrackerServer: SSL listener failed on port " + this.getPort(), throwable));
                        if (throwable instanceof TRTrackerServerException) {
                            throw (TRTrackerServerException)throwable;
                        }
                        throw new TRTrackerServerException("TRTrackerServer: accept fails: " + throwable.toString());
                    }
                }
                try {
                    ServerSocket serverSocket;
                    int n2 = this.getPort();
                    if (inetAddress != null) {
                        this.current_bind_ip = inetAddress;
                        serverSocket = new ServerSocket(n2, 1024, inetAddress);
                    } else if (inetAddress2 == null) {
                        serverSocket = new ServerSocket(n2, 1024);
                    } else {
                        this.current_bind_ip = inetAddress2;
                        serverSocket = new ServerSocket(n2, 1024, inetAddress2);
                    }
                    if (n2 == 0) {
                        this.setPort(serverSocket.getLocalPort());
                    }
                    serverSocket.setReuseAddress(true);
                    this.server_socket = serverSocket;
                    AEThread aEThread = new AEThread("TRTrackerServer:accept.loop"){

                        @Override
                        public void runSupport() {
                            TRBlockingServer.this.acceptLoop(TRBlockingServer.this.server_socket);
                        }
                    };
                    aEThread.setDaemon(true);
                    aEThread.start();
                    Logger.log(new LogEvent(LOGID, "TRTrackerServer: listener established on port " + this.getPort()));
                    bl4 = true;
                }
                catch (Throwable throwable) {
                    Logger.logTextResource(new LogAlert(false, 3, "Tracker.alert.listenfail"), new String[]{"" + this.getPort()});
                    throw new TRTrackerServerException("TRTrackerServer: accept fails", throwable);
                }
            }
            finally {
                if (!bl4) {
                    this.destroySupport();
                }
            }
        }
    }

    @Override
    public InetAddress getBindIP() {
        return this.current_bind_ip;
    }

    protected void acceptLoop(ServerSocket serverSocket) {
        long l = 0L;
        long l2 = 0L;
        while (!this.closed) {
            try {
                Socket socket = serverSocket.accept();
                ++l;
                String string = socket.getInetAddress().getHostAddress();
                if (!this.isIPFilterEnabled() || !this.ip_filter.isInRange(string, "Tracker", null)) {
                    this.runProcessor(new TRBlockingServerProcessor(this, socket));
                    continue;
                }
                socket.close();
            }
            catch (Throwable throwable) {
                if (this.closed) continue;
                Logger.log(new LogEvent(LOGID, "TRTrackerServer: listener failed on port " + this.getPort(), throwable));
                if (++l2 <= 100L || l != 0L) continue;
                Logger.logTextResource(new LogAlert(false, 3, "Network.alert.acceptfail"), new String[]{"" + this.getPort(), "TCP"});
                break;
            }
        }
    }

    @Override
    protected void closeSupport() {
        this.closed = true;
        try {
            this.server_socket.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.destroySupport();
    }
}

