/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl;

import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerPeer;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerNATChecker;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerNatCheckerListener;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerSimplePeer;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.HostNameToIPResolver;
import org.gudy.azureus2.core3.util.HostNameToIPResolverListener;
import org.gudy.azureus2.core3.util.SystemTime;

public class TRTrackerServerPeerImpl
implements TRTrackerServerPeer,
TRTrackerServerSimplePeer,
HostNameToIPResolverListener,
TRTrackerServerNatCheckerListener {
    private HashWrapper peer_id;
    private int key_hash_code;
    private byte[] ip;
    private boolean ip_override;
    private short tcp_port;
    private short udp_port;
    private short http_port;
    private byte crypto_level;
    private byte az_ver;
    private String ip_str;
    private byte[] ip_bytes;
    private byte NAT_status = 0;
    private long timeout;
    private long uploaded;
    private long downloaded;
    private long amount_left;
    private long last_contact_time;
    private boolean download_completed;
    private boolean biased;
    private short up_speed;
    private DHTNetworkPosition network_position;
    private Object user_data;

    protected TRTrackerServerPeerImpl(HashWrapper hashWrapper, int n, byte[] byArray, boolean bl, int n2, int n3, int n4, byte by, byte by2, long l, boolean bl2, byte by3, int n5, DHTNetworkPosition dHTNetworkPosition) {
        this.peer_id = hashWrapper;
        this.key_hash_code = n;
        this.ip = byArray;
        this.ip_override = bl;
        this.tcp_port = (short)n2;
        this.udp_port = (short)n3;
        this.http_port = (short)n4;
        this.crypto_level = by;
        this.az_ver = by2;
        this.last_contact_time = l;
        this.download_completed = bl2;
        this.NAT_status = by3;
        this.up_speed = (short)(n5 > Short.MAX_VALUE ? Short.MAX_VALUE : (short)n5);
        this.network_position = dHTNetworkPosition;
        this.resolveAndCheckNAT();
    }

    protected TRTrackerServerPeerImpl(HashWrapper hashWrapper, int n, byte[] byArray, boolean bl, short s, short s2, short s3, byte by, byte by2, String string, byte[] byArray2, byte by3, long l, long l2, long l3, long l4, long l5, boolean bl2, boolean bl3, short s4) {
        this.peer_id = hashWrapper;
        this.key_hash_code = n;
        this.ip = byArray;
        this.ip_override = bl;
        this.tcp_port = s;
        this.udp_port = s2;
        this.http_port = s3;
        this.crypto_level = by;
        this.az_ver = by2;
        this.ip_str = string;
        this.ip_bytes = byArray2;
        this.NAT_status = by3;
        this.timeout = l;
        this.uploaded = l2;
        this.downloaded = l3;
        this.amount_left = l4;
        this.last_contact_time = l5;
        this.download_completed = bl2;
        this.biased = bl3;
        this.up_speed = s4;
    }

    protected boolean update(byte[] byArray, int n, int n2, int n3, byte by, byte by2, int n4, DHTNetworkPosition dHTNetworkPosition) {
        this.udp_port = (short)n2;
        this.http_port = (short)n3;
        this.crypto_level = by;
        this.az_ver = by2;
        this.up_speed = (short)(n4 > Short.MAX_VALUE ? Short.MAX_VALUE : (short)n4);
        this.network_position = dHTNetworkPosition;
        boolean bl = false;
        if (n != this.getTCPPort()) {
            this.tcp_port = (short)n;
            bl = true;
        }
        if (!Arrays.equals(byArray, this.ip)) {
            this.ip = byArray;
            bl = true;
        }
        if (bl) {
            this.resolveAndCheckNAT();
        }
        return bl;
    }

    @Override
    public void NATCheckComplete(boolean bl) {
        this.NAT_status = bl ? (byte)3 : (byte)4;
    }

    protected void setNATStatus(byte by) {
        this.NAT_status = by;
    }

    @Override
    public byte getNATStatus() {
        return this.NAT_status;
    }

    protected boolean isNATStatusBad() {
        return this.NAT_status == 4 || this.NAT_status == 5;
    }

    protected void resolveAndCheckNAT() {
        this.ip_str = new String(this.ip);
        this.ip_bytes = null;
        HostNameToIPResolver.addResolverRequest(this.ip_str, this);
        if (this.tcp_port == 0) {
            this.NAT_status = (byte)5;
        } else if (this.NAT_status == 0) {
            this.NAT_status = (byte)2;
            if (!TRTrackerServerNATChecker.getSingleton().addNATCheckRequest(this.ip_str, this.getTCPPort(), this)) {
                this.NAT_status = 1;
            }
        }
    }

    @Override
    public void hostNameResolutionComplete(InetAddress inetAddress) {
        if (inetAddress != null) {
            this.ip_str = inetAddress.getHostAddress();
            this.ip_bytes = inetAddress.getAddress();
        }
    }

    protected long getLastContactTime() {
        return this.last_contact_time;
    }

    protected boolean getDownloadCompleted() {
        return this.download_completed;
    }

    protected void setDownloadCompleted() {
        this.download_completed = true;
    }

    @Override
    public boolean isBiased() {
        return this.biased;
    }

    @Override
    public void setBiased(boolean bl) {
        this.biased = bl;
    }

    @Override
    public HashWrapper getPeerId() {
        return this.peer_id;
    }

    @Override
    public byte[] getPeerID() {
        return this.peer_id.getBytes();
    }

    protected int getKeyHashCode() {
        return this.key_hash_code;
    }

    @Override
    public byte[] getIPAsRead() {
        return this.ip;
    }

    @Override
    public String getIPRaw() {
        return new String(this.ip);
    }

    @Override
    public String getIP() {
        return this.ip_str;
    }

    protected boolean isIPOverride() {
        return this.ip_override;
    }

    @Override
    public byte[] getIPAddressBytes() {
        return this.ip_bytes;
    }

    @Override
    public int getTCPPort() {
        return this.tcp_port & 0xFFFF;
    }

    @Override
    public int getUDPPort() {
        return this.udp_port & 0xFFFF;
    }

    @Override
    public int getHTTPPort() {
        return this.http_port & 0xFFFF;
    }

    @Override
    public byte getCryptoLevel() {
        return this.crypto_level;
    }

    @Override
    public byte getAZVer() {
        return this.az_ver;
    }

    @Override
    public int getUpSpeed() {
        return this.up_speed & 0xFFFF;
    }

    @Override
    public DHTNetworkPosition getNetworkPosition() {
        return this.network_position;
    }

    protected void setTimeout(long l, long l2) {
        this.last_contact_time = l;
        this.timeout = l2;
    }

    protected long getTimeout() {
        return this.timeout;
    }

    @Override
    public int getSecsToLive() {
        return (int)((this.timeout - SystemTime.getCurrentTime()) / 1000L);
    }

    protected void setStats(long l, long l2, long l3) {
        this.uploaded = l;
        this.downloaded = l2;
        this.amount_left = l3;
    }

    @Override
    public long getUploaded() {
        return this.uploaded;
    }

    @Override
    public long getDownloaded() {
        return this.downloaded;
    }

    @Override
    public long getAmountLeft() {
        return this.amount_left;
    }

    @Override
    public boolean isSeed() {
        return this.amount_left == 0L;
    }

    @Override
    public void setUserData(Object object, Object object2) {
        if (this.user_data == null) {
            this.user_data = new Object[]{object, object2};
        } else if (this.user_data instanceof Object[]) {
            Object[] objectArray = (Object[])this.user_data;
            if (objectArray[0] == object) {
                objectArray[1] = object2;
            } else {
                HashMap<Object, Object> hashMap;
                this.user_data = hashMap = new HashMap<Object, Object>();
                hashMap.put(objectArray[0], objectArray[1]);
                hashMap.put(object, object2);
            }
        } else {
            ((Map)this.user_data).put(object, object2);
        }
    }

    @Override
    public Object getUserData(Object object) {
        if (this.user_data == null) {
            return null;
        }
        if (this.user_data instanceof Object[]) {
            Object[] objectArray = (Object[])this.user_data;
            if (objectArray[0] == object) {
                return objectArray[1];
            }
            return null;
        }
        return ((Map)this.user_data).get(object);
    }

    @Override
    public Map export() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("peer_id", this.peer_id.getBytes());
        hashMap.put("key_hash_code", new Long(this.key_hash_code));
        hashMap.put("ip", this.ip);
        hashMap.put("ip_override", new Long(this.ip_override ? 1L : 0L));
        hashMap.put("tcp_port", new Long(this.tcp_port));
        hashMap.put("udp_port", new Long(this.udp_port));
        hashMap.put("http_port", new Long(this.http_port));
        hashMap.put("crypto_level", new Long(this.crypto_level));
        hashMap.put("az_ver", new Long(this.az_ver));
        hashMap.put("ip_str", this.ip_str);
        if (this.ip_bytes != null) {
            hashMap.put("ip_bytes", this.ip_bytes);
        }
        hashMap.put("NAT_status", new Long(this.NAT_status));
        hashMap.put("timeout", new Long(this.timeout));
        hashMap.put("uploaded", new Long(this.uploaded));
        hashMap.put("downloaded", new Long(this.downloaded));
        hashMap.put("amount_left", new Long(this.amount_left));
        hashMap.put("last_contact_time", new Long(this.last_contact_time));
        hashMap.put("download_completed", new Long(this.download_completed ? 1L : 0L));
        hashMap.put("biased", new Long(this.biased ? 1L : 0L));
        hashMap.put("up_speed", new Long(this.up_speed));
        return hashMap;
    }

    public static TRTrackerServerPeerImpl importPeer(Map map) {
        try {
            HashWrapper hashWrapper = new HashWrapper((byte[])map.get("peer_id"));
            int n = ((Long)map.get("key_hash_code")).intValue();
            byte[] byArray = (byte[])map.get("ip");
            boolean bl = ((Long)map.get("ip_override")).intValue() == 1;
            short s = ((Long)map.get("tcp_port")).shortValue();
            short s2 = ((Long)map.get("udp_port")).shortValue();
            short s3 = ((Long)map.get("http_port")).shortValue();
            byte by = ((Long)map.get("crypto_level")).byteValue();
            byte by2 = ((Long)map.get("az_ver")).byteValue();
            String string = new String((byte[])map.get("ip_str"));
            byte[] byArray2 = (byte[])map.get("ip_bytes");
            byte by3 = ((Long)map.get("NAT_status")).byteValue();
            long l = (Long)map.get("timeout");
            long l2 = (Long)map.get("uploaded");
            long l3 = (Long)map.get("downloaded");
            long l4 = (Long)map.get("amount_left");
            long l5 = (Long)map.get("last_contact_time");
            boolean bl2 = ((Long)map.get("download_completed")).intValue() == 1;
            boolean bl3 = ((Long)map.get("biased")).intValue() == 1;
            short s4 = ((Long)map.get("up_speed")).shortValue();
            return new TRTrackerServerPeerImpl(hashWrapper, n, byArray, bl, s, s2, s3, by, by2, string, byArray2, by3, l, l2, l3, l4, l5, bl2, bl3, s4);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected String getString() {
        return new String(this.ip) + ":" + this.getTCPPort() + "(" + new String(this.peer_id.getHash()) + ")";
    }
}

