/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.protocol.udp;

import com.aelitis.net.udp.uc.PRUDPPacketReply;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class PRUDPPacketReplyAnnounce
extends PRUDPPacketReply {
    protected int interval;
    protected static final int BYTES_PER_ENTRY = 6;
    protected int[] addresses;
    protected short[] ports;

    public PRUDPPacketReplyAnnounce(int n) {
        super(1, n);
    }

    protected PRUDPPacketReplyAnnounce(DataInputStream dataInputStream, int n) throws IOException {
        super(1, n);
        this.interval = dataInputStream.readInt();
        this.addresses = new int[dataInputStream.available() / 6];
        this.ports = new short[this.addresses.length];
        for (int i = 0; i < this.addresses.length; ++i) {
            this.addresses[i] = dataInputStream.readInt();
            this.ports[i] = dataInputStream.readShort();
        }
    }

    public void setInterval(int n) {
        this.interval = n;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setPeers(int[] nArray, short[] sArray) {
        this.addresses = nArray;
        this.ports = sArray;
    }

    public int[] getAddresses() {
        return this.addresses;
    }

    public short[] getPorts() {
        return this.ports;
    }

    @Override
    public void serialise(DataOutputStream dataOutputStream) throws IOException {
        super.serialise(dataOutputStream);
        dataOutputStream.writeInt(this.interval);
        if (this.addresses != null) {
            for (int i = 0; i < this.addresses.length; ++i) {
                dataOutputStream.writeInt(this.addresses[i]);
                dataOutputStream.writeShort(this.ports[i]);
            }
        }
    }

    @Override
    public String getString() {
        return super.getString().concat("[interval=").concat(String.valueOf(this.interval)).concat(", addresses=").concat(String.valueOf(this.addresses.length)).concat("]");
    }
}

