/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.host.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperFactory;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.tracker.host.TRHostException;
import org.gudy.azureus2.core3.tracker.host.TRHostPeer;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentListener;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentRemovalVetoException;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentRequest;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentWillBeRemovedListener;
import org.gudy.azureus2.core3.tracker.host.impl.TRHostImpl;
import org.gudy.azureus2.core3.tracker.host.impl.TRHostPeerPublishImpl;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrent;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;

public class TRHostTorrentPublishImpl
implements TRHostTorrent {
    private TRHostImpl host;
    private TOTorrent torrent;
    private long date_added;
    private int status = 3;
    private boolean persistent;
    private int seed_count;
    private int peer_count;
    private TRHostPeer[] peers = new TRHostPeer[0];
    private List listeners_cow = new ArrayList();
    private List removal_listeners = new ArrayList();
    private HashMap data;
    protected AEMonitor this_mon = new AEMonitor("TRHostTorrentPublish");

    protected TRHostTorrentPublishImpl(TRHostImpl tRHostImpl, TOTorrent tOTorrent, long l) {
        this.host = tRHostImpl;
        this.torrent = tOTorrent;
        this.date_added = l;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove() throws TRHostTorrentRemovalVetoException {
        try {
            this.this_mon.enter();
            this.canBeRemoved();
            this.host.remove(this);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public boolean canBeRemoved() throws TRHostTorrentRemovalVetoException {
        for (int i = 0; i < this.removal_listeners.size(); ++i) {
            ((TRHostTorrentWillBeRemovedListener)this.removal_listeners.get(i)).torrentWillBeRemoved(this);
        }
        return true;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean bl) {
        this.persistent = bl;
    }

    @Override
    public boolean isPassive() {
        return false;
    }

    @Override
    public void setPassive(boolean bl) {
    }

    @Override
    public long getDateAdded() {
        return this.date_added;
    }

    @Override
    public TOTorrent getTorrent() {
        return this.torrent;
    }

    @Override
    public TRTrackerServerTorrent getTrackerTorrent() {
        return null;
    }

    @Override
    public int getPort() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TRHostPeer[] getPeers() {
        try {
            this.this_mon.enter();
            TRHostPeer[] tRHostPeerArray = this.peers;
            return tRHostPeerArray;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public long getAnnounceCount() {
        return 0L;
    }

    @Override
    public long getAverageAnnounceCount() {
        return 0L;
    }

    @Override
    public long getScrapeCount() {
        return 0L;
    }

    @Override
    public long getAverageScrapeCount() {
        return 0L;
    }

    @Override
    public long getCompletedCount() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateStats() {
        TRTrackerScraperResponse tRTrackerScraperResponse = null;
        TRTrackerAnnouncer tRTrackerAnnouncer = this.host.getTrackerClient(this);
        if (tRTrackerAnnouncer != null) {
            tRTrackerScraperResponse = TRTrackerScraperFactory.getSingleton().scrape(tRTrackerAnnouncer);
        }
        if (tRTrackerScraperResponse == null) {
            tRTrackerScraperResponse = TRTrackerScraperFactory.getSingleton().scrape(this.torrent);
        }
        try {
            this.this_mon.enter();
            if (tRTrackerScraperResponse != null && tRTrackerScraperResponse.isValid()) {
                this.peer_count = tRTrackerScraperResponse.getPeers();
                this.seed_count = tRTrackerScraperResponse.getSeeds();
                this.peers = new TRHostPeer[this.peer_count + this.seed_count];
                for (int i = 0; i < this.peers.length; ++i) {
                    this.peers[i] = new TRHostPeerPublishImpl(i < this.seed_count);
                }
            } else {
                this.peers = new TRHostPeer[0];
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public int getSeedCount() {
        return this.seed_count;
    }

    @Override
    public int getLeecherCount() {
        return this.peer_count;
    }

    @Override
    public int getBadNATCount() {
        return 0;
    }

    @Override
    public long getTotalUploaded() {
        return 0L;
    }

    @Override
    public long getTotalDownloaded() {
        return 0L;
    }

    @Override
    public long getTotalLeft() {
        return 0L;
    }

    @Override
    public long getAverageUploaded() {
        return 0L;
    }

    @Override
    public long getAverageDownloaded() {
        return 0L;
    }

    @Override
    public long getTotalBytesIn() {
        return 0L;
    }

    @Override
    public long getTotalBytesOut() {
        return 0L;
    }

    @Override
    public long getAverageBytesIn() {
        return 0L;
    }

    @Override
    public long getAverageBytesOut() {
        return 0L;
    }

    @Override
    public void disableReplyCaching() {
    }

    protected void preProcess(TRHostTorrentRequest tRHostTorrentRequest) throws TRHostException {
        List list = this.listeners_cow;
        for (int i = 0; i < list.size(); ++i) {
            try {
                ((TRHostTorrentListener)list.get(i)).preProcess(tRHostTorrentRequest);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    protected void postProcess(TRHostTorrentRequest tRHostTorrentRequest) throws TRHostException {
        List list = this.listeners_cow;
        for (int i = 0; i < list.size(); ++i) {
            try {
                ((TRHostTorrentListener)list.get(i)).postProcess(tRHostTorrentRequest);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(TRHostTorrentListener tRHostTorrentListener) {
        try {
            this.this_mon.enter();
            ArrayList<TRHostTorrentListener> arrayList = new ArrayList<TRHostTorrentListener>(this.listeners_cow);
            arrayList.add(tRHostTorrentListener);
            this.listeners_cow = arrayList;
        }
        finally {
            this.this_mon.exit();
        }
        this.host.torrentListenerRegistered();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(TRHostTorrentListener tRHostTorrentListener) {
        try {
            this.this_mon.enter();
            ArrayList arrayList = new ArrayList(this.listeners_cow);
            arrayList.remove(tRHostTorrentListener);
            this.listeners_cow = arrayList;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRemovalListener(TRHostTorrentWillBeRemovedListener tRHostTorrentWillBeRemovedListener) {
        try {
            this.this_mon.enter();
            this.removal_listeners.add(tRHostTorrentWillBeRemovedListener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRemovalListener(TRHostTorrentWillBeRemovedListener tRHostTorrentWillBeRemovedListener) {
        try {
            this.this_mon.enter();
            this.removal_listeners.remove(tRHostTorrentWillBeRemovedListener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public Object getData(String string) {
        if (this.data == null) {
            return null;
        }
        return this.data.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setData(String string, Object object) {
        try {
            this.this_mon.enter();
            if (this.data == null) {
                this.data = new HashMap();
            }
            if (object == null) {
                if (this.data.containsKey(string)) {
                    this.data.remove(string);
                }
            } else {
                this.data.put(string, object);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }
}

