/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.host.impl;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilEncodingException;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLGroup;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.torrent.TOTorrentListener;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;

public class TRHostExternalTorrent
implements TOTorrent {
    private byte[] name;
    private byte[] hash;
    private HashWrapper hash_wrapper;
    private URL announce_url;
    protected Map additional_properties = new HashMap();
    protected AEMonitor this_mon = new AEMonitor("TRHostExternalTorrent");

    protected TRHostExternalTorrent(byte[] byArray, URL uRL) {
        this.hash = byArray;
        this.hash_wrapper = new HashWrapper(this.hash);
        this.announce_url = uRL;
        this.name = ByteFormatter.nicePrint(this.hash, true).getBytes();
        try {
            LocaleTorrentUtil.setDefaultTorrentEncoding(this);
        }
        catch (LocaleUtilEncodingException localeUtilEncodingException) {
            Debug.printStackTrace(localeUtilEncodingException);
        }
    }

    @Override
    public byte[] getName() {
        return this.name;
    }

    @Override
    public String getUTF8Name() {
        return null;
    }

    @Override
    public boolean isSimpleTorrent() {
        return true;
    }

    @Override
    public byte[] getComment() {
        return null;
    }

    @Override
    public void setComment(String string) {
    }

    @Override
    public long getCreationDate() {
        return 0L;
    }

    @Override
    public void setCreationDate(long l) {
    }

    @Override
    public byte[] getCreatedBy() {
        return null;
    }

    @Override
    public void setCreatedBy(byte[] byArray) {
    }

    @Override
    public boolean isCreated() {
        return false;
    }

    @Override
    public URL getAnnounceURL() {
        return this.announce_url;
    }

    @Override
    public boolean setAnnounceURL(URL uRL) {
        return false;
    }

    @Override
    public TOTorrentAnnounceURLGroup getAnnounceURLGroup() {
        return new TOTorrentAnnounceURLGroup(){

            @Override
            public TOTorrentAnnounceURLSet[] getAnnounceURLSets() {
                return new TOTorrentAnnounceURLSet[0];
            }

            @Override
            public void setAnnounceURLSets(TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray) {
            }

            @Override
            public TOTorrentAnnounceURLSet createAnnounceURLSet(URL[] uRLArray) {
                return new TOTorrentAnnounceURLSet(){

                    @Override
                    public URL[] getAnnounceURLs() {
                        return new URL[0];
                    }

                    @Override
                    public void setAnnounceURLs(URL[] uRLArray) {
                    }
                };
            }
        };
    }

    public void addTorrentAnnounceURLSet(URL[] uRLArray) {
    }

    @Override
    public byte[][] getPieces() {
        return new byte[0][];
    }

    @Override
    public void setPieces(byte[][] byArray) {
    }

    @Override
    public int getNumberOfPieces() {
        return 0;
    }

    @Override
    public long getPieceLength() {
        return -1L;
    }

    @Override
    public long getSize() {
        return -1L;
    }

    @Override
    public TOTorrentFile[] getFiles() {
        return new TOTorrentFile[0];
    }

    @Override
    public byte[] getHash() throws TOTorrentException {
        return this.hash;
    }

    @Override
    public HashWrapper getHashWrapper() throws TOTorrentException {
        return this.hash_wrapper;
    }

    @Override
    public void setHashOverride(byte[] byArray) throws TOTorrentException {
        throw new TOTorrentException("Not supported", 8);
    }

    @Override
    public boolean getPrivate() {
        return false;
    }

    @Override
    public void setPrivate(boolean bl) throws TOTorrentException {
    }

    @Override
    public boolean hasSameHashAs(TOTorrent tOTorrent) {
        try {
            byte[] byArray = tOTorrent.getHash();
            return Arrays.equals(this.hash, byArray);
        }
        catch (TOTorrentException tOTorrentException) {
            Debug.printStackTrace(tOTorrentException);
            return false;
        }
    }

    @Override
    public void setAdditionalStringProperty(String string, String string2) {
        try {
            this.additional_properties.put(string, string2.getBytes("UTF8"));
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    @Override
    public String getAdditionalStringProperty(String string) {
        try {
            Object v = this.additional_properties.get(string);
            if (v == null) {
                return null;
            }
            if (!(v instanceof byte[])) {
                Debug.out("property '" + string + "' is not a byte[]: " + v);
                return null;
            }
            return new String((byte[])v, "UTF8");
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            return null;
        }
    }

    @Override
    public void setAdditionalByteArrayProperty(String string, byte[] byArray) {
        this.additional_properties.put(string, byArray);
    }

    @Override
    public byte[] getAdditionalByteArrayProperty(String string) {
        return (byte[])this.additional_properties.get(string);
    }

    @Override
    public void setAdditionalLongProperty(String string, Long l) {
        this.additional_properties.put(string, l);
    }

    @Override
    public void setAdditionalProperty(String string, Object object) {
        if (object instanceof String) {
            this.setAdditionalStringProperty(string, (String)object);
        } else {
            this.additional_properties.put(string, object);
        }
    }

    @Override
    public Long getAdditionalLongProperty(String string) {
        return (Long)this.additional_properties.get(string);
    }

    @Override
    public void setAdditionalListProperty(String string, List list) {
        this.additional_properties.put(string, list);
    }

    @Override
    public List getAdditionalListProperty(String string) {
        return (List)this.additional_properties.get(string);
    }

    @Override
    public void setAdditionalMapProperty(String string, Map map) {
        this.additional_properties.put(string, map);
    }

    @Override
    public Map getAdditionalMapProperty(String string) {
        return (Map)this.additional_properties.get(string);
    }

    @Override
    public Object getAdditionalProperty(String string) {
        return this.additional_properties.get(string);
    }

    @Override
    public void removeAdditionalProperty(String string) {
        this.additional_properties.remove(string);
    }

    @Override
    public void removeAdditionalProperties() {
        this.additional_properties.clear();
    }

    @Override
    public void serialiseToBEncodedFile(File file) throws TOTorrentException {
        throw new TOTorrentException("External Torrent", 5);
    }

    @Override
    public Map serialiseToMap() throws TOTorrentException {
        throw new TOTorrentException("External Torrent", 5);
    }

    @Override
    public void serialiseToXMLFile(File file) throws TOTorrentException {
        throw new TOTorrentException("External Torrent", 5);
    }

    @Override
    public void addListener(TOTorrentListener tOTorrentListener) {
    }

    @Override
    public void removeListener(TOTorrentListener tOTorrentListener) {
    }

    @Override
    public AEMonitor getMonitor() {
        return this.this_mon;
    }

    @Override
    public void print() {
    }
}

