/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.host.impl;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentFinder;
import org.gudy.azureus2.core3.tracker.host.impl.TRHostImpl;
import org.gudy.azureus2.core3.tracker.host.impl.TRHostTorrentHostImpl;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class TRHostConfigImpl {
    public static final String LOG_FILE_NAME = "tracker.log";
    public static final long BACKUP_RETENTION_PERIOD = 604800000L;
    private TRHostImpl host;
    private AEMonitor save_lock_mon = new AEMonitor("TRHostConfig:SL");
    private String log_dir;
    private volatile boolean loading = false;
    private volatile boolean save_outstanding = false;
    private Map saved_stats = new HashMap();
    private List saved_stats_to_delete = new ArrayList();
    private boolean config_exists = true;
    private AEMonitor this_mon = new AEMonitor("TRHostConfig");

    protected TRHostConfigImpl(TRHostImpl tRHostImpl) {
        this.host = tRHostImpl;
        this.log_dir = SystemProperties.getUserPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadConfig(TRHostTorrentFinder tRHostTorrentFinder) {
        try {
            this.this_mon.enter();
            this.loading = true;
            Map map = FileUtil.readResilientConfigFile("tracker.config");
            List list = (List)map.get("torrents");
            if (list == null) {
                return;
            }
            for (Map map2 : list) {
                Long l = (Long)map2.get("persistent");
                boolean bl = l == null || l == 1L;
                Long l2 = (Long)map2.get("passive");
                boolean bl2 = l2 != null && l2 == 1L;
                Long l3 = (Long)map2.get("dateadded");
                long l4 = l3 == null ? SystemTime.getCurrentTime() : l3;
                byte[] byArray = (byte[])map2.get("hash");
                if (bl) {
                    Object object;
                    Object object2;
                    TOTorrent tOTorrent;
                    int n = ((Long)map2.get("status")).intValue();
                    if (n == 0) {
                        n = 1;
                    }
                    if ((tOTorrent = tRHostTorrentFinder.lookupTorrent(byArray)) == null && bl2 && (object2 = (byte[])map2.get("torrent_file")) != null) {
                        try {
                            object = new File(new String((byte[])object2, "ISO-8859-1"));
                            tOTorrent = TorrentUtils.readFromFile((File)object, true, true);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    if (tOTorrent != null) {
                        object2 = this.host.addTorrent(tOTorrent, n, true, bl2, l4);
                        if (!(object2 instanceof TRHostTorrentHostImpl)) continue;
                        object = (TRHostTorrentHostImpl)object2;
                        this.recoverStats((TRHostTorrentHostImpl)object, map2);
                        continue;
                    }
                    if (!COConfigurationManager.getBooleanParameter("Tracker Public Enable")) continue;
                    this.host.addExternalTorrent(byArray, n, l4);
                    continue;
                }
                this.saved_stats.put(new HashWrapper(byArray), map2);
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
        }
        finally {
            this.loading = false;
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recoverStats(TRHostTorrentHostImpl tRHostTorrentHostImpl) {
        block5: {
            try {
                HashWrapper hashWrapper = tRHostTorrentHostImpl.getTorrent().getHashWrapper();
                Map map = (Map)this.saved_stats.get(hashWrapper);
                if (map == null) break block5;
                this.recoverStats(tRHostTorrentHostImpl, map);
                List list = this.saved_stats_to_delete;
                synchronized (list) {
                    this.saved_stats_to_delete.add(hashWrapper);
                }
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    private void recoverStats(TRHostTorrentHostImpl tRHostTorrentHostImpl, Map map) {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        Long l8 = (Long)map.get("dateadded");
        long l9 = l8 == null ? SystemTime.getCurrentTime() : l8;
        Map map2 = (Map)map.get("stats");
        if (map2 != null) {
            Long l10;
            Long l11;
            l = (Long)map2.get("completed");
            l2 = (Long)map2.get("announces");
            l4 = (Long)map2.get("uploaded");
            l5 = (Long)map2.get("downloaded");
            Long l12 = (Long)map2.get("scrapes");
            if (l12 != null) {
                l3 = l12;
            }
            if ((l11 = (Long)map2.get("bytesin")) != null) {
                l6 = l11;
            }
            if ((l10 = (Long)map2.get("bytesout")) != null) {
                l7 = l10;
            }
        }
        tRHostTorrentHostImpl.setStartOfDayValues(l9, l, l2, l3, l4, l5, l6, l7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void saveConfig(boolean bl) {
        Cloneable cloneable;
        Object object;
        if (this.loading) {
            return;
        }
        if (this.saved_stats_to_delete.size() > 0) {
            object = this.saved_stats_to_delete;
            synchronized (object) {
                cloneable = new HashMap(this.saved_stats);
                for (int i = 0; i < this.saved_stats_to_delete.size(); ++i) {
                    cloneable.remove(this.saved_stats_to_delete.get(i));
                }
                this.saved_stats_to_delete.clear();
                this.saved_stats = cloneable;
            }
        }
        if (!bl) {
            if (!this.save_outstanding) return;
        }
        this.save_outstanding = false;
        try {
            Object object2;
            Object object3;
            object = new HashMap();
            cloneable = new ArrayList();
            TRHostTorrent[] tRHostTorrentArray = this.host.getTorrents();
            ArrayList<StringBuffer> arrayList = new ArrayList<StringBuffer>();
            HashSet<Object> hashSet = new HashSet<Object>();
            for (int i = 0; i < tRHostTorrentArray.length; ++i) {
                try {
                    Object object4;
                    TRHostTorrent tRHostTorrent = tRHostTorrentArray[i];
                    hashSet.add(tRHostTorrent.getTorrent().getHashWrapper());
                    StringBuffer stringBuffer = new StringBuffer(2048);
                    object3 = tRHostTorrent.getTorrent().getHash();
                    object2 = tRHostTorrent.getTorrent().getName();
                    int n = tRHostTorrent.getStatus();
                    long l = tRHostTorrent.getCompletedCount();
                    long l2 = tRHostTorrent.getAnnounceCount();
                    long l3 = tRHostTorrent.getScrapeCount();
                    long l4 = tRHostTorrent.getTotalUploaded();
                    long l5 = tRHostTorrent.getTotalDownloaded();
                    long l6 = tRHostTorrent.getTotalBytesIn();
                    long l7 = tRHostTorrent.getTotalBytesOut();
                    long l8 = tRHostTorrent.getDateAdded();
                    int n2 = tRHostTorrent.getSeedCount();
                    int n3 = tRHostTorrent.getLeecherCount();
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("persistent", new Long(tRHostTorrent.isPersistent() ? 1L : 0L));
                    hashMap.put("passive", new Long(tRHostTorrent.isPassive() ? 1L : 0L));
                    if (tRHostTorrent.isPassive()) {
                        try {
                            object4 = TorrentUtils.getTorrentFileName(tRHostTorrent.getTorrent());
                            hashMap.put("torrent_file", ((String)object4).getBytes("ISO-8859-1"));
                        }
                        catch (Throwable object42) {
                            Debug.printStackTrace(object42);
                        }
                    }
                    hashMap.put("hash", object3);
                    hashMap.put("dateadded", new Long(l8));
                    hashMap.put("status", new Long(n));
                    cloneable.add(hashMap);
                    object4 = new HashMap();
                    hashMap.put("stats", object4);
                    object4.put("completed", new Long(l));
                    object4.put("announces", new Long(l2));
                    object4.put("scrapes", new Long(l3));
                    object4.put("uploaded", new Long(l4));
                    object4.put("downloaded", new Long(l5));
                    object4.put("bytesin", new Long(l6));
                    object4.put("bytesout", new Long(l7));
                    stringBuffer.append(new String((byte[])object2, "UTF8"));
                    stringBuffer.append(",");
                    stringBuffer.append(ByteFormatter.nicePrint((byte[])object3, true));
                    stringBuffer.append(",");
                    stringBuffer.append(n);
                    stringBuffer.append(",");
                    stringBuffer.append(n2);
                    stringBuffer.append(",");
                    stringBuffer.append(n3);
                    stringBuffer.append(",");
                    stringBuffer.append(l);
                    stringBuffer.append(",");
                    stringBuffer.append(l2);
                    stringBuffer.append(",");
                    stringBuffer.append(l3);
                    stringBuffer.append(",");
                    stringBuffer.append(DisplayFormatters.formatByteCountToKiBEtc(l4));
                    stringBuffer.append(",");
                    stringBuffer.append(DisplayFormatters.formatByteCountToKiBEtc(l5));
                    stringBuffer.append(",");
                    stringBuffer.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(tRHostTorrent.getAverageUploaded()));
                    stringBuffer.append(",");
                    stringBuffer.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(tRHostTorrent.getAverageDownloaded()));
                    stringBuffer.append(",");
                    stringBuffer.append(DisplayFormatters.formatByteCountToKiBEtc(tRHostTorrent.getTotalLeft()));
                    stringBuffer.append(",");
                    stringBuffer.append(DisplayFormatters.formatByteCountToKiBEtc(l6));
                    stringBuffer.append(",");
                    stringBuffer.append(DisplayFormatters.formatByteCountToKiBEtc(l7));
                    stringBuffer.append(",");
                    stringBuffer.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(tRHostTorrent.getAverageBytesIn()));
                    stringBuffer.append(",");
                    stringBuffer.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(tRHostTorrent.getAverageBytesOut()));
                    stringBuffer.append("\r\n");
                    arrayList.add(stringBuffer);
                    continue;
                }
                catch (TOTorrentException tRHostTorrent) {
                    Debug.printStackTrace(tRHostTorrent);
                }
            }
            Iterator i = this.saved_stats.keySet().iterator();
            long tOTorrentException = SystemTime.getCurrentTime();
            while (i.hasNext()) {
                object3 = (HashWrapper)i.next();
                if (hashSet.contains(object3)) continue;
                object2 = (Map)this.saved_stats.get(object3);
                Long n = (Long)object2.get("backup_time");
                if (n == null) {
                    n = new Long(tOTorrentException);
                    object2.put("backup_time", n);
                }
                if (tOTorrentException - n >= 604800000L) continue;
                cloneable.add(object2);
                hashSet.add(object3);
            }
            object.put("torrents", cloneable);
            try {
                this.save_lock_mon.enter();
                if (tRHostTorrentArray.length == 0) {
                    if (this.config_exists) {
                        FileUtil.deleteResilientConfigFile("tracker.config");
                        this.config_exists = false;
                    }
                } else {
                    this.config_exists = true;
                    FileUtil.writeResilientConfigFile("tracker.config", (Map)object);
                }
                if (!COConfigurationManager.getBooleanParameter("Tracker Log Enable")) return;
                if (arrayList.size() <= 0) return;
                try {
                    object3 = "[" + new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss").format(new Date()) + "] ";
                    object2 = null;
                    File l9 = new File(this.log_dir.concat(File.separator).concat(LOG_FILE_NAME));
                    try {
                        object2 = new PrintWriter(new FileWriter(l9, true));
                        for (int l = 0; l < arrayList.size(); ++l) {
                            StringBuffer stringBuffer = (StringBuffer)arrayList.get(l);
                            String l2 = (String)object3 + stringBuffer.toString();
                            ((PrintWriter)object2).print(l2);
                        }
                        if (object2 == null) return;
                    }
                    catch (Throwable throwable) {
                        try {
                            Debug.printStackTrace(throwable);
                            return;
                        }
                        catch (Throwable throwable2) {
                            throw throwable2;
                        }
                        finally {
                            if (object2 != null) {
                                try {
                                    ((PrintWriter)object2).close();
                                }
                                catch (Throwable throwable3) {}
                            }
                        }
                    }
                    try {
                        ((PrintWriter)object2).close();
                        return;
                    }
                    catch (Throwable i2) {
                        return;
                    }
                }
                catch (Throwable object32) {
                    Debug.printStackTrace(object32);
                    return;
                }
            }
            finally {
                this.save_lock_mon.exit();
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    protected void saveRequired() {
        this.save_outstanding = true;
    }
}

