/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.impl.dht;

import com.aelitis.azureus.core.tracker.TrackerPeerSource;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerDataProvider;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerListener;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponse;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponsePeer;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerHelper;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerImpl;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerResponseImpl;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerResponsePeerImpl;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.clientid.ClientIDException;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResultPeer;
import org.gudy.azureus2.pluginsimpl.local.clientid.ClientIDManagerImpl;

public class TRTrackerDHTAnnouncerImpl
implements TRTrackerAnnouncerHelper {
    public static final LogIDs LOGID = LogIDs.TRACKER;
    private TOTorrent torrent;
    private HashWrapper torrent_hash;
    private TRTrackerAnnouncerImpl.Helper helper;
    private byte[] data_peer_id;
    private String tracker_status_str;
    private long last_update_time;
    private int state = 1;
    private TRTrackerAnnouncerResponseImpl last_response;
    private boolean manual;

    public TRTrackerDHTAnnouncerImpl(TOTorrent tOTorrent, String[] stringArray, boolean bl, TRTrackerAnnouncerImpl.Helper helper) throws TRTrackerAnnouncerException {
        this.torrent = tOTorrent;
        this.manual = bl;
        this.helper = helper;
        try {
            this.torrent_hash = this.torrent.getHashWrapper();
        }
        catch (TOTorrentException tOTorrentException) {
            Debug.printStackTrace(tOTorrentException);
        }
        try {
            this.data_peer_id = ClientIDManagerImpl.getSingleton().generatePeerID(this.torrent, false);
        }
        catch (ClientIDException clientIDException) {
            throw new TRTrackerAnnouncerException("TRTrackerAnnouncer: Peer ID generation fails", clientIDException);
        }
        this.last_response = new TRTrackerAnnouncerResponseImpl(this.torrent.getAnnounceURL(), this.torrent_hash, 0, 0L, "Initialising");
        this.tracker_status_str = MessageText.getString("PeerManager.status.checking") + "...";
    }

    @Override
    public void setAnnounceDataProvider(TRTrackerAnnouncerDataProvider tRTrackerAnnouncerDataProvider) {
    }

    @Override
    public boolean isManual() {
        return this.manual;
    }

    @Override
    public TOTorrent getTorrent() {
        return this.torrent;
    }

    @Override
    public URL getTrackerURL() {
        return TorrentUtils.getDecentralisedURL(this.torrent);
    }

    @Override
    public void setTrackerURL(URL uRL) {
        Debug.out("Not implemented");
    }

    @Override
    public void setAnnounceSets(TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray) {
        Debug.out("Not implemented");
    }

    @Override
    public TOTorrentAnnounceURLSet[] getAnnounceSets() {
        return new TOTorrentAnnounceURLSet[]{this.torrent.getAnnounceURLGroup().createAnnounceURLSet(new URL[]{TorrentUtils.getDecentralisedURL(this.torrent)})};
    }

    @Override
    public void resetTrackerUrl(boolean bl) {
    }

    @Override
    public void setIPOverride(String string) {
    }

    @Override
    public void clearIPOverride() {
    }

    public int getPort() {
        return 0;
    }

    @Override
    public byte[] getPeerId() {
        return this.data_peer_id;
    }

    @Override
    public void setRefreshDelayOverrides(int n) {
    }

    @Override
    public int getTimeUntilNextUpdate() {
        long l = (SystemTime.getCurrentTime() - this.last_update_time) / 1000L;
        return (int)(this.last_response.getTimeToWait() - l);
    }

    @Override
    public int getLastUpdateTime() {
        return (int)(this.last_update_time / 1000L);
    }

    @Override
    public void update(boolean bl) {
        this.state = 2;
    }

    @Override
    public void complete(boolean bl) {
        this.state = 3;
    }

    @Override
    public void stop(boolean bl) {
        this.state = 4;
    }

    @Override
    public void destroy() {
    }

    @Override
    public int getStatus() {
        return this.state;
    }

    @Override
    public String getStatusString() {
        return this.tracker_status_str;
    }

    @Override
    public TRTrackerAnnouncer getBestAnnouncer() {
        return this;
    }

    @Override
    public TRTrackerAnnouncerResponse getLastResponse() {
        return this.last_response;
    }

    @Override
    public boolean isUpdating() {
        return false;
    }

    @Override
    public long getInterval() {
        return -1L;
    }

    @Override
    public long getMinInterval() {
        return -1L;
    }

    @Override
    public void refreshListeners() {
    }

    @Override
    public void setAnnounceResult(DownloadAnnounceResult downloadAnnounceResult) {
        TRTrackerAnnouncerResponsePeer[] tRTrackerAnnouncerResponsePeerArray;
        TRTrackerAnnouncerResponseImpl tRTrackerAnnouncerResponseImpl;
        Object object;
        this.last_update_time = SystemTime.getCurrentTime();
        if (downloadAnnounceResult.getResponseType() == 2) {
            this.tracker_status_str = MessageText.getString("PeerManager.status.error");
            object = downloadAnnounceResult.getError();
            if (object != null) {
                this.tracker_status_str = this.tracker_status_str + " (" + (String)object + ")";
            }
            tRTrackerAnnouncerResponseImpl = new TRTrackerAnnouncerResponseImpl(downloadAnnounceResult.getURL(), this.torrent_hash, 0, downloadAnnounceResult.getTimeToWait(), (String)object);
        } else {
            object = downloadAnnounceResult.getPeers();
            tRTrackerAnnouncerResponsePeerArray = new TRTrackerAnnouncerResponsePeerImpl[((DownloadAnnounceResultPeer[])object).length];
            for (int i = 0; i < ((DownloadAnnounceResultPeer[])object).length; ++i) {
                DownloadAnnounceResultPeer downloadAnnounceResultPeer = object[i];
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "EXTERNAL PEER DHT: ip=" + downloadAnnounceResultPeer.getAddress() + ",port=" + downloadAnnounceResultPeer.getPort() + ",prot=" + downloadAnnounceResultPeer.getProtocol()));
                }
                int n = 0;
                byte by = 1;
                tRTrackerAnnouncerResponsePeerArray[i] = new TRTrackerAnnouncerResponsePeerImpl(downloadAnnounceResultPeer.getSource(), downloadAnnounceResultPeer.getPeerID(), downloadAnnounceResultPeer.getAddress(), downloadAnnounceResultPeer.getPort(), downloadAnnounceResultPeer.getUDPPort(), n, downloadAnnounceResultPeer.getProtocol(), by, 0);
            }
            this.helper.addToTrackerCache((TRTrackerAnnouncerResponsePeerImpl[])tRTrackerAnnouncerResponsePeerArray);
            this.tracker_status_str = MessageText.getString("PeerManager.status.ok");
            tRTrackerAnnouncerResponseImpl = new TRTrackerAnnouncerResponseImpl(downloadAnnounceResult.getURL(), this.torrent_hash, 2, downloadAnnounceResult.getTimeToWait(), tRTrackerAnnouncerResponsePeerArray);
        }
        this.last_response = tRTrackerAnnouncerResponseImpl;
        object = tRTrackerAnnouncerResponseImpl.getPeers();
        if ((object == null || ((DownloadAnnounceResultPeer[])object).length < 5) && (tRTrackerAnnouncerResponsePeerArray = this.helper.getPeersFromCache(100)).length > 0) {
            TreeSet<TRTrackerAnnouncerResponsePeer> treeSet = new TreeSet<TRTrackerAnnouncerResponsePeer>(new Comparator<TRTrackerAnnouncerResponsePeer>(){

                @Override
                public int compare(TRTrackerAnnouncerResponsePeer tRTrackerAnnouncerResponsePeer, TRTrackerAnnouncerResponsePeer tRTrackerAnnouncerResponsePeer2) {
                    return tRTrackerAnnouncerResponsePeer.compareTo(tRTrackerAnnouncerResponsePeer2);
                }
            });
            if (object != null) {
                treeSet.addAll(Arrays.asList(object));
            }
            treeSet.addAll(Arrays.asList(tRTrackerAnnouncerResponsePeerArray));
            tRTrackerAnnouncerResponseImpl.setPeers(treeSet.toArray(new TRTrackerAnnouncerResponsePeer[treeSet.size()]));
        }
        this.helper.informResponse(this, tRTrackerAnnouncerResponseImpl);
    }

    @Override
    public void addListener(TRTrackerAnnouncerListener tRTrackerAnnouncerListener) {
        this.helper.addListener(tRTrackerAnnouncerListener);
    }

    @Override
    public void removeListener(TRTrackerAnnouncerListener tRTrackerAnnouncerListener) {
        this.helper.removeListener(tRTrackerAnnouncerListener);
    }

    @Override
    public void setTrackerResponseCache(Map map) {
        this.helper.setTrackerResponseCache(map);
    }

    @Override
    public void removeFromTrackerResponseCache(String string, int n) {
        this.helper.removeFromTrackerResponseCache(string, n);
    }

    @Override
    public Map getTrackerResponseCache() {
        return this.helper.getTrackerResponseCache();
    }

    @Override
    public TrackerPeerSource getTrackerPeerSource(TOTorrentAnnounceURLSet tOTorrentAnnounceURLSet) {
        Debug.out("not implemented");
        return null;
    }

    @Override
    public TrackerPeerSource getCacheTrackerPeerSource() {
        Debug.out("not implemented");
        return null;
    }

    @Override
    public void generateEvidence(IndentWriter indentWriter) {
        indentWriter.println("DHT announce: " + (this.last_response == null ? "null" : this.last_response.getString()));
    }
}

