/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.impl.bt;

import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPositionManager;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPNetworkManager;
import com.aelitis.azureus.core.peermanager.utils.PeerClassifier;
import com.aelitis.azureus.core.tracker.TrackerPeerSource;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerException;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.client.DNSTracker;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerDataProvider;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerListener;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponse;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponsePeer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraper;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperFactory;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerHelper;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerImpl;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerResponseImpl;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerResponsePeerImpl;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerScraperResponseImpl;
import org.gudy.azureus2.core3.tracker.protocol.PRHelpers;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyAnnounce;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyAnnounce2;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyConnect;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyError;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestAnnounce;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestAnnounce2;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestConnect;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketTracker;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPTrackerCodecs;
import org.gudy.azureus2.core3.tracker.util.TRTrackerUtils;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.Timer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.clientid.ClientIDException;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResultPeer;
import org.gudy.azureus2.pluginsimpl.local.clientid.ClientIDManagerImpl;

public class TRTrackerBTAnnouncerImpl
implements TRTrackerAnnouncerHelper {
    public static final LogIDs LOGID = LogIDs.TRACKER;
    private static final int OVERRIDE_PERIOD = 10000;
    protected static Timer tracker_timer = new Timer("Tracker Timer", 32);
    public static String UDP_REALM = "UDP Tracker";
    private static int userMinInterval = 0;
    private static int userMaxNumwant = 100;
    private static boolean udpAnnounceEnabled = true;
    private static AEMonitor class_mon;
    private static Map tracker_report_map;
    private TOTorrent torrent;
    private TOTorrentAnnounceURLSet[] announce_urls;
    private TRTrackerAnnouncerImpl.Helper helper;
    private TimerEvent current_timer_event;
    private TimerEventPerformer timer_event_action;
    protected int tracker_state = 1;
    private String tracker_status_str = "";
    private TRTrackerAnnouncerResponseImpl last_response = null;
    private long last_update_time_secs;
    private long current_time_to_wait_secs;
    private boolean manual_control;
    private long tracker_interval;
    private long tracker_min_interval;
    private long min_interval = 0L;
    private int failure_added_time = 0;
    private long failure_time_last_updated = 0L;
    private boolean stopped;
    private boolean stopped_for_queue;
    private boolean completed;
    private boolean complete_reported = false;
    private boolean update_in_progress = false;
    private long rd_last_override = 0L;
    private int rd_override_percentage = 100;
    private long min_interval_override = 0L;
    private List trackerUrlLists;
    private URL lastUsedUrl;
    private URL lastAZTrackerCheckedURL;
    private HashWrapper torrent_hash;
    private String last_tracker_message;
    private String info_hash = "info_hash=";
    private byte[] tracker_peer_id;
    private String tracker_peer_id_str = "&peer_id=";
    private byte[] data_peer_id;
    private int announceCount;
    private int announceFailCount;
    private byte autoUDPprobeEvery = 1;
    private String tracker_id = "";
    private String ip_override;
    private String[] peer_networks;
    private TRTrackerAnnouncerDataProvider announce_data_provider;
    protected AEMonitor this_mon = new AEMonitor("TRTrackerBTAnnouncer");
    private boolean az_tracker;
    private boolean destroyed;

    public TRTrackerBTAnnouncerImpl(TOTorrent tOTorrent, TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray, String[] stringArray, boolean bl, TRTrackerAnnouncerImpl.Helper helper) throws TRTrackerAnnouncerException {
        this.torrent = tOTorrent;
        this.announce_urls = tOTorrentAnnounceURLSetArray;
        this.peer_networks = stringArray;
        this.manual_control = bl;
        this.helper = helper;
        this.constructTrackerUrlLists(true);
        try {
            this.data_peer_id = this.helper.getPeerID();
            this.tracker_peer_id = COConfigurationManager.getBooleanParameter("Tracker Separate Peer IDs") ? ClientIDManagerImpl.getSingleton().generatePeerID(this.torrent, true) : this.data_peer_id;
        }
        catch (ClientIDException clientIDException) {
            throw new TRTrackerAnnouncerException("TRTrackerAnnouncer: Peer ID generation fails", clientIDException);
        }
        try {
            this.torrent_hash = tOTorrent.getHashWrapper();
            this.info_hash = this.info_hash + URLEncoder.encode(new String(this.torrent_hash.getBytes(), "ISO-8859-1"), "ISO-8859-1").replaceAll("\\+", "%20");
            this.tracker_peer_id_str = this.tracker_peer_id_str + URLEncoder.encode(new String(this.tracker_peer_id, "ISO-8859-1"), "ISO-8859-1").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.log(new LogEvent((Object)this.torrent, LOGID, "URL encode fails", (Throwable)unsupportedEncodingException));
            throw new TRTrackerAnnouncerException("TRTrackerAnnouncer: URL encode fails");
        }
        catch (TOTorrentException tOTorrentException) {
            Logger.log(new LogEvent((Object)this.torrent, LOGID, "Torrent hash retrieval fails", (Throwable)tOTorrentException));
            throw new TRTrackerAnnouncerException("TRTrackerAnnouncer: URL encode fails");
        }
        this.timer_event_action = new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform(TimerEvent timerEvent2) {
                if (TRTrackerBTAnnouncerImpl.this.manual_control) {
                    TRTrackerBTAnnouncerImpl.this.requestUpdateSupport();
                    return;
                }
                long l = TRTrackerBTAnnouncerImpl.this.getErrorRetryInterval();
                try {
                    l = TRTrackerBTAnnouncerImpl.this.requestUpdateSupport();
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(TRTrackerBTAnnouncerImpl.this.torrent, LOGID, "Next tracker announce (unadjusted) will be in " + l + "s"));
                    }
                }
                finally {
                    TRTrackerBTAnnouncerImpl.this.current_time_to_wait_secs = l;
                    if (TRTrackerBTAnnouncerImpl.this.tracker_state != 4) {
                        try {
                            TRTrackerBTAnnouncerImpl.this.this_mon.enter();
                            if (timerEvent2.isCancelled()) {
                            } else {
                                l = TRTrackerBTAnnouncerImpl.this.getAdjustedSecsToWait();
                                if (Logger.isEnabled()) {
                                    Logger.log(new LogEvent(TRTrackerBTAnnouncerImpl.this.torrent, LOGID, "Next tracker announce (adjusted) will be in " + l + "s"));
                                }
                                long l2 = SystemTime.getCurrentTime() + l * 1000L;
                                if (TRTrackerBTAnnouncerImpl.this.current_timer_event != null && !TRTrackerBTAnnouncerImpl.this.current_timer_event.isCancelled()) {
                                    if (TRTrackerBTAnnouncerImpl.this.current_timer_event != timerEvent2 && TRTrackerBTAnnouncerImpl.this.current_timer_event.getWhen() < l2) {
                                        return;
                                    }
                                    TRTrackerBTAnnouncerImpl.this.current_timer_event.cancel();
                                }
                                if (!TRTrackerBTAnnouncerImpl.this.destroyed) {
                                    TRTrackerBTAnnouncerImpl.this.current_timer_event = tracker_timer.addEvent(l2, this);
                                }
                            }
                        }
                        finally {
                            TRTrackerBTAnnouncerImpl.this.this_mon.exit();
                        }
                    }
                }
            }
        };
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this.torrent, LOGID, "Tracker Announcer Created using url : " + this.trackerURLListToString()));
        }
    }

    public void cloneFrom(TRTrackerBTAnnouncerImpl tRTrackerBTAnnouncerImpl) {
        this.helper = tRTrackerBTAnnouncerImpl.helper;
        this.data_peer_id = tRTrackerBTAnnouncerImpl.data_peer_id;
        this.tracker_peer_id = tRTrackerBTAnnouncerImpl.tracker_peer_id;
        this.tracker_peer_id_str = tRTrackerBTAnnouncerImpl.tracker_peer_id_str;
        this.tracker_id = tRTrackerBTAnnouncerImpl.tracker_id;
        this.announce_data_provider = tRTrackerBTAnnouncerImpl.announce_data_provider;
    }

    protected long getAdjustedSecsToWait() {
        long l = this.current_time_to_wait_secs;
        if (this.last_response != null && this.last_response.getStatus() != 2) {
            if (this.last_response.getStatus() == 1) {
                if (this.failure_added_time < 900) {
                    this.failure_added_time = 900;
                }
                l = this.getErrorRetryInterval();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "MIN INTERVAL CALC: tracker reported error, adjusting to error retry interval"));
                }
            } else {
                l = this.getErrorRetryInterval();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "MIN INTERVAL CALC: tracker seems to be offline, adjusting to error retry interval"));
                }
            }
        } else {
            if (this.rd_override_percentage == 0) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "MIN INTERVAL CALC: override, perc = 0"));
                }
                return 60L;
            }
            if (this.rd_override_percentage != 100) {
                l = l * (long)this.rd_override_percentage / 100L;
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "MIN INTERVAL CALC: override, perc = " + this.rd_override_percentage));
                }
            }
            if (l < 60L) {
                l = 60L;
            }
            if (this.min_interval != 0L && l < this.min_interval) {
                float f = (float)this.min_interval / (float)this.current_time_to_wait_secs;
                int n = (int)((float)(this.min_interval - l) * f);
                l += (long)n;
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "MIN INTERVAL CALC: min_interval=" + this.min_interval + ", interval=" + this.current_time_to_wait_secs + ", orig=" + this.current_time_to_wait_secs + ", new=" + l + ", added=" + n + ", perc=" + f));
                }
            }
        }
        return l;
    }

    @Override
    public int getStatus() {
        return this.tracker_state;
    }

    @Override
    public String getStatusString() {
        return this.tracker_status_str;
    }

    @Override
    public TRTrackerAnnouncer getBestAnnouncer() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRefreshDelayOverrides(int n) {
        boolean bl;
        if (n > 100) {
            n = 100;
        } else if (n < 50) {
            n = 50;
        }
        long l = SystemTime.getCurrentTime();
        boolean bl2 = bl = this.rd_last_override > 0L && l - this.rd_last_override > 10000L;
        if (l < this.rd_last_override) {
            bl = true;
        }
        if (bl && this.rd_override_percentage != n) {
            try {
                this.this_mon.enter();
                this.rd_last_override = l;
                this.rd_override_percentage = n;
                if (this.current_timer_event != null && !this.current_timer_event.isCancelled()) {
                    long l2 = this.current_timer_event.getCreatedTime();
                    long l3 = this.current_timer_event.getWhen();
                    long l4 = this.getAdjustedSecsToWait();
                    long l5 = l2 + l4 * 1000L;
                    if (l5 != l3) {
                        this.current_timer_event.cancel();
                        if (!this.destroyed) {
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(this.torrent, LOGID, "Changed next tracker announce to " + l4 + "s via " + Debug.getStackTrace(true, false, 0, 3)));
                            }
                            this.current_timer_event = tracker_timer.addEvent(l2, l5, this.timer_event_action);
                        }
                    }
                }
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    @Override
    public boolean isUpdating() {
        return this.update_in_progress;
    }

    @Override
    public long getInterval() {
        return this.tracker_interval;
    }

    @Override
    public long getMinInterval() {
        return this.tracker_min_interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTimeUntilNextUpdate() {
        try {
            int n;
            this.this_mon.enter();
            if (this.current_timer_event == null) {
                int n2 = this.getErrorRetryInterval();
                return n2;
            }
            int n3 = n = (int)((this.current_timer_event.getWhen() - SystemTime.getCurrentTime()) / 1000L);
            return n3;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public int getLastUpdateTime() {
        return (int)this.last_update_time_secs;
    }

    @Override
    public void update(boolean bl) {
        long l;
        long l2 = SystemTime.getCurrentTime() / 1000L;
        if (l2 < this.last_update_time_secs) {
            bl = true;
        }
        long l3 = l = this.min_interval_override > 0L ? this.min_interval_override : 60L;
        if (this.manual_control || bl || l2 - this.last_update_time_secs >= l) {
            this.requestUpdate();
        }
    }

    @Override
    public void complete(boolean bl) {
        this.complete_reported = this.complete_reported || bl;
        this.completed = true;
        this.requestUpdate();
    }

    @Override
    public void stop(boolean bl) {
        this.stopped = true;
        this.stopped_for_queue = bl;
        this.requestUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestUpdate() {
        try {
            this.this_mon.enter();
            if (this.current_timer_event != null) {
                this.current_timer_event.cancel();
            }
            this.rd_last_override = SystemTime.getCurrentTime();
            if (!this.destroyed) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "Forcing tracker announce now via " + Debug.getStackTrace(true, false, 0, 3)));
                }
                this.current_timer_event = tracker_timer.addEvent(SystemTime.getCurrentTime(), this.timer_event_action);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long requestUpdateSupport() {
        boolean bl = true;
        try {
            try {
                this.this_mon.enter();
                if (this.update_in_progress || this.announce_data_provider == null) {
                    bl = false;
                    long l = this.getErrorRetryInterval();
                    return l;
                }
                this.update_in_progress = true;
            }
            finally {
                this.this_mon.exit();
            }
            this.last_update_time_secs = SystemTime.getCurrentTime() / 1000L;
            this.tracker_status_str = MessageText.getString("PeerManager.status.checking") + "...";
            TRTrackerAnnouncerResponseImpl tRTrackerAnnouncerResponseImpl = null;
            if (this.stopped) {
                if (this.tracker_state == 1 && !this.manual_control) {
                    this.tracker_state = 4;
                } else if (this.tracker_state != 4) {
                    tRTrackerAnnouncerResponseImpl = this.stopSupport();
                    this.tracker_state = tRTrackerAnnouncerResponseImpl.getStatus() == 2 ? 4 : 4;
                }
            } else if (this.tracker_state == 1) {
                tRTrackerAnnouncerResponseImpl = this.startSupport();
                if (tRTrackerAnnouncerResponseImpl.getStatus() == 2) {
                    this.tracker_state = 2;
                }
            } else if (this.completed) {
                if (!this.complete_reported) {
                    tRTrackerAnnouncerResponseImpl = this.completeSupport();
                    if (tRTrackerAnnouncerResponseImpl.getStatus() != 0) {
                        this.complete_reported = true;
                        this.tracker_state = 3;
                    }
                } else {
                    this.tracker_state = 3;
                    tRTrackerAnnouncerResponseImpl = this.updateSupport();
                }
            } else {
                tRTrackerAnnouncerResponseImpl = this.updateSupport();
            }
            if (tRTrackerAnnouncerResponseImpl != null) {
                int n = tRTrackerAnnouncerResponseImpl.getStatus();
                if (n == 0) {
                    this.tracker_status_str = MessageText.getString("PeerManager.status.offline");
                } else if (n == 1) {
                    this.tracker_status_str = MessageText.getString("PeerManager.status.error");
                    this.tracker_state = 1;
                } else if (this.announce_data_provider.isPeerSourceEnabled("Tracker")) {
                    this.tracker_status_str = MessageText.getString("PeerManager.status.ok");
                } else {
                    this.tracker_status_str = MessageText.getString("PeerManager.status.ps_disabled");
                    tRTrackerAnnouncerResponseImpl.setPeers(new TRTrackerAnnouncerResponsePeerImpl[0]);
                }
                String string = tRTrackerAnnouncerResponseImpl.getAdditionalInfo();
                if (string != null) {
                    this.tracker_status_str = this.tracker_status_str + " (" + string + ")";
                }
                this.last_response = tRTrackerAnnouncerResponseImpl;
                this.helper.informResponse(this, tRTrackerAnnouncerResponseImpl);
                long l = tRTrackerAnnouncerResponseImpl.getTimeToWait();
                return l;
            }
            this.tracker_status_str = "";
            long l = this.getErrorRetryInterval();
            return l;
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            long l = this.getErrorRetryInterval();
            return l;
        }
        finally {
            try {
                this.this_mon.enter();
                if (bl) {
                    this.update_in_progress = false;
                }
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    protected TRTrackerAnnouncerResponseImpl startSupport() {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this.torrent, LOGID, "Tracker Announcer is sending a start Request"));
        }
        return this.update("started");
    }

    protected TRTrackerAnnouncerResponseImpl completeSupport() {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this.torrent, LOGID, "Tracker Announcer is sending a completed Request"));
        }
        return this.update("completed");
    }

    protected TRTrackerAnnouncerResponseImpl stopSupport() {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this.torrent, LOGID, "Tracker Announcer is sending a stopped Request"));
        }
        return this.update("stopped");
    }

    protected TRTrackerAnnouncerResponseImpl updateSupport() {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this.torrent, LOGID, "Tracker Announcer is sending an update Request"));
        }
        return this.update("");
    }

    private TRTrackerAnnouncerResponseImpl update(String string) {
        TRTrackerAnnouncerResponseImpl tRTrackerAnnouncerResponseImpl = this.update2(string);
        TRTrackerAnnouncerResponsePeer[] tRTrackerAnnouncerResponsePeerArray = tRTrackerAnnouncerResponseImpl.getPeers();
        if (tRTrackerAnnouncerResponsePeerArray != null) {
            ArrayList<TRTrackerAnnouncerResponsePeer> arrayList = new ArrayList<TRTrackerAnnouncerResponsePeer>();
            for (int i = 0; i < tRTrackerAnnouncerResponsePeerArray.length; ++i) {
                TRTrackerAnnouncerResponsePeer tRTrackerAnnouncerResponsePeer = tRTrackerAnnouncerResponsePeerArray[i];
                if (this.peer_networks == null) {
                    arrayList.add(tRTrackerAnnouncerResponsePeer);
                    continue;
                }
                String string2 = tRTrackerAnnouncerResponsePeer.getAddress();
                String string3 = AENetworkClassifier.categoriseAddress(string2);
                boolean bl = false;
                for (int j = 0; j < this.peer_networks.length; ++j) {
                    if (this.peer_networks[j] != string3) continue;
                    arrayList.add(tRTrackerAnnouncerResponsePeer);
                    bl = true;
                    break;
                }
                if (bl || !Logger.isEnabled()) continue;
                Logger.log(new LogEvent((Object)this.torrent, LOGID, 1, "Tracker Announcer dropped peer '" + string2 + "' as incompatible " + "with network selection"));
            }
            tRTrackerAnnouncerResponsePeerArray = new TRTrackerAnnouncerResponsePeer[arrayList.size()];
            arrayList.toArray(tRTrackerAnnouncerResponsePeerArray);
            tRTrackerAnnouncerResponseImpl.setPeers(tRTrackerAnnouncerResponsePeerArray);
        }
        return tRTrackerAnnouncerResponseImpl;
    }

    private TRTrackerAnnouncerResponseImpl update2(String string) {
        TRTrackerAnnouncerResponsePeer[] tRTrackerAnnouncerResponsePeerArray;
        int n;
        TRTrackerAnnouncerResponseImpl tRTrackerAnnouncerResponseImpl = null;
        String string2 = null;
        block5: for (n = 0; n < this.trackerUrlLists.size(); ++n) {
            tRTrackerAnnouncerResponsePeerArray = (TRTrackerAnnouncerResponsePeer[])this.trackerUrlLists.get(n);
            for (int i = 0; i < tRTrackerAnnouncerResponsePeerArray.size(); ++i) {
                URL uRL = (URL)tRTrackerAnnouncerResponsePeerArray.get(i);
                if (string2 != null && string2.equals(uRL.getHost())) {
                    if (!Logger.isEnabled()) continue;
                    Logger.log(new LogEvent((Object)this.torrent, LOGID, 1, "Tracker Announcer is ignoring '" + uRL + "' as already received overloaded response from this host"));
                    continue;
                }
                this.lastUsedUrl = uRL;
                if (this.lastUsedUrl != this.lastAZTrackerCheckedURL) {
                    this.az_tracker = TRTrackerUtils.isAZTracker(this.lastUsedUrl);
                }
                URL uRL2 = null;
                if (tRTrackerAnnouncerResponseImpl != null) {
                    this.helper.informResponse(this, tRTrackerAnnouncerResponseImpl);
                }
                try {
                    uRL2 = this.constructUrl(string, uRL);
                    URL[] uRLArray = new URL[]{uRL};
                    byte[] byArray = this.updateOld(uRLArray, uRL2);
                    this.lastUsedUrl = uRLArray[0];
                    TRTrackerAnnouncerResponseImpl tRTrackerAnnouncerResponseImpl2 = this.decodeTrackerResponse(this.lastUsedUrl, byArray);
                    int n2 = tRTrackerAnnouncerResponseImpl2.getStatus();
                    if (n2 == 2) {
                        try {
                            if (!uRL.toString().equals(this.lastUsedUrl.toString())) {
                                if (Logger.isEnabled()) {
                                    Logger.log(new LogEvent(this.torrent, LOGID, "announce url permanently redirected: old = " + uRL + ", new = " + this.lastUsedUrl));
                                }
                                TorrentUtils.replaceAnnounceURL(this.torrent, uRL, this.lastUsedUrl);
                            }
                        }
                        catch (Throwable throwable) {
                            Debug.printStackTrace(throwable);
                        }
                        tRTrackerAnnouncerResponsePeerArray.remove(i);
                        tRTrackerAnnouncerResponsePeerArray.add(0, this.lastUsedUrl);
                        this.trackerUrlLists.remove(n);
                        this.trackerUrlLists.add(0, tRTrackerAnnouncerResponsePeerArray);
                        this.informURLChange(uRL, this.lastUsedUrl, false);
                        return tRTrackerAnnouncerResponseImpl2;
                    }
                    if (n2 == 1) {
                        tRTrackerAnnouncerResponseImpl = tRTrackerAnnouncerResponseImpl2;
                        String string3 = tRTrackerAnnouncerResponseImpl2.getAdditionalInfo();
                        if (string3 != null && (string3.indexOf("too many seeds") != -1 || string3.indexOf("too many peers") != -1)) {
                            string2 = uRL.getHost();
                        }
                    } else {
                        ++this.announceFailCount;
                        tRTrackerAnnouncerResponseImpl = tRTrackerAnnouncerResponseImpl2;
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    ++this.announceFailCount;
                    Debug.printStackTrace(malformedURLException);
                    tRTrackerAnnouncerResponseImpl = new TRTrackerAnnouncerResponseImpl(uRL, this.torrent_hash, 0, (long)this.getErrorRetryInterval(), "malformed URL '" + (uRL2 == null ? "<null>" : uRL2.toString()) + "'");
                }
                catch (Throwable throwable) {
                    ++this.announceFailCount;
                    tRTrackerAnnouncerResponseImpl = new TRTrackerAnnouncerResponseImpl(uRL, this.torrent_hash, 0, (long)this.getErrorRetryInterval(), throwable.getMessage() == null ? throwable.toString() : throwable.getMessage());
                }
                if (this.destroyed) break block5;
            }
        }
        if (tRTrackerAnnouncerResponseImpl == null) {
            tRTrackerAnnouncerResponseImpl = new TRTrackerAnnouncerResponseImpl(null, this.torrent_hash, 0, (long)this.getErrorRetryInterval(), "Reason Unknown");
        }
        if ((tRTrackerAnnouncerResponsePeerArray = this.helper.getPeersFromCache(n = this.calculateNumWant() * 4)).length > 0) {
            tRTrackerAnnouncerResponseImpl.setPeers(tRTrackerAnnouncerResponsePeerArray);
        }
        return tRTrackerAnnouncerResponseImpl;
    }

    private byte[] updateOld(URL[] uRLArray, URL uRL) throws Exception {
        uRL = DNSTracker.fixTrackerURL(uRL);
        boolean bl = true;
        try {
            TorrentUtils.setTLSTorrentHash(this.torrent_hash);
            for (int i = 0; i < 2; ++i) {
                URL uRL2;
                String string;
                String string2;
                block30: {
                    string2 = null;
                    string = uRL.getProtocol();
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(this.torrent, LOGID, "Tracker Announcer is Requesting: " + uRL));
                    }
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    uRL2 = null;
                    boolean bl2 = false;
                    if (string.equalsIgnoreCase("udp") && udpAnnounceEnabled) {
                        uRL2 = uRL;
                    } else if (string.equalsIgnoreCase("http") && !this.az_tracker && this.announceCount % this.autoUDPprobeEvery == 0 && udpAnnounceEnabled && (!this.stopped && this.announceCount != 0 && (this.announceCount >= this.trackerUrlLists.size() || this.announceFailCount != this.announceCount) || TRTrackerUtils.isUDPProbeOK(uRL))) {
                        uRL2 = new URL(uRL.toString().replaceFirst("^http", "udp"));
                        bl2 = true;
                    }
                    if (uRL2 != null) {
                        string2 = this.announceUDP(uRL, byteArrayOutputStream, bl2);
                        if ((string2 != null || byteArrayOutputStream.size() == 0) && bl2) {
                            uRL2 = null;
                            if (this.autoUDPprobeEvery < 16) {
                                this.autoUDPprobeEvery = (byte)(this.autoUDPprobeEvery << 1);
                            } else {
                                TRTrackerUtils.setUDPProbeResult(uRL, false);
                            }
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent((Object)this.torrent, LOGID, 0, "redirection of http announce [" + uRLArray[0] + "] to udp failed, will retry in " + this.autoUDPprobeEvery + " announces"));
                            }
                        } else if (string2 == null && bl2) {
                            TRTrackerUtils.setUDPProbeResult(uRL, true);
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent((Object)this.torrent, LOGID, 0, "redirection of http announce [" + uRLArray[0] + "] to udp successful"));
                            }
                            this.autoUDPprobeEvery = 1;
                        }
                    }
                    ++this.announceCount;
                    if (uRL2 == null) {
                        string2 = this.announceHTTP(uRLArray, uRL, byteArrayOutputStream);
                    }
                    if (byteArrayOutputStream.size() <= 0) break block30;
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    return byArray;
                }
                try {
                    if (string2 == null) {
                        string2 = "No data received from tracker";
                    }
                }
                catch (SSLException sSLException) {
                    if (i == 0) {
                        if (SESecurityManager.installServerCertificates(uRL) != null) continue;
                        string2 = this.exceptionToString(sSLException);
                    } else {
                        string2 = this.exceptionToString(sSLException);
                    }
                }
                catch (IOException iOException) {
                    if (iOException instanceof UnknownHostException) {
                        bl = false;
                    }
                    if (i == 0 && string.toLowerCase().startsWith("http") && (uRL2 = UrlUtils.getIPV4Fallback(uRL)) != null) {
                        uRL = uRL2;
                        continue;
                    }
                    string2 = this.exceptionToString(iOException);
                }
                catch (Exception exception) {
                    string2 = this.exceptionToString(exception);
                }
                if (string2 != null && string2.indexOf("401") != -1) {
                    string2 = "Tracker authentication failed";
                    bl = false;
                }
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent((Object)this.torrent, LOGID, bl ? 3 : 1, "Exception while processing the Tracker Request for " + uRL + ": " + string2));
                }
                throw new Exception(string2);
            }
            throw new Exception("Internal Error: should never get here");
        }
        finally {
            TorrentUtils.setTLSTorrentHash(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String announceHTTP(URL[] uRLArray, URL uRL, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        Object object;
        Object object2;
        TRTrackerUtils.checkForBlacklistedURLs(uRL);
        URL uRL2 = TRTrackerUtils.adjustURLForHosting(uRL);
        uRL2 = AddressUtils.adjustURL(uRL2);
        if (uRL2 != uRL && Logger.isEnabled()) {
            Logger.log(new LogEvent(this.torrent, LOGID, "    HTTP: url adjusted to " + uRL2));
        }
        String string = null;
        Properties properties = new Properties();
        properties.put("URL", uRL2);
        try {
            ClientIDManagerImpl.getSingleton().generateHTTPProperties(properties);
        }
        catch (ClientIDException clientIDException) {
            throw new IOException(clientIDException.getMessage());
        }
        uRL2 = (URL)properties.get("URL");
        if (uRL2.getProtocol().equalsIgnoreCase("https")) {
            object2 = (HttpsURLConnection)uRL2.openConnection();
            ((HttpsURLConnection)object2).setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String string, SSLSession sSLSession) {
                    return true;
                }
            });
            object = object2;
        } else {
            object = (HttpURLConnection)uRL2.openConnection();
        }
        object2 = (String)properties.get("User-Agent");
        if (object2 != null) {
            ((URLConnection)object).setRequestProperty("User-Agent", (String)object2);
        }
        ((URLConnection)object).setRequestProperty("Connection", "close");
        ((URLConnection)object).addRequestProperty("Accept-Encoding", "gzip");
        try {
            ((URLConnection)object).connect();
            InputStream inputStream = null;
            try {
                String string2;
                int n;
                inputStream = ((URLConnection)object).getInputStream();
                String string3 = ((URLConnection)object).getURL().toString();
                if (!uRL2.toString().equals(string3) && (n = string3.indexOf(string2 = "permredirect=1")) != -1) {
                    --n;
                    try {
                        URL uRL3;
                        uRLArray[0] = uRL3 = new URL(string3.substring(0, n));
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
                int n2 = n = (string2 = ((URLConnection)object).getHeaderField("content-encoding")) != null && string2.equalsIgnoreCase("gzip") ? 1 : 0;
                if (n != 0) {
                    inputStream = new GZIPInputStream(inputStream);
                }
                int n3 = -1;
                byte[] byArray = new byte[1024];
                int n4 = 0;
                while (n3 <= 0 || n4 < n3) {
                    try {
                        int n5 = inputStream.read(byArray);
                        if (n5 > 0) {
                            byteArrayOutputStream.write(byArray, 0, n5);
                            if ((n4 += n5) <= 131072) continue;
                            byteArrayOutputStream.reset();
                            throw new Exception("Tracker response invalid (too large)");
                        }
                        if (n5 != 0) break;
                        Thread.sleep(20L);
                    }
                    catch (Exception exception) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent((Object)this.torrent, LOGID, "Exception while Requesting Tracker", (Throwable)exception));
                            Logger.log(new LogEvent((Object)this.torrent, LOGID, 3, "Message Received was : " + byteArrayOutputStream));
                        }
                        string = this.exceptionToString(exception);
                        break;
                    }
                }
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "Tracker Announcer [" + this.lastUsedUrl + "] has received : " + byteArrayOutputStream));
                }
            }
            catch (Exception exception) {
                string = this.exceptionToString(exception);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                    inputStream = null;
                }
            }
        }
        finally {
            ((HttpURLConnection)object).disconnect();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String announceUDP(URL var1_1, ByteArrayOutputStream var2_2, boolean var3_3) throws IOException {
        var4_4 = var3_3 != false ? 10000L : 30000L;
        var6_5 = TRTrackerUtils.adjustURLForHosting(var1_1);
        if (var6_5 != var1_1 && Logger.isEnabled()) {
            Logger.log(new LogEvent(this.torrent, TRTrackerBTAnnouncerImpl.LOGID, "    UDP: url adjusted to " + var6_5));
        }
        var7_6 = null;
        var8_7 = null;
        try {
            if (!var3_3 && UrlUtils.queryHasParameter(var6_5.getQuery(), "auth", false)) {
                var8_7 = SESecurityManager.getPasswordAuthentication(TRTrackerBTAnnouncerImpl.UDP_REALM, var6_5);
            }
            var9_8 = PRUDPPacketHandlerFactory.getHandler(UDPNetworkManager.getSingleton().getUDPNonDataListeningPortNumber());
            var10_10 = new InetSocketAddress(var6_5.getHost(), var6_5.getPort() == -1 ? 80 : var6_5.getPort());
            var9_8 = var9_8.openSession(var10_10);
            try {
                var11_11 = 0;
lbl15:
                // 2 sources

                while (var11_11 < 1) {
                    try {
                        var12_12 = new PRUDPPacketRequestConnect();
                        var13_14 = var9_8.sendAndReceive(var8_7, var12_12, var10_10, var4_4);
                        if (var13_14.getAction() != 0) ** GOTO lbl132
                        var14_15 = (PRUDPPacketReplyConnect)var13_14;
                        var15_16 = var14_15.getConnectionId();
                        if (PRUDPPacketTracker.VERSION == 1) {
                            var18_18 = new PRUDPPacketRequestAnnounce(var15_16);
                            var17_17 = var18_18;
                            var19_19 = var6_5.toString();
                            var20_20 = var19_19.indexOf("?");
                            var19_19 = var19_19.substring(var20_20 + 1);
                            var21_23 = this.getURLParam((String)var19_19, "event");
                            var22_24 = 0;
                            if (var21_23 != null) {
                                if (var21_23.equals("started")) {
                                    var22_24 = 2;
                                } else if (var21_23.equals("stopped")) {
                                    var22_24 = 3;
                                } else if (var21_23.equals("completed")) {
                                    var22_24 = 1;
                                }
                            }
                            var23_27 = this.getURLParam((String)var19_19, "ip");
                            var24_32 = 0;
                            if (var23_27 != null) {
                                var24_32 = PRHelpers.addressToInt(var23_27);
                            }
                            var18_18.setDetails(this.torrent_hash.getBytes(), this.tracker_peer_id, this.getLongURLParam((String)var19_19, "downloaded"), var22_24, var24_32, (int)this.getLongURLParam((String)var19_19, "numwant"), this.getLongURLParam((String)var19_19, "left"), (short)this.getLongURLParam((String)var19_19, "port"), this.getLongURLParam((String)var19_19, "uploaded"));
                        } else {
                            var18_18 = new PRUDPPacketRequestAnnounce2(var15_16);
                            var17_17 = var18_18;
                            var19_19 = var6_5.toString();
                            var20_20 = var19_19.indexOf("?");
                            var19_19 = var19_19.substring(var20_20 + 1);
                            var21_23 = this.getURLParam((String)var19_19, "event");
                            var22_24 = 0;
                            if (var21_23 != null) {
                                if (var21_23.equals("started")) {
                                    var22_24 = 2;
                                } else if (var21_23.equals("stopped")) {
                                    var22_24 = 3;
                                } else if (var21_23.equals("completed")) {
                                    var22_24 = 1;
                                }
                            }
                            var23_27 = this.getURLParam((String)var19_19, "ip");
                            var24_32 = 0;
                            if (var23_27 != null) {
                                var24_32 = PRHelpers.addressToInt(var23_27);
                            }
                            var18_18.setDetails(this.torrent_hash.getBytes(), this.tracker_peer_id, this.getLongURLParam((String)var19_19, "downloaded"), var22_24, var24_32, this.helper.getUDPKey(), (int)this.getLongURLParam((String)var19_19, "numwant"), this.getLongURLParam((String)var19_19, "left"), (short)this.getLongURLParam((String)var19_19, "port"), this.getLongURLParam((String)var19_19, "uploaded"));
                        }
                        var13_14 = var9_8.sendAndReceive(var8_7, var17_17, var10_10);
                        if (var13_14.getAction() != 1) ** GOTO lbl-1000
                        if (var8_7 != null) {
                            SESecurityManager.setPasswordAuthenticationOutcome(TRTrackerBTAnnouncerImpl.UDP_REALM, var6_5, true);
                        }
                        if (PRUDPPacketTracker.VERSION != 1) ** GOTO lbl-1000
                        var18_18 = (PRUDPPacketReplyAnnounce)var13_14;
                        var19_19 = new HashMap<K, V>();
                        var19_19.put("interval", new Long(var18_18.getInterval()));
                        var20_21 = var18_18.getAddresses();
                        var21_23 = var18_18.getPorts();
                        var22_25 = new ArrayList<HashMap<K, V>>();
                        var19_19.put("peers", (Long)var22_25);
                        for (var23_28 = 0; var23_28 < var20_21.length; ++var23_28) {
                            var24_34 = new HashMap<String, Object>();
                            var22_25.add(var24_34);
                            var24_34.put("ip", PRHelpers.intToAddress(var20_21[var23_28]).getBytes());
                            var24_34.put("port", new Long((long)var21_23[var23_28]));
                        }
                        var23_29 = BEncoder.encode(var19_19);
                        var2_2.write(var23_29);
                        var24_35 = null;
                        ** GOTO lbl101
                    }
                    catch (PRUDPPacketHandlerException var12_13) {
                        if (var12_13.getMessage() == null || var12_13.getMessage().indexOf("timed out") == -1) {
                            throw var12_13;
                        }
                        ** GOTO lbl133
                    }
                }
                ** GOTO lbl136
            }
            catch (Throwable var25_38) {
                block33: {
                    var9_8.closeSession();
                    throw var25_38;
lbl101:
                    // 1 sources

                    var9_8.closeSession();
                    return var24_35;
lbl-1000:
                    // 1 sources

                    {
                        var18_18 = (PRUDPPacketReplyAnnounce2)var13_14;
                        var19_19 = new HashMap<String, Long>();
                        var19_19.put("interval", new Long(var18_18.getInterval()));
                        var20_22 = var18_18.getAddresses();
                        var21_23 = var18_18.getPorts();
                        var19_19.put("complete", new Long(var18_18.getSeeders()));
                        var19_19.put("incomplete", new Long(var18_18.getLeechers()));
                        var22_26 = new ArrayList<HashMap<K, V>>();
                        var19_19.put("peers", (Long)var22_26);
                        for (var23_30 = 0; var23_30 < var20_22.length; ++var23_30) {
                            var24_36 = new HashMap<String, Object>();
                            var22_26.add(var24_36);
                            var24_36.put("ip", PRHelpers.intToAddress(var20_22[var23_30]).getBytes());
                            var24_36.put("port", new Long((long)var21_23[var23_30]));
                        }
                        var23_31 = BEncoder.encode(var19_19);
                        var2_2.write(var23_31);
                        var24_37 = null;
                    }
                    var9_8.closeSession();
                    return var24_37;
lbl-1000:
                    // 1 sources

                    {
                        var7_6 = ((PRUDPPacketReplyError)var13_14).getMessage();
                        break block33;
lbl132:
                        // 1 sources

                        var7_6 = ((PRUDPPacketReplyError)var13_14).getMessage();
                    }
                }
                ++var11_11;
                ** GOTO lbl15
lbl136:
                // 1 sources

                var9_8.closeSession();
            }
        }
        catch (Throwable var9_9) {
            var7_6 = this.exceptionToString(var9_9);
        }
        if (var8_7 != null) {
            SESecurityManager.setPasswordAuthenticationOutcome(TRTrackerBTAnnouncerImpl.UDP_REALM, var6_5, false);
        }
        return var7_6;
    }

    protected long getLongURLParam(String string, String string2) {
        String string3 = this.getURLParam(string, string2);
        if (string3 == null) {
            return 0L;
        }
        return Long.parseLong(string3);
    }

    protected String getURLParam(String string, String string2) {
        int n = string.indexOf(string2 + "=");
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf("&", n);
        if (n2 == -1) {
            return string.substring(n + string2.length() + 1);
        }
        return string.substring(n + string2.length() + 1, n2);
    }

    protected String exceptionToString(Throwable throwable) {
        String string;
        String string2 = throwable.getClass().getName();
        int n = string2.lastIndexOf(46);
        if (n != -1) {
            string2 = string2.substring(n + 1);
        }
        if ((string = string2 + ":" + throwable.getMessage()).indexOf("timed out") != -1) {
            string = "timeout";
        }
        return string;
    }

    public URL constructUrl(String string, URL uRL) throws Exception {
        String string2;
        Object object;
        boolean bl;
        String string3 = uRL.toString();
        StringBuffer stringBuffer = new StringBuffer(string3);
        if (string3.indexOf(63) != -1) {
            stringBuffer.append('&');
        } else {
            stringBuffer.append('?');
        }
        stringBuffer.append(this.info_hash);
        stringBuffer.append(this.tracker_peer_id_str);
        String string4 = this.announce_data_provider.getCryptoLevel() == 1 ? TRTrackerUtils.getPortsForURLFullCrypto() : TRTrackerUtils.getPortsForURL();
        stringBuffer.append(string4);
        stringBuffer.append("&uploaded=").append(this.announce_data_provider.getTotalSent());
        stringBuffer.append("&downloaded=").append(this.announce_data_provider.getTotalReceived());
        if (Constants.DOWNLOAD_SOURCES_PRETEND_COMPLETE) {
            stringBuffer.append("&left=0");
        } else {
            stringBuffer.append("&left=").append(this.announce_data_provider.getRemaining());
        }
        stringBuffer.append("&corrupt=").append(this.announce_data_provider.getFailedHashCheck());
        if (this.tracker_id.length() > 0) {
            stringBuffer.append("&trackerid=").append(this.tracker_id);
        }
        if (string.length() != 0) {
            stringBuffer.append("&event=").append(string);
        }
        if (bl = string.equals("stopped")) {
            stringBuffer.append("&numwant=0");
            if (this.stopped_for_queue) {
                stringBuffer.append("&azq=1");
            }
        } else {
            int n = Math.min(this.calculateNumWant(), userMaxNumwant);
            stringBuffer.append("&numwant=").append(n);
        }
        stringBuffer.append("&no_peer_id=1");
        stringBuffer.append("&compact=1");
        String string5 = COConfigurationManager.getStringParameter("Override Ip", "");
        String string6 = null;
        String string7 = AENetworkClassifier.categoriseAddress(uRL.getHost());
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.peer_networks == null) {
            bl2 = true;
            bl3 = true;
        } else {
            for (int i = 0; i < this.peer_networks.length; ++i) {
                if (this.peer_networks[i] == "Public") {
                    bl3 = true;
                }
                if (this.peer_networks[i] != string7) continue;
                bl2 = true;
            }
        }
        if (!bl2) {
            throw new Exception("Network not enabled for url '" + uRL + "'");
        }
        String string8 = null;
        if (string5.length() > 0) {
            object = new StringTokenizer(string5, ";");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string9 = ((StringTokenizer)object).nextToken().trim();
                if (string9.length() <= 0) continue;
                string2 = AENetworkClassifier.categoriseAddress(string9);
                if (string2 == "Public") {
                    string8 = string9;
                }
                if (string7 != string2) continue;
                string6 = string9;
                break;
            }
        }
        if (string6 == null) {
            if (bl3 && string8 != null) {
                string6 = string8;
            } else if (this.ip_override != null) {
                string6 = this.ip_override;
            }
        }
        if (string6 != null) {
            block34: {
                if (string7 == "Public") {
                    try {
                        string6 = PRHelpers.DNSToIPAddress(string6);
                    }
                    catch (UnknownHostException unknownHostException) {
                        if (!Logger.isEnabled()) break block34;
                        Logger.log(new LogEvent((Object)this.torrent, LOGID, 3, "IP Override host resolution of '" + string6 + "' fails, using unresolved address"));
                    }
                }
            }
            stringBuffer.append("&ip=").append(string6);
        }
        if (COConfigurationManager.getBooleanParameter("Tracker Key Enable Client", true)) {
            stringBuffer.append("&key=").append(this.helper.getTrackerKey());
        }
        if ((object = this.announce_data_provider.getExtensions()) != null) {
            while (((String)object).startsWith("&")) {
                object = ((String)object).substring(1);
            }
            stringBuffer.append("&");
            stringBuffer.append((String)object);
        }
        stringBuffer.append("&azver=3");
        if (this.az_tracker && !bl) {
            DHTNetworkPosition dHTNetworkPosition;
            int n = this.announce_data_provider.getUploadSpeedKBSec(string.equals("started"));
            if (n > 0) {
                stringBuffer.append("&azup=" + n);
            }
            if ((string2 = NetworkAdmin.getSingleton().getCurrentASN().getAS()).length() > 0) {
                stringBuffer.append("&azas=" + URLEncoder.encode(string2, "UTF8"));
            }
            if ((dHTNetworkPosition = DHTNetworkPositionManager.getBestLocalPosition()) != null) {
                try {
                    byte[] byArray = DHTNetworkPositionManager.serialisePosition(dHTNetworkPosition);
                    stringBuffer.append("&aznp=" + Base32.encode(byArray));
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
        return new URL(stringBuffer.toString());
    }

    protected int calculateNumWant() {
        if (!this.announce_data_provider.isPeerSourceEnabled("Tracker")) {
            return 0;
        }
        int n = 100;
        int n2 = 3 * this.announce_data_provider.getMaxNewConnectionsAllowed() / 2;
        if (n2 < 0 || n2 > n) {
            n2 = n;
        }
        return n2;
    }

    @Override
    public byte[] getPeerId() {
        return this.data_peer_id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAnnounceDataProvider(TRTrackerAnnouncerDataProvider tRTrackerAnnouncerDataProvider) {
        try {
            this.this_mon.enter();
            this.announce_data_provider = tRTrackerAnnouncerDataProvider;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public TOTorrent getTorrent() {
        return this.torrent;
    }

    @Override
    public URL getTrackerURL() {
        return this.lastUsedUrl;
    }

    @Override
    public void setTrackerURL(URL uRL) {
        try {
            uRL = new URL(uRL.toString().replaceAll(" ", ""));
            ArrayList<URL> arrayList = new ArrayList<URL>(1);
            arrayList.add(uRL);
            this.trackerUrlLists.clear();
            this.trackerUrlLists.add(arrayList);
            this.informURLChange(this.lastUsedUrl, uRL, true);
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    @Override
    public void setAnnounceSets(TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray) {
        this.announce_urls = tOTorrentAnnounceURLSetArray;
    }

    @Override
    public TOTorrentAnnounceURLSet[] getAnnounceSets() {
        return this.announce_urls;
    }

    @Override
    public void resetTrackerUrl(boolean bl) {
        String string = this.trackerURLListToString();
        this.constructTrackerUrlLists(bl);
        if (this.trackerUrlLists.size() == 0) {
            return;
        }
        if (!string.equals(this.trackerURLListToString())) {
            URL uRL = (URL)((List)this.trackerUrlLists.get(0)).get(0);
            this.informURLChange(this.lastUsedUrl, uRL, true);
        }
    }

    @Override
    public void refreshListeners() {
        this.informURLRefresh();
    }

    @Override
    public void setIPOverride(String string) {
        this.ip_override = string;
    }

    @Override
    public void clearIPOverride() {
        this.ip_override = null;
    }

    private void constructTrackerUrlLists(boolean bl) {
        try {
            this.trackerUrlLists = new ArrayList(1);
            if (this.announce_urls.length == 0) {
                URL uRL = this.torrent.getAnnounceURL();
                ArrayList<URL> arrayList = new ArrayList<URL>();
                arrayList.add(uRL);
                this.trackerUrlLists.add(arrayList);
            } else {
                for (int i = 0; i < this.announce_urls.length; ++i) {
                    URL[] uRLArray = this.announce_urls[i].getAnnounceURLs();
                    ArrayList<URL> arrayList = new ArrayList<URL>();
                    for (int j = 0; j < uRLArray.length; ++j) {
                        URL uRL = uRLArray[j];
                        int n = bl ? (int)(Math.random() * (double)(arrayList.size() + 1)) : j;
                        arrayList.add(n, uRL);
                    }
                    this.trackerUrlLists.add(arrayList);
                }
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
        }
    }

    protected String trackerURLListToString() {
        String string = "[";
        for (int i = 0; i < this.trackerUrlLists.size(); ++i) {
            List list = (List)this.trackerUrlLists.get(i);
            string = string + (i == 0 ? "" : ",") + "[";
            for (int j = 0; j < list.size(); ++j) {
                URL uRL = (URL)list.get(j);
                string = string + (j == 0 ? "" : ",") + uRL.toString();
            }
            string = string + "]";
        }
        string = string + "]";
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TRTrackerAnnouncerResponseImpl decodeTrackerResponse(URL uRL, byte[] byArray) {
        String string;
        if (byArray == null) {
            string = "no response";
        } else {
            try {
                try {
                    int n;
                    int n2;
                    int n3;
                    int n4;
                    ArrayList arrayList;
                    boolean bl;
                    byte[] byArray2;
                    Long l;
                    long l2;
                    Object object;
                    Map map;
                    block100: {
                        Object object2;
                        Object object3;
                        map = BDecoder.decode(byArray);
                        Object v = map.get("az_ps");
                        if (v instanceof List) {
                            object3 = (List)v;
                            object2 = new ArrayList();
                            for (int i = 0; i < object3.size(); ++i) {
                                object = object3.get(i);
                                if (!(object instanceof byte[])) continue;
                                object2.add(new String((byte[])object));
                            }
                            String[] stringArray = new String[object2.size()];
                            object2.toArray(stringArray);
                            this.announce_data_provider.setPeerSources(stringArray);
                        }
                        try {
                            object3 = (byte[])map.get("warning message");
                            if (object3 == null || !COConfigurationManager.getBooleanParameter("Tracker Client Show Warnings") || ((String)(object2 = new String((byte[])object3))).equals(this.last_tracker_message)) break block100;
                            this.last_tracker_message = object2;
                            boolean bl2 = false;
                            try {
                                class_mon.enter();
                                object = (String)tracker_report_map.get(uRL.getHost());
                                if (object == null || !((String)object2).equals(object)) {
                                    bl2 = true;
                                    tracker_report_map.put(uRL.getHost(), object2);
                                }
                            }
                            finally {
                                class_mon.exit();
                            }
                            if (bl2) {
                                Logger.logTextResource(new LogAlert((Object)this.torrent, false, 1, "TrackerClient.announce.warningmessage"), new String[]{this.announce_data_provider.getName(), object2});
                            }
                        }
                        catch (Throwable throwable) {
                            Debug.printStackTrace(throwable);
                        }
                    }
                    try {
                        this.tracker_interval = l2 = ((Long)map.get("interval")).longValue();
                        l = (Long)map.get("min interval");
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent((Object)this.torrent, LOGID, 0, "Received from announce: 'interval' = " + l2 + "; 'min interval' = " + l));
                        }
                        if (l2 < 0L || l2 > 0xFFFFFFFFL) {
                            l2 = 0xFFFFFFFFL;
                        }
                        if (l != null) {
                            this.tracker_min_interval = this.min_interval = l.longValue();
                            if (this.min_interval < 1L) {
                                if (Logger.isEnabled()) {
                                    Logger.log(new LogEvent((Object)this.torrent, LOGID, 0, "Tracker being silly and returning a 'min interval' of less than 1 second (" + this.min_interval + ")"));
                                }
                                this.min_interval = 0L;
                            } else if (this.min_interval > l2) {
                                if (Logger.isEnabled()) {
                                    Logger.log(new LogEvent((Object)this.torrent, LOGID, 0, "Tracker being silly and returning a 'min interval' (" + this.min_interval + ") greater than recommended announce 'interval'" + " (" + l2 + ")"));
                                }
                                this.min_interval = 0L;
                            }
                        } else {
                            long l3 = this.min_interval = l2 > 30L ? l2 - 10L : l2;
                        }
                        if (userMinInterval != 0) {
                            l2 = Math.max((long)userMinInterval, l2);
                            this.min_interval = Math.max(this.min_interval, (long)userMinInterval);
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent((Object)this.torrent, LOGID, 0, "Overriding with user settings: 'interval' = " + l2 + "; 'min interval' = " + this.min_interval));
                            }
                        }
                        if (l2 > 30L) {
                            l2 -= 10L;
                        }
                    }
                    catch (Exception exception) {
                        object = (byte[])map.get("failure reason");
                        if (object == null) {
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent((Object)this.torrent, LOGID, 1, "Problems with Tracker, will retry in " + this.getErrorRetryInterval() + "ms"));
                            }
                            return new TRTrackerAnnouncerResponseImpl(uRL, this.torrent_hash, 0, (long)this.getErrorRetryInterval(), "Unknown cause");
                        }
                        String string2 = new String((byte[])object, "UTF8");
                        return new TRTrackerAnnouncerResponseImpl(uRL, this.torrent_hash, 1, (long)this.getErrorRetryInterval(), string2);
                    }
                    l = this.getLong(map, "incomplete");
                    object = this.getLong(map, "complete");
                    Long l4 = this.getLong(map, "downloaded");
                    if ((l != null || object != null) && Logger.isEnabled()) {
                        Logger.log(new LogEvent(this.torrent, LOGID, "ANNOUNCE SCRAPE1: seeds=" + object + " peers=" + l));
                    }
                    if ((byArray2 = (byte[])map.get("tracker id")) != null) {
                        this.tracker_id = new String(byArray2);
                    }
                    byte[] byArray3 = (byte[])map.get("crypto_flags");
                    ArrayList<TRTrackerAnnouncerResponsePeerImpl> arrayList2 = new ArrayList<TRTrackerAnnouncerResponsePeerImpl>();
                    Object v = map.get("peers");
                    Long l5 = (Long)map.get("azcompact");
                    long l6 = l5 == null ? 0L : l5;
                    boolean bl3 = bl = l6 == 2L;
                    if (this.az_tracker != bl || this.lastUsedUrl != this.lastAZTrackerCheckedURL) {
                        this.lastAZTrackerCheckedURL = this.lastUsedUrl;
                        this.az_tracker = bl;
                        TRTrackerUtils.setAZTracker(uRL, this.az_tracker);
                    }
                    if (l6 == 2L) {
                        int n5;
                        Long l7;
                        Object object4;
                        short s;
                        Object object5;
                        int n6;
                        Object object6;
                        int n7;
                        arrayList = (List)v;
                        n4 = arrayList.size();
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(this.torrent, LOGID, "ANNOUNCE CompactPeers2: num=" + n4));
                        }
                        if (n4 > 1) {
                            long l8 = 0L;
                            n3 = 0;
                            for (n2 = 0; n2 < n4; ++n2) {
                                Map map2 = (Map)arrayList.get(n2);
                                Long l9 = (Long)map2.get("r");
                                if (l9 == null) continue;
                                long l10 = l9;
                                if (l10 <= 0L) {
                                    map2.remove("r");
                                } else {
                                    l8 += l10;
                                }
                                ++n3;
                            }
                            n2 = (int)(n3 == 0 ? 0L : l8 / (long)n3);
                            Collections.sort(arrayList, new Comparator(){

                                public int compare(Object object, Object object2) {
                                    boolean bl;
                                    Map map = (Map)object;
                                    Map map2 = (Map)object2;
                                    Long l = (Long)map.get("r");
                                    Long l2 = (Long)map2.get("r");
                                    boolean bl2 = map.containsKey("b");
                                    if (bl2 == (bl = map2.containsKey("b"))) {
                                        int n = l == null ? n2 : l.intValue();
                                        int n22 = l2 == null ? n2 : l2.intValue();
                                        return n - n22;
                                    }
                                    if (bl2) {
                                        return -1;
                                    }
                                    return 1;
                                }
                            });
                            int n8 = n4;
                            n7 = n4;
                            for (int i = 0; i < n4; ++i) {
                                Map map3 = (Map)arrayList.get(i);
                                if (map3.containsKey("b")) {
                                    if (i != 0) continue;
                                    n8 = i;
                                    continue;
                                }
                                n7 = i;
                                break;
                            }
                            object6 = new ArrayList(n4);
                            n6 = n7;
                            short s2 = 1;
                            while (n8 < n6 || n7 < n4) {
                                if (n8 < n6) {
                                    if (n7 < n4) {
                                        Map map4 = (Map)arrayList.get(n8);
                                        object5 = (Map)arrayList.get(n7);
                                        if (s2 == 0) {
                                            s = 1;
                                        } else {
                                            object4 = (Long)map4.get("r");
                                            l7 = (Long)object5.get("r");
                                            n5 = object4 == null ? n2 : ((Long)object4).intValue();
                                            int n9 = l7 == null ? n2 : l7.intValue();
                                            short s3 = s = n9 >= n5 ? (short)1 : 0;
                                        }
                                        if (s != 0) {
                                            object6.add(map4);
                                            ++n8;
                                        } else {
                                            object6.add(object5);
                                            ++n7;
                                        }
                                        s2 = s;
                                        continue;
                                    }
                                    object6.add(arrayList.get(n8++));
                                    continue;
                                }
                                object6.add(arrayList.get(n7++));
                            }
                            arrayList = object6;
                        }
                        for (n = 0; n < n4; ++n) {
                            Map map5 = (Map)arrayList.get(n);
                            try {
                                String string3;
                                byte[] byArray4 = (byte[])map5.get("i");
                                if (byArray4.length == 4) {
                                    int n10 = 0xFF & byArray4[0];
                                    n7 = 0xFF & byArray4[1];
                                    int n11 = 0xFF & byArray4[2];
                                    n6 = 0xFF & byArray4[3];
                                    string3 = n10 + "." + n7 + "." + n11 + "." + n6;
                                } else {
                                    StringBuffer stringBuffer = new StringBuffer(39);
                                    for (n7 = 0; n7 < 16; n7 += 2) {
                                        stringBuffer.append(Integer.toHexString(byArray4[n7] << 8 & 0xFF00 | byArray4[n7 + 1] & 0xFF));
                                        if (n7 >= 14) continue;
                                        stringBuffer.append(":");
                                    }
                                    string3 = stringBuffer.toString();
                                }
                                byte[] byArray5 = (byte[])map5.get("t");
                                n7 = ((byArray5[0] & 0xFF) << 8) + (byArray5[1] & 0xFF);
                                object6 = TRTrackerAnnouncerImpl.getAnonymousPeerId(string3, n7);
                                n6 = 0;
                                byte[] byArray6 = (byte[])map5.get("u");
                                if (byArray6 != null) {
                                    n6 = byArray6.length == 0 ? n7 : ((byArray6[0] & 0xFF) << 8) + (byArray6[1] & 0xFF);
                                }
                                int n12 = 0;
                                object5 = (byte[])map5.get("h");
                                if (object5 != null) {
                                    n12 = ((object5[0] & 0xFF) << 8) + (object5[1] & 0xFF);
                                }
                                s = 1;
                                object4 = (byte[])map5.get("c");
                                if (object4 != null) {
                                    s = (object4[0] & 1) == 0 ? (short)1 : 2;
                                }
                                n5 = (l7 = (Long)map5.get("v")) == null ? (byte)1 : l7.byteValue();
                                Long l11 = (Long)map5.get("s");
                                boolean bl4 = map5.containsKey("b");
                                if (bl4) {
                                    PeerClassifier.setAzureusIP(string3);
                                }
                                TRTrackerAnnouncerResponsePeerImpl tRTrackerAnnouncerResponsePeerImpl = new TRTrackerAnnouncerResponsePeerImpl("Tracker", (byte[])object6, string3, n7, n6, n12, s, (byte)n5, l11 == null ? (short)0 : l11.shortValue());
                                if (Logger.isEnabled()) {
                                    String string4 = "";
                                    Long l12 = (Long)map5.get("r");
                                    if (l12 != null) {
                                        string4 = ",rtt=" + l12;
                                    }
                                    if (bl4) {
                                        string4 = string4 + ",biased";
                                    }
                                    Logger.log(new LogEvent(this.torrent, LOGID, "AZ2-COMPACT PEER: " + tRTrackerAnnouncerResponsePeerImpl.getString() + string4));
                                }
                                arrayList2.add(tRTrackerAnnouncerResponsePeerImpl);
                                continue;
                            }
                            catch (Throwable throwable) {
                                if (!Logger.isEnabled()) continue;
                                Logger.log(new LogEvent((Object)this.torrent, LOGID, 3, "Invalid az2 peer received: " + map5));
                            }
                        }
                    } else if (v instanceof List) {
                        arrayList = (List)v;
                        n4 = arrayList.size();
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(this.torrent, LOGID, "ANNOUNCE old style non-compact: num=" + n4));
                        }
                        if (byArray3 != null && n4 != byArray3.length) {
                            byArray3 = null;
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent((Object)this.torrent, LOGID, 3, "Invalid crypto_flags returned: length mismatch"));
                            }
                        }
                        for (n = 0; n < n4; ++n) {
                            int n13;
                            Map map6 = (Map)arrayList.get(n);
                            Object v2 = map6.get("peer id");
                            Object v3 = map6.get("ip");
                            Object v4 = map6.get("port");
                            if (v3 == null || v4 == null) continue;
                            String string5 = new String((byte[])v3, "UTF8");
                            int n14 = n13 = v4 instanceof byte[] ? Integer.parseInt(new String((byte[])v4)) : ((Long)v4).intValue();
                            if (n13 > 65535) {
                                n13 -= 65536;
                            }
                            if (n13 < 0) {
                                n13 += 65536;
                            }
                            if (n13 < 0 || n13 > 65535) {
                                if (!Logger.isEnabled()) continue;
                                Logger.log(new LogEvent((Object)this.torrent, LOGID, 3, "Invalid peer port given: " + string5 + ": " + n13));
                                continue;
                            }
                            byte[] byArray7 = v2 == null ? TRTrackerAnnouncerImpl.getAnonymousPeerId(string5, n13) : (byte[])v2;
                            short s = byArray3 == null ? (short)1 : (byArray3[n] == 0 ? (short)1 : 2);
                            int n15 = 0;
                            int n16 = 0;
                            TRTrackerAnnouncerResponsePeerImpl tRTrackerAnnouncerResponsePeerImpl = new TRTrackerAnnouncerResponsePeerImpl("Tracker", byArray7, string5, n13, n15, n16, s, 1, 0);
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(this.torrent, LOGID, "NON-COMPACT PEER: " + tRTrackerAnnouncerResponsePeerImpl.getString()));
                            }
                            arrayList2.add(tRTrackerAnnouncerResponsePeerImpl);
                        }
                    } else if (v instanceof byte[]) {
                        arrayList = (ArrayList)((byte[])v);
                        int n17 = n4 = l6 == 1L ? 9 : 6;
                        if (byArray3 != null && ((Object)arrayList).length / n4 != byArray3.length) {
                            byArray3 = null;
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent((Object)this.torrent, LOGID, 3, "Invalid crypto_flags returned: length mismatch"));
                            }
                        }
                        n = 0;
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(this.torrent, LOGID, "ANNOUNCE CompactPeers: num=" + ((Object)arrayList).length / n4));
                        }
                        for (int i = 0; i < ((Object)arrayList).length; i += n4) {
                            int n18;
                            int n19;
                            int n20;
                            ++n;
                            int n21 = 0xFF & arrayList[i];
                            int n22 = 0xFF & arrayList[i + 1];
                            int n23 = 0xFF & arrayList[i + 2];
                            int n24 = 0xFF & arrayList[i + 3];
                            int n25 = 0xFF & arrayList[i + 4];
                            int n26 = 0xFF & arrayList[i + 5];
                            String string6 = "" + n21 + "." + n22 + "." + n23 + "." + n24;
                            int n27 = n25 * 256 + n26;
                            if (n27 < 0 || n27 > 65535) {
                                if (!Logger.isEnabled()) continue;
                                Logger.log(new LogEvent((Object)this.torrent, LOGID, 3, "Invalid compact peer port given: " + string6 + ": " + n27));
                                continue;
                            }
                            byte[] byArray8 = TRTrackerAnnouncerImpl.getAnonymousPeerId(string6, n27);
                            if (l6 == 1L) {
                                n20 = 0xFF & arrayList[i + 6];
                                int n28 = 0xFF & arrayList[i + 7];
                                n19 = n20 * 256 + n28;
                                ArrayList arrayList3 = arrayList[i + 8];
                                n18 = (arrayList3 & 1) == 0 ? 1 : 2;
                            } else {
                                n18 = byArray3 == null ? 1 : (byArray3[n - 1] == 0 ? 1 : 2);
                                n19 = 0;
                            }
                            n20 = 0;
                            TRTrackerAnnouncerResponsePeerImpl tRTrackerAnnouncerResponsePeerImpl = new TRTrackerAnnouncerResponsePeerImpl("Tracker", byArray8, string6, n27, n19, n20, (short)n18, 1, 0);
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(this.torrent, LOGID, "COMPACT PEER: " + tRTrackerAnnouncerResponsePeerImpl.getString()));
                            }
                            arrayList2.add(tRTrackerAnnouncerResponsePeerImpl);
                        }
                    } else if (v instanceof Map ? ((Map)v).size() != 0 : !map.containsKey("peers6")) {
                        throw new IOException("peers missing from response");
                    }
                    if ((arrayList = (ArrayList)((byte[])map.get("peers6"))) != null) {
                        byte[] byArray9 = new byte[16];
                        for (int i = 0; i < ((Object)arrayList).length; i += 18) {
                            System.arraycopy(arrayList, i, byArray9, 0, 16);
                            String string7 = InetAddress.getByAddress(byArray9).getHostAddress();
                            n2 = 0xFF & arrayList[i + 16];
                            int n29 = 0xFF & arrayList[i + 17];
                            int n30 = n2 * 256 + n29;
                            if (n30 < 0 || n30 > 65535) {
                                if (!Logger.isEnabled()) continue;
                                Logger.log(new LogEvent((Object)this.torrent, LOGID, 3, "Invalid compactv6 peer port given: " + string7 + ": " + n30));
                                continue;
                            }
                            byte[] byArray10 = TRTrackerAnnouncerImpl.getAnonymousPeerId(string7, n30);
                            short s = 1;
                            TRTrackerAnnouncerResponsePeerImpl tRTrackerAnnouncerResponsePeerImpl = new TRTrackerAnnouncerResponsePeerImpl("Tracker", byArray10, string7, n30, 0, 0, s, 1, 0);
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(this.torrent, LOGID, "COMPACTv6 PEER: " + tRTrackerAnnouncerResponsePeerImpl.getString()));
                            }
                            arrayList2.add(tRTrackerAnnouncerResponsePeerImpl);
                        }
                    }
                    TRTrackerAnnouncerResponsePeer[] tRTrackerAnnouncerResponsePeerArray = new TRTrackerAnnouncerResponsePeerImpl[arrayList2.size()];
                    arrayList2.toArray(tRTrackerAnnouncerResponsePeerArray);
                    this.helper.addToTrackerCache((TRTrackerAnnouncerResponsePeerImpl[])tRTrackerAnnouncerResponsePeerArray);
                    TRTrackerAnnouncerResponseImpl tRTrackerAnnouncerResponseImpl = new TRTrackerAnnouncerResponseImpl(uRL, this.torrent_hash, 2, l2, tRTrackerAnnouncerResponsePeerArray);
                    this.failure_added_time = 0;
                    Map map7 = (Map)map.get("extensions");
                    tRTrackerAnnouncerResponseImpl.setExtensions(map7);
                    if (map7 != null) {
                        Object v5;
                        if (object == null) {
                            object = (Long)map7.get("complete");
                        }
                        if (l == null) {
                            l = (Long)map7.get("incomplete");
                        }
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(this.torrent, LOGID, "ANNOUNCE SCRAPE2: seeds=" + object + " peers=" + l));
                        }
                        if ((v5 = map7.get("min interval override")) != null && v5 instanceof Long) {
                            this.min_interval_override = (Long)v5;
                        }
                    }
                    if (object != null || l != null) {
                        n3 = object == null ? 0 : ((Long)object).intValue();
                        int n31 = n2 = l == null ? 0 : l.intValue();
                        if (n3 < 0 || n2 < 0) {
                            tRTrackerAnnouncerResponseImpl.setFailurReason(MessageText.getString("Tracker.announce.ignorePeerSeed", new String[]{(n3 < 0 ? MessageText.getString("MyTorrentsView.seeds") + " == " + n3 + ". " : "") + (n2 < 0 ? MessageText.getString("MyTorrentsView.peers") + " == " + n2 + ". " : "")}));
                        } else {
                            TRTrackerScraperResponse tRTrackerScraperResponse;
                            tRTrackerAnnouncerResponseImpl.setScrapeResult(n3, n2);
                            TRTrackerScraper tRTrackerScraper = TRTrackerScraperFactory.getSingleton();
                            if (tRTrackerScraper != null && (tRTrackerScraperResponse = tRTrackerScraper.scrape(this.torrent, this.getTrackerURL())) != null) {
                                long l13 = tRTrackerScraperResponse.getNextScrapeStartTime();
                                long l14 = TRTrackerScraperResponseImpl.calcScrapeIntervalSecs(0, n3) * 1000;
                                tRTrackerScraperResponse.setScrapeStartTime(SystemTime.getCurrentTime());
                                if (l13 < l14) {
                                    tRTrackerScraperResponse.setNextScrapeStartTime(l14);
                                }
                                tRTrackerScraperResponse.setSeedsPeers(n3, n2);
                                if (l4 != null) {
                                    tRTrackerScraperResponse.setCompleted(l4.intValue());
                                }
                            }
                        }
                    }
                    return tRTrackerAnnouncerResponseImpl;
                }
                catch (IOException iOException) {
                    String string8 = byArray.length <= 150 ? new String(byArray) : new String(byArray, 0, 150) + "...";
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent((Object)this.torrent, LOGID, 3, "TRTrackerAnnouncer::invalid reply: " + string8));
                    }
                    string = "invalid reply: " + string8;
                }
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
                string = "error: " + throwable.getMessage();
            }
        }
        return new TRTrackerAnnouncerResponseImpl(uRL, this.torrent_hash, 0, (long)this.getErrorRetryInterval(), string);
    }

    private Long getLong(Map map, String string) {
        Object v = map.get(string);
        if (v instanceof Long) {
            return (Long)v;
        }
        return null;
    }

    protected void informURLChange(URL uRL, URL uRL2, boolean bl) {
        this.helper.informURLChange(uRL, uRL2, bl);
    }

    protected void informURLRefresh() {
        this.helper.informURLRefresh();
    }

    @Override
    public TRTrackerAnnouncerResponse getLastResponse() {
        if (this.last_response == null) {
            return new TRTrackerAnnouncerResponseImpl(null, this.torrent_hash, 0, 60L, "Initialising");
        }
        return this.last_response;
    }

    @Override
    public boolean isManual() {
        return this.manual_control;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        this.destroyed = true;
        try {
            this.this_mon.enter();
            if (this.current_timer_event != null && this.current_timer_event.getWhen() - SystemTime.getCurrentTime() > 10000L) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "Canceling announce trigger"));
                }
                this.current_timer_event.cancel();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected int getErrorRetryInterval() {
        boolean bl;
        long l = SystemTime.getCurrentTime() / 1000L;
        long l2 = l - this.failure_time_last_updated;
        if (l2 < (long)this.failure_added_time && l2 >= 0L) {
            return this.failure_added_time;
        }
        this.failure_time_last_updated = l;
        this.failure_added_time = this.failure_added_time == 0 ? 10 : (this.failure_added_time < 30 ? (this.failure_added_time += 10) : (this.failure_added_time < 60 ? (this.failure_added_time += 15) : (this.failure_added_time < 120 ? (this.failure_added_time += 30) : (this.failure_added_time < 600 ? (this.failure_added_time += 60) : (this.failure_added_time += 120 + new Random().nextInt(60))))));
        boolean bl2 = this.announce_data_provider == null ? false : (bl = this.announce_data_provider.getRemaining() == 0L);
        if (bl) {
            this.failure_added_time *= 2;
        }
        if (!bl && this.failure_added_time > 1800) {
            this.failure_added_time = 1800;
        } else if (bl && this.failure_added_time > 3600) {
            this.failure_added_time = 3600;
        }
        return this.failure_added_time;
    }

    @Override
    public void setAnnounceResult(DownloadAnnounceResult downloadAnnounceResult) {
        TRTrackerAnnouncerResponseImpl tRTrackerAnnouncerResponseImpl;
        String string;
        if (downloadAnnounceResult.getResponseType() == 2) {
            string = MessageText.getString("PeerManager.status.error");
            String string2 = downloadAnnounceResult.getError();
            if (string2 != null) {
                string = string + " (" + string2 + ")";
            }
            tRTrackerAnnouncerResponseImpl = new TRTrackerAnnouncerResponseImpl(downloadAnnounceResult.getURL(), this.torrent_hash, 0, downloadAnnounceResult.getTimeToWait(), string2);
        } else {
            DownloadAnnounceResultPeer[] downloadAnnounceResultPeerArray = downloadAnnounceResult.getPeers();
            ArrayList<TRTrackerAnnouncerResponsePeerImpl> arrayList = new ArrayList<TRTrackerAnnouncerResponsePeerImpl>(downloadAnnounceResultPeerArray.length);
            boolean bl = this.announce_data_provider != null && this.announce_data_provider.isPeerSourceEnabled("Tracker");
            for (int i = 0; i < downloadAnnounceResultPeerArray.length; ++i) {
                DownloadAnnounceResultPeer downloadAnnounceResultPeer = downloadAnnounceResultPeerArray[i];
                String string3 = downloadAnnounceResultPeer.getSource();
                if (!bl && string3.equals("Tracker")) continue;
                int n = 0;
                byte by = 1;
                TRTrackerAnnouncerResponsePeerImpl tRTrackerAnnouncerResponsePeerImpl = new TRTrackerAnnouncerResponsePeerImpl(downloadAnnounceResultPeer.getSource(), downloadAnnounceResultPeer.getPeerID(), downloadAnnounceResultPeer.getAddress(), downloadAnnounceResultPeer.getPort(), downloadAnnounceResultPeer.getUDPPort(), n, downloadAnnounceResultPeer.getProtocol(), by, 0);
                arrayList.add(tRTrackerAnnouncerResponsePeerImpl);
                if (!Logger.isEnabled()) continue;
                Logger.log(new LogEvent(this.torrent, LOGID, "EXTERNAL PEER: " + tRTrackerAnnouncerResponsePeerImpl.getString()));
            }
            TRTrackerAnnouncerResponsePeer[] tRTrackerAnnouncerResponsePeerArray = new TRTrackerAnnouncerResponsePeerImpl[arrayList.size()];
            arrayList.toArray(tRTrackerAnnouncerResponsePeerArray);
            this.helper.addToTrackerCache((TRTrackerAnnouncerResponsePeerImpl[])tRTrackerAnnouncerResponsePeerArray);
            if (bl || tRTrackerAnnouncerResponsePeerArray.length > 0 || downloadAnnounceResultPeerArray.length == 0) {
                string = MessageText.getString("PeerManager.status.ok");
            } else {
                string = MessageText.getString("PeerManager.status.ps_disabled");
                tRTrackerAnnouncerResponsePeerArray = new TRTrackerAnnouncerResponsePeerImpl[]{};
            }
            tRTrackerAnnouncerResponseImpl = new TRTrackerAnnouncerResponseImpl(downloadAnnounceResult.getURL(), this.torrent_hash, 2, downloadAnnounceResult.getTimeToWait(), tRTrackerAnnouncerResponsePeerArray);
        }
        if (this.last_response == null || this.last_response.getStatus() != 2) {
            this.tracker_status_str = string + " (" + downloadAnnounceResult.getURL() + ")";
        }
        this.helper.informResponse(this, tRTrackerAnnouncerResponseImpl);
    }

    @Override
    public void addListener(TRTrackerAnnouncerListener tRTrackerAnnouncerListener) {
        this.helper.addListener(tRTrackerAnnouncerListener);
    }

    @Override
    public void removeListener(TRTrackerAnnouncerListener tRTrackerAnnouncerListener) {
        this.helper.removeListener(tRTrackerAnnouncerListener);
    }

    @Override
    public void setTrackerResponseCache(Map map) {
        this.helper.setTrackerResponseCache(map);
    }

    @Override
    public void removeFromTrackerResponseCache(String string, int n) {
        this.helper.removeFromTrackerResponseCache(string, n);
    }

    @Override
    public Map getTrackerResponseCache() {
        return this.helper.getTrackerResponseCache();
    }

    @Override
    public TrackerPeerSource getTrackerPeerSource(TOTorrentAnnounceURLSet tOTorrentAnnounceURLSet) {
        Debug.out("not implemented");
        return null;
    }

    @Override
    public TrackerPeerSource getCacheTrackerPeerSource() {
        Debug.out("not implemented");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateEvidence(IndentWriter indentWriter) {
        indentWriter.println("BT announce:");
        try {
            indentWriter.indent();
            indentWriter.println("state: " + this.tracker_state + ", in_progress=" + this.update_in_progress);
            indentWriter.println("current: " + (this.lastUsedUrl == null ? "null" : this.lastUsedUrl.toString()));
            indentWriter.println("last: " + (this.last_response == null ? "null" : this.last_response.getString()));
            indentWriter.println("last_update_secs: " + this.last_update_time_secs);
            indentWriter.println("secs_to_wait: " + this.current_time_to_wait_secs + (this.manual_control ? " - manual" : ""));
            indentWriter.println("t_interval: " + this.tracker_interval);
            indentWriter.println("t_min_interval: " + this.tracker_min_interval);
            indentWriter.println("min_interval: " + this.min_interval);
            indentWriter.println("min_interval_override: " + this.min_interval_override);
            indentWriter.println("rd: last_override=" + this.rd_last_override + ",percentage=" + this.rd_override_percentage);
            indentWriter.println("event: " + (this.current_timer_event == null ? "null" : this.current_timer_event.getString()));
            indentWriter.println("stopped: " + this.stopped + ", for_q=" + this.stopped_for_queue);
            indentWriter.println("complete: " + this.completed + ", reported=" + this.complete_reported);
        }
        finally {
            indentWriter.exdent();
        }
    }

    static {
        PRUDPTrackerCodecs.registerCodecs();
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Tracker Client Min Announce Interval", "Tracker Client Numwant Limit", "Server Enable UDP"}, new ParameterListener(){

            @Override
            public void parameterChanged(String string) {
                userMinInterval = COConfigurationManager.getIntParameter("Tracker Client Min Announce Interval");
                userMaxNumwant = COConfigurationManager.getIntParameter("Tracker Client Numwant Limit");
                udpAnnounceEnabled = COConfigurationManager.getBooleanParameter("Server Enable UDP");
            }
        });
        class_mon = new AEMonitor("TRTrackerBTAnnouncer:class");
        tracker_report_map = new HashMap();
    }
}

