/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.impl;

import java.net.URL;
import java.util.Map;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponse;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponsePeer;
import org.gudy.azureus2.core3.util.HashWrapper;

public class TRTrackerAnnouncerResponseImpl
implements TRTrackerAnnouncerResponse {
    private URL url;
    private HashWrapper hash;
    private int status;
    private long time_to_wait;
    private String failure_reason;
    private int scrape_complete = -1;
    private int scrape_incomplete = -1;
    protected TRTrackerAnnouncerResponsePeer[] peers;
    protected Map extensions;

    public TRTrackerAnnouncerResponseImpl(URL uRL, HashWrapper hashWrapper, int n, long l) {
        this.url = uRL;
        this.hash = hashWrapper;
        this.status = n;
        this.time_to_wait = l;
    }

    public TRTrackerAnnouncerResponseImpl(URL uRL, HashWrapper hashWrapper, int n, long l, String string) {
        this.url = uRL;
        this.hash = hashWrapper;
        this.status = n;
        this.time_to_wait = l;
        this.failure_reason = string;
    }

    public TRTrackerAnnouncerResponseImpl(URL uRL, HashWrapper hashWrapper, int n, long l, TRTrackerAnnouncerResponsePeer[] tRTrackerAnnouncerResponsePeerArray) {
        this.url = uRL;
        this.hash = hashWrapper;
        this.status = n;
        this.time_to_wait = l;
        this.peers = tRTrackerAnnouncerResponsePeerArray;
    }

    @Override
    public HashWrapper getHash() {
        return this.hash;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public String getStatusString() {
        String string = "";
        string = this.status == 0 ? "Offline" : (this.status == 2 ? "OK" : "Failed");
        if (this.failure_reason != null && this.failure_reason.length() > 0) {
            string = string + " - " + this.failure_reason;
        }
        return string;
    }

    public void setFailurReason(String string) {
        this.failure_reason = string;
    }

    @Override
    public long getTimeToWait() {
        return this.time_to_wait;
    }

    @Override
    public String getAdditionalInfo() {
        return this.failure_reason;
    }

    @Override
    public void setPeers(TRTrackerAnnouncerResponsePeer[] tRTrackerAnnouncerResponsePeerArray) {
        this.peers = tRTrackerAnnouncerResponsePeerArray;
    }

    @Override
    public TRTrackerAnnouncerResponsePeer[] getPeers() {
        return this.peers;
    }

    public void setExtensions(Map map) {
        this.extensions = map;
    }

    @Override
    public Map getExtensions() {
        return this.extensions;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public int getScrapeCompleteCount() {
        return this.scrape_complete;
    }

    @Override
    public int getScrapeIncompleteCount() {
        return this.scrape_incomplete;
    }

    public void setScrapeResult(int n, int n2) {
        this.scrape_complete = n;
        this.scrape_incomplete = n2;
    }

    @Override
    public void print() {
        System.out.println("TRTrackerResponse::print");
        System.out.println("\tstatus = " + this.getStatus());
        System.out.println("\tfail msg = " + this.getAdditionalInfo());
        System.out.println("\tpeers:");
        if (this.peers != null) {
            for (int i = 0; i < this.peers.length; ++i) {
                TRTrackerAnnouncerResponsePeer tRTrackerAnnouncerResponsePeer = this.peers[i];
                System.out.println("\t\t" + tRTrackerAnnouncerResponsePeer.getAddress() + ":" + tRTrackerAnnouncerResponsePeer.getPort());
            }
        }
    }

    public String getString() {
        String string = "url=" + this.url + ", status=" + this.getStatus();
        if (this.getStatus() != 2) {
            string = string + ", error=" + this.getAdditionalInfo();
        }
        string = string + ", time_to_wait=" + this.time_to_wait;
        string = string + ", scrape_comp=" + this.scrape_complete + ", scrape_incomp=" + this.scrape_incomplete;
        return string;
    }
}

