/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.torrent.impl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.gudy.azureus2.core3.html.HTMLUtils;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentFileImpl;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentImpl;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.StringInterner;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class TOTorrentDeserialiseImpl
extends TOTorrentImpl {
    public TOTorrentDeserialiseImpl(File file) throws TOTorrentException {
        if (!file.exists()) {
            throw new TOTorrentException("Torrent file '" + file.toString() + "' does not exist", 1);
        }
        if (!file.isFile()) {
            throw new TOTorrentException("Torrent must be a file ('" + file.toString() + "')", 1);
        }
        if (file.length() == 0L) {
            throw new TOTorrentException("Torrent is zero length ('" + file.toString() + "')", 2);
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            this.construct(fileInputStream);
        }
        catch (Throwable throwable) {
            throw new TOTorrentException("Error reading torrent file '" + file.toString() + " - " + Debug.getNestedExceptionMessage(throwable), 4);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    Debug.printStackTrace(iOException);
                }
            }
        }
    }

    public TOTorrentDeserialiseImpl(InputStream inputStream) throws TOTorrentException {
        this.construct(inputStream);
    }

    public TOTorrentDeserialiseImpl(byte[] byArray) throws TOTorrentException {
        this.construct(byArray);
    }

    public TOTorrentDeserialiseImpl(Map map) throws TOTorrentException {
        this.construct(map);
    }

    protected void construct(InputStream inputStream) throws TOTorrentException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n;
            byte[] byArray = new byte[32768];
            int n2 = inputStream.read();
            if (n2 != 100 && n2 != 101 && n2 != 105 && (n2 < 48 || n2 > 57)) {
                block9: {
                    try {
                        int n3;
                        byteArrayOutputStream.write(n2);
                        while ((n3 = inputStream.read(byArray)) > 0 && byteArrayOutputStream.size() < 32000) {
                            byteArrayOutputStream.write(byArray, 0, n3);
                        }
                        String string = new String(byteArrayOutputStream.toByteArray());
                        if (string.toLowerCase().indexOf("html") != -1) {
                            string = HTMLUtils.convertHTMLToText2(string);
                            if ((string = HTMLUtils.splitWithLineLength(string, 80)).length() > 400) {
                                string = string.substring(0, 400) + "...";
                            }
                            throw new TOTorrentException("Contents maybe HTML:\n" + string, 6);
                        }
                    }
                    catch (Throwable throwable) {
                        if (!(throwable instanceof TOTorrentException)) break block9;
                        throw (TOTorrentException)throwable;
                    }
                }
                throw new TOTorrentException("Contents invalid - bad header", 6);
            }
            byteArrayOutputStream.write(n2);
            while ((n = inputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
        }
        catch (Throwable throwable) {
            throw new TOTorrentException("Error reading torrent: " + Debug.getNestedExceptionMessage(throwable), 4);
        }
        this.construct(byteArrayOutputStream.toByteArray());
    }

    protected void construct(byte[] byArray) throws TOTorrentException {
        try {
            Map map = BDecoder.decode(byArray);
            this.construct(map);
        }
        catch (IOException iOException) {
            throw new TOTorrentException("Error reading torrent: " + Debug.getNestedExceptionMessage(iOException), 6, iOException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void construct(Map map) throws TOTorrentException {
        try {
            Object object;
            Object object2;
            Object object3;
            Object object42;
            String string = null;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            for (Object object42 : map.keySet()) {
                Object object5;
                if (((String)object42).equalsIgnoreCase("announce")) {
                    bl = true;
                    string = this.readStringFromMetaData(map, "announce");
                    if (string == null) {
                        bl3 = true;
                        continue;
                    }
                    string = string.replaceAll(" ", "");
                    try {
                        this.setAnnounceURL(new URL(string));
                    }
                    catch (MalformedURLException malformedURLException) {
                        if (string.indexOf("://") == -1) {
                            string = "http:/" + (string.startsWith("/") ? "" : "/") + string;
                        }
                        try {
                            this.setAnnounceURL(new URL(string));
                        }
                        catch (MalformedURLException malformedURLException2) {
                            bl3 = true;
                        }
                    }
                    continue;
                }
                if (((String)object42).equalsIgnoreCase("announce-list")) {
                    bl2 = true;
                    object5 = null;
                    Object v = map.get("announce-list");
                    if (v instanceof List) {
                        object5 = (List)v;
                    }
                    if (object5 == null || object5.size() <= 0) continue;
                    string = this.readStringFromMetaData(map, "announce");
                    if (string != null) {
                        string = string.replaceAll(" ", "");
                    }
                    boolean bl4 = false;
                    for (int i = 0; i < object5.size(); ++i) {
                        Object e = object5.get(i);
                        if (e instanceof List) {
                            List list = (List)e;
                            object3 = new Vector();
                            for (int j = 0; j < list.size(); ++j) {
                                object2 = this.readStringFromMetaData((byte[])list.get(j));
                                object2 = ((String)object2).replaceAll(" ", "");
                                try {
                                    ((Vector)object3).add(new URL(StringInterner.intern((String)object2)));
                                    if (!((String)object2).equalsIgnoreCase(string)) continue;
                                    bl4 = true;
                                    continue;
                                }
                                catch (MalformedURLException malformedURLException) {
                                    if (((String)object2).indexOf("://") == -1) {
                                        object2 = "http:/" + (((String)object2).startsWith("/") ? "" : "/") + (String)object2;
                                    }
                                    try {
                                        ((Vector)object3).add(new URL(StringInterner.intern((String)object2)));
                                        if (!((String)object2).equalsIgnoreCase(string)) continue;
                                        bl4 = true;
                                        continue;
                                    }
                                    catch (MalformedURLException malformedURLException3) {
                                        Debug.printStackTrace(malformedURLException3);
                                    }
                                }
                            }
                            if (((Vector)object3).size() <= 0) continue;
                            Object[] objectArray = new URL[((Vector)object3).size()];
                            ((Vector)object3).copyInto(objectArray);
                            this.addTorrentAnnounceURLSet((URL[])objectArray);
                            continue;
                        }
                        Debug.out("Torrent has invalid url-list entry (" + e + ") - ignoring");
                    }
                    if (bl4 || string == null || string.length() <= 0) continue;
                    try {
                        Vector<URL> vector = new Vector<URL>();
                        vector.add(new URL(StringInterner.intern(string)));
                        Object[] objectArray = new URL[vector.size()];
                        vector.copyInto(objectArray);
                        this.addTorrentAnnounceURLSet((URL[])objectArray);
                    }
                    catch (Exception exception) {
                        Debug.printStackTrace(exception);
                    }
                    continue;
                }
                if (((String)object42).equalsIgnoreCase("comment")) {
                    this.setComment((byte[])map.get("comment"));
                    continue;
                }
                if (((String)object42).equalsIgnoreCase("created by")) {
                    this.setCreatedBy((byte[])map.get("created by"));
                    continue;
                }
                if (((String)object42).equalsIgnoreCase("creation date")) {
                    try {
                        object5 = (Long)map.get("creation date");
                        if (object5 == null) continue;
                        this.setCreationDate((Long)object5);
                    }
                    catch (Exception exception) {
                        System.out.println("creation_date extraction fails, ignoring");
                    }
                    continue;
                }
                if (((String)object42).equalsIgnoreCase("info")) continue;
                object5 = map.get(object42);
                if (object5 instanceof byte[]) {
                    this.setAdditionalByteArrayProperty((String)object42, (byte[])object5);
                    continue;
                }
                if (object5 instanceof Long) {
                    this.setAdditionalLongProperty((String)object42, (Long)object5);
                    continue;
                }
                if (object5 instanceof List) {
                    this.setAdditionalListProperty((String)object42, (List)object5);
                    continue;
                }
                this.setAdditionalMapProperty((String)object42, (Map)object5);
            }
            if (bl3) {
                if (!bl2) throw new TOTorrentException("ANNOUNCE_URL malformed ('" + string + "'", 6);
                object42 = this.getAnnounceURLGroup().getAnnounceURLSets();
                if (((TOTorrentAnnounceURLSet[])object42).length <= 0) throw new TOTorrentException("ANNOUNCE_URL malformed ('" + string + "' and no usable announce list)", 6);
                this.setAnnounceURL(object42[0].getAnnounceURLs()[0]);
            }
            if (!bl2 && !bl) {
                this.setAnnounceURL(TorrentUtils.getDecentralisedEmptyURL());
            }
            if ((object42 = (Map)map.get("info")) == null) {
                throw new TOTorrentException("Decode fails, 'info' element not found'", 6);
            }
            boolean bl5 = object42.containsKey("name.utf-8");
            this.setName((byte[])object42.get("name"));
            long l = (Long)object42.get("piece length");
            if (l <= 0L) {
                throw new TOTorrentException("Decode fails, piece-length is invalid", 6);
            }
            this.setPieceLength(l);
            this.setHashFromInfo((Map)object42);
            Long l2 = (Long)object42.get("length");
            long l3 = 0L;
            object3 = this.getAdditionalStringProperty("encoding");
            bl5 &= object3 == null || ((String)object3).equals("utf8 keys");
            if (l2 != null) {
                this.setSimpleTorrent(true);
                l3 = l2;
                if (bl5) {
                    this.setNameUTF8((byte[])object42.get("name.utf-8"));
                    this.setAdditionalStringProperty("encoding", "utf8 keys");
                }
                this.setFiles(new TOTorrentFileImpl[]{new TOTorrentFileImpl((TOTorrent)this, 0L, l3, new byte[][]{this.getName()})});
            } else {
                this.setSimpleTorrent(false);
                List list = (List)object42.get("files");
                object2 = new TOTorrentFileImpl[list.size()];
                if (bl5) {
                    for (int i = 0; i < ((Object)object2).length && (bl5 &= (object = (Map)list.get(i)).containsKey("path.utf-8")); ++i) {
                    }
                    if (bl5) {
                        this.setNameUTF8((byte[])object42.get("name.utf-8"));
                        this.setAdditionalStringProperty("encoding", "utf8 keys");
                    }
                }
                for (int i = 0; i < ((Object)object2).length; ++i) {
                    TOTorrentFileImpl tOTorrentFileImpl;
                    Object object6;
                    object = (Map)list.get(i);
                    long l4 = (Long)object.get("length");
                    List list2 = (List)object.get("path");
                    List list3 = (List)object.get("path.utf-8");
                    byte[][] byArrayArray = new byte[list2.size()][];
                    for (int j = 0; j < list2.size(); ++j) {
                        byArrayArray[j] = (byte[])list2.get(j);
                    }
                    if (bl5) {
                        object6 = new byte[list3.size()][];
                        for (int j = 0; j < list3.size(); ++j) {
                            object6[j] = (byte[])list3.get(j);
                        }
                        object2[i] = new TOTorrentFileImpl(this, l3, l4, byArrayArray, (byte[][])object6);
                        tOTorrentFileImpl = object2[i];
                    } else {
                        object2[i] = new TOTorrentFileImpl((TOTorrent)this, l3, l4, byArrayArray);
                        tOTorrentFileImpl = object2[i];
                    }
                    l3 += l4;
                    object6 = object.keySet().iterator();
                    while (object6.hasNext()) {
                        String string2 = (String)object6.next();
                        if (string2.equals("length") || string2.equals("path")) continue;
                        tOTorrentFileImpl.setAdditionalProperty(string2, object.get(string2));
                    }
                }
                this.setFiles((TOTorrentFileImpl[])object2);
            }
            byte[] byArray = (byte[])object42.get("pieces");
            int n = (int)((l3 + (l - 1L)) / l);
            int n2 = byArray.length / 20;
            if (n2 < n) {
                throw new TOTorrentException("Decode fails, insufficient pieces supplied", 6);
            }
            if (n2 > n) {
                Debug.out("Torrent '" + new String(this.getName()) + "' has too many pieces (required=" + n + ",supplied=" + n2 + ") - ignoring excess");
            }
            object = new byte[n2][20];
            for (int i = 0; i < ((Object)object).length; ++i) {
                System.arraycopy(byArray, i * 20, object[i], 0, 20);
            }
            this.setPieces((byte[][])object);
            for (Object object7 : object42.keySet()) {
                if (((String)object7).equals("name") || ((String)object7).equals("length") || ((String)object7).equals("files") || ((String)object7).equals("piece length") || ((String)object7).equals("pieces")) continue;
                this.addAdditionalInfoProperty((String)object7, object42.get(object7));
            }
            try {
                Object object7;
                object7 = (byte[])object42.get("hash-override");
                if (object7 == null) return;
                this.setHashOverride((byte[])object7);
                return;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
            return;
        }
        catch (Throwable throwable) {
            if (!(throwable instanceof TOTorrentException)) throw new TOTorrentException("Torrent decode fails '" + Debug.getNestedExceptionMessageAndStack(throwable) + "'", 6, throwable);
            throw (TOTorrentException)throwable;
        }
    }

    public void printMap() {
        try {
            this.print("", "root", this.serialiseToMap());
        }
        catch (TOTorrentException tOTorrentException) {
            Debug.printStackTrace(tOTorrentException);
        }
    }

    protected void print(String string, String string2, Map map) {
        System.out.println(string + string2 + "{map}");
        for (String string3 : map.keySet()) {
            Object v = map.get(string3);
            if (v instanceof Map) {
                this.print(string + "  ", string3, (Map)v);
                continue;
            }
            if (v instanceof List) {
                this.print(string + "  ", string3, (List)v);
                continue;
            }
            if (v instanceof Long) {
                this.print(string + "  ", string3, (Long)v);
                continue;
            }
            this.print(string + "  ", string3, (byte[])v);
        }
    }

    protected void print(String string, String string2, List list) {
        System.out.println(string + string2 + "{list}");
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Map) {
                this.print(string + "  ", "[" + n + "]", (Map)e);
            } else if (e instanceof List) {
                this.print(string + "  ", "[" + n + "]", (List)e);
            } else if (e instanceof Long) {
                this.print(string + "  ", "[" + n + "]", (Long)e);
            } else {
                this.print(string + "  ", "[" + n + "]", (byte[])e);
            }
            ++n;
        }
    }

    protected void print(String string, String string2, Long l) {
        System.out.println(string + string2 + "{long} = " + l);
    }

    protected void print(String string, String string2, byte[] byArray) {
        String string3 = new String(byArray);
        boolean bl = true;
        for (int i = 0; i < string3.length(); ++i) {
            char c = string3.charAt(i);
            if (c < '\u0080') continue;
            bl = false;
            break;
        }
        if (bl) {
            System.out.println(string + string2 + "{byte[]} = " + string3);
        } else {
            System.out.println(string + string2 + "{byte[], length " + byArray.length + "}");
        }
    }
}

