/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.ipfilter.impl;

import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.ipfilter.IpRange;
import org.gudy.azureus2.core3.ipfilter.impl.IpFilterImpl;
import org.gudy.azureus2.core3.ipfilter.impl.IpRangeImpl;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;

public class IpFilterAutoLoaderImpl {
    private static final LogIDs LOGID = LogIDs.CORE;
    public static final String CFG_AUTOLOAD_LAST = "Ip Filter Autoload Last Date";
    public static final String CFG_AUTOLOAD_FILE = "Ip Filter Autoload File";
    private static AEMonitor class_mon = new AEMonitor("IpFilterAutoLoaderImpl:class");
    private Object timerEventFilterReload;
    private final IpFilterImpl ipFilter;

    public IpFilterAutoLoaderImpl(IpFilterImpl ipFilterImpl) {
        this.ipFilter = ipFilterImpl;
        COConfigurationManager.setLongDefault(CFG_AUTOLOAD_LAST, 0L);
        COConfigurationManager.setStringDefault(CFG_AUTOLOAD_FILE, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDATFilters(InputStream inputStream) {
        try {
            class_mon.enter();
            ArrayList<Object> arrayList = new ArrayList<Object>(1024);
            InputStreamReader inputStreamReader = null;
            BufferedReader bufferedReader = null;
            try {
                Pattern pattern = Pattern.compile("^(.*):([0-9\\.]+)[^0-9]+([0-9\\.]+).*");
                int n = -1;
                inputStreamReader = new InputStreamReader(inputStream, "utf8");
                bufferedReader = new BufferedReader(inputStreamReader);
                int n2 = 0;
                while (n2 < 1000) {
                    Object object;
                    String string = bufferedReader.readLine();
                    if (string == null) {
                        break;
                    }
                    if ((string = string.trim()).startsWith("#") || string.length() == 0) continue;
                    Object object2 = "";
                    Object object3 = null;
                    Object object4 = null;
                    int n3 = 0;
                    if (n <= 0 || n == 1) {
                        object = pattern.matcher(string);
                        if (((Matcher)object).find()) {
                            if (n != 1) {
                                n = 1;
                            }
                            object2 = ((Matcher)object).group(1);
                            object3 = ((Matcher)object).group(2);
                            object4 = ((Matcher)object).group(3);
                        } else {
                            Logger.log(new LogEvent(LOGID, 1, "unrecognized line while reading ip filter: " + string));
                        }
                    }
                    if (n != 1) {
                        if (n != 2) {
                            n = 2;
                        }
                        if (((String[])(object = string.split(" *[-,] *", 4))).length >= 2 && (object[0].indexOf(46) < 0 || ((String)object[1]).indexOf(46) < 0 || ((String)object[0]).length() > 15 || ((String)object[1]).length() > 15 || ((String)object[0]).length() < 7 || ((String)object[1]).length() < 7)) {
                            ++n2;
                            continue;
                        }
                        if (((String[])object).length >= 4) {
                            object3 = object[0];
                            object4 = object[1];
                            object2 = object[3];
                            try {
                                n3 = Integer.parseInt((String)object[2]);
                            }
                            catch (NumberFormatException numberFormatException) {
                                object2 = (String)object[2] + " " + (String)object2;
                            }
                            for (int i = 4; i < ((Object)object).length; ++i) {
                                object2 = (String)object2 + " " + (String)object[i];
                            }
                            n2 = 0;
                        } else if (((Object)object).length == 3) {
                            object3 = object[0];
                            object4 = object[1];
                            object2 = object[2];
                            n2 = 0;
                        } else if (((Object)object).length == 2) {
                            object3 = object[0];
                            object4 = object[1];
                            n2 = 0;
                        } else {
                            ++n2;
                            continue;
                        }
                        if (n3 >= 128) continue;
                    }
                    if (object3 == null || object4 == null) continue;
                    object = new IpRangeImpl((String)object2, (String)object3, (String)object4, true);
                    ((IpRangeImpl)object).setAddedToRangeList(true);
                    arrayList.add(object);
                }
            }
            catch (IOException iOException) {
                Debug.out(iOException);
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Throwable throwable) {}
                }
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (Throwable throwable) {}
                }
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    ((IpRange)iterator.next()).checkValid();
                }
                this.ipFilter.markAsUpToDate();
            }
        }
        finally {
            class_mon.exit();
        }
    }

    private int getP2BFileVersion(InputStream inputStream) {
        try {
            int n;
            for (int i = 0; i < 4; ++i) {
                n = inputStream.read();
                if (n == 255) continue;
                return -1;
            }
            byte[] byArray = new byte[]{80, 50, 66};
            for (n = 0; n < byArray.length; ++n) {
                byte by = byArray[n];
                if (by == inputStream.read()) continue;
                return -1;
            }
            n = inputStream.read();
            Logger.log(new LogEvent(LOGID, "Log Filter: loading p2b version " + n));
            return n;
        }
        catch (IOException iOException) {
            Debug.out(iOException);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadOtherFilters(boolean bl, boolean bl2) {
        int n;
        int n2;
        String string;
        Object object;
        Iterator iterator;
        int n3 = -1;
        class_mon.enter();
        ArrayList<IpRangeImpl> arrayList = new ArrayList<IpRangeImpl>(1024);
        InputStream inputStream = null;
        BufferedInputStream bufferedInputStream = null;
        boolean bl3 = false;
        try {
            Object object2;
            String string2 = COConfigurationManager.getStringParameter(CFG_AUTOLOAD_FILE);
            Logger.log(new LogEvent(LOGID, "IP Filter file: " + (String)string2));
            File file = new File(string2);
            if (file.exists()) {
                bl3 = false;
            } else {
                if (!UrlUtils.isURL(string2)) {
                    return;
                }
                bl3 = true;
                file = FileUtil.getUserFile("ipfilter.dl");
                if (file.exists()) {
                    if (bl) {
                        Logger.log(new LogEvent(LOGID, "Downloading " + (String)string2 + "  async"));
                        this.downloadFiltersAsync(new URL(string2));
                        if (!bl2) {
                            return;
                        }
                    }
                } else {
                    Logger.log(new LogEvent(LOGID, "sync Downloading " + (String)string2));
                    try {
                        object2 = ResourceDownloaderFactoryImpl.getSingleton().create(new URL(string2));
                        inputStream = object2.download();
                        FileUtil.copyFile(inputStream, file);
                        this.setNextAutoDownload(true);
                    }
                    catch (ResourceDownloaderException resourceDownloaderException) {
                        if (bufferedInputStream != null) {
                            try {
                                bufferedInputStream.close();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        Iterator iterator2 = arrayList.iterator();
                        while (iterator2.hasNext()) {
                            ((IpRange)iterator2.next()).checkValid();
                        }
                        this.ipFilter.markAsUpToDate();
                        if (!bl3) {
                            this.setFileReloadTimer();
                        }
                        class_mon.exit();
                        return;
                    }
                }
            }
            inputStream = new FileInputStream(file);
            bufferedInputStream = new BufferedInputStream(inputStream, 16384);
            object2 = new byte[2];
            bufferedInputStream.mark(3);
            bufferedInputStream.read((byte[])object2, 0, 2);
            bufferedInputStream.reset();
            if (object2[1] == -117 && object2[0] == 31) {
                iterator = new GZIPInputStream(bufferedInputStream);
                file = FileUtil.getUserFile("ipfilter.ext");
                FileUtil.copyFile((InputStream)((Object)iterator), file);
                inputStream = new FileInputStream(file);
                bufferedInputStream = new BufferedInputStream(inputStream, 16384);
            } else if (object2[0] == 80 && object2[1] == 75) {
                iterator = new ZipInputStream(bufferedInputStream);
                object = ((ZipInputStream)((Object)iterator)).getNextEntry();
                while (object != null && ((ZipEntry)object).getSize() < 0x100000L) {
                    object = ((ZipInputStream)((Object)iterator)).getNextEntry();
                }
                if (object == null) {
                    return;
                }
                file = FileUtil.getUserFile("ipfilter.ext");
                FileUtil.copyFile(iterator, file);
                inputStream = new FileInputStream(file);
                bufferedInputStream = new BufferedInputStream(inputStream, 16384);
            }
            bufferedInputStream.mark(8);
            n3 = this.getP2BFileVersion(bufferedInputStream);
            if (n3 < 1 || n3 > 3) {
                bufferedInputStream.reset();
                this.loadDATFilters(bufferedInputStream);
                return;
            }
            iterator = (Iterator)new byte[255];
            object = new byte[4];
            String string3 = string = n3 == 1 ? "ISO-8859-1" : "UTF-8";
            if (n3 != 1 && n3 != 2) {
                int n4 = bufferedInputStream.read((byte[])object);
                if (n4 < 4) {
                    return;
                }
                n2 = ByteFormatter.byteArrayToInt((byte[])object);
                String[] stringArray = new String[n2];
                for (n = 0; n < n2; ++n) {
                    stringArray[n] = this.readString(bufferedInputStream, (byte[])iterator, string);
                }
                n4 = bufferedInputStream.read((byte[])object);
                if (n4 < 4) {
                    return;
                }
                n = ByteFormatter.byteArrayToInt((byte[])object);
                int n5 = 0;
                while (n5 < n) {
                    n4 = bufferedInputStream.read((byte[])object);
                    if (n4 < 4) {
                        return;
                    }
                    int n6 = ByteFormatter.byteArrayToInt((byte[])object);
                    n4 = bufferedInputStream.read((byte[])object);
                    if (n4 < 4) {
                        return;
                    }
                    int n7 = ByteFormatter.byteArrayToInt((byte[])object);
                    n4 = bufferedInputStream.read((byte[])object);
                    if (n4 < 4) {
                        return;
                    }
                    int n8 = ByteFormatter.byteArrayToInt((byte[])object);
                    String string4 = n6 < stringArray.length && n6 >= 0 ? stringArray[n6] : "";
                    IpRangeImpl ipRangeImpl = new IpRangeImpl(string4, n7, n8, true);
                    ipRangeImpl.setAddedToRangeList(true);
                    arrayList.add(ipRangeImpl);
                    ++n5;
                }
                return;
            }
        }
        catch (IOException iOException) {
            Debug.out(iOException);
            return;
        }
        finally {
            class_mon.exit();
        }
        while (true) {
            String string5 = this.readString(bufferedInputStream, (byte[])iterator, string);
            n2 = bufferedInputStream.read((byte[])object);
            if (n2 < 4) {
                return;
            }
            int n9 = ByteFormatter.byteArrayToInt((byte[])object);
            n2 = bufferedInputStream.read((byte[])object);
            if (n2 < 4) {
                return;
            }
            n = ByteFormatter.byteArrayToInt((byte[])object);
            IpRangeImpl ipRangeImpl = new IpRangeImpl(string5, n9, n, true);
            ipRangeImpl.setAddedToRangeList(true);
            arrayList.add(ipRangeImpl);
        }
    }

    private void setFileReloadTimer() {
        if (this.timerEventFilterReload instanceof TimerEvent) {
            ((TimerEvent)this.timerEventFilterReload).cancel();
        } else if (this.timerEventFilterReload instanceof TimerEventPeriodic) {
            ((TimerEventPeriodic)this.timerEventFilterReload).cancel();
        }
        this.timerEventFilterReload = SimpleTimer.addPeriodicEvent("IP Filter download", 60000L, new TimerEventPerformer(){
            long lastFileModified;

            @Override
            public void perform(TimerEvent timerEvent2) {
                timerEvent2.cancel();
                String string = COConfigurationManager.getStringParameter(IpFilterAutoLoaderImpl.CFG_AUTOLOAD_FILE);
                File file = new File(string);
                if (!file.exists()) {
                    return;
                }
                long l = file.lastModified();
                if (this.lastFileModified == 0L) {
                    this.lastFileModified = l;
                } else if (this.lastFileModified != l) {
                    try {
                        IpFilterAutoLoaderImpl.this.ipFilter.reload();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private void downloadFiltersAsync(URL uRL) {
        ResourceDownloader resourceDownloader = ResourceDownloaderFactoryImpl.getSingleton().create(uRL);
        resourceDownloader.addListener(new ResourceDownloaderAdapter(){

            @Override
            public void reportPercentComplete(ResourceDownloader resourceDownloader, int n) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean completed(ResourceDownloader resourceDownloader, InputStream inputStream) {
                try {
                    IpFilterAutoLoaderImpl.this.setNextAutoDownload(true);
                    Logger.log(new LogEvent(LOGID, "downloaded..waiting"));
                    class_mon.enter();
                    Logger.log(new LogEvent(LOGID, "downloaded.. copying"));
                    try {
                        FileUtil.copyFile(inputStream, FileUtil.getUserFile("ipfilter.dl"));
                        AEThread aEThread = new AEThread("reload ipfilters", true){

                            @Override
                            public void runSupport() {
                                try {
                                    UIFunctions uIFunctions = UIFunctionsManager.getUIFunctions();
                                    if (uIFunctions != null) {
                                        uIFunctions.setStatusText("Reloading Filters..");
                                    }
                                    IpFilterAutoLoaderImpl.this.ipFilter.reload(false);
                                    if (uIFunctions != null) {
                                        uIFunctions.setStatusText(null);
                                    }
                                }
                                catch (Exception exception) {
                                    Debug.out(exception);
                                }
                            }
                        };
                        aEThread.setPriority(4);
                        aEThread.start();
                    }
                    catch (Exception exception) {
                        Debug.out(exception);
                    }
                }
                finally {
                    class_mon.exit();
                }
                return true;
            }
        });
        resourceDownloader.asyncDownload();
    }

    public void setNextAutoDownload(boolean bl) {
        long l;
        long l2 = SystemTime.getCurrentTime();
        if (bl) {
            COConfigurationManager.setParameter(CFG_AUTOLOAD_LAST, l2);
            l = l2;
        } else {
            l = COConfigurationManager.getLongParameter(CFG_AUTOLOAD_LAST);
            if (l > l2) {
                l = l2;
                COConfigurationManager.setParameter(CFG_AUTOLOAD_LAST, l2);
            }
        }
        long l3 = l + 604800000L;
        if (this.timerEventFilterReload instanceof TimerEvent) {
            ((TimerEvent)this.timerEventFilterReload).cancel();
        } else if (this.timerEventFilterReload instanceof TimerEventPeriodic) {
            ((TimerEventPeriodic)this.timerEventFilterReload).cancel();
        }
        this.timerEventFilterReload = SimpleTimer.addEvent("IP Filter download", l3, new TimerEventPerformer(){

            @Override
            public void perform(TimerEvent timerEvent2) {
                String string = COConfigurationManager.getStringParameter(IpFilterAutoLoaderImpl.CFG_AUTOLOAD_FILE);
                try {
                    IpFilterAutoLoaderImpl.this.downloadFiltersAsync(new URL(string));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        });
    }

    private String readString(BufferedInputStream bufferedInputStream, byte[] byArray, String string) {
        int n = 0;
        try {
            int n2;
            while ((n2 = bufferedInputStream.read()) >= 0) {
                if (n < byArray.length) {
                    byArray[n] = (byte)n2;
                    ++n;
                }
                if (n2 != 0) continue;
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (n > 1) {
            try {
                return new String(byArray, 0, n - 1, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return "";
    }
}

