/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.internat;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.gudy.azureus2.core3.internat.LocaleUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoderCandidate;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoderFallback;
import org.gudy.azureus2.core3.internat.LocaleUtilEncodingException;
import org.gudy.azureus2.core3.internat.LocaleUtilListener;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class LocaleTorrentUtil {
    private static List listeners = new ArrayList();

    public static LocaleUtilDecoder getTorrentEncodingIfAvailable(TOTorrent tOTorrent) throws TOTorrentException, UnsupportedEncodingException {
        String string;
        String string2 = tOTorrent.getAdditionalStringProperty("encoding");
        if (string2 == null) {
            return null;
        }
        if ("utf8 keys".equals(string2)) {
            string2 = "utf8";
        }
        try {
            string = Charset.forName(string2).name();
        }
        catch (Throwable throwable) {
            string = string2;
        }
        LocaleUtilDecoder localeUtilDecoder = null;
        LocaleUtilDecoder[] localeUtilDecoderArray = LocaleUtil.getSingleton().getDecoders();
        for (int i = 0; i < localeUtilDecoderArray.length; ++i) {
            if (!localeUtilDecoderArray[i].getName().equals(string)) continue;
            localeUtilDecoder = localeUtilDecoderArray[i];
            break;
        }
        return localeUtilDecoder;
    }

    public static LocaleUtilDecoder getTorrentEncoding(TOTorrent tOTorrent) throws TOTorrentException, UnsupportedEncodingException {
        Object object;
        Object[] objectArray;
        boolean bl;
        String string = tOTorrent.getAdditionalStringProperty("encoding");
        if ("utf8 keys".equals(string)) {
            string = "utf8";
        }
        try {
            TorrentUtils.getTorrentFileName(tOTorrent);
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        if (string != null) {
            try {
                objectArray = LocaleUtil.getSingleton().getDecoders();
                LocaleUtilDecoder localeUtilDecoder = LocaleUtil.getSingleton().getFallBackDecoder();
                object = string.equals(localeUtilDecoder.getName()) ? string : Charset.forName(string).name();
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!objectArray[i].getName().equals(object)) continue;
                    return objectArray[i];
                }
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        objectArray = LocaleTorrentUtil.getTorrentCandidates(tOTorrent);
        boolean bl2 = false;
        object = LocaleUtil.getSingleton();
        LocaleUtilDecoder localeUtilDecoder = ((LocaleUtil)object).getSystemDecoder();
        for (int i = 0; i < objectArray.length; ++i) {
            if (((LocaleUtilDecoderCandidate)objectArray[i]).getDecoder() != localeUtilDecoder) continue;
            bl2 = true;
            break;
        }
        LocaleUtilDecoder localeUtilDecoder2 = null;
        for (int i = 0; i < listeners.size(); ++i) {
            LocaleUtilDecoderCandidate localeUtilDecoderCandidate = null;
            try {
                localeUtilDecoderCandidate = ((LocaleUtilListener)listeners.get(i)).selectDecoder((LocaleUtil)object, tOTorrent, (LocaleUtilDecoderCandidate[])objectArray);
            }
            catch (LocaleUtilEncodingException localeUtilEncodingException) {
                // empty catch block
            }
            if (localeUtilDecoderCandidate != null) {
                localeUtilDecoder2 = localeUtilDecoderCandidate.getDecoder();
                break;
            }
            bl = false;
        }
        if (localeUtilDecoder2 == null) {
            localeUtilDecoder2 = bl2 ? ((LocaleUtil)object).getSystemDecoder() : ((LocaleUtil)object).getFallBackDecoder();
        }
        tOTorrent.setAdditionalStringProperty("encoding", localeUtilDecoder2.getName());
        if (bl) {
            TorrentUtils.writeToFile(tOTorrent);
        }
        return localeUtilDecoder2;
    }

    protected static LocaleUtilDecoderCandidate[] getTorrentCandidates(TOTorrent tOTorrent) throws TOTorrentException, UnsupportedEncodingException {
        Object object;
        Object object2;
        HashSet hashSet = new HashSet();
        LocaleUtil localeUtil = LocaleUtil.getSingleton();
        List list = localeUtil.getCandidateDecoders(tOTorrent.getName());
        long l = list.size();
        Object object3 = tOTorrent.getName();
        hashSet.addAll(list);
        TOTorrentFile[] tOTorrentFileArray = tOTorrent.getFiles();
        for (int i = 0; i < tOTorrentFileArray.length; ++i) {
            object2 = tOTorrentFileArray[i];
            object = object2.getPathComponents();
            for (int j = 0; j < ((byte[][])object).length; ++j) {
                list = localeUtil.getCandidateDecoders((byte[])object[j]);
                if ((long)list.size() < l) {
                    l = list.size();
                    object3 = object[j];
                }
                hashSet.retainAll(list);
            }
        }
        byte[] byArray = tOTorrent.getComment();
        if (byArray != null) {
            list = localeUtil.getCandidateDecoders(byArray);
            if ((long)list.size() < l) {
                l = list.size();
                object3 = byArray;
            }
            hashSet.retainAll(list);
        }
        if ((object2 = (Object)tOTorrent.getCreatedBy()) != null) {
            list = localeUtil.getCandidateDecoders((byte[])object2);
            if ((long)list.size() < l) {
                l = list.size();
                object3 = object2;
            }
            hashSet.retainAll(list);
        }
        object = localeUtil.getCandidatesAsList((byte[])object3);
        LocaleUtilDecoderCandidate[] localeUtilDecoderCandidateArray = new LocaleUtilDecoderCandidate[object.size()];
        object.toArray(localeUtilDecoderCandidateArray);
        Arrays.sort(localeUtilDecoderCandidateArray, new Comparator(){

            public int compare(Object object, Object object2) {
                LocaleUtilDecoderCandidate localeUtilDecoderCandidate = (LocaleUtilDecoderCandidate)object;
                LocaleUtilDecoderCandidate localeUtilDecoderCandidate2 = (LocaleUtilDecoderCandidate)object2;
                return localeUtilDecoderCandidate.getDecoder().getIndex() - localeUtilDecoderCandidate2.getDecoder().getIndex();
            }
        });
        return localeUtilDecoderCandidateArray;
    }

    public static void setTorrentEncoding(TOTorrent tOTorrent, String string) throws LocaleUtilEncodingException {
        try {
            String string2;
            LocaleUtil localeUtil = LocaleUtil.getSingleton();
            LocaleUtilDecoderCandidate[] localeUtilDecoderCandidateArray = LocaleTorrentUtil.getTorrentCandidates(tOTorrent);
            if (string.equalsIgnoreCase("system")) {
                string2 = localeUtil.getSystemEncoding();
            } else if (string.equalsIgnoreCase(LocaleUtilDecoderFallback.NAME)) {
                string2 = LocaleUtilDecoderFallback.NAME;
            } else {
                CharsetDecoder charsetDecoder = Charset.forName(string).newDecoder();
                string2 = charsetDecoder.charset().name();
            }
            boolean bl = false;
            for (int i = 0; i < localeUtilDecoderCandidateArray.length; ++i) {
                if (!localeUtilDecoderCandidateArray[i].getDecoder().getName().equals(string2)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                String[] stringArray = new String[localeUtilDecoderCandidateArray.length];
                String[] stringArray2 = new String[localeUtilDecoderCandidateArray.length];
                for (int i = 0; i < localeUtilDecoderCandidateArray.length; ++i) {
                    LocaleUtilDecoder localeUtilDecoder = localeUtilDecoderCandidateArray[i].getDecoder();
                    stringArray[i] = localeUtilDecoder.getName();
                    stringArray2[i] = localeUtilDecoder.decodeString(tOTorrent.getName());
                }
                throw new LocaleUtilEncodingException(stringArray, stringArray2);
            }
            tOTorrent.setAdditionalStringProperty("encoding", string2);
        }
        catch (Throwable throwable) {
            if (throwable instanceof LocaleUtilEncodingException) {
                throw (LocaleUtilEncodingException)throwable;
            }
            throw new LocaleUtilEncodingException(throwable);
        }
    }

    public static void setDefaultTorrentEncoding(TOTorrent tOTorrent) throws LocaleUtilEncodingException {
        LocaleTorrentUtil.setTorrentEncoding(tOTorrent, "UTF8");
    }

    public static String getCurrentTorrentEncoding(TOTorrent tOTorrent) {
        return tOTorrent.getAdditionalStringProperty("encoding");
    }

    public static void addListener(LocaleUtilListener localeUtilListener) {
        listeners.add(localeUtilListener);
    }

    public static void removeListener(LocaleUtilListener localeUtilListener) {
        listeners.remove(localeUtilListener);
    }
}

