/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl.piecemapper.impl;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceList;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMap;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapper;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapperFile;
import org.gudy.azureus2.core3.disk.impl.piecemapper.impl.DMPieceMapImpl;
import org.gudy.azureus2.core3.disk.impl.piecemapper.impl.DMPieceMapSimple;
import org.gudy.azureus2.core3.disk.impl.piecemapper.impl.PieceListImpl;
import org.gudy.azureus2.core3.disk.impl.piecemapper.impl.PieceMapEntryImpl;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.StringInterner;

public class PieceMapperImpl
implements DMPieceMapper {
    private TOTorrent torrent;
    private int last_piece_length;
    protected ArrayList<fileInfo> btFileList = new ArrayList();

    public PieceMapperImpl(TOTorrent tOTorrent) {
        this.torrent = tOTorrent;
        int n = (int)this.torrent.getPieceLength();
        int n2 = this.torrent.getNumberOfPieces();
        long l = this.torrent.getSize();
        this.last_piece_length = (int)(l - (long)(n2 - 1) * (long)n);
    }

    @Override
    public void construct(LocaleUtilDecoder localeUtilDecoder, String string) throws UnsupportedEncodingException {
        TOTorrentFile[] tOTorrentFileArray = this.torrent.getFiles();
        if (this.torrent.isSimpleTorrent()) {
            this.buildFileLookupTables(tOTorrentFileArray[0], string);
        } else {
            this.buildFileLookupTables(tOTorrentFileArray, localeUtilDecoder);
        }
    }

    private void buildFileLookupTables(TOTorrentFile tOTorrentFile, String string) {
        this.btFileList.add(new fileInfo(tOTorrentFile, "", string));
    }

    private void buildFileLookupTables(TOTorrentFile[] tOTorrentFileArray, LocaleUtilDecoder localeUtilDecoder) throws UnsupportedEncodingException {
        char c = File.separatorChar;
        for (int i = 0; i < tOTorrentFileArray.length; ++i) {
            this.buildFileLookupTable(tOTorrentFileArray[i], localeUtilDecoder, c);
        }
    }

    private void buildFileLookupTable(TOTorrentFile tOTorrentFile, LocaleUtilDecoder localeUtilDecoder, char c) throws UnsupportedEncodingException {
        byte[][] byArray = tOTorrentFile.getPathComponents();
        StringBuffer stringBuffer = new StringBuffer(0);
        int n = byArray.length - 1;
        for (int i = 0; i < n; ++i) {
            String string = localeUtilDecoder.decodeString(byArray[i]);
            string = FileUtil.convertOSSpecificChars(string, true);
            stringBuffer.append(string);
            stringBuffer.append(c);
        }
        String string = localeUtilDecoder.decodeString(byArray[n]);
        string = FileUtil.convertOSSpecificChars(string, false);
        this.btFileList.add(new fileInfo(tOTorrentFile, stringBuffer.toString(), string));
    }

    @Override
    public DMPieceMap getPieceMap() {
        if (this.btFileList.size() == 1) {
            return new DMPieceMapSimple(this.torrent, this.btFileList.get(0).getFileInfo());
        }
        int n = (int)this.torrent.getPieceLength();
        int n2 = this.torrent.getNumberOfPieces();
        long l = this.torrent.getSize();
        DMPieceList[] dMPieceListArray = new DMPieceList[n2];
        int n3 = n;
        if (l < (long)n3) {
            n3 = (int)l;
        }
        long l2 = 0L;
        int n4 = 0;
        for (int i = 0; 1 == n2 && i < n2 || i < n2 - 1; ++i) {
            ArrayList<PieceMapEntryImpl> arrayList = new ArrayList<PieceMapEntryImpl>();
            int n5 = 0;
            while (n3 > n5) {
                fileInfo fileInfo2 = this.btFileList.get(n4);
                long l3 = fileInfo2.getLength();
                long l4 = l3 - l2;
                PieceMapEntryImpl pieceMapEntryImpl = null;
                if (l4 <= (long)(n3 - n5)) {
                    pieceMapEntryImpl = new PieceMapEntryImpl(fileInfo2.getFileInfo(), l2, (int)l4);
                    n5 = (int)((long)n5 + l4);
                    l2 = 0L;
                    ++n4;
                } else {
                    pieceMapEntryImpl = new PieceMapEntryImpl(fileInfo2.getFileInfo(), l2, n3 - n5);
                    l2 += (long)(n3 - n5);
                    n5 += n3 - n5;
                }
                arrayList.add(pieceMapEntryImpl);
            }
            dMPieceListArray[i] = PieceListImpl.convert(arrayList);
        }
        if (n2 > 1) {
            dMPieceListArray[n2 - 1] = PieceListImpl.convert(this.buildLastPieceToFileList(this.btFileList, n4, l2));
        }
        return new DMPieceMapImpl(dMPieceListArray);
    }

    private List<PieceMapEntryImpl> buildLastPieceToFileList(List<fileInfo> list, int n, long l) {
        ArrayList<PieceMapEntryImpl> arrayList = new ArrayList<PieceMapEntryImpl>();
        for (int i = n; i < list.size(); ++i) {
            fileInfo fileInfo2 = list.get(i);
            long l2 = fileInfo2.getLength() - l;
            PieceMapEntryImpl pieceMapEntryImpl = new PieceMapEntryImpl(fileInfo2.getFileInfo(), l, (int)l2);
            arrayList.add(pieceMapEntryImpl);
            l = 0L;
        }
        return arrayList;
    }

    @Override
    public long getTotalLength() {
        return this.torrent.getSize();
    }

    @Override
    public int getPieceLength() {
        return (int)this.torrent.getPieceLength();
    }

    @Override
    public int getLastPieceLength() {
        return this.last_piece_length;
    }

    @Override
    public DMPieceMapperFile[] getFiles() {
        DMPieceMapperFile[] dMPieceMapperFileArray = new DMPieceMapperFile[this.btFileList.size()];
        this.btFileList.toArray(dMPieceMapperFileArray);
        return dMPieceMapperFileArray;
    }

    protected static class fileInfo
    implements DMPieceMapperFile {
        private DiskManagerFileInfoImpl file;
        private TOTorrentFile torrent_file;
        private String path;
        private String name;

        public fileInfo(TOTorrentFile tOTorrentFile, String string, String string2) {
            this.torrent_file = tOTorrentFile;
            this.path = StringInterner.intern(string);
            this.name = string2;
        }

        @Override
        public long getLength() {
            return this.torrent_file.getLength();
        }

        @Override
        public File getDataFile() {
            return new File(this.path, this.name);
        }

        @Override
        public TOTorrentFile getTorrentFile() {
            return this.torrent_file;
        }

        @Override
        public DiskManagerFileInfoImpl getFileInfo() {
            return this.file;
        }

        @Override
        public void setFileInfo(DiskManagerFileInfoImpl diskManagerFileInfoImpl) {
            this.file = diskManagerFileInfoImpl;
        }
    }
}

