/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl.access.impl;

import com.aelitis.azureus.core.diskmanager.access.DiskAccessController;
import com.aelitis.azureus.core.diskmanager.access.DiskAccessRequest;
import com.aelitis.azureus.core.diskmanager.access.DiskAccessRequestListener;
import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gudy.azureus2.core3.disk.DiskManagerException;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequest;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequestListener;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerHelper;
import org.gudy.azureus2.core3.disk.impl.access.DMWriter;
import org.gudy.azureus2.core3.disk.impl.access.impl.DiskManagerWriteRequestImpl;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceList;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapEntry;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;
import org.gudy.azureus2.core3.util.SystemTime;

public class DMWriterImpl
implements DMWriter {
    private static final LogIDs LOGID = LogIDs.DISK;
    private static final int MIN_ZERO_BLOCK = 0x100000;
    private DiskManagerHelper disk_manager;
    private DiskAccessController disk_access;
    private int async_writes;
    private Set write_requests = new HashSet();
    private AESemaphore async_write_sem = new AESemaphore("DMWriter::asyncWrite");
    private boolean started;
    private volatile boolean stopped;
    private int pieceLength;
    private long totalLength;
    private boolean complete_recheck_in_progress;
    private AEMonitor this_mon = new AEMonitor("DMWriter");

    public DMWriterImpl(DiskManagerHelper diskManagerHelper) {
        this.disk_manager = diskManagerHelper;
        this.disk_access = this.disk_manager.getDiskAccessController();
        this.pieceLength = this.disk_manager.getPieceLength();
        this.totalLength = this.disk_manager.getTotalLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        try {
            this.this_mon.enter();
            if (this.started) {
                throw new RuntimeException("DMWWriter: start while started");
            }
            if (this.stopped) {
                throw new RuntimeException("DMWWriter: start after stopped");
            }
            this.started = true;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        int n;
        try {
            this.this_mon.enter();
            if (this.stopped || !this.started) {
                return;
            }
            this.stopped = true;
            n = this.async_writes;
        }
        finally {
            this.this_mon.exit();
        }
        long l = SystemTime.getCurrentTime();
        for (int i = 0; i < n; ++i) {
            long l2 = SystemTime.getCurrentTime();
            if (l2 < l) {
                l = l2;
            } else if (l2 - l > 1000L) {
                l = l2;
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.disk_manager, LOGID, "Waiting for writes to complete - " + (n - i) + " remaining"));
                }
            }
            this.async_write_sem.reserve();
        }
    }

    public boolean isChecking() {
        return this.complete_recheck_in_progress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zeroFile(DiskManagerFileInfoImpl diskManagerFileInfoImpl, long l) throws DiskManagerException {
        CacheFile cacheFile = diskManagerFileInfoImpl.getCacheFile();
        try {
            if (l == 0L) {
                cacheFile.setLength(0L);
            } else {
                int n = this.pieceLength < 0x100000 ? 0x100000 : this.pieceLength;
                n = (n + 1023) / 1024 * 1024;
                DirectByteBuffer directByteBuffer = DirectByteBufferPool.getBuffer((byte)7, n);
                long l2 = l;
                long l3 = 0L;
                try {
                    int n2;
                    byte[] byArray = new byte[1024];
                    for (n2 = 0; n2 < n / 1024; ++n2) {
                        directByteBuffer.put((byte)8, byArray);
                    }
                    directByteBuffer.position((byte)8, 0);
                    while (l2 > 0L && !this.stopped) {
                        n2 = n;
                        if (l2 < (long)n2) {
                            n2 = (int)l2;
                            directByteBuffer.limit((byte)8, n2);
                        }
                        final AESemaphore aESemaphore = new AESemaphore("DMW&C:zeroFile");
                        final Throwable[] throwableArray = new Throwable[]{null};
                        this.disk_access.queueWriteRequest(cacheFile, l3, directByteBuffer, false, new DiskAccessRequestListener(){

                            @Override
                            public void requestComplete(DiskAccessRequest diskAccessRequest) {
                                aESemaphore.release();
                            }

                            @Override
                            public void requestCancelled(DiskAccessRequest diskAccessRequest) {
                                throwableArray[0] = new Throwable("Request cancelled");
                                aESemaphore.release();
                            }

                            @Override
                            public void requestFailed(DiskAccessRequest diskAccessRequest, Throwable throwable) {
                                throwableArray[0] = throwable;
                                aESemaphore.release();
                            }

                            @Override
                            public int getPriority() {
                                return -1;
                            }

                            @Override
                            public void requestExecuted(long l) {
                            }
                        });
                        aESemaphore.reserve();
                        if (throwableArray[0] != null) {
                            throw throwableArray[0];
                        }
                        directByteBuffer.position((byte)8, 0);
                        l3 += (long)n2;
                        l2 -= (long)n2;
                        this.disk_manager.setAllocated(this.disk_manager.getAllocated() + (long)n2);
                        this.disk_manager.setPercentDone((int)(this.disk_manager.getAllocated() * 1000L / this.totalLength));
                    }
                }
                finally {
                    directByteBuffer.returnToPool();
                }
                cacheFile.flushCache();
            }
            if (this.stopped) {
                return false;
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            throw new DiskManagerException(throwable);
        }
        return true;
    }

    @Override
    public DiskManagerWriteRequest createWriteRequest(int n, int n2, DirectByteBuffer directByteBuffer, Object object) {
        return new DiskManagerWriteRequestImpl(n, n2, directByteBuffer, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasOutstandingWriteRequestForPiece(int n) {
        try {
            this.this_mon.enter();
            for (DiskManagerWriteRequest diskManagerWriteRequest : this.write_requests) {
                if (diskManagerWriteRequest.getPieceNumber() != n) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeBlock(final DiskManagerWriteRequest diskManagerWriteRequest, final DiskManagerWriteRequestListener diskManagerWriteRequestListener) {
        block12: {
            diskManagerWriteRequest.requestStarts();
            final DiskManagerWriteRequestListener diskManagerWriteRequestListener2 = new DiskManagerWriteRequestListener(){

                @Override
                public void writeCompleted(DiskManagerWriteRequest diskManagerWriteRequest) {
                    diskManagerWriteRequest.requestEnds(true);
                    diskManagerWriteRequestListener.writeCompleted(diskManagerWriteRequest);
                }

                @Override
                public void writeFailed(DiskManagerWriteRequest diskManagerWriteRequest, Throwable throwable) {
                    diskManagerWriteRequest.requestEnds(false);
                    diskManagerWriteRequestListener.writeFailed(diskManagerWriteRequest, throwable);
                }
            };
            try {
                int n = diskManagerWriteRequest.getPieceNumber();
                DirectByteBuffer directByteBuffer = diskManagerWriteRequest.getBuffer();
                int n2 = diskManagerWriteRequest.getOffset();
                final DiskManagerPiece diskManagerPiece = this.disk_manager.getPieces()[n];
                if (diskManagerPiece.isDone()) {
                    directByteBuffer.returnToPool();
                    diskManagerWriteRequestListener2.writeCompleted(diskManagerWriteRequest);
                    break block12;
                }
                int n3 = directByteBuffer.position((byte)8);
                int n4 = directByteBuffer.limit((byte)8);
                int n5 = 0;
                int n6 = 0;
                DMPieceList dMPieceList = this.disk_manager.getPieceList(n);
                DMPieceMapEntry dMPieceMapEntry = dMPieceList.get(n6);
                long l = dMPieceMapEntry.getOffset();
                while (n5 + dMPieceMapEntry.getLength() < n2) {
                    n5 += dMPieceMapEntry.getLength();
                    l = 0L;
                    dMPieceMapEntry = dMPieceList.get(++n6);
                }
                ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
                while (n3 < n4) {
                    dMPieceMapEntry = dMPieceList.get(n6);
                    long l2 = (long)n3 + (dMPieceMapEntry.getFile().getLength() - dMPieceMapEntry.getOffset() - (long)(n2 - n5));
                    if (l2 > (long)n4) {
                        l2 = n4;
                    }
                    if (l2 > (long)n3) {
                        long l3 = l + (long)(n2 - n5);
                        arrayList.add(new Object[]{dMPieceMapEntry.getFile(), new Long(l3), new Integer((int)l2)});
                        n3 = (int)l2;
                    }
                    ++n6;
                    l = 0L;
                    n5 = n2;
                }
                DiskManagerWriteRequestListener diskManagerWriteRequestListener3 = new DiskManagerWriteRequestListener(){

                    @Override
                    public void writeCompleted(DiskManagerWriteRequest diskManagerWriteRequest2) {
                        this.complete();
                        diskManagerWriteRequestListener2.writeCompleted(diskManagerWriteRequest2);
                    }

                    @Override
                    public void writeFailed(DiskManagerWriteRequest diskManagerWriteRequest2, Throwable throwable) {
                        this.complete();
                        if (diskManagerPiece.isDone()) {
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(DMWriterImpl.this.disk_manager, LOGID, "Piece " + diskManagerPiece.getPieceNumber() + " write failed but already marked as done"));
                            }
                            diskManagerWriteRequestListener2.writeCompleted(diskManagerWriteRequest2);
                        } else {
                            DMWriterImpl.this.disk_manager.setFailed("Disk write error - " + Debug.getNestedExceptionMessage(throwable));
                            Debug.printStackTrace(throwable);
                            diskManagerWriteRequestListener2.writeFailed(diskManagerWriteRequest2, throwable);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected void complete() {
                        try {
                            DMWriterImpl.this.this_mon.enter();
                            DMWriterImpl.this.async_writes--;
                            if (!DMWriterImpl.this.write_requests.remove(diskManagerWriteRequest)) {
                                Debug.out("request not found");
                            }
                            if (DMWriterImpl.this.stopped) {
                                DMWriterImpl.this.async_write_sem.release();
                            }
                        }
                        finally {
                            DMWriterImpl.this.this_mon.exit();
                        }
                    }
                };
                try {
                    this.this_mon.enter();
                    if (this.stopped) {
                        directByteBuffer.returnToPool();
                        diskManagerWriteRequestListener2.writeFailed(diskManagerWriteRequest, new Exception("Disk writer has been stopped"));
                        return;
                    }
                    ++this.async_writes;
                    this.write_requests.add(diskManagerWriteRequest);
                }
                finally {
                    this.this_mon.exit();
                }
                new requestDispatcher(diskManagerWriteRequest, diskManagerWriteRequestListener3, directByteBuffer, arrayList);
            }
            catch (Throwable throwable) {
                diskManagerWriteRequest.getBuffer().returnToPool();
                this.disk_manager.setFailed("Disk write error - " + Debug.getNestedExceptionMessage(throwable));
                Debug.printStackTrace(throwable);
                diskManagerWriteRequestListener2.writeFailed(diskManagerWriteRequest, throwable);
            }
        }
    }

    protected class requestDispatcher
    implements DiskAccessRequestListener {
        private DiskManagerWriteRequest request;
        private DiskManagerWriteRequestListener listener;
        private DirectByteBuffer buffer;
        private List chunks;
        private int chunk_index;

        protected requestDispatcher(DiskManagerWriteRequest diskManagerWriteRequest, DiskManagerWriteRequestListener diskManagerWriteRequestListener, DirectByteBuffer directByteBuffer, List list) {
            this.request = diskManagerWriteRequest;
            this.listener = diskManagerWriteRequestListener;
            this.buffer = directByteBuffer;
            this.chunks = list;
            this.dispatch();
        }

        protected void dispatch() {
            try {
                if (this.chunk_index == this.chunks.size()) {
                    this.listener.writeCompleted(this.request);
                } else if (this.chunk_index == 1 && this.chunks.size() > 32) {
                    for (int i = 1; i < this.chunks.size(); ++i) {
                        final AESemaphore aESemaphore = new AESemaphore("DMW&C:dispatch:asyncReq");
                        final Throwable[] throwableArray = new Throwable[]{null};
                        this.doRequest(new DiskAccessRequestListener(){

                            @Override
                            public void requestComplete(DiskAccessRequest diskAccessRequest) {
                                aESemaphore.release();
                            }

                            @Override
                            public void requestCancelled(DiskAccessRequest diskAccessRequest) {
                                Debug.out("shouldn't get here");
                            }

                            @Override
                            public void requestFailed(DiskAccessRequest diskAccessRequest, Throwable throwable) {
                                throwableArray[0] = throwable;
                                aESemaphore.release();
                            }

                            @Override
                            public int getPriority() {
                                return -1;
                            }

                            @Override
                            public void requestExecuted(long l) {
                            }
                        });
                        aESemaphore.reserve();
                        if (throwableArray[0] == null) continue;
                        throw throwableArray[0];
                    }
                    this.listener.writeCompleted(this.request);
                } else {
                    this.doRequest(this);
                }
            }
            catch (Throwable throwable) {
                this.failed(throwable);
            }
        }

        protected void doRequest(final DiskAccessRequestListener diskAccessRequestListener) throws CacheFileManagerException {
            Object[] objectArray = (Object[])this.chunks.get(this.chunk_index++);
            final DiskManagerFileInfoImpl diskManagerFileInfoImpl = (DiskManagerFileInfoImpl)objectArray[0];
            this.buffer.limit((byte)7, (Integer)objectArray[2]);
            if (diskManagerFileInfoImpl.getAccessMode() == 1) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(DMWriterImpl.this.disk_manager, LOGID, "Changing " + diskManagerFileInfoImpl.getFile(true).getName() + " to read/write"));
                }
                diskManagerFileInfoImpl.setAccessMode(2);
            }
            boolean bl = this.chunk_index == this.chunks.size();
            DiskAccessRequestListener diskAccessRequestListener2 = new DiskAccessRequestListener(){

                @Override
                public void requestComplete(DiskAccessRequest diskAccessRequest) {
                    diskAccessRequestListener.requestComplete(diskAccessRequest);
                    diskManagerFileInfoImpl.dataWritten(diskAccessRequest.getOffset(), diskAccessRequest.getSize());
                }

                @Override
                public void requestCancelled(DiskAccessRequest diskAccessRequest) {
                    diskAccessRequestListener.requestCancelled(diskAccessRequest);
                }

                @Override
                public void requestFailed(DiskAccessRequest diskAccessRequest, Throwable throwable) {
                    diskAccessRequestListener.requestFailed(diskAccessRequest, throwable);
                }

                @Override
                public int getPriority() {
                    return -1;
                }

                @Override
                public void requestExecuted(long l) {
                }
            };
            DMWriterImpl.this.disk_access.queueWriteRequest(diskManagerFileInfoImpl.getCacheFile(), (Long)objectArray[1], this.buffer, bl, diskAccessRequestListener2);
        }

        @Override
        public void requestComplete(DiskAccessRequest diskAccessRequest) {
            this.dispatch();
        }

        @Override
        public void requestCancelled(DiskAccessRequest diskAccessRequest) {
            Debug.out("shouldn't get here");
        }

        @Override
        public void requestFailed(DiskAccessRequest diskAccessRequest, Throwable throwable) {
            this.failed(throwable);
        }

        @Override
        public int getPriority() {
            return -1;
        }

        @Override
        public void requestExecuted(long l) {
        }

        protected void failed(Throwable throwable) {
            this.buffer.returnToPool();
            this.listener.writeFailed(this.request, throwable);
        }
    }
}

