/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl;

import java.util.Arrays;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoSet;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerHelper;
import org.gudy.azureus2.core3.disk.impl.DiskManagerUtil;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.util.Debug;

public class DiskManagerFileInfoSetImpl
implements DiskManagerFileInfoSet {
    final DiskManagerFileInfoImpl[] files;
    final DiskManagerHelper diskManager;

    public DiskManagerFileInfoSetImpl(DiskManagerFileInfoImpl[] diskManagerFileInfoImplArray, DiskManagerHelper diskManagerHelper) {
        this.files = diskManagerFileInfoImplArray;
        this.diskManager = diskManagerHelper;
    }

    @Override
    public DiskManagerFileInfo[] getFiles() {
        return this.files;
    }

    @Override
    public int nbFiles() {
        return this.files.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPriority(int[] nArray) {
        if (nArray.length != this.files.length) {
            throw new IllegalArgumentException("array length mismatches the number of files");
        }
        DownloadManagerState downloadManagerState = this.diskManager.getDownloadState();
        try {
            downloadManagerState.suppressStateSave(true);
            for (int i = 0; i < this.files.length; ++i) {
                if (nArray[i] <= 0) continue;
                this.files[i].setPriority(nArray[i]);
            }
        }
        finally {
            downloadManagerState.suppressStateSave(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSkipped(boolean[] blArray, boolean bl) {
        if (blArray.length != this.files.length) {
            throw new IllegalArgumentException("array length mismatches the number of files");
        }
        DownloadManagerState downloadManagerState = this.diskManager.getDownloadState();
        try {
            downloadManagerState.suppressStateSave(true);
            if (!bl) {
                String[] stringArray = this.diskManager.getStorageTypes();
                boolean[] blArray2 = new boolean[blArray.length];
                boolean[] blArray3 = new boolean[blArray.length];
                int n = 0;
                int n2 = 0;
                for (int i = 0; i < blArray.length; ++i) {
                    if (!blArray[i]) continue;
                    int n3 = DiskManagerUtil.convertDMStorageTypeFromString(stringArray[i]);
                    if (n3 == 2) {
                        blArray2[i] = true;
                        ++n;
                        continue;
                    }
                    if (n3 != 4) continue;
                    blArray3[i] = true;
                    ++n2;
                }
                if (n > 0 && !Arrays.equals(blArray2, this.setStorageTypes(blArray2, 1))) {
                    return;
                }
                if (n2 > 0 && !Arrays.equals(blArray3, this.setStorageTypes(blArray3, 3))) {
                    return;
                }
            }
            for (int i = 0; i < this.files.length; ++i) {
                if (!blArray[i]) continue;
                this.files[i].skipped = bl;
                this.diskManager.skippedFileSetChanged(this.files[i]);
            }
            if (!bl) {
                DiskManagerUtil.doFileExistenceChecks(this, blArray, this.diskManager.getDownloadState().getDownloadManager(), true);
            }
        }
        finally {
            downloadManagerState.suppressStateSave(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean[] setStorageTypes(boolean[] blArray, int n) {
        if (blArray.length != this.files.length) {
            throw new IllegalArgumentException("array length mismatches the number of files");
        }
        if (this.files.length == 0) {
            return new boolean[0];
        }
        String[] stringArray = this.diskManager.getStorageTypes();
        boolean[] blArray2 = new boolean[this.files.length];
        DownloadManagerState downloadManagerState = this.diskManager.getDownloadState();
        if (n == 2 || n == 4) {
            Debug.out("Download must be stopped for linear -> compact conversion");
            return blArray2;
        }
        try {
            downloadManagerState.suppressStateSave(true);
            for (int i = 0; i < this.files.length; ++i) {
                if (!blArray[i]) continue;
                int n2 = DiskManagerUtil.convertDMStorageTypeFromString(stringArray[i]);
                if (n == n2) {
                    blArray2[i] = true;
                    continue;
                }
                DiskManagerFileInfoImpl diskManagerFileInfoImpl = this.files[i];
                try {
                    diskManagerFileInfoImpl.getCacheFile().setStorageType(DiskManagerUtil.convertDMStorageTypeToCache(n));
                    blArray2[i] = true;
                    continue;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                    this.diskManager.setFailed(diskManagerFileInfoImpl, "Failed to change storage type for '" + diskManagerFileInfoImpl.getFile(true) + "': " + Debug.getNestedExceptionMessage(throwable));
                    break;
                }
                finally {
                    stringArray[i] = DiskManagerUtil.convertCacheStorageTypeToString(diskManagerFileInfoImpl.getCacheFile().getStorageType());
                }
            }
            downloadManagerState.setListAttribute("storetypes", stringArray);
            DiskManagerUtil.doFileExistenceChecks(this, blArray, downloadManagerState.getDownloadManager(), true);
        }
        finally {
            downloadManagerState.suppressStateSave(false);
            downloadManagerState.save();
        }
        return blArray2;
    }
}

