/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk;

import com.aelitis.azureus.core.util.CaseSensitiveFileMap;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoSet;
import org.gudy.azureus2.core3.disk.DiskManagerListener;
import org.gudy.azureus2.core3.disk.impl.DiskManagerImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerUtil;
import org.gudy.azureus2.core3.disk.impl.resume.RDResumeHandler;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.torrent.TOTorrent;

public class DiskManagerFactory {
    public static DiskManager create(TOTorrent tOTorrent, DownloadManager downloadManager) {
        DiskManagerImpl diskManagerImpl = new DiskManagerImpl(tOTorrent, downloadManager);
        if (diskManagerImpl.getState() != 10) {
            diskManagerImpl.start();
        }
        return diskManagerImpl;
    }

    public static void setResumeDataCompletelyValid(DownloadManagerState downloadManagerState) {
        RDResumeHandler.setTorrentResumeDataComplete(downloadManagerState);
    }

    public static void setTorrentResumeDataNearlyComplete(DownloadManagerState downloadManagerState) {
        RDResumeHandler.setTorrentResumeDataNearlyComplete(downloadManagerState);
    }

    public static boolean isTorrentResumeDataComplete(DownloadManagerState downloadManagerState) {
        return RDResumeHandler.isTorrentResumeDataComplete(downloadManagerState);
    }

    public static void deleteDataFiles(TOTorrent tOTorrent, String string, String string2, boolean bl) {
        DiskManagerImpl.deleteDataFiles(tOTorrent, string, string2, bl);
    }

    public static DiskManagerFileInfoSet getFileInfoSkeleton(DownloadManager downloadManager, DiskManagerListener diskManagerListener) {
        return DiskManagerUtil.getFileInfoSkeleton(downloadManager, diskManagerListener);
    }

    public static void setFileLinks(DownloadManager downloadManager, CaseSensitiveFileMap caseSensitiveFileMap) {
        DiskManagerImpl.setFileLinks(downloadManager, caseSensitiveFileMap);
    }

    public static void clearResumeData(DownloadManager downloadManager, DiskManagerFileInfo diskManagerFileInfo) {
        RDResumeHandler.clearResumeData(downloadManager, diskManagerFileInfo);
    }

    public static void recheckFile(DownloadManager downloadManager, DiskManagerFileInfo diskManagerFileInfo) {
        RDResumeHandler.recheckFile(downloadManager, diskManagerFileInfo);
    }
}

