/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManagerFactory;
import com.aelitis.azureus.util.ConstantsVuze;
import java.net.MalformedURLException;
import java.net.URL;

public class ContentNetworkUtils {
    public static String getUrl(ContentNetwork contentNetwork, int n) {
        try {
            if (!contentNetwork.isServiceSupported(n)) {
                return null;
            }
            return contentNetwork.getServiceURL(n);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static String getUrl(ContentNetwork contentNetwork, int n, Object[] objectArray) {
        try {
            if (!contentNetwork.isServiceSupported(n)) {
                return null;
            }
            return contentNetwork.getServiceURL(n, objectArray);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static ContentNetwork getContentNetworkFromTarget(String string) {
        ContentNetwork contentNetwork = null;
        if (string != null && string.startsWith("ContentNetwork.")) {
            long l = Long.parseLong(string.substring(15));
            contentNetwork = ContentNetworkManagerFactory.getSingleton().getContentNetwork(l);
        }
        if (contentNetwork == null) {
            contentNetwork = ConstantsVuze.getDefaultContentNetwork();
        }
        return contentNetwork;
    }

    public static String getTarget(ContentNetwork contentNetwork) {
        return "ContentNetwork." + (contentNetwork == null ? ConstantsVuze.getDefaultContentNetwork().getID() : contentNetwork.getID());
    }

    public static void setSourceRef(String string, String string2, boolean bl) {
        ContentNetworkUtils.setSourceRef(ContentNetworkUtils.getContentNetworkFromTarget(string), string2, bl);
    }

    public static void setSourceRef(ContentNetwork contentNetwork, String string, boolean bl) {
        String string2;
        Object object;
        if (contentNetwork == ConstantsVuze.getDefaultContentNetwork()) {
            return;
        }
        if (contentNetwork.isServiceSupported(31)) {
            boolean bl2 = false;
            object = contentNetwork.getPersistentProperty("auth_shown");
            if (object instanceof Boolean) {
                bl2 = (Boolean)object;
            }
            if (!bl2) {
                bl = true;
            }
        }
        if ((string2 = (String)contentNetwork.getPersistentProperty("source_ref")) == null || bl) {
            if (string != null && string.startsWith("http")) {
                try {
                    object = new URL(string);
                    string = ((URL)object).getHost() + ((URL)object).getPath();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            contentNetwork.setPersistentProperty("source_ref", string);
        }
    }
}

