/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.tracker.peerauth;

import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import java.io.BufferedInputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResultPeer;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadPeerListener;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.plugins.download.DownloadTrackerListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.peers.PeerManagerListener;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;

public class TrackerPeerAuthPlugin
implements Plugin,
DownloadManagerListener {
    private static final String PLUGIN_NAME = "Tracker Peer Auth";
    private static final String PLUGIN_CONFIGSECTION_ID = "Plugin.trackerpeerauth.name";
    private static final int DEFAULT_CHECK_PERIOD = 30000;
    private static final String STATE_ENABLED = "enabled";
    private static final String STATE_DISABLED = "disabled";
    private static final int TIMER_PERIOD = 10000;
    private PluginInterface plugin_interface;
    private TorrentAttribute ta_state;
    private LoggerChannel log;
    private Map dt_map = new HashMap();
    private ThreadPool thread_pool = new ThreadPool("TrackerPeerAuthPlugin", 8, true);

    public static void load(PluginInterface pluginInterface) {
        pluginInterface.getPluginProperties().setProperty("plugin.version", "1.0");
        pluginInterface.getPluginProperties().setProperty("plugin.name", PLUGIN_NAME);
    }

    @Override
    public void initialize(PluginInterface pluginInterface) {
        this.plugin_interface = pluginInterface;
        this.ta_state = this.plugin_interface.getTorrentManager().getPluginAttribute("state");
        this.log = this.plugin_interface.getLogger().getTimeStampedChannel(PLUGIN_NAME);
        UIManager uIManager = this.plugin_interface.getUIManager();
        BasicPluginConfigModel basicPluginConfigModel = uIManager.createBasicPluginConfigModel("plugins", PLUGIN_CONFIGSECTION_ID);
        basicPluginConfigModel.addLabelParameter2("Plugin.trackerpeerauth.info");
        final BasicPluginViewModel basicPluginViewModel = this.plugin_interface.getUIManager().createBasicPluginViewModel(PLUGIN_CONFIGSECTION_ID);
        basicPluginViewModel.setConfigSectionID(PLUGIN_CONFIGSECTION_ID);
        basicPluginViewModel.getActivity().setVisible(false);
        basicPluginViewModel.getProgress().setVisible(false);
        this.log.addListener(new LoggerChannelListener(){

            @Override
            public void messageLogged(int n, String string) {
                basicPluginViewModel.getLogArea().appendText(string + "\n");
            }

            @Override
            public void messageLogged(String string, Throwable throwable) {
                if (string.length() > 0) {
                    basicPluginViewModel.getLogArea().appendText(string + "\n");
                }
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                throwable.printStackTrace(printWriter);
                printWriter.flush();
                basicPluginViewModel.getLogArea().appendText(stringWriter.toString() + "\n");
            }
        });
        System.out.println("**** tracker peer auth disabled ****");
    }

    @Override
    public void downloadAdded(final Download download) {
        Torrent torrent = download.getTorrent();
        if (torrent != null && torrent.isPrivate()) {
            download.addTrackerListener(new DownloadTrackerListener(){

                @Override
                public void scrapeResult(DownloadScrapeResult downloadScrapeResult) {
                }

                @Override
                public void announceResult(DownloadAnnounceResult downloadAnnounceResult) {
                    if (downloadAnnounceResult.getResponseType() == 1) {
                        Map map = downloadAnnounceResult.getExtensions();
                        boolean bl = true;
                        int n = 30000;
                        if (map != null) {
                            // empty if block
                        }
                        download.setAttribute(TrackerPeerAuthPlugin.this.ta_state, bl ? TrackerPeerAuthPlugin.STATE_ENABLED : TrackerPeerAuthPlugin.STATE_DISABLED);
                        TrackerPeerAuthPlugin.this.setState(download, bl, n);
                    }
                }
            });
            String string = download.getAttribute(this.ta_state);
            if (string != null) {
                boolean bl = string.equals(STATE_ENABLED);
                this.setState(download, bl, 30000);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadRemoved(Download download) {
        Map map = this.dt_map;
        synchronized (map) {
            this.dt_map.remove(download);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(Download download, boolean bl, int n) {
        Map map = this.dt_map;
        synchronized (map) {
            if (bl) {
                DownloadTracker downloadTracker = (DownloadTracker)this.dt_map.get(download);
                if (downloadTracker == null) {
                    DownloadTracker downloadTracker2 = new DownloadTracker(download, n);
                    this.dt_map.put(download, downloadTracker2);
                } else {
                    downloadTracker.setCheckPeriod(n);
                }
            } else {
                this.dt_map.remove(download);
            }
        }
    }

    protected void log(Download download, String string) {
        this.log.log("Download '" + download.getName() + "' - " + string);
    }

    protected class DownloadTracker
    implements DownloadPeerListener,
    PeerManagerListener,
    DownloadTrackerListener {
        private static final int BACKOFF_TICK_COUNT = 6;
        private static final int MAX_PEERS_PER_QUERY = 100;
        private static final int OK_BLOOM_INITIAL = 16384;
        private static final int OK_BLOOM_INC = 16384;
        private static final int OK_BLOOM_MAX = 131072;
        private static final int BAD_BLOOM_INITIAL = 4096;
        private static final int BAD_BLOOM_INC = 4096;
        private static final int BAD_BLOOM_MAX = 65536;
        private Download download;
        private BloomFilter ok_bloom = BloomFilterFactory.createAddOnly(16384);
        private BloomFilter bad_bloom = BloomFilterFactory.createAddOnly(4096);
        private long pending_check_peer_count = 0L;
        private boolean check_running;
        private int check_tick_count;
        private int backoff_tick_count;

        protected DownloadTracker(Download download, int n) {
            this.download = download;
            this.download.addTrackerListener(this);
            this.download.addPeerListener(this);
            this.setCheckPeriod(n);
            this.log("enabled, check period=" + n);
        }

        protected void setCheckPeriod(int n) {
            this.check_tick_count = n / 10000;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void recordPeer(String string, byte[] byArray, String string2, int n, boolean bl) {
            if (byArray == null) {
                return;
            }
            byte[] byArray2 = this.getKey(byArray, string2);
            DownloadTracker downloadTracker = this;
            synchronized (downloadTracker) {
                if (bl) {
                    int n2 = this.ok_bloom.getEntryCount();
                    if (n2 > 0 && this.ok_bloom.getSize() / n2 < 10) {
                        int n3 = this.ok_bloom.getSize() + 16384;
                        if (n3 > 131072) {
                            n3 = 131072;
                        }
                        this.log("Expanding ok bloom to " + n3 + " entries");
                        BloomFilter bloomFilter = BloomFilterFactory.createAddOnly(n3);
                        PeerManager peerManager = this.download.getPeerManager();
                        if (peerManager != null) {
                            Peer[] peerArray = peerManager.getPeers();
                            for (int i = 0; i < peerArray.length; ++i) {
                                byte[] byArray3 = this.getKey(peerArray[i]);
                                if (byArray3 == null || !this.ok_bloom.contains(byArray3)) continue;
                                bloomFilter.add(byArray3);
                            }
                        }
                        this.ok_bloom = bloomFilter;
                        this.bad_bloom = BloomFilterFactory.createAddOnly(this.bad_bloom.getSize());
                    }
                    this.ok_bloom.add(byArray2);
                } else {
                    int n4 = this.bad_bloom.getEntryCount();
                    if (n4 > 0 && this.bad_bloom.getSize() / n4 < 10) {
                        int n5 = this.bad_bloom.getSize() + 4096;
                        if (n5 > 65536) {
                            n5 = 65536;
                        }
                        this.log("Expanding bad bloom to " + n5 + " entries");
                        this.bad_bloom = BloomFilterFactory.createAddOnly(n5);
                    }
                    this.bad_bloom.add(byArray2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void checkPeers(long l) {
            if (this.backoff_tick_count > 0) {
                --this.backoff_tick_count;
                return;
            }
            if (l % (long)this.check_tick_count == 0L) {
                Object object;
                DownloadTracker downloadTracker = this;
                synchronized (downloadTracker) {
                    if (this.pending_check_peer_count <= 0L || this.check_running) {
                        return;
                    }
                    this.pending_check_peer_count = 0L;
                    this.check_running = true;
                }
                boolean bl = false;
                try {
                    object = this.download.getPeerManager();
                    if (object != null) {
                        Peer[] peerArray = object.getPeers();
                        final ArrayList<Peer> arrayList = new ArrayList<Peer>();
                        for (int i = 0; i < peerArray.length; ++i) {
                            Peer peer = peerArray[i];
                            byte[] byArray = this.getKey(peer);
                            if (byArray == null || this.ok_bloom.contains(byArray)) continue;
                            if (this.bad_bloom.contains(byArray)) {
                                this.removePeer(peer);
                                continue;
                            }
                            arrayList.add(peer);
                        }
                        if (arrayList.size() > 0) {
                            TrackerPeerAuthPlugin.this.thread_pool.run(new AERunnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void runSupport() {
                                    try {
                                        DownloadTracker.this.check(arrayList);
                                    }
                                    finally {
                                        DownloadTracker downloadTracker = DownloadTracker.this;
                                        synchronized (downloadTracker) {
                                            DownloadTracker.this.check_running = false;
                                        }
                                    }
                                }
                            });
                            bl = true;
                        }
                    }
                }
                finally {
                    if (!bl) {
                        object = this;
                        synchronized (object) {
                            this.check_running = false;
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void check(List list) {
            URL uRL;
            DownloadAnnounceResult downloadAnnounceResult = this.download.getLastAnnounceResult();
            URL uRL2 = uRL = downloadAnnounceResult == null ? null : downloadAnnounceResult.getURL();
            if (uRL == null) {
                uRL = this.download.getTorrent().getAnnounceURL();
            }
            OutputStreamWriter outputStreamWriter = null;
            BufferedInputStream bufferedInputStream = null;
            try {
                Object object;
                Object object2;
                String string = uRL.toString();
                int n = string.indexOf("announce");
                if (n == -1) {
                    this.log("announce URL '" + string + "' is non-conformant");
                    return;
                }
                string = string.substring(0, n) + "testauth" + string.substring(n + 8);
                uRL = new URL(string);
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                String string2 = "";
                for (int i = 0; i < list.size() && i < 100; ++i) {
                    object2 = (Peer)list.get(i);
                    object = new ArrayList<Object>();
                    object.add(this.download.getTorrent().getHash());
                    object.add(object2.getId());
                    object.add(object2.getIp());
                    hashMap.put("peer" + i, object);
                    string2 = string2 + (i == 0 ? "" : ",") + object2.getIp();
                }
                this.log("Checking " + string + " : peers=" + string2);
                byte[] byArray = BEncoder.encode(hashMap, true);
                object2 = (HttpURLConnection)uRL.openConnection();
                object = "authpeers=" + new String(byArray, "ISO-8859-1");
                System.out.println("sending '" + (String)object + "'");
                ((URLConnection)object2).setDoOutput(true);
                ((HttpURLConnection)object2).setRequestMethod("POST");
                ((URLConnection)object2).setRequestProperty("User-Agent", "Azureus 4.5.0.4");
                ((URLConnection)object2).setRequestProperty("Connection", "close");
                ((URLConnection)object2).addRequestProperty("Accept-Encoding", "gzip");
                outputStreamWriter = new OutputStreamWriter(((URLConnection)object2).getOutputStream());
                outputStreamWriter.write((String)object);
                outputStreamWriter.flush();
                bufferedInputStream = new BufferedInputStream(((URLConnection)object2).getInputStream());
                Map map = BDecoder.decode(bufferedInputStream);
                for (int i = 0; i < list.size() && i < 100; ++i) {
                    Peer peer = (Peer)list.get(i);
                    Long l = (Long)map.get("peer" + i);
                    if (l == null) {
                        this.log("No response for peer '" + peer.getIp() + "'");
                        continue;
                    }
                    boolean bl = l != 0L;
                    this.recordPeer("auth check", peer.getId(), peer.getIp(), peer.getPort(), bl);
                    if (bl) continue;
                    this.removePeer(peer);
                }
            }
            catch (Throwable throwable) {
                this.backoff_tick_count = 6;
                throwable.printStackTrace();
            }
            finally {
                if (outputStreamWriter != null) {
                    try {
                        outputStreamWriter.close();
                    }
                    catch (Throwable throwable) {}
                }
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }

        protected byte[] getKey(Peer peer) {
            byte[] byArray = peer.getId();
            if (byArray == null) {
                return null;
            }
            return this.getKey(byArray, peer.getIp());
        }

        protected byte[] getKey(byte[] byArray, String string) {
            byte[] byArray2 = string.getBytes();
            byte[] byArray3 = new byte[byArray.length + byArray2.length];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
            return byArray3;
        }

        protected boolean knownToBeOK(Peer peer) {
            byte[] byArray = peer.getId();
            if (byArray == null) {
                return true;
            }
            byte[] byArray2 = this.getKey(byArray, peer.getIp());
            return this.ok_bloom.contains(byArray2);
        }

        protected boolean knownToBeBad(Peer peer) {
            byte[] byArray = peer.getId();
            if (byArray == null) {
                return true;
            }
            byte[] byArray2 = this.getKey(byArray, peer.getIp());
            return this.bad_bloom.contains(byArray2);
        }

        protected void peerMightBeBad(Peer peer) {
            if (!this.knownToBeOK(peer)) {
                if (this.knownToBeBad(peer)) {
                    this.removePeer(peer);
                } else {
                    ++this.pending_check_peer_count;
                }
            }
        }

        protected void removePeer(Peer peer) {
            this.log("Disconnecting peer " + peer.getIp() + "/" + peer.getPort() + ": not authorized");
            peer.close("Tracker peer authorization failure", false, false);
        }

        @Override
        public void scrapeResult(DownloadScrapeResult downloadScrapeResult) {
        }

        @Override
        public void announceResult(DownloadAnnounceResult downloadAnnounceResult) {
            DownloadAnnounceResultPeer[] downloadAnnounceResultPeerArray = downloadAnnounceResult.getPeers();
            if (downloadAnnounceResultPeerArray != null) {
                for (int i = 0; i < downloadAnnounceResultPeerArray.length; ++i) {
                    DownloadAnnounceResultPeer downloadAnnounceResultPeer = downloadAnnounceResultPeerArray[i];
                    this.recordPeer("Tracker", downloadAnnounceResultPeer.getPeerID(), downloadAnnounceResultPeer.getAddress(), downloadAnnounceResultPeer.getPort(), true);
                }
            }
        }

        @Override
        public void peerAdded(PeerManager peerManager, Peer peer) {
            if (peer.isIncoming()) {
                this.peerMightBeBad(peer);
            } else {
                this.recordPeer("Outgoing", peer.getId(), peer.getIp(), peer.getPort(), true);
            }
        }

        @Override
        public void peerRemoved(PeerManager peerManager, Peer peer) {
        }

        @Override
        public void peerManagerAdded(Download download, PeerManager peerManager) {
            peerManager.addListener(this);
        }

        @Override
        public void peerManagerRemoved(Download download, PeerManager peerManager) {
            peerManager.removeListener(this);
        }

        protected void log(String string) {
            TrackerPeerAuthPlugin.this.log(this.download, string);
        }
    }
}

