/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.tracker.local;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.instancemanager.AZInstance;
import com.aelitis.azureus.core.instancemanager.AZInstanceManager;
import com.aelitis.azureus.core.instancemanager.AZInstanceManagerListener;
import com.aelitis.azureus.core.instancemanager.AZInstanceTracked;
import com.aelitis.azureus.core.tracker.TrackerPeerSource;
import com.aelitis.azureus.core.tracker.TrackerPeerSourceAdapter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginConfigListener;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadListener;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.StringParameter;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;
import org.gudy.azureus2.plugins.utils.DelayedTask;
import org.gudy.azureus2.plugins.utils.Monitor;
import org.gudy.azureus2.plugins.utils.UTTimerEvent;
import org.gudy.azureus2.plugins.utils.UTTimerEventPerformer;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

public class LocalTrackerPlugin
implements Plugin,
AZInstanceManagerListener,
DownloadManagerListener,
DownloadListener {
    private static final String PLUGIN_NAME = "LAN Peer Finder";
    private static final String PLUGIN_CONFIGSECTION_ID = "Plugin.localtracker.name";
    private static final long ANNOUNCE_PERIOD = 300000L;
    private static final long RE_ANNOUNCE_PERIOD = 60000L;
    private PluginInterface plugin_interface;
    private AZInstanceManager instance_manager;
    private boolean active;
    private TorrentAttribute ta_networks;
    private TorrentAttribute ta_peer_sources;
    private Map<Download, long[]> downloads = new HashMap<Download, long[]>();
    private Map<String, Map<String, Long>> track_times = new HashMap<String, Map<String, Long>>();
    private String last_autoadd = "";
    private String last_subnets = "";
    private BooleanParameter enabled;
    private long plugin_start_time;
    private long current_time;
    private LoggerChannel log;
    private Monitor mon;
    private AsyncDispatcher dispatcher = new AsyncDispatcher(30000);

    public static void load(PluginInterface pluginInterface) {
        pluginInterface.getPluginProperties().setProperty("plugin.version", "1.0");
        pluginInterface.getPluginProperties().setProperty("plugin.name", PLUGIN_NAME);
    }

    @Override
    public void initialize(PluginInterface pluginInterface) {
        this.plugin_interface = pluginInterface;
        this.ta_networks = this.plugin_interface.getTorrentManager().getAttribute("Networks");
        this.ta_peer_sources = this.plugin_interface.getTorrentManager().getAttribute("PeerSources");
        this.mon = this.plugin_interface.getUtilities().getMonitor();
        this.log = this.plugin_interface.getLogger().getTimeStampedChannel(PLUGIN_NAME);
        UIManager uIManager = this.plugin_interface.getUIManager();
        BasicPluginConfigModel basicPluginConfigModel = uIManager.createBasicPluginConfigModel("plugins", PLUGIN_CONFIGSECTION_ID);
        basicPluginConfigModel.addLabelParameter2("Plugin.localtracker.info");
        this.enabled = basicPluginConfigModel.addBooleanParameter2("Plugin.localtracker.enable", "Plugin.localtracker.enable", true);
        basicPluginConfigModel.addLabelParameter2("Plugin.localtracker.networks.info");
        final StringParameter stringParameter = basicPluginConfigModel.addStringParameter2("Plugin.localtracker.networks", "Plugin.localtracker.networks", "");
        final BooleanParameter booleanParameter = basicPluginConfigModel.addBooleanParameter2("Plugin.localtracker.wellknownlocals", "Plugin.localtracker.wellknownlocals", true);
        basicPluginConfigModel.addLabelParameter2("Plugin.localtracker.autoadd.info");
        final StringParameter stringParameter2 = basicPluginConfigModel.addStringParameter2("Plugin.localtracker.autoadd", "Plugin.localtracker.autoadd", "");
        final BasicPluginViewModel basicPluginViewModel = this.plugin_interface.getUIManager().createBasicPluginViewModel(PLUGIN_CONFIGSECTION_ID);
        basicPluginViewModel.setConfigSectionID(PLUGIN_CONFIGSECTION_ID);
        basicPluginViewModel.getActivity().setVisible(false);
        basicPluginViewModel.getProgress().setVisible(false);
        this.log.addListener(new LoggerChannelListener(){

            @Override
            public void messageLogged(int n, String string) {
                basicPluginViewModel.getLogArea().appendText(string + "\n");
            }

            @Override
            public void messageLogged(String string, Throwable throwable) {
                if (string.length() > 0) {
                    basicPluginViewModel.getLogArea().appendText(string + "\n");
                }
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                throwable.printStackTrace(printWriter);
                printWriter.flush();
                basicPluginViewModel.getLogArea().appendText(stringWriter.toString() + "\n");
            }
        });
        this.plugin_start_time = this.plugin_interface.getUtilities().getCurrentSystemTime();
        this.instance_manager = AzureusCoreFactory.getSingleton().getInstanceManager();
        this.instance_manager.addListener(this);
        this.plugin_interface.getPluginconfig().addListener(new PluginConfigListener(){

            @Override
            public void configSaved() {
                LocalTrackerPlugin.this.processSubNets(stringParameter.getValue(), booleanParameter.getValue());
                LocalTrackerPlugin.this.processAutoAdd(stringParameter2.getValue());
            }
        });
        this.processSubNets(stringParameter.getValue(), booleanParameter.getValue());
        this.processAutoAdd(stringParameter2.getValue());
        DelayedTask delayedTask = this.plugin_interface.getUtilities().createDelayedTask(new Runnable(){

            @Override
            public void run() {
                LocalTrackerPlugin.this.plugin_interface.getDownloadManager().addListener(LocalTrackerPlugin.this);
            }
        });
        delayedTask.queue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void instanceFound(AZInstance aZInstance) {
        if (!this.enabled.getValue()) {
            return;
        }
        this.log.log("Found: " + aZInstance.getString());
        try {
            this.mon.enter();
            this.track_times.put(aZInstance.getID(), new HashMap());
        }
        finally {
            this.mon.exit();
        }
        this.checkActivation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkActivation() {
        try {
            this.mon.enter();
            if (this.active) {
                return;
            }
            this.active = true;
            this.plugin_interface.getUtilities().createThread("Tracker", new Runnable(){

                @Override
                public void run() {
                    LocalTrackerPlugin.this.track();
                }
            });
        }
        finally {
            this.mon.exit();
        }
    }

    @Override
    public void instanceChanged(AZInstance aZInstance) {
        if (!this.enabled.getValue()) {
            return;
        }
        this.log.log("Changed: " + aZInstance.getString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void instanceLost(AZInstance aZInstance) {
        try {
            this.mon.enter();
            this.track_times.remove(aZInstance.getID());
        }
        finally {
            this.mon.exit();
        }
        if (!this.enabled.getValue()) {
            return;
        }
        this.log.log("Lost: " + aZInstance.getString());
    }

    @Override
    public void instanceTracked(AZInstanceTracked aZInstanceTracked) {
        if (!this.enabled.getValue()) {
            return;
        }
        this.handleTrackResult(aZInstanceTracked);
    }

    protected void track() {
        long l = this.plugin_interface.getUtilities().getCurrentSystemTime();
        if (l - this.plugin_start_time < 60000L) {
            try {
                Thread.sleep(15000L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.plugin_interface.getUtilities().createTimer("LanPeerFinder:Tracker", true).addPeriodicEvent(30000L, new UTTimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform(UTTimerEvent uTTimerEvent) {
                LocalTrackerPlugin.this.current_time = LocalTrackerPlugin.this.plugin_interface.getUtilities().getCurrentSystemTime();
                try {
                    ArrayList<Download> arrayList = new ArrayList<Download>();
                    try {
                        LocalTrackerPlugin.this.mon.enter();
                        for (Map.Entry entry : LocalTrackerPlugin.this.downloads.entrySet()) {
                            Download download = (Download)entry.getKey();
                            long l = ((long[])entry.getValue())[0];
                            if (l <= LocalTrackerPlugin.this.current_time && LocalTrackerPlugin.this.current_time - l <= 300000L) continue;
                            arrayList.add(download);
                        }
                    }
                    finally {
                        LocalTrackerPlugin.this.mon.exit();
                    }
                    for (int i = 0; i < arrayList.size(); ++i) {
                        LocalTrackerPlugin.this.track((Download)arrayList.get(i));
                    }
                }
                catch (Throwable throwable) {
                    LocalTrackerPlugin.this.log.log(throwable);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void track(Download download) {
        long l = this.plugin_interface.getUtilities().getCurrentSystemTime();
        boolean bl = false;
        try {
            this.mon.enter();
            long[] lArray = this.downloads.get(download);
            if (lArray == null) {
                return;
            }
            long l2 = lArray[0];
            if (l2 > l || l - l2 > 60000L) {
                bl = true;
                lArray[0] = l;
            }
        }
        finally {
            this.mon.exit();
        }
        if (bl) {
            this.trackSupport(download);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trackSupport(final Download download) {
        if (!this.enabled.getValue()) {
            return;
        }
        int n = download.getState();
        if (n == 8 || n == 7) {
            return;
        }
        String[] stringArray = download.getListAttribute(this.ta_peer_sources);
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase("Plugin")) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        if (download.getTorrent() == null) {
            return;
        }
        byte[] byArray = new SHA1Simple().calculateHash(download.getTorrent().getHash());
        AZInstanceTracked[] aZInstanceTrackedArray = this.instance_manager.track(byArray, new AZInstanceTracked.TrackTarget(){

            @Override
            public Object getTarget() {
                return download;
            }

            @Override
            public boolean isSeed() {
                return download.isComplete();
            }
        });
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < aZInstanceTrackedArray.length; ++i) {
            int n5 = this.handleTrackResult(aZInstanceTrackedArray[i]);
            if (n5 == 1) {
                ++n2;
                continue;
            }
            if (n5 == 2) {
                ++n3;
                continue;
            }
            if (n5 == 3) {
                ++n2;
                ++n4;
                continue;
            }
            if (n5 != 4) continue;
            ++n3;
            ++n4;
        }
        try {
            this.mon.enter();
            long[] lArray = this.downloads.get(download);
            if (lArray != null) {
                lArray[1] = n2;
                lArray[2] = n3;
                lArray[3] = n4;
            }
        }
        finally {
            this.mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forceTrack(final Download download) {
        try {
            this.mon.enter();
            long[] lArray = this.downloads.get(download);
            if (lArray == null) {
                lArray = new long[4];
                this.downloads.put(download, lArray);
            } else {
                lArray[0] = 0L;
            }
            String string = this.plugin_interface.getUtilities().getFormatters().encodeBytesToString(download.getTorrent().getHash());
            Iterator<Map<String, Long>> iterator = this.track_times.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().remove(string);
            }
        }
        finally {
            this.mon.exit();
        }
        this.dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                LocalTrackerPlugin.this.track(download);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int handleTrackResult(AZInstanceTracked aZInstanceTracked) {
        String string;
        Object object;
        AZInstance aZInstance = aZInstanceTracked.getInstance();
        Download download = (Download)aZInstanceTracked.getTarget().getTarget();
        boolean bl = aZInstanceTracked.isSeed();
        long l = this.plugin_interface.getUtilities().getCurrentSystemTime();
        boolean bl2 = false;
        try {
            long l2;
            Long l3;
            this.mon.enter();
            object = this.track_times.get(aZInstance.getID());
            if (object == null) {
                object = new HashMap<String, Long>();
                this.track_times.put(aZInstance.getID(), (Map<String, Long>)object);
            }
            if ((l3 = object.get(string = this.plugin_interface.getUtilities().getFormatters().encodeBytesToString(download.getTorrent().getHash()))) != null && l - (l2 = l3.longValue()) < 30000L) {
                bl2 = true;
            }
            object.put((String)string, (Long)new Long(l));
        }
        finally {
            this.mon.exit();
        }
        if (bl2) {
            return -1;
        }
        this.log.log("Tracked: " + aZInstance.getString() + ": " + download.getName() + ", seed = " + bl);
        if (download.isComplete() && bl) {
            return bl ? 1 : 0;
        }
        object = download.getPeerManager();
        if (object != null) {
            string = aZInstance.getInternalAddress().getHostAddress();
            int n = aZInstance.getTCPListenPort();
            int n2 = aZInstance.getUDPListenPort();
            this.log.log("    " + download.getName() + ": Injecting peer " + string + ":" + n + "/" + n2);
            object.addPeer(string, n, n2, false);
        }
        return bl ? 3 : 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadAdded(Download download) {
        try {
            long[] lArray;
            this.mon.enter();
            Torrent torrent = download.getTorrent();
            if (torrent == null) {
                return;
            }
            if (TorrentUtils.isReallyPrivate(PluginCoreUtils.unwrap(torrent))) {
                this.log.log("Not tracking " + download.getName() + ": torrent is private");
                return;
            }
            String[] stringArray = download.getListAttribute(this.ta_networks);
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equalsIgnoreCase("Public")) continue;
                bl = true;
                break;
            }
            if (!bl) {
                this.log.log("Not tracking " + download.getName() + ": torrent has no public network");
                return;
            }
            if (this.enabled.getValue()) {
                this.log.log("Tracking " + download.getName());
            }
            if ((lArray = this.downloads.get(download)) == null) {
                lArray = new long[4];
                this.downloads.put(download, lArray);
            } else {
                lArray[0] = 0L;
            }
            download.addListener(this);
        }
        finally {
            this.mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadRemoved(Download download) {
        try {
            this.mon.enter();
            this.downloads.remove(download);
            download.removeListener(this);
        }
        finally {
            this.mon.exit();
        }
    }

    public TrackerPeerSource getTrackerPeerSource(final Download download) {
        return new TrackerPeerSourceAdapter(){
            private long[] _last_data;
            private boolean enabled;
            private boolean running;
            private long fixup_time;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private long[] fixup() {
                long l = SystemTime.getMonotonousTime();
                if (l - this.fixup_time > 1000L) {
                    int n;
                    try {
                        LocalTrackerPlugin.this.mon.enter();
                        this._last_data = (long[])LocalTrackerPlugin.this.downloads.get(download);
                    }
                    finally {
                        LocalTrackerPlugin.this.mon.exit();
                    }
                    this.enabled = LocalTrackerPlugin.this.enabled.getValue();
                    this.running = this.enabled ? (n = download.getState()) == 4 || n == 5 : false;
                    this.fixup_time = l;
                }
                return this._last_data;
            }

            @Override
            public int getType() {
                return 4;
            }

            @Override
            public String getName() {
                return MessageText.getString("tps.lan.details", new String[]{String.valueOf(LocalTrackerPlugin.this.instance_manager.getOtherInstanceCount())});
            }

            @Override
            public int getStatus() {
                long[] lArray = this.fixup();
                if (lArray == null || !this.enabled) {
                    return 1;
                }
                if (this.running) {
                    return 5;
                }
                return 2;
            }

            @Override
            public int getSeedCount() {
                long[] lArray = this.fixup();
                if (lArray == null || !this.running) {
                    return -1;
                }
                return (int)lArray[1];
            }

            @Override
            public int getLeecherCount() {
                long[] lArray = this.fixup();
                if (lArray == null || !this.running) {
                    return -1;
                }
                return (int)lArray[2];
            }

            @Override
            public int getPeers() {
                long[] lArray = this.fixup();
                if (lArray == null || !this.running) {
                    return -1;
                }
                return (int)lArray[3];
            }

            @Override
            public int getSecondsToUpdate() {
                long[] lArray = this.fixup();
                if (lArray == null || !this.running) {
                    return Integer.MIN_VALUE;
                }
                return (int)((300000L - (SystemTime.getCurrentTime() - lArray[0])) / 1000L);
            }

            @Override
            public int getInterval() {
                if (this.running) {
                    return 300;
                }
                return -1;
            }

            @Override
            public int getMinInterval() {
                if (this.running) {
                    return 60;
                }
                return -1;
            }

            @Override
            public boolean isUpdating() {
                int n = this.getSecondsToUpdate();
                return n != Integer.MIN_VALUE && n < 0;
            }
        };
    }

    @Override
    public void stateChanged(Download download, int n, int n2) {
        if (n2 == 4 || n2 == 5) {
            this.forceTrack(download);
        }
    }

    @Override
    public void positionChanged(Download download, int n, int n2) {
    }

    protected void processSubNets(String string, boolean bl) {
        if (bl != this.instance_manager.getIncludeWellKnownLANs()) {
            this.instance_manager.setIncludeWellKnownLANs(bl);
            this.log.log("Include well known local networks set to " + bl);
        }
        if (string.equals(this.last_subnets)) {
            return;
        }
        this.last_subnets = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            try {
                if (!this.instance_manager.addLANSubnet(string2)) continue;
                this.log.log("Added network '" + string2 + "'");
            }
            catch (Throwable throwable) {
                this.log.log("Failed to add network '" + string2 + "'", throwable);
            }
        }
    }

    protected void processAutoAdd(String string) {
        if (string.equals(this.last_autoadd)) {
            return;
        }
        this.last_autoadd = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            try {
                InetAddress inetAddress = InetAddress.getByName(string2.trim());
                if (!this.instance_manager.addInstance(inetAddress)) continue;
                this.log.log("Added peer '" + string2 + "'");
            }
            catch (Throwable throwable) {
                this.log.log("Failed to decode peer '" + string2 + "'", throwable);
            }
        }
    }
}

