/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.vuzefile;

import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileComponent;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import java.io.File;

public class VuzeFileMerger {
    protected VuzeFileMerger(String[] stringArray) {
        File file;
        if (stringArray.length != 1) {
            this.usage();
        }
        if (!(file = new File(stringArray[0])).isDirectory()) {
            this.usage();
        }
        try {
            File file2 = new File(stringArray[0] + ".vuze");
            File[] fileArray = file.listFiles();
            VuzeFileHandler vuzeFileHandler = VuzeFileHandler.getSingleton();
            VuzeFile vuzeFile = vuzeFileHandler.create();
            for (int i = 0; i < fileArray.length; ++i) {
                File file3 = fileArray[i];
                if (file3.isDirectory() || !file3.getName().endsWith(".vuze")) continue;
                VuzeFile vuzeFile2 = vuzeFileHandler.loadVuzeFile(file3.getAbsolutePath());
                System.out.println("Read " + file3);
                VuzeFileComponent[] vuzeFileComponentArray = vuzeFile2.getComponents();
                for (int j = 0; j < vuzeFileComponentArray.length; ++j) {
                    VuzeFileComponent vuzeFileComponent = vuzeFileComponentArray[j];
                    vuzeFile.addComponent(vuzeFileComponent.getType(), vuzeFileComponent.getContent());
                    System.out.println("    added component: " + vuzeFileComponent.getType());
                }
            }
            vuzeFile.write(file2);
            System.out.println("Wrote " + file2);
        }
        catch (Throwable throwable) {
            System.err.print("Failed to merge vuze files");
            throwable.printStackTrace();
        }
    }

    protected void usage() {
        System.err.println("Usage: <dir_of_vuze_files_to_merge>");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        new VuzeFileMerger(stringArray);
    }
}

