/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util.bloom.impl;

import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.impl.BloomFilterImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BloomFilterRotator
implements BloomFilter {
    private volatile BloomFilter current_filter;
    private int current_filter_index;
    private final BloomFilter[] filters;

    public BloomFilterRotator(BloomFilter bloomFilter, int n) {
        this.filters = new BloomFilter[n];
        this.filters[0] = bloomFilter;
        for (int i = 1; i < this.filters.length; ++i) {
            this.filters[i] = bloomFilter.getReplica();
        }
        this.current_filter = bloomFilter;
        this.current_filter_index = 0;
    }

    public BloomFilterRotator(Map<String, Object> map) {
        List list = (List)map.get("list");
        this.filters = new BloomFilter[list.size()];
        for (int i = 0; i < this.filters.length; ++i) {
            this.filters[i] = BloomFilterImpl.deserialiseFromMap((Map)list.get(i));
        }
        this.current_filter_index = ((Long)map.get("index")).intValue();
        this.current_filter = this.filters[this.current_filter_index];
    }

    @Override
    public Map<String, Object> serialiseToMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        this.serialiseToMap(hashMap);
        return hashMap;
    }

    protected void serialiseToMap(Map<String, Object> map) {
        String string = this.getClass().getName();
        if (string.startsWith("com.aelitis.azureus.core.util.bloom.impl")) {
            string = string.substring("com.aelitis.azureus.core.util.bloom.impl".length());
        }
        map.put("_impl", string);
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        for (BloomFilter bloomFilter : this.filters) {
            arrayList.add(bloomFilter.serialiseToMap());
        }
        map.put("list", arrayList);
        map.put("index", new Long(this.current_filter_index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int add(byte[] byArray) {
        BloomFilter[] bloomFilterArray = this.filters;
        synchronized (this.filters) {
            int n;
            int n2;
            int n3 = this.current_filter.getSize();
            int n4 = this.current_filter.getEntryCount();
            int n5 = n3 / 8;
            if (n4 > n5) {
                n4 = n5;
            }
            if ((n2 = n4 / (n = n5 / this.filters.length) + 1) > this.filters.length) {
                n2 = this.filters.length;
            }
            int n6 = 0;
            for (int i = this.current_filter_index; i < this.current_filter_index + n2; ++i) {
                int n7 = this.filters[i % this.filters.length].add(byArray);
                if (i != this.current_filter_index) continue;
                n6 = n7;
            }
            if (this.current_filter.getEntryCount() > n5) {
                this.filters[this.current_filter_index] = this.current_filter.getReplica();
                this.current_filter_index = (this.current_filter_index + 1) % this.filters.length;
                this.current_filter = this.filters[this.current_filter_index];
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return n6;
        }
    }

    @Override
    public int remove(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < this.filters.length; ++i) {
            BloomFilter bloomFilter = this.filters[i];
            int n2 = bloomFilter.remove(byArray);
            if (bloomFilter != this.current_filter) continue;
            n = n2;
        }
        return n;
    }

    @Override
    public boolean contains(byte[] byArray) {
        return this.current_filter.contains(byArray);
    }

    @Override
    public int count(byte[] byArray) {
        return this.current_filter.count(byArray);
    }

    @Override
    public int getEntryCount() {
        return this.current_filter.getEntryCount();
    }

    @Override
    public int getSize() {
        return this.current_filter.getSize();
    }

    @Override
    public BloomFilter getReplica() {
        return new BloomFilterRotator(this.current_filter, this.filters.length);
    }

    @Override
    public String getString() {
        return "ind=" + this.current_filter_index + ",filt=" + this.current_filter.getString();
    }
}

