/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.limewire.util.OSUtils;

public class DNSUtils {
    private static String getFactory() {
        String string = OSUtils.isLinux() ? "org.limewire.util.LinuxDnsContextFactory" : "com.sun.jndi.dns.DnsContextFactory";
        return System.getProperty("azureus.dns.context.factory", string);
    }

    public static DirContext getInitialDirContext() throws NamingException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.factory.initial", DNSUtils.getFactory());
        return new InitialDirContext(hashtable);
    }

    public static Inet6Address getIPV6ByName(String string) throws UnknownHostException {
        List<Inet6Address> list = DNSUtils.getAllIPV6ByName(string);
        return list.get(0);
    }

    public static List<Inet6Address> getAllIPV6ByName(String string) throws UnknownHostException {
        ArrayList<Inet6Address> arrayList = new ArrayList<Inet6Address>();
        try {
            Attribute attribute;
            DirContext dirContext = DNSUtils.getInitialDirContext();
            Attributes attributes = dirContext.getAttributes(string, new String[]{"AAAA"});
            if (attributes != null && (attribute = attributes.get("aaaa")) != null) {
                NamingEnumeration<?> namingEnumeration = attribute.getAll();
                while (namingEnumeration.hasMore()) {
                    Object obj = namingEnumeration.next();
                    if (!(obj instanceof String)) continue;
                    try {
                        arrayList.add((Inet6Address)InetAddress.getByName((String)obj));
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (arrayList.size() > 0) {
            return arrayList;
        }
        throw new UnknownHostException(string);
    }
}

