/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.subs.impl;

import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.Result;
import com.aelitis.azureus.core.metasearch.SearchLoginException;
import com.aelitis.azureus.core.metasearch.SearchParameter;
import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionException;
import com.aelitis.azureus.core.subs.impl.SubscriptionHistoryImpl;
import com.aelitis.azureus.core.subs.impl.SubscriptionImpl;
import com.aelitis.azureus.core.subs.impl.SubscriptionManagerImpl;
import com.aelitis.azureus.core.subs.impl.SubscriptionResultFilter;
import com.aelitis.azureus.core.subs.impl.SubscriptionResultImpl;
import com.aelitis.azureus.util.JSONUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;

public class SubscriptionDownloader {
    private SubscriptionManagerImpl manager;
    private SubscriptionImpl subs;

    protected SubscriptionDownloader(SubscriptionManagerImpl subscriptionManagerImpl, SubscriptionImpl subscriptionImpl) throws SubscriptionException {
        this.manager = subscriptionManagerImpl;
        this.subs = subscriptionImpl;
    }

    protected void download() throws SubscriptionException {
        this.log("Downloading");
        Map map = JSONUtils.decodeJSON(this.subs.getJSON());
        Long l = (Long)map.get("engine_id");
        String string = (String)map.get("search_term");
        Map map2 = (Map)map.get("filters");
        Engine engine = this.manager.getEngine(this.subs, map, false);
        if (engine == null) {
            throw new SubscriptionException("Download failed, search engine " + l + " not found");
        }
        ArrayList<SearchParameter> arrayList = new ArrayList<SearchParameter>();
        if (string != null) {
            arrayList.add(new SearchParameter("s", string));
            this.log("    Using search term '" + string + "' for engine " + engine.getString());
        }
        SearchParameter[] searchParameterArray = arrayList.toArray(new SearchParameter[arrayList.size()]);
        SubscriptionHistoryImpl subscriptionHistoryImpl = (SubscriptionHistoryImpl)this.subs.getHistory();
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("azsrc", "subscription");
            Result[] resultArray = engine.search(searchParameterArray, hashMap, -1, -1, null, null);
            this.log("    Got " + resultArray.length + " results");
            SubscriptionResultFilter subscriptionResultFilter = new SubscriptionResultFilter(map2);
            resultArray = subscriptionResultFilter.filter(resultArray);
            this.log("    Post-filter: " + resultArray.length + " results");
            SubscriptionResultImpl[] subscriptionResultImplArray = new SubscriptionResultImpl[resultArray.length];
            for (int i = 0; i < resultArray.length; ++i) {
                SubscriptionResultImpl subscriptionResultImpl;
                subscriptionResultImplArray[i] = subscriptionResultImpl = new SubscriptionResultImpl(subscriptionHistoryImpl, resultArray[i]);
            }
            SubscriptionResultImpl[] subscriptionResultImplArray2 = subscriptionHistoryImpl.reconcileResults(engine, subscriptionResultImplArray);
            this.checkAutoDownload(subscriptionResultImplArray2);
            subscriptionHistoryImpl.setLastError(null, false);
        }
        catch (Throwable throwable) {
            this.log("    Download failed", throwable);
            subscriptionHistoryImpl.setLastError(Debug.getNestedExceptionMessage(throwable), throwable instanceof SearchLoginException);
            throw new SubscriptionException("Search failed", throwable);
        }
    }

    protected void checkAutoDownload(SubscriptionResultImpl[] subscriptionResultImplArray) {
        if (!this.subs.getHistory().isAutoDownload()) {
            return;
        }
        for (int i = 0; i < subscriptionResultImplArray.length; ++i) {
            SubscriptionResultImpl subscriptionResultImpl = subscriptionResultImplArray[i];
            if (subscriptionResultImpl.isDeleted() || subscriptionResultImpl.getRead()) continue;
            this.manager.getScheduler().download((Subscription)this.subs, subscriptionResultImpl);
        }
    }

    protected void log(String string) {
        this.manager.log(string);
    }

    protected void log(String string, Throwable throwable) {
        this.manager.log(string, throwable);
    }
}

