/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.speedmanager.impl.v2;

import com.aelitis.azureus.core.speedmanager.SpeedManagerPingSource;
import com.aelitis.azureus.core.speedmanager.impl.SpeedManagerAlgorithmProvider;
import com.aelitis.azureus.core.speedmanager.impl.SpeedManagerAlgorithmProviderAdapter;
import com.aelitis.azureus.core.speedmanager.impl.v2.SpeedManagerAlgorithmProviderPingMap;
import com.aelitis.azureus.core.speedmanager.impl.v2.SpeedManagerLogger;

public class SpeedManagerAlgorithmProviderV2
implements SpeedManagerAlgorithmProvider {
    private SpeedManagerAlgorithmProviderAdapter adapter;
    private SpeedManagerAlgorithmProvider strategy;
    public static final String SETTING_DOWNLOAD_MAX_LIMIT = "SpeedManagerAlgorithmProviderV2.setting.download.max.limit";
    public static final String SETTING_UPLOAD_MAX_LIMIT = "SpeedManagerAlgorithmProviderV2.setting.upload.max.limit";
    public static final String SETTING_UPLOAD_LIMIT_ESTIMATE_TYPE_FROM_UI = "AutoSpeed Network Upload Speed Type (temp)";
    public static final String SETTING_DOWNLOAD_LIMIT_ESTIMATE_TYPE_FROM_UI = "AutoSpeed Network Download Speed Type (temp)";
    public static final String SETTING_DATA_SOURCE_INPUT = "SpeedManagerAlgorithmProviderV2.source.data.input";
    public static final String SETTING_DHT_GOOD_SET_POINT = "SpeedManagerAlgorithmProviderV2.setting.dht.good.setpoint";
    public static final String SETTING_DHT_GOOD_TOLERANCE = "SpeedManagerAlgorithmProviderV2.setting.dht.good.tolerance";
    public static final String SETTING_DHT_BAD_SET_POINT = "SpeedManagerAlgorithmProviderV2.setting.dht.bad.setpoint";
    public static final String SETTING_DHT_BAD_TOLERANCE = "SpeedManagerAlgorithmProviderV2.setting.dht.bad.tolerance";
    public static final String SETTING_WAIT_AFTER_ADJUST = "SpeedManagerAlgorithmProviderV2.setting.wait.after.adjust";
    public static final String SETTING_INTERVALS_BETWEEN_ADJUST = "SpeedManagerAlgorithmProviderV2.intervals.between.adjust";
    public static final String SETTING_V2_BETA_ENABLED = "SpeedManagerAlgorithmProviderV2.setting.beta.enabled";

    public SpeedManagerAlgorithmProviderV2(SpeedManagerAlgorithmProviderAdapter speedManagerAlgorithmProviderAdapter) {
        this.adapter = speedManagerAlgorithmProviderAdapter;
        SpeedManagerLogger.setAdapter("v2", this.adapter);
        this.strategy = new SpeedManagerAlgorithmProviderPingMap(speedManagerAlgorithmProviderAdapter);
    }

    @Override
    public void destroy() {
        this.strategy.destroy();
    }

    @Override
    public void reset() {
        this.strategy.reset();
    }

    @Override
    public void updateStats() {
        this.strategy.updateStats();
    }

    @Override
    public void pingSourceFound(SpeedManagerPingSource speedManagerPingSource, boolean bl) {
        this.log("Found ping source: " + speedManagerPingSource.getAddress());
        this.strategy.pingSourceFound(speedManagerPingSource, bl);
    }

    @Override
    public void pingSourceFailed(SpeedManagerPingSource speedManagerPingSource) {
        this.log("Lost ping source: " + speedManagerPingSource.getAddress());
        this.strategy.pingSourceFailed(speedManagerPingSource);
    }

    @Override
    public void calculate(SpeedManagerPingSource[] speedManagerPingSourceArray) {
        String string = "";
        for (int i = 0; i < speedManagerPingSourceArray.length; ++i) {
            string = string + (i == 0 ? "" : ",") + speedManagerPingSourceArray[i].getAddress() + " -> " + speedManagerPingSourceArray[i].getPingTime();
        }
        this.log("ping-data: " + string);
        this.strategy.calculate(speedManagerPingSourceArray);
    }

    @Override
    public int getIdlePingMillis() {
        return this.strategy.getIdlePingMillis();
    }

    @Override
    public int getCurrentPingMillis() {
        return this.strategy.getCurrentPingMillis();
    }

    @Override
    public int getMaxPingMillis() {
        return this.strategy.getMaxPingMillis();
    }

    @Override
    public int getCurrentChokeSpeed() {
        return this.strategy.getCurrentChokeSpeed();
    }

    @Override
    public int getMaxUploadSpeed() {
        return this.strategy.getMaxUploadSpeed();
    }

    @Override
    public boolean getAdjustsDownloadLimits() {
        return false;
    }

    protected void log(String string) {
        SpeedManagerLogger.log(string);
    }
}

