/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.speedmanager.impl.v2;

import com.aelitis.azureus.core.speedmanager.impl.v2.LimitControl;
import com.aelitis.azureus.core.speedmanager.impl.v2.SMConst;
import com.aelitis.azureus.core.speedmanager.impl.v2.SMUpdate;
import com.aelitis.azureus.core.speedmanager.impl.v2.SaturatedMode;
import com.aelitis.azureus.core.speedmanager.impl.v2.SpeedManagerLogger;
import com.aelitis.azureus.core.speedmanager.impl.v2.TransferMode;

public class LimitControlDropUploadFirst
implements LimitControl {
    private float valueUp = 0.5f;
    int upMax;
    int upCurr;
    int upMin;
    SaturatedMode upUsage;
    private float valueDown = 1.0f;
    int downMax;
    int downCurr;
    int downMin;
    SaturatedMode downUsage;
    TransferMode mode;
    float usedUpMaxDownloadMode = 0.6f;
    boolean isDownloadUnlimited = false;

    @Override
    public void updateStatus(int n, SaturatedMode saturatedMode, int n2, SaturatedMode saturatedMode2, TransferMode transferMode) {
        this.upCurr = n;
        this.upUsage = saturatedMode;
        this.downCurr = n2;
        this.downUsage = saturatedMode2;
        this.mode = transferMode;
    }

    @Override
    public void setDownloadUnlimitedMode(boolean bl) {
        this.isDownloadUnlimited = bl;
        if (bl) {
            this.valueDown = 1.0f;
        }
    }

    @Override
    public boolean isDownloadUnlimitedMode() {
        return this.isDownloadUnlimited;
    }

    @Override
    public void updateLimits(int n, int n2, int n3, int n4) {
        if (n < 30720) {
            n = 30720;
        }
        if (n3 < 61440) {
            n3 = 61440;
        }
        if (n3 < n) {
            n3 = n;
        }
        n2 = SMConst.calculateMinUpload(n);
        n4 = SMConst.calculateMinDownload(n3);
        this.upMax = n;
        this.upMin = n2;
        this.downMax = n3;
        this.downMin = n4;
    }

    private int usedUploadCapacity() {
        float f = this.upMax;
        if (this.mode.getMode() == TransferMode.State.SEEDING) {
            f = this.upMax;
        } else if (this.mode.getMode() == TransferMode.State.DOWNLOADING) {
            f = (float)this.upMax * this.usedUpMaxDownloadMode;
        } else if (this.mode.getMode() == TransferMode.State.DOWNLOAD_LIMIT_SEARCH) {
            f = (float)this.upMax * this.usedUpMaxDownloadMode;
        } else if (this.mode.getMode() == TransferMode.State.UPLOAD_LIMIT_SEARCH) {
            f = this.upMax;
        } else {
            SpeedManagerLogger.trace("LimitControlDropUploadFirst -> unrecognized transfer mode. ");
        }
        return Math.round(f);
    }

    @Override
    public void updateSeedSettings(float f) {
        if (f < 1.0f && f > 0.1f) {
            this.usedUpMaxDownloadMode = f;
            SpeedManagerLogger.trace("LimitControlDropUploadFirst %used upload used while downloading: " + f);
        }
    }

    @Override
    public SMUpdate adjust(float f) {
        boolean bl = true;
        if (f < 0.0f) {
            bl = false;
        }
        float f2 = f / 10.0f;
        int n = this.usedUploadCapacity();
        float f3 = (float)n / (float)this.downMax;
        if (bl) {
            if (this.valueDown < 0.99f) {
                this.valueDown = this.calculateNewValue(this.valueDown, f2);
            } else if (this.upUsage == SaturatedMode.AT_LIMIT) {
                this.valueUp = this.calculateNewValue(this.valueUp, f3 * 0.5f * f2);
            }
        } else if (this.valueUp > 0.01f) {
            this.valueUp = this.calculateNewValue(this.valueUp, f3 * f2);
        } else {
            this.valueDown = this.calculateNewValue(this.valueDown, f2);
        }
        return this.update();
    }

    private SMUpdate update() {
        int n = this.usedUploadCapacity();
        int n2 = Math.round((float)(n - this.upMin) * this.valueUp + (float)this.upMin);
        if (n2 > this.upMax || Float.isNaN(this.valueUp)) {
            SpeedManagerLogger.trace("Limit - should upload have an unlimited condition? Setting to usedUpMax");
            n2 = n;
        }
        int n3 = this.isDownloadUnlimited ? 0 : Math.round((float)(this.downMax - this.downMin) * this.valueDown + (float)this.downMin);
        if ((double)this.valueDown == 1.0) {
            n3 = 0;
        }
        StringBuffer stringBuffer = new StringBuffer(" create-update: valueUp=" + this.valueUp + ",upLimit=" + n2 + ",valueDown=");
        if ((double)this.valueDown == 1.0) {
            stringBuffer.append("_unlimited_");
        } else {
            stringBuffer.append(this.valueDown);
        }
        stringBuffer.append(",downLimit=" + n3 + ",upMax=" + this.upMax + ",usedUpMax=" + n + ",upMin=" + this.upMin + ",downMax=" + this.downMax);
        stringBuffer.append(",downMin=" + this.downMin + ",transferMode=" + this.mode.getString() + ",isDownUnlimited=" + this.isDownloadUnlimited);
        SpeedManagerLogger.log(stringBuffer.toString());
        return new SMUpdate(n2, true, n3, true);
    }

    private float calculateNewValue(float f, float f2) {
        if (Float.isNaN(f)) {
            SpeedManagerLogger.trace("calculateNewValue - curr=NaN");
        }
        if (Float.isNaN(f2)) {
            SpeedManagerLogger.trace("calculateNewValue = amount=NaN");
        }
        if ((f += f2) > 1.0f) {
            f = 1.0f;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (Float.isNaN(f)) {
            f = 0.0f;
        }
        return f;
    }
}

