/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.speedmanager.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import com.aelitis.azureus.core.dht.speed.DHTSpeedTester;
import com.aelitis.azureus.core.dht.speed.DHTSpeedTesterContact;
import com.aelitis.azureus.core.dht.speed.DHTSpeedTesterContactListener;
import com.aelitis.azureus.core.dht.speed.DHTSpeedTesterListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminASN;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminPropertyChangeListener;
import com.aelitis.azureus.core.speedmanager.SpeedManager;
import com.aelitis.azureus.core.speedmanager.SpeedManagerAdapter;
import com.aelitis.azureus.core.speedmanager.SpeedManagerLimitEstimate;
import com.aelitis.azureus.core.speedmanager.SpeedManagerListener;
import com.aelitis.azureus.core.speedmanager.SpeedManagerPingMapper;
import com.aelitis.azureus.core.speedmanager.SpeedManagerPingSource;
import com.aelitis.azureus.core.speedmanager.impl.SpeedManagerAlgorithmProvider;
import com.aelitis.azureus.core.speedmanager.impl.SpeedManagerAlgorithmProviderAdapter;
import com.aelitis.azureus.core.speedmanager.impl.SpeedManagerPingMapperImpl;
import com.aelitis.azureus.core.speedmanager.impl.TestPingSourceRandom;
import com.aelitis.azureus.core.speedmanager.impl.v1.SpeedManagerAlgorithmProviderV1;
import com.aelitis.azureus.core.speedmanager.impl.v2.SpeedManagerAlgorithmProviderV2;
import com.aelitis.azureus.core.speedmanager.impl.v3.SpeedManagerAlgorithmProviderV3;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class SpeedManagerImpl
implements SpeedManager,
SpeedManagerAlgorithmProviderAdapter,
AEDiagnosticsEvidenceGenerator {
    protected static final int UPDATE_PERIOD_MILLIS = 3000;
    private static final int CONTACT_NUMBER = 3;
    private static final int CONTACT_PING_SECS = 3;
    private static final int LONG_PERIOD_SECS = 3600;
    private static final int LONG_PERIOD_TICKS = 1200;
    private static final int SHORT_ESTIMATE_SECS = 15;
    private static final int MEDIUM_ESTIMATE_SECS = 150;
    static final int SHORT_ESTIMATE_SAMPLES = 5;
    static final int MEDIUM_ESTIMATE_SAMPLES = 50;
    private static final int SAVE_PERIOD_SECS = 900;
    private static final int SAVE_PERIOD_TICKS = 300;
    private static final int AUTO_ADJUST_PERIOD_SECS = 60;
    private static final int AUTO_ADJUST_PERIOD_TICKS = 20;
    private static final int SPEED_AVERAGE_PERIOD = 3000;
    private static boolean DEBUG;
    public static final String CONFIG_VERSION_STR = "Auto_Upload_Speed_Version_String";
    public static final String CONFIG_VERSION = "Auto Upload Speed Version";
    private static final String CONFIG_AVAIL = "AutoSpeed Available";
    private static final String CONFIG_DEBUG = "Auto Upload Speed Debug Enabled";
    private static final String[] CONFIG_PARAMS;
    private static boolean emulated_ping_source;
    private AzureusCore core;
    private DHTSpeedTester speed_tester;
    private SpeedManagerAdapter adapter;
    private SpeedManagerAlgorithmProvider provider = new nullProvider();
    private int provider_version = -1;
    private boolean enabled;
    private final boolean pm_enabled = true;
    private Map contacts = new HashMap();
    private volatile int total_contacts;
    private pingContact[] contacts_array = new pingContact[0];
    private Object original_limits;
    private AsyncDispatcher dispatcher = new AsyncDispatcher();
    private SpeedManagerPingMapperImpl ping_mapper;
    private SpeedManagerPingMapperImpl[] ping_mappers;
    private CopyOnWriteList transient_mappers = new CopyOnWriteList();
    private AEDiagnosticsLogger logger;
    private String asn;
    private CopyOnWriteList listeners = new CopyOnWriteList();

    public SpeedManagerImpl(AzureusCore azureusCore, SpeedManagerAdapter speedManagerAdapter) {
        Object object;
        this.core = azureusCore;
        this.adapter = speedManagerAdapter;
        AEDiagnostics.addEvidenceGenerator(this);
        this.logger = AEDiagnostics.getLogger("SpeedMan");
        this.ping_mapper = new SpeedManagerPingMapperImpl(this, "Var", 1200, true, false);
        if (Constants.isCVSVersion()) {
            object = new SpeedManagerPingMapperImpl(this, "Abs", 1200, false, false);
            this.ping_mappers = new SpeedManagerPingMapperImpl[]{object, this.ping_mapper};
        } else {
            this.ping_mappers = new SpeedManagerPingMapperImpl[]{this.ping_mapper};
        }
        object = new File(SystemProperties.getUserPath(), "net");
        if (!((File)object).exists()) {
            ((File)object).mkdirs();
        }
        NetworkAdmin.getSingleton().addAndFirePropertyChangeListener(new NetworkAdminPropertyChangeListener((File)object){
            final /* synthetic */ File val$config_dir;
            {
                this.val$config_dir = file;
            }

            @Override
            public void propertyChanged(String string) {
                if (string == "AS") {
                    NetworkAdminASN networkAdminASN = NetworkAdmin.getSingleton().getCurrentASN();
                    String string2 = networkAdminASN.getAS();
                    if (string2.length() == 0) {
                        string2 = "default";
                    }
                    File file = new File(this.val$config_dir, "pm_" + FileUtil.convertOSSpecificChars(string2, false) + ".dat");
                    SpeedManagerImpl.this.ping_mapper.loadHistory(file);
                    SpeedManagerImpl.this.asn = networkAdminASN.getASName();
                    if (SpeedManagerImpl.this.asn.length() == 0) {
                        SpeedManagerImpl.this.asn = "Unknown";
                    }
                    SpeedManagerImpl.this.informListeners(1);
                }
            }
        });
        this.core.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

            @Override
            public void stopping(AzureusCore azureusCore) {
                SpeedManagerImpl.this.ping_mapper.saveHistory();
            }
        });
        COConfigurationManager.addAndFireParameterListener(CONFIG_VERSION, new ParameterListener(){

            @Override
            public void parameterChanged(final String string) {
                SpeedManagerImpl.this.dispatcher.dispatch(new AERunnable(){

                    @Override
                    public void runSupport() {
                        boolean bl = SpeedManagerImpl.this.provider_version == -1;
                        int n = COConfigurationManager.getIntParameter(string);
                        if (n != SpeedManagerImpl.this.provider_version) {
                            SpeedManagerImpl.this.provider_version = n;
                            if (SpeedManagerImpl.this.isEnabled()) {
                                SpeedManagerImpl.this.setEnabledSupport(false);
                                SpeedManagerImpl.this.setEnabledSupport(true);
                            }
                        }
                        if (bl) {
                            SpeedManagerImpl.this.enableOrAlgChanged();
                        }
                    }
                });
            }
        });
        COConfigurationManager.setParameter(CONFIG_AVAIL, false);
        SimpleTimer.addPeriodicEvent("SpeedManager:timer", 3000L, new TimerEventPerformer(){
            private int tick_count;

            @Override
            public void perform(TimerEvent timerEvent2) {
                if (SpeedManagerImpl.this.contacts_array.length == 0) {
                    int n = SpeedManagerImpl.this.adapter.getCurrentDataUploadSpeed(3000) + SpeedManagerImpl.this.adapter.getCurrentProtocolUploadSpeed(3000);
                    int n2 = SpeedManagerImpl.this.adapter.getCurrentDataDownloadSpeed(3000) + SpeedManagerImpl.this.adapter.getCurrentProtocolDownloadSpeed(3000);
                    for (int i = 0; i < SpeedManagerImpl.this.ping_mappers.length; ++i) {
                        SpeedManagerImpl.this.ping_mappers[i].addSpeed(n, n2);
                    }
                }
                ++this.tick_count;
                if (this.tick_count % 300 == 0) {
                    SpeedManagerImpl.this.ping_mapper.saveHistory();
                }
                if (this.tick_count % 20 == 0) {
                    SpeedManagerImpl.this.autoAdjust();
                }
            }
        });
        COConfigurationManager.addAndFireParameterListener("Auto Adjust Transfer Defaults", new ParameterListener(){

            @Override
            public void parameterChanged(String string) {
                SpeedManagerImpl.this.autoAdjust();
            }
        });
        emulated_ping_source = false;
        if (emulated_ping_source) {
            Debug.out("Emulated ping source!!!!");
            this.setSpeedTester(new TestPingSourceRandom(this));
        }
    }

    @Override
    public SpeedManager getSpeedManager() {
        return this;
    }

    @Override
    public String getASN() {
        return this.asn;
    }

    @Override
    public SpeedManagerLimitEstimate getEstimatedUploadCapacityBytesPerSec() {
        return this.ping_mapper.getEstimatedUploadCapacityBytesPerSec();
    }

    @Override
    public void setEstimatedUploadCapacityBytesPerSec(int n, float f) {
        this.ping_mapper.setEstimatedUploadCapacityBytesPerSec(n, f);
    }

    @Override
    public SpeedManagerLimitEstimate getEstimatedDownloadCapacityBytesPerSec() {
        return this.ping_mapper.getEstimatedDownloadCapacityBytesPerSec();
    }

    @Override
    public void setEstimatedDownloadCapacityBytesPerSec(int n, float f) {
        this.ping_mapper.setEstimatedDownloadCapacityBytesPerSec(n, f);
    }

    @Override
    public void reset() {
        this.ping_mapper.reset();
    }

    protected void enableOrAlgChanged() {
        this.total_contacts = 0;
        SpeedManagerAlgorithmProvider speedManagerAlgorithmProvider = this.provider;
        if (this.provider_version == 1) {
            if (!(this.provider instanceof SpeedManagerAlgorithmProviderV1)) {
                this.provider = new SpeedManagerAlgorithmProviderV1(this);
            }
        } else if (this.provider_version == 2) {
            if (!(this.provider instanceof SpeedManagerAlgorithmProviderV2)) {
                this.provider = new SpeedManagerAlgorithmProviderV2(this);
            }
        } else if (this.provider_version == 3) {
            this.provider = new SpeedManagerAlgorithmProviderV3(this);
        } else {
            Debug.out("Unknown provider version " + this.provider_version);
            if (!(this.provider instanceof nullProvider)) {
                this.provider = new nullProvider();
            }
        }
        if (speedManagerAlgorithmProvider != this.provider) {
            this.log("Algorithm set to " + this.provider.getClass().getName());
        }
        if (speedManagerAlgorithmProvider != null) {
            speedManagerAlgorithmProvider.destroy();
        }
        this.provider.reset();
    }

    @Override
    public SpeedManagerPingMapper createTransientPingMapper() {
        SpeedManagerPingMapperImpl speedManagerPingMapperImpl = new SpeedManagerPingMapperImpl(this, "Transient", 1200, true, true);
        this.transient_mappers.add(speedManagerPingMapperImpl);
        if (this.transient_mappers.size() > 32) {
            Debug.out("Transient mappers are growing too large");
        }
        return speedManagerPingMapperImpl;
    }

    protected void destroy(SpeedManagerPingMapper speedManagerPingMapper) {
        this.transient_mappers.remove(speedManagerPingMapper);
    }

    @Override
    public void setSpeedTester(DHTSpeedTester dHTSpeedTester) {
        if (this.speed_tester != null) {
            if (!emulated_ping_source) {
                Debug.out("speed tester already set!");
            }
            return;
        }
        COConfigurationManager.setParameter(CONFIG_AVAIL, true);
        this.speed_tester = dHTSpeedTester;
        this.speed_tester.addListener(new DHTSpeedTesterListener(){
            private DHTSpeedTesterContact[] last_contact_group = new DHTSpeedTesterContact[0];

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void contactAdded(DHTSpeedTesterContact dHTSpeedTesterContact) {
                if (SpeedManagerImpl.this.core.getInstanceManager().isLANAddress(dHTSpeedTesterContact.getAddress().getAddress())) {
                    dHTSpeedTesterContact.destroy();
                } else {
                    SpeedManagerImpl.this.log("activePing: " + dHTSpeedTesterContact.getString());
                    dHTSpeedTesterContact.setPingPeriod(3);
                    Map map = SpeedManagerImpl.this.contacts;
                    synchronized (map) {
                        pingContact pingContact2 = new pingContact(dHTSpeedTesterContact);
                        SpeedManagerImpl.this.contacts.put(dHTSpeedTesterContact, pingContact2);
                        SpeedManagerImpl.access$502(SpeedManagerImpl.this, new pingContact[SpeedManagerImpl.this.contacts.size()]);
                        SpeedManagerImpl.this.contacts.values().toArray(SpeedManagerImpl.this.contacts_array);
                        SpeedManagerImpl.this.total_contacts++;
                        SpeedManagerImpl.this.provider.pingSourceFound(pingContact2, SpeedManagerImpl.this.total_contacts > 3);
                    }
                    dHTSpeedTesterContact.addListener(new DHTSpeedTesterContactListener(){

                        @Override
                        public void ping(DHTSpeedTesterContact dHTSpeedTesterContact, int n) {
                        }

                        @Override
                        public void pingFailed(DHTSpeedTesterContact dHTSpeedTesterContact) {
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void contactDied(DHTSpeedTesterContact dHTSpeedTesterContact) {
                            SpeedManagerImpl.this.log("deadPing: " + dHTSpeedTesterContact.getString());
                            Map map = SpeedManagerImpl.this.contacts;
                            synchronized (map) {
                                pingContact pingContact2 = (pingContact)SpeedManagerImpl.this.contacts.remove(dHTSpeedTesterContact);
                                if (pingContact2 != null) {
                                    SpeedManagerImpl.access$502(SpeedManagerImpl.this, new pingContact[SpeedManagerImpl.this.contacts.size()]);
                                    SpeedManagerImpl.this.contacts.values().toArray(SpeedManagerImpl.this.contacts_array);
                                    SpeedManagerImpl.this.provider.pingSourceFailed(pingContact2);
                                }
                            }
                        }
                    });
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resultGroup(DHTSpeedTesterContact[] dHTSpeedTesterContactArray, int[] nArray) {
                int n;
                boolean bl;
                boolean bl2 = false;
                for (int i = 0; i < dHTSpeedTesterContactArray.length; ++i) {
                    bl = false;
                    for (n = 0; n < this.last_contact_group.length; ++n) {
                        if (dHTSpeedTesterContactArray[i] != this.last_contact_group[n]) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    bl2 = true;
                    break;
                }
                this.last_contact_group = dHTSpeedTesterContactArray;
                SpeedManagerPingSource[] speedManagerPingSourceArray = new pingContact[dHTSpeedTesterContactArray.length];
                bl = false;
                n = -1;
                int n2 = Integer.MAX_VALUE;
                int n3 = 0;
                int n4 = 0;
                Map map = SpeedManagerImpl.this.contacts;
                synchronized (map) {
                    for (int i = 0; i < dHTSpeedTesterContactArray.length; ++i) {
                        speedManagerPingSourceArray[i] = (pingContact)SpeedManagerImpl.this.contacts.get(dHTSpeedTesterContactArray[i]);
                        SpeedManagerPingSource speedManagerPingSource = speedManagerPingSourceArray[i];
                        if (speedManagerPingSource != null) {
                            int n5 = nArray[i];
                            if (n5 >= 0) {
                                if (n5 > n) {
                                    n = n5;
                                }
                                if (n5 < n2) {
                                    n2 = n5;
                                }
                                ++n3;
                                n4 += n5;
                            }
                            speedManagerPingSource.setPingTime(n5);
                            continue;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    Debug.out("Auto-speed: source missing");
                } else {
                    SpeedManagerImpl.this.provider.calculate(speedManagerPingSourceArray);
                    if (n3 > 1) {
                        n4 -= n;
                        --n3;
                    }
                    if (n3 > 0) {
                        int n6 = n4 / n3;
                        n6 = (n6 + n2) / 2;
                        SpeedManagerImpl.this.addPingHistory(n6, bl2);
                    }
                }
            }
        });
        this.speed_tester.setContactNumber(3);
        SimpleTimer.addPeriodicEvent("SpeedManager:stats", 1000L, new TimerEventPerformer(){

            @Override
            public void perform(TimerEvent timerEvent2) {
                if (SpeedManagerImpl.this.enabled) {
                    SpeedManagerImpl.this.provider.updateStats();
                }
            }
        });
    }

    protected void addPingHistory(int n, boolean bl) {
        int n2 = this.adapter.getCurrentDataUploadSpeed(3000) + this.adapter.getCurrentProtocolUploadSpeed(3000);
        int n3 = this.adapter.getCurrentDataDownloadSpeed(3000) + this.adapter.getCurrentProtocolDownloadSpeed(3000);
        for (int i = 0; i < this.ping_mappers.length; ++i) {
            this.ping_mappers[i].addPing(n2, n3, n, bl);
        }
        Iterator iterator = this.transient_mappers.iterator();
        while (iterator.hasNext()) {
            ((SpeedManagerPingMapperImpl)iterator.next()).addPing(n2, n3, n, bl);
        }
    }

    @Override
    public boolean isAvailable() {
        return this.speed_tester != null;
    }

    @Override
    public void setEnabled(final boolean bl) {
        final AESemaphore aESemaphore = new AESemaphore("SpeedManagerImpl.setEnabled");
        this.dispatcher.dispatch(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runSupport() {
                try {
                    SpeedManagerImpl.this.setEnabledSupport(bl);
                }
                finally {
                    aESemaphore.release();
                }
            }
        });
        if (!aESemaphore.reserve(10000L)) {
            Debug.out("operation didn't complete in time");
        }
    }

    protected void setEnabledSupport(boolean bl) {
        if (this.enabled != bl) {
            this.log("Enabled set to " + bl);
            if (bl) {
                this.original_limits = this.adapter.getLimits();
            } else {
                this.ping_mapper.saveHistory();
            }
            this.enableOrAlgChanged();
            this.enabled = bl;
            if (this.speed_tester != null) {
                // empty if block
            }
            if (!this.enabled) {
                this.adapter.setLimits(this.original_limits, true, this.provider.getAdjustsDownloadLimits());
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public DHTSpeedTester getSpeedTester() {
        return this.speed_tester;
    }

    @Override
    public SpeedManagerPingSource[] getPingSources() {
        return this.contacts_array;
    }

    @Override
    public SpeedManagerPingMapper getActiveMapper() {
        return this.ping_mapper;
    }

    @Override
    public SpeedManagerPingMapper getPingMapper() {
        return this.getActiveMapper();
    }

    @Override
    public SpeedManagerPingMapper[] getMappers() {
        return this.ping_mappers;
    }

    public int getIdlePingMillis() {
        return this.provider.getIdlePingMillis();
    }

    public int getCurrentPingMillis() {
        return this.provider.getCurrentPingMillis();
    }

    public int getMaxPingMillis() {
        return this.provider.getMaxPingMillis();
    }

    public int getCurrentChokeSpeed() {
        return this.provider.getCurrentChokeSpeed();
    }

    public int getMaxUploadSpeed() {
        return this.provider.getMaxUploadSpeed();
    }

    @Override
    public int getCurrentUploadLimit() {
        return this.adapter.getCurrentUploadLimit();
    }

    @Override
    public void setCurrentUploadLimit(int n) {
        if (this.enabled) {
            this.adapter.setCurrentUploadLimit(n);
        }
    }

    @Override
    public int getCurrentDownloadLimit() {
        return this.adapter.getCurrentDownloadLimit();
    }

    @Override
    public void setCurrentDownloadLimit(int n) {
        if (this.enabled) {
            this.adapter.setCurrentDownloadLimit(n);
        }
    }

    @Override
    public int getCurrentProtocolUploadSpeed() {
        return this.adapter.getCurrentProtocolUploadSpeed(-1);
    }

    @Override
    public int getCurrentDataUploadSpeed() {
        return this.adapter.getCurrentDataUploadSpeed(-1);
    }

    @Override
    public int getCurrentDataDownloadSpeed() {
        return this.adapter.getCurrentDataDownloadSpeed(-1);
    }

    @Override
    public int getCurrentProtocolDownloadSpeed() {
        return this.adapter.getCurrentProtocolDownloadSpeed(-1);
    }

    private void autoAdjust() {
        if (COConfigurationManager.getBooleanParameter("Auto Adjust Transfer Defaults")) {
            int n;
            int n2;
            int n3 = this.getEstimatedUploadCapacityBytesPerSec().getBytesPerSec();
            int n4 = this.getEstimatedDownloadCapacityBytesPerSec().getBytesPerSec();
            int n5 = n3 / 1024;
            int[][] nArrayArray = new int[][]{{56, 2, 20, 40}, {96, 3, 30, 60}, {128, 3, 40, 80}, {192, 4, 50, 100}, {256, 4, 60, 200}, {512, 5, 70, 300}, {1024, 6, 80, 400}, {2048, 8, 90, 500}, {5120, 10, 100, 600}, {10240, 20, 110, 750}, {20480, 30, 120, 900}, {51200, 40, 130, 1100}, {102400, 50, 140, 1300}, {-1, 60, 150, 1500}};
            int[] nArray = nArrayArray[nArrayArray.length - 1];
            for (n2 = 3; n2 < nArrayArray.length; ++n2) {
                int[] nArray2 = nArrayArray[n2];
                n = nArray2[0];
                int n6 = n / 8 * 4 / 5;
                if (n5 > n6) continue;
                nArray = nArray2;
                break;
            }
            n2 = nArray[1];
            int n7 = nArray[2];
            n = nArray[3];
            if (n2 != COConfigurationManager.getIntParameter("Max Uploads")) {
                COConfigurationManager.setParameter("Max Uploads", n2);
                COConfigurationManager.setParameter("Max Uploads Seeding", n2);
            }
            if (n7 != COConfigurationManager.getIntParameter("Max.Peer.Connections.Per.Torrent")) {
                COConfigurationManager.setParameter("Max.Peer.Connections.Per.Torrent", n7);
                COConfigurationManager.setParameter("Max.Peer.Connections.Per.Torrent.When.Seeding", n7 / 2);
            }
            if (n != COConfigurationManager.getIntParameter("Max.Peer.Connections.Total")) {
                COConfigurationManager.setParameter("Max.Peer.Connections.Total", n);
            }
        }
    }

    public void setLoggingEnabled(boolean bl) {
        COConfigurationManager.setParameter(CONFIG_DEBUG, bl);
    }

    @Override
    public void log(String string) {
        if (DEBUG) {
            this.logger.log(string);
        }
    }

    protected void informDownCapChanged() {
        this.informListeners(3);
    }

    protected void informUpCapChanged() {
        this.informListeners(2);
    }

    protected void informListeners(int n) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            try {
                ((SpeedManagerListener)iterator.next()).propertyChanged(n);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    @Override
    public void addListener(SpeedManagerListener speedManagerListener) {
        this.listeners.add(speedManagerListener);
    }

    @Override
    public void removeListener(SpeedManagerListener speedManagerListener) {
        this.listeners.remove(speedManagerListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndentWriter indentWriter) {
        indentWriter.println("SpeedManager: enabled=" + this.enabled + ",provider=" + this.provider);
        try {
            indentWriter.indent();
            this.ping_mapper.generateEvidence(indentWriter);
        }
        finally {
            indentWriter.exdent();
        }
    }

    static /* synthetic */ pingContact[] access$502(SpeedManagerImpl speedManagerImpl, pingContact[] pingContactArray) {
        speedManagerImpl.contacts_array = pingContactArray;
        return pingContactArray;
    }

    static {
        CONFIG_PARAMS = new String[]{CONFIG_DEBUG};
        COConfigurationManager.addAndFireParameterListeners(CONFIG_PARAMS, new ParameterListener(){

            @Override
            public void parameterChanged(String string) {
                DEBUG = COConfigurationManager.getBooleanParameter(SpeedManagerImpl.CONFIG_DEBUG);
            }
        });
    }

    protected class nullProvider
    implements SpeedManagerAlgorithmProvider {
        protected nullProvider() {
        }

        @Override
        public void reset() {
        }

        @Override
        public void destroy() {
        }

        @Override
        public void updateStats() {
        }

        @Override
        public void pingSourceFound(SpeedManagerPingSource speedManagerPingSource, boolean bl) {
        }

        @Override
        public void pingSourceFailed(SpeedManagerPingSource speedManagerPingSource) {
        }

        @Override
        public void calculate(SpeedManagerPingSource[] speedManagerPingSourceArray) {
        }

        @Override
        public int getIdlePingMillis() {
            return 0;
        }

        @Override
        public int getCurrentPingMillis() {
            return 0;
        }

        @Override
        public int getMaxPingMillis() {
            return 0;
        }

        @Override
        public int getCurrentChokeSpeed() {
            return 0;
        }

        @Override
        public int getMaxUploadSpeed() {
            return 0;
        }

        @Override
        public boolean getAdjustsDownloadLimits() {
            return false;
        }
    }

    protected class SMUnlimited
    implements SpeedManagerAlgorithmProvider {
        private int good_signals;

        protected SMUnlimited() {
        }

        @Override
        public void destroy() {
        }

        @Override
        public void reset() {
            SpeedManagerImpl.this.adapter.setCurrentDownloadLimit(0);
            SpeedManagerImpl.this.adapter.setCurrentUploadLimit(0);
        }

        @Override
        public void updateStats() {
        }

        @Override
        public void pingSourceFound(SpeedManagerPingSource speedManagerPingSource, boolean bl) {
        }

        @Override
        public void pingSourceFailed(SpeedManagerPingSource speedManagerPingSource) {
        }

        @Override
        public void calculate(SpeedManagerPingSource[] speedManagerPingSourceArray) {
            SpeedManagerLimitEstimate speedManagerLimitEstimate = SpeedManagerImpl.this.ping_mapper.getEstimatedUploadLimit(true);
            if (speedManagerLimitEstimate != null) {
                double d = SpeedManagerImpl.this.ping_mapper.getCurrentMetricRating();
                this.good_signals = d == 1.0 ? ++this.good_signals : 0;
                if (d == -1.0) {
                    SpeedManagerImpl.this.adapter.setCurrentUploadLimit(speedManagerLimitEstimate.getBytesPerSec() + (this.good_signals < 3 ? -1024 : 1024));
                } else if (d <= 0.0) {
                    SpeedManagerImpl.this.adapter.setCurrentUploadLimit(speedManagerLimitEstimate.getBytesPerSec() + 1024);
                } else {
                    SpeedManagerImpl.this.adapter.setCurrentUploadLimit(speedManagerLimitEstimate.getBytesPerSec() + 5120);
                }
            }
        }

        @Override
        public int getIdlePingMillis() {
            return 0;
        }

        @Override
        public int getCurrentPingMillis() {
            return 0;
        }

        @Override
        public int getMaxPingMillis() {
            return 0;
        }

        @Override
        public int getCurrentChokeSpeed() {
            return 0;
        }

        @Override
        public int getMaxUploadSpeed() {
            return 0;
        }

        @Override
        public boolean getAdjustsDownloadLimits() {
            return true;
        }
    }

    protected class pingContact
    implements SpeedManagerPingSource {
        private DHTSpeedTesterContact contact;
        private int ping_time;

        protected pingContact(DHTSpeedTesterContact dHTSpeedTesterContact) {
            this.contact = dHTSpeedTesterContact;
        }

        protected void setPingTime(int n) {
            this.ping_time = n;
        }

        @Override
        public InetSocketAddress getAddress() {
            return this.contact.getAddress();
        }

        @Override
        public int getPingTime() {
            return this.ping_time;
        }

        @Override
        public void destroy() {
            this.contact.destroy();
        }
    }
}

