/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.peerdb;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.gudy.azureus2.plugins.peers.PeerDescriptor;

public class PeerItem
implements PeerDescriptor {
    private final byte[] address;
    private final short udp_port;
    private final short tcp_port;
    private final byte source;
    private final int hashcode;
    private final byte handshake;
    private final byte crypto_level;
    private final short up_speed;

    protected PeerItem(String string, int n, byte by, byte by2, int n2, byte by3, int n3) {
        byte[] byArray;
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            byArray = inetAddress.getAddress();
        }
        catch (UnknownHostException unknownHostException) {
            byArray = string.getBytes();
        }
        this.address = byArray;
        this.tcp_port = (short)n;
        this.udp_port = (short)n2;
        this.source = by;
        this.hashcode = new String(this.address).hashCode() + this.tcp_port;
        this.handshake = by2;
        this.crypto_level = by3;
        this.up_speed = (short)n3;
    }

    protected PeerItem(byte[] byArray, byte by, byte by2, int n) throws Exception {
        if (byArray.length < 6 || byArray.length > 32) {
            throw new Exception("PeerItem: invalid serialisation length - " + byArray.length);
        }
        this.address = new byte[byArray.length - 2];
        System.arraycopy(byArray, 0, this.address, 0, byArray.length - 2);
        byte by3 = byArray[byArray.length - 2];
        byte by4 = byArray[byArray.length - 1];
        this.tcp_port = (short)((by4 & 0xFF) + ((by3 & 0xFF) << 8));
        this.source = by;
        this.hashcode = new String(this.address).hashCode() + this.tcp_port;
        this.handshake = by2;
        this.udp_port = (short)n;
        this.crypto_level = 1;
        this.up_speed = 0;
    }

    public byte[] getSerialization() {
        byte[] byArray = new byte[this.address.length + 2];
        System.arraycopy(this.address, 0, byArray, 0, this.address.length);
        byArray[this.address.length] = (byte)(this.tcp_port >> 8);
        byArray[this.address.length + 1] = (byte)(this.tcp_port & 0xFF);
        return byArray;
    }

    public String getAddressString() {
        try {
            return InetAddress.getByAddress(this.address).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return new String(this.address);
        }
    }

    @Override
    public String getIP() {
        return this.getAddressString();
    }

    @Override
    public int getTCPPort() {
        return this.tcp_port & 0xFFFF;
    }

    @Override
    public int getUDPPort() {
        return this.udp_port & 0xFFFF;
    }

    public byte getSource() {
        return this.source;
    }

    public byte getHandshakeType() {
        return this.handshake;
    }

    public byte getCryptoLevel() {
        return this.crypto_level;
    }

    @Override
    public boolean useCrypto() {
        return this.crypto_level != 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof PeerItem) {
            PeerItem peerItem = (PeerItem)object;
            if (this.tcp_port == peerItem.tcp_port && this.udp_port == peerItem.udp_port && this.handshake == peerItem.handshake && Arrays.equals(this.address, peerItem.address)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public static String convertSourceString(byte by) {
        switch (by) {
            case 0: {
                return "Tracker";
            }
            case 1: {
                return "DHT";
            }
            case 2: {
                return "PeerExchange";
            }
            case 3: {
                return "Plugin";
            }
            case 4: {
                return "Incoming";
            }
        }
        return "<unknown>";
    }

    public static byte convertSourceID(String string) {
        if (string.equals("Tracker")) {
            return 0;
        }
        if (string.equals("DHT")) {
            return 1;
        }
        if (string.equals("PeerExchange")) {
            return 2;
        }
        if (string.equals("Plugin")) {
            return 3;
        }
        if (string.equals("Incoming")) {
            return 4;
        }
        return -1;
    }

    public boolean isIPv4() {
        return this.address.length == 4;
    }
}

