/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.peerdb;

import com.aelitis.azureus.core.peermanager.peerdb.PeerExchangerItem;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItem;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.gudy.azureus2.core3.peer.util.PeerUtils;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.SystemTime;

public class PeerDatabase {
    private static final int STARTUP_MIN_REBUILD_WAIT_TIME = 10000;
    private static final int STARTUP_MILLIS = 120000;
    private static final int MIN_REBUILD_WAIT_TIME = 60000;
    private static final int MAX_DISCOVERED_PEERS = 500;
    private static final int BLOOM_ROTATION_PERIOD = 420000;
    private static final int BLOOM_FILTER_SIZE = 10000;
    private long start_time = SystemTime.getMonotonousTime();
    private final HashMap peer_connections = new HashMap();
    private final LinkedList discovered_peers = new LinkedList();
    private final AEMonitor map_mon = new AEMonitor("PeerDatabase");
    private PeerItem[] cached_peer_popularities = null;
    private int popularity_pos = 0;
    private long last_rebuild_time = Integer.MIN_VALUE;
    private long last_rotation_time = Integer.MIN_VALUE;
    private PeerItem self_peer;
    private BloomFilter filter_one = null;
    private BloomFilter filter_two = BloomFilterFactory.createAddOnly(10000);
    private long pex_count_last_time;
    private int pex_count_last;
    private int pex_used_count;
    private int total_peers_returned;

    protected PeerDatabase() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerExchangerItem registerPeerConnection(PeerItem peerItem, PeerExchangerItem.Helper helper) {
        try {
            this.map_mon.enter();
            PeerExchangerItem peerExchangerItem = new PeerExchangerItem(this, peerItem, helper);
            for (Map.Entry entry : this.peer_connections.entrySet()) {
                PeerItem peerItem2 = (PeerItem)entry.getKey();
                PeerExchangerItem peerExchangerItem2 = (PeerExchangerItem)entry.getValue();
                if (peerExchangerItem2.getHelper().isSeed() && peerExchangerItem.getHelper().isSeed()) continue;
                peerExchangerItem2.notifyAdded(peerItem);
                peerExchangerItem.notifyAdded(peerItem2);
            }
            this.peer_connections.put(peerItem, peerExchangerItem);
            PeerExchangerItem peerExchangerItem3 = peerExchangerItem;
            return peerExchangerItem3;
        }
        finally {
            this.map_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregisterPeerConnection(PeerItem peerItem) {
        try {
            this.map_mon.enter();
            this.peer_connections.remove(peerItem);
            for (PeerExchangerItem peerExchangerItem : this.peer_connections.values()) {
                peerExchangerItem.notifyDropped(peerItem);
            }
        }
        finally {
            this.map_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seedStatusChanged(PeerExchangerItem peerExchangerItem) {
        if (peerExchangerItem.getHelper().isSeed()) {
            try {
                this.map_mon.enter();
                for (PeerExchangerItem peerExchangerItem2 : this.peer_connections.values()) {
                    if (peerExchangerItem2 == peerExchangerItem || !peerExchangerItem2.getHelper().isSeed()) continue;
                    peerExchangerItem2.notifyDropped(peerExchangerItem.getBasePeer());
                    peerExchangerItem.notifyDropped(peerExchangerItem2.getBasePeer());
                }
            }
            finally {
                this.map_mon.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDiscoveredPeer(PeerItem peerItem) {
        try {
            this.map_mon.enter();
            for (PeerExchangerItem peerExchangerItem : this.peer_connections.values()) {
                if (!peerExchangerItem.isConnectedToPeer(peerItem)) continue;
                return;
            }
            if (!this.discovered_peers.contains(peerItem)) {
                this.discovered_peers.addLast(peerItem);
                int n = PeerUtils.MAX_CONNECTIONS_PER_TORRENT * 2;
                if (n < 1 || n > 500) {
                    n = 500;
                }
                if (this.discovered_peers.size() > n) {
                    this.discovered_peers.removeFirst();
                }
            }
        }
        finally {
            this.map_mon.exit();
        }
    }

    public void setSelfPeer(PeerItem peerItem) {
        this.self_peer = peerItem;
    }

    public PeerItem getSelfPeer() {
        return this.self_peer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerItem[] getDiscoveredPeers() {
        try {
            this.map_mon.enter();
            PeerItem[] peerItemArray = this.discovered_peers.toArray(new PeerItem[this.discovered_peers.size()]);
            return peerItemArray;
        }
        finally {
            this.map_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerItem[] getDiscoveredPeers(String string) {
        ArrayList<PeerItem> arrayList = null;
        try {
            this.map_mon.enter();
            for (int i = 0; i < this.discovered_peers.size(); ++i) {
                PeerItem peerItem = (PeerItem)this.discovered_peers.get(i);
                if (!peerItem.getIP().equals(string)) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<PeerItem>();
                }
                arrayList.add(peerItem);
            }
        }
        finally {
            this.map_mon.exit();
        }
        if (arrayList == null) {
            return new PeerItem[0];
        }
        return arrayList.toArray(new PeerItem[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDiscoveredPeerCount() {
        try {
            this.map_mon.enter();
            int n = this.discovered_peers.size();
            return n;
        }
        finally {
            this.map_mon.exit();
        }
    }

    public PeerItem getNextOptimisticConnectPeer() {
        return this.getNextOptimisticConnectPeer(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PeerItem getNextOptimisticConnectPeer(int n) {
        long l = SystemTime.getMonotonousTime();
        boolean bl = l - this.start_time <= 120000L;
        PeerItem peerItem = null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (bl && this.total_peers_returned % 5 == 0) {
            peerItem = this.getPeerFromPEX(l, bl);
            bl3 = true;
        }
        if (peerItem == null) {
            try {
                this.map_mon.enter();
                if (!this.discovered_peers.isEmpty()) {
                    peerItem = (PeerItem)this.discovered_peers.removeFirst();
                    bl2 = true;
                }
            }
            finally {
                this.map_mon.exit();
            }
        }
        if (peerItem == null && !bl3) {
            peerItem = this.getPeerFromPEX(l, bl);
        }
        if (peerItem != null) {
            PeerItem peerItem2;
            long l2 = l - this.last_rotation_time;
            if (l2 > 420000L) {
                this.filter_one = this.filter_two;
                this.filter_two = BloomFilterFactory.createAddOnly(10000);
                this.last_rotation_time = l;
            }
            boolean bl4 = false;
            byte[] byArray = peerItem.getSerialization();
            if (this.filter_one.contains(byArray) && n < 100 && (peerItem2 = this.getNextOptimisticConnectPeer(n + 1)) != null) {
                if (bl2) {
                    try {
                        this.map_mon.enter();
                        this.discovered_peers.addLast(peerItem);
                    }
                    finally {
                        this.map_mon.exit();
                    }
                }
                peerItem = peerItem2;
                bl4 = true;
            }
            if (!bl4) {
                this.filter_one.add(byArray);
                this.filter_two.add(byArray);
            }
        }
        if (n == 0 && peerItem != null) {
            ++this.total_peers_returned;
        }
        return peerItem;
    }

    private PeerItem getPeerFromPEX(long l, boolean bl) {
        PeerItem peerItem;
        if (this.cached_peer_popularities == null || this.popularity_pos == this.cached_peer_popularities.length) {
            this.cached_peer_popularities = null;
            long l2 = l - this.last_rebuild_time;
            if (l2 > (long)(bl ? 10000 : 60000)) {
                this.cached_peer_popularities = this.getExchangedPeersSortedByLeastPopularFirst();
                this.popularity_pos = 0;
                this.last_rebuild_time = l;
            }
        }
        if (this.cached_peer_popularities != null && this.cached_peer_popularities.length > 0) {
            peerItem = this.cached_peer_popularities[this.popularity_pos];
            ++this.popularity_pos;
            ++this.pex_used_count;
            this.last_rebuild_time = l;
        } else {
            peerItem = null;
        }
        return peerItem;
    }

    public int getExchangedPeerCount() {
        long l = SystemTime.getMonotonousTime();
        if (l - this.pex_count_last_time >= 10000L) {
            PeerItem[] peerItemArray = this.getExchangedPeersSortedByLeastPopularFirst();
            this.pex_count_last = peerItemArray == null ? 0 : peerItemArray.length;
            this.pex_count_last_time = l;
        }
        return Math.max(0, this.pex_count_last - this.popularity_pos);
    }

    public int getExchangedPeersUsed() {
        return this.pex_used_count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PeerItem[] getExchangedPeersSortedByLeastPopularFirst() {
        PeerItem[] peerItemArray2;
        HashMap<PeerItem, Integer> hashMap = new HashMap<PeerItem, Integer>();
        try {
            this.map_mon.enter();
            for (PeerItem[] peerItemArray2 : this.peer_connections.values()) {
                PeerItem[] peerItemArray3 = peerItemArray2.getConnectedPeers();
                for (int i = 0; i < peerItemArray3.length; ++i) {
                    PeerItem peerItem = peerItemArray3[i];
                    Integer n = (Integer)hashMap.get(peerItem);
                    n = n == null ? new Integer(1) : new Integer(n + 1);
                    hashMap.put(peerItem, n);
                }
            }
        }
        finally {
            this.map_mon.exit();
        }
        if (hashMap.isEmpty()) {
            return null;
        }
        Map.Entry[] entryArray = new Map.Entry[hashMap.size()];
        hashMap.entrySet().toArray(entryArray);
        Arrays.sort(entryArray, new Comparator(){

            public int compare(Object object, Object object2) {
                Map.Entry entry = (Map.Entry)object;
                Map.Entry entry2 = (Map.Entry)object2;
                return ((Integer)entry.getValue()).compareTo((Integer)entry2.getValue());
            }
        });
        peerItemArray2 = new PeerItem[entryArray.length];
        for (int i = 0; i < entryArray.length; ++i) {
            Map.Entry entry = entryArray[i];
            peerItemArray2[i] = (PeerItem)entry.getKey();
        }
        return peerItemArray2;
    }

    public String getString() {
        return "pc=" + this.peer_connections.size() + ",dp=" + this.discovered_peers.size();
    }
}

