/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.tcp;

import com.aelitis.azureus.core.networkmanager.VirtualChannelSelector;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TimeFormatter;

public class TCPTransportHelper
implements TransportHelper {
    public static final int READ_TIMEOUT = 10000;
    public static final int CONNECT_TIMEOUT = 60000;
    public static final int MAX_PARTIAL_WRITE_RETAIN = 64;
    private long remainingBytesToScatter = 0L;
    private static boolean enable_efficient_io = !Constants.JAVA_VERSION.startsWith("1.4");
    private final SocketChannel channel;
    private ByteBuffer delayed_write;
    private Map user_data;
    private boolean trace;
    private static final Random rnd = new Random();

    public TCPTransportHelper(SocketChannel socketChannel) {
        this.channel = socketChannel;
    }

    @Override
    public InetSocketAddress getAddress() {
        return new InetSocketAddress(this.channel.socket().getInetAddress(), this.channel.socket().getPort());
    }

    @Override
    public String getName(boolean bl) {
        if (bl) {
            return "TCP";
        }
        return "";
    }

    @Override
    public boolean minimiseOverheads() {
        return false;
    }

    @Override
    public int getConnectTimeout() {
        return 60000;
    }

    @Override
    public int getReadTimeout() {
        return 10000;
    }

    @Override
    public boolean delayWrite(ByteBuffer byteBuffer) {
        if (this.delayed_write != null) {
            Debug.out("secondary delayed write");
            return false;
        }
        this.delayed_write = byteBuffer;
        return true;
    }

    @Override
    public boolean hasDelayedWrite() {
        return this.delayed_write != null;
    }

    @Override
    public int write(ByteBuffer byteBuffer, boolean bl) throws IOException {
        if (this.channel == null) {
            Debug.out("channel == null");
            return 0;
        }
        if (bl && this.delayed_write == null && byteBuffer.remaining() < 64) {
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(byteBuffer.remaining());
            byteBuffer2.put(byteBuffer);
            byteBuffer2.position(0);
            this.delayed_write = byteBuffer2;
            return byteBuffer2.remaining();
        }
        long l = 0L;
        if (this.delayed_write != null) {
            ByteBuffer[] byteBufferArray = new ByteBuffer[]{this.delayed_write, byteBuffer};
            int n = this.delayed_write.remaining();
            this.delayed_write = null;
            l = this.write(byteBufferArray, 0, 2);
            if (byteBufferArray[0].hasRemaining()) {
                this.delayed_write = byteBufferArray[0];
                l = 0L;
            } else {
                l -= (long)n;
            }
        } else {
            l = this.channelWrite(byteBuffer);
        }
        if (this.trace) {
            TimeFormatter.milliTrace("tcp: write " + l);
        }
        return (int)l;
    }

    @Override
    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (this.channel == null) {
            Debug.out("channel == null");
            return 0L;
        }
        long l = 0L;
        if (this.delayed_write != null) {
            int n3;
            ByteBuffer[] byteBufferArray2 = new ByteBuffer[n2 + 1];
            byteBufferArray2[0] = this.delayed_write;
            int n4 = 1;
            for (n3 = n; n3 < n + n2; ++n3) {
                byteBufferArray2[n4++] = byteBufferArray[n3];
            }
            n3 = this.delayed_write.remaining();
            this.delayed_write = null;
            l = this.write(byteBufferArray2, 0, byteBufferArray2.length);
            if (byteBufferArray2[0].hasRemaining()) {
                this.delayed_write = byteBufferArray2[0];
                l = 0L;
            } else {
                l -= (long)n3;
            }
        } else if (enable_efficient_io && this.remainingBytesToScatter < 1L) {
            try {
                l = this.channel.write(byteBufferArray, n, n2);
            }
            catch (IOException iOException) {
                String string = iOException.getMessage();
                if (string != null && string.equals("A non-blocking socket operation could not be completed immediately")) {
                    enable_efficient_io = false;
                    Logger.log(new LogAlert(false, 1, "WARNING: Multi-buffer socket write failed; switching to single-buffer mode.\nUpgrade to JRE 1.5 (5.0) series to fix this problem!"));
                }
                throw iOException;
            }
        } else {
            for (int i = n; i < n + n2; ++i) {
                int n5 = byteBufferArray[i].remaining();
                int n6 = this.channelWrite(byteBufferArray[i]);
                l += (long)n6;
                if (n6 < n5) break;
            }
        }
        if (this.trace) {
            TimeFormatter.milliTrace("tcp: write " + l);
        }
        return l;
    }

    private int channelWrite(ByteBuffer byteBuffer) throws IOException {
        int n;
        int n2 = 0;
        while (this.remainingBytesToScatter > 0L && byteBuffer.remaining() > 0 && (n = this.channel.write((ByteBuffer)byteBuffer.slice().limit(Math.min(50 + rnd.nextInt(100), byteBuffer.remaining())))) != 0) {
            byteBuffer.position(byteBuffer.position() + n);
            this.remainingBytesToScatter -= (long)n;
            if (this.remainingBytesToScatter <= 0L) {
                this.remainingBytesToScatter = 0L;
                try {
                    this.channel.socket().setTcpNoDelay(false);
                }
                catch (SocketException socketException) {
                    Debug.printStackTrace(socketException);
                }
            }
            n2 += n;
        }
        if (byteBuffer.remaining() > 0) {
            n2 += this.channel.write(byteBuffer);
        }
        return n2;
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        if (this.channel == null) {
            Debug.out("channel == null");
            return 0;
        }
        int n = this.channel.read(byteBuffer);
        if (this.trace) {
            TimeFormatter.milliTrace("tcp: read " + n);
        }
        return n;
    }

    @Override
    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (this.channel == null) {
            Debug.out("channel == null");
            return 0L;
        }
        if (byteBufferArray == null) {
            Debug.out("read: buffers == null");
            return 0L;
        }
        long l = 0L;
        if (enable_efficient_io) {
            try {
                l = this.channel.read(byteBufferArray, n, n2);
            }
            catch (IOException iOException) {
                String string = iOException.getMessage();
                if (string != null && string.equals("A non-blocking socket operation could not be completed immediately")) {
                    enable_efficient_io = false;
                    Logger.log(new LogAlert(false, 1, "WARNING: Multi-buffer socket read failed; switching to single-buffer mode.\nUpgrade to JRE 1.5 (5.0) series to fix this problem!"));
                }
                throw iOException;
            }
        } else {
            for (int i = n; i < n + n2; ++i) {
                int n3 = byteBufferArray[i].remaining();
                int n4 = this.channel.read(byteBufferArray[i]);
                l += (long)n4;
                if (n4 < n3) break;
            }
        }
        if (l < 0L) {
            throw new IOException("end of stream on socket read");
        }
        if (this.trace) {
            TimeFormatter.milliTrace("tcp: read " + l);
        }
        return l;
    }

    @Override
    public void registerForReadSelects(final TransportHelper.selectListener selectListener2, Object object) {
        TCPNetworkManager.getSingleton().getReadSelector().register(this.channel, new VirtualChannelSelector.VirtualSelectorListener(){

            @Override
            public boolean selectSuccess(VirtualChannelSelector virtualChannelSelector, SocketChannel socketChannel, Object object) {
                return selectListener2.selectSuccess(TCPTransportHelper.this, object);
            }

            @Override
            public void selectFailure(VirtualChannelSelector virtualChannelSelector, SocketChannel socketChannel, Object object, Throwable throwable) {
                selectListener2.selectFailure(TCPTransportHelper.this, object, throwable);
            }
        }, object);
    }

    @Override
    public void registerForWriteSelects(final TransportHelper.selectListener selectListener2, Object object) {
        TCPNetworkManager.getSingleton().getWriteSelector().register(this.channel, new VirtualChannelSelector.VirtualSelectorListener(){

            @Override
            public boolean selectSuccess(VirtualChannelSelector virtualChannelSelector, SocketChannel socketChannel, Object object) {
                if (TCPTransportHelper.this.trace) {
                    TimeFormatter.milliTrace("tcp: write select");
                }
                return selectListener2.selectSuccess(TCPTransportHelper.this, object);
            }

            @Override
            public void selectFailure(VirtualChannelSelector virtualChannelSelector, SocketChannel socketChannel, Object object, Throwable throwable) {
                selectListener2.selectFailure(TCPTransportHelper.this, object, throwable);
            }
        }, object);
    }

    @Override
    public void cancelReadSelects() {
        TCPNetworkManager.getSingleton().getReadSelector().cancel(this.channel);
    }

    @Override
    public void cancelWriteSelects() {
        if (this.trace) {
            TimeFormatter.milliTrace("tcp: cancel write selects");
        }
        TCPNetworkManager.getSingleton().getWriteSelector().cancel(this.channel);
    }

    @Override
    public void resumeReadSelects() {
        TCPNetworkManager.getSingleton().getReadSelector().resumeSelects(this.channel);
    }

    @Override
    public void resumeWriteSelects() {
        if (this.trace) {
            TimeFormatter.milliTrace("tcp: resume write selects");
        }
        TCPNetworkManager.getSingleton().getWriteSelector().resumeSelects(this.channel);
    }

    @Override
    public void pauseReadSelects() {
        TCPNetworkManager.getSingleton().getReadSelector().pauseSelects(this.channel);
    }

    @Override
    public void pauseWriteSelects() {
        if (this.trace) {
            TimeFormatter.milliTrace("tcp: pause write selects");
        }
        TCPNetworkManager.getSingleton().getWriteSelector().pauseSelects(this.channel);
    }

    @Override
    public void close(String string) {
        TCPNetworkManager.getSingleton().getReadSelector().cancel(this.channel);
        TCPNetworkManager.getSingleton().getWriteSelector().cancel(this.channel);
        TCPNetworkManager.getSingleton().getConnectDisconnectManager().closeConnection(this.channel);
    }

    @Override
    public void failed(Throwable throwable) {
        this.close(Debug.getNestedExceptionMessage(throwable));
    }

    public SocketChannel getSocketChannel() {
        return this.channel;
    }

    @Override
    public synchronized void setUserData(Object object, Object object2) {
        if (this.user_data == null) {
            this.user_data = new HashMap();
        }
        this.user_data.put(object, object2);
    }

    @Override
    public synchronized Object getUserData(Object object) {
        if (this.user_data == null) {
            return null;
        }
        return this.user_data.get(object);
    }

    @Override
    public void setTrace(boolean bl) {
        this.trace = bl;
    }

    @Override
    public void setScatteringMode(long l) {
        if (l > 0L) {
            if (this.remainingBytesToScatter == 0L) {
                try {
                    this.channel.socket().setTcpNoDelay(true);
                }
                catch (SocketException socketException) {
                    Debug.printStackTrace(socketException);
                }
            }
            this.remainingBytesToScatter = l;
        } else {
            if (this.remainingBytesToScatter > 0L) {
                try {
                    this.channel.socket().setTcpNoDelay(false);
                }
                catch (SocketException socketException) {
                    Debug.printStackTrace(socketException);
                }
            }
            this.remainingBytesToScatter = 0L;
        }
    }
}

