/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.tcp;

import com.aelitis.azureus.core.networkmanager.EventWaiter;
import com.aelitis.azureus.core.networkmanager.ProtocolEndpoint;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.TransportEndpoint;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TransportEndpointTCP;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class LightweightTCPTransport
implements Transport {
    private final TransportEndpoint transport_endpoint;
    private final TransportHelperFilter filter;

    public LightweightTCPTransport(ProtocolEndpoint protocolEndpoint, TransportHelperFilter transportHelperFilter) {
        SocketChannel socketChannel = ((TCPTransportHelper)transportHelperFilter.getHelper()).getSocketChannel();
        this.transport_endpoint = new TransportEndpointTCP(protocolEndpoint, socketChannel);
        this.filter = transportHelperFilter;
    }

    @Override
    public TransportEndpoint getTransportEndpoint() {
        return this.transport_endpoint;
    }

    @Override
    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        return this.filter.write(byteBufferArray, n, n2);
    }

    @Override
    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        return this.filter.read(byteBufferArray, n, n2);
    }

    public SocketChannel getSocketChannel() {
        return ((TCPTransportHelper)this.filter.getHelper()).getSocketChannel();
    }

    public InetSocketAddress getRemoteAddress() {
        return new InetSocketAddress(this.getSocketChannel().socket().getInetAddress(), this.getSocketChannel().socket().getPort());
    }

    @Override
    public String getDescription() {
        return this.getSocketChannel().socket().getInetAddress().getHostAddress() + ": " + this.getSocketChannel().socket().getPort();
    }

    @Override
    public void close(String string) {
        try {
            this.getSocketChannel().close();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public int getMssSize() {
        return TCPNetworkManager.getTcpMssSize();
    }

    @Override
    public void setAlreadyRead(ByteBuffer byteBuffer) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public boolean isReadyForWrite(EventWaiter eventWaiter) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public long isReadyForRead(EventWaiter eventWaiter) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void setReadyForRead() {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void connectOutbound(ByteBuffer byteBuffer, Transport.ConnectListener connectListener, int n) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void connectedInbound() {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void setTransportMode(int n) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public int getTransportMode() {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void setTrace(boolean bl) {
    }

    @Override
    public String getEncryption(boolean bl) {
        return this.filter.getName(bl);
    }

    @Override
    public boolean isEncrypted() {
        return this.filter.isEncrypted();
    }

    @Override
    public boolean isTCP() {
        return true;
    }
}

