/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.admin.impl;

import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminNATUDPReply;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminNATUDPRequest;
import com.aelitis.net.udp.uc.PRUDPPacketHandler;
import com.aelitis.net.udp.uc.PRUDPPacketReply;
import com.aelitis.net.udp.uc.PRUDPPacketReplyDecoder;
import com.aelitis.net.udp.uc.PRUDPPacketRequest;
import com.aelitis.net.udp.uc.PRUDPPacketRequestDecoder;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;

public class NetworkAdminNATUDPCodecs {
    public static final int ACT_NAT_REQUEST = 40;
    public static final int ACT_NAT_REPLY = 41;
    private static boolean registered = false;

    public static void registerCodecs() {
        if (registered) {
            return;
        }
        registered = true;
        PRUDPPacketReplyDecoder pRUDPPacketReplyDecoder = new PRUDPPacketReplyDecoder(){

            @Override
            public PRUDPPacketReply decode(PRUDPPacketHandler pRUDPPacketHandler, InetSocketAddress inetSocketAddress, DataInputStream dataInputStream, int n, int n2) throws IOException {
                switch (n) {
                    case 41: {
                        return new NetworkAdminNATUDPReply(dataInputStream, n2);
                    }
                }
                throw new IOException("Unrecognised action '" + n + "'");
            }
        };
        HashMap<Integer, 1> hashMap = new HashMap<Integer, 1>();
        hashMap.put(new Integer(41), pRUDPPacketReplyDecoder);
        PRUDPPacketReply.registerDecoders(hashMap);
        PRUDPPacketRequestDecoder pRUDPPacketRequestDecoder = new PRUDPPacketRequestDecoder(){

            @Override
            public PRUDPPacketRequest decode(PRUDPPacketHandler pRUDPPacketHandler, DataInputStream dataInputStream, long l, int n, int n2) throws IOException {
                switch (n) {
                    case 40: {
                        return new NetworkAdminNATUDPRequest(dataInputStream, l, n2);
                    }
                }
                throw new IOException("unsupported request type");
            }
        };
        HashMap<Integer, 2> hashMap2 = new HashMap<Integer, 2>();
        hashMap2.put(new Integer(40), pRUDPPacketRequestDecoder);
        PRUDPPacketRequest.registerDecoders(hashMap2);
    }

    static {
        NetworkAdminNATUDPCodecs.registerCodecs();
    }
}

